;Blitriz by David Williamson
;(c) W.I.P. Games
;http://members.aol.com/WIPgames
;WIPgames@aol.com

AppTitle "Blitriz"				;Started 05/03/01

If GfxModeExists(800,600,16)	;Test to see if GFX mode is available
	Graphics 800,600,16			;Set GFX mode
Else
	Print "Could not open graphics mode (800x600x16)"
	Repeat
	Until GetKey()
	End							;exit if could not set GFX mode
EndIf

WIPIntro()

Const NoOfRows=19
Const NoOfColumns=10

SetBuffer BackBuffer()
SeedRnd MilliSecs()

Global GameTimer=CreateTimer(30)	;Keepsgame running at same speed
Global NoOfUpdates
Global GameOver=False
Global CurrentCluster=Rand(0,6)
Global CurrentRotation=Rand(0,3)
Global CurrentX=4
Global CurrentY=1
Global NextCluster=Rand(0,6)
Global NextRotation=Rand(0,3)
Global CurrentYPlus=0
Global MoveTimer
Global KeyPressed
Global KeyPressed2
Global KeyPressed3
Global Drop
Global Speed=1
Global StartSpeed=1
Global NoOfLines#
Global Score
Global NewCluster=False
Global MenuOption
Global GameMenuOption
Global SetupMenuOption
Global StartLines=0
Global StartLineDensity=5
Global MusicVolume#=5
Global MusicChannel
Global MusicPlaying
Global ShowNextBlock=True
Global Swapping=True
Global Swapped

File=ReadFile("Dat\Keys.dat")
Global Key_Left=ReadInt(File)
Global Key_Right=ReadInt(File)
Global Key_AntiSpin=ReadInt(File)
Global Key_Spin=ReadInt(File)
Global Key_Swap=ReadInt(File)
Global Key_Drop=ReadInt(File)
CloseFile File

Dim HiName$(4)
Dim HiScore%(4)
LoadHiScores()

Type Block
	Field x_Offset
	Field y_Offset
End Type

Type MenuCluster
	Field x
	Field y
	Field ClusterType
	Field ClusterRotation
End Type

Dim Cluster.Block(6,3,2)		;Cluster,Rotation,Block
Dim Level(NoOfColumns-1,NoOfRows-1)					;x,y

Global BlockGraphics=LoadAnimImage("Png\Blocks.png",32,32,0,9)
Global BackGround=LoadImage("Png\BackGround.png")
Global Font=LoadAnimImage("Png\Font.png",17,25,0,10)
Global Title=LoadImage("Png\Title.png")
MidHandle Title
MaskImage Title,255,255,255

Global CopyrightFont=LoadFont("arial",18,True)
Global MenuFont=LoadFont("arial",48,True)
SetFont MenuFont

;Sound Effects
Global SFX_Rotate=LoadSound("Wav\Rotate.wav")
Global SFX_Blocked=LoadSound("Wav\Blocked.wav")
Global SFX_Hit=LoadSound("Wav\BlockHit.wav")
Global SFX_Remove=LoadSound("Wav\RemoveBlock.wav")
Global SFX_Drop=LoadSound("Wav\Drop.wav")
Global SFX_GameOver=LoadSound("Wav\GameOver.wav")

CreateClusters()

MusicChannel=PlayMusic("Mod\mattiasa.mod")
MusicPlaying=True
ChannelVolume MusicChannel,MusicVolume/20

Repeat
	
	Menu()
	
	InitLevel()

	Repeat
		NoOfUpdates=WaitTimer(GameTimer)
		For Count=1 To NoOfUpdates
			UpdateGame()
		Next
		RenderGame()
		;If KeyDown(25) Then SaveBuffer(BackBuffer(),"ScreenShot.bmp")
	Until GameOver
	Repeat
	Until Not GetKey()
	Repeat
	Until GetKey()
	
	EnterHiScore()

Forever


Function CreateClusters()
	For ClusterCount=0 To 6
		For RotationCount=0 To 3
			For BlockCount=0 To 2
				Cluster(ClusterCount,RotationCount,BlockCount)=New Block
				Read Cluster(ClusterCount,RotationCount,BlockCount)\x_Offset
				Read Cluster(ClusterCount,RotationCount,BlockCount)\y_Offset
			Next
		Next
	Next
	For a=1 To 6
		MC.MenuCluster=New MenuCluster
		MC\x=Rand(0,24)*32
		MC\y=(a*128)-140
		MC\ClusterType=Rand(0,6)
		MC\ClusterRotation=Rand(0,3)
	Next
End Function

Function InitLevel()
	For x_Count=0 To NoOfColumns-1
		For y_count=0 To NoOfRows-1
			Level(x_Count,y_Count)=-1
		Next
	Next
	
	If StartLines>0
		For y_Count=NoOfRows-1 To NoOfRows-StartLines Step -1
			For x_Count=1 To StartLineDensity
				Block_x=Rand(0,NoOfColumns-1)
				While Level(Block_x,y_Count)>0
					Block_x=Block_x+1
					If Block_x>NoOfColumns-1 Then Block_x=0
				Wend
				Level(Block_x,y_Count)=7
			Next
		Next
	EndIf

	GameOver=False
	CurrentCluster=Rand(0,6)
	CurrentRotation=Rand(0,3)
	CurrentX=(NoOfColumns-2)/2
	CurrentY=1
	NextCluster=Rand(0,6)
	NextRotation=Rand(0,3)
	CurrentYPlus=0
	Drop=False
	Speed=StartSpeed+1
	NoOfLines=0
	Score=0
	Swapped=False
	NewCluster=False

	WaitTimer(GameTimer)

End Function

Function UpdateGame()
	If Drop=False
		If KeyDown(Key_Left) And MoveTimer<MilliSecs()
			CurrentX=CurrentX-1
			If Collision()
				Currentx=CurrentX+1
			Else
				MoveTimer=MilliSecs()+100
			EndIf
		EndIf

		If KeyDown(Key_Right) And MoveTimer<MilliSecs()
			CurrentX=CurrentX+1
			If Collision()
				Currentx=CurrentX-1
			Else
				MoveTimer=MilliSecs()+100
			EndIf			
		EndIf
	
		If KeyDown(Key_Spin)
			If KeyPressed=False
				TempRotation=CurrentRotation
				CurrentRotation=(CurrentRotation+1)Mod 4
				If Collision()
					CurrentRotation=TempRotation
					PlaySound(SFX_Blocked)
				Else
					PlaySound(SFX_Rotate)
				EndIf
				KeyPressed=True
				
			EndIf
		Else
			KeyPressed=False
		EndIf

		If KeyDown(Key_AntiSpin)
			If KeyPressed3=False
				TempRotation=CurrentRotation
				CurrentRotation=CurrentRotation-1
				If CurrentRotation<0 Then CurrentRotation=3
				If Collision()
					CurrentRotation=TempRotation
					PlaySound(SFX_Blocked)
				Else
					PlaySound(SFX_Rotate)
				EndIf
				KeyPressed3=True
				
			EndIf
		Else
			KeyPressed3=False
		EndIf
		
		If Swapping=True And Swapped=False	
			If KeyDown(Key_Swap)
				TempCluster=CurrentCluster
				CurrentCluster=NextCluster
				NextCluster=TempCluster
				
				TempRotation=CurrentRotation
				CurrentRotation=NextRotation
				NextRotation=TempRotation
				
				If Collision()
					TempCluster=CurrentCluster
					CurrentCluster=NextCluster
					NextCluster=TempCluster
					
					TempRotation=CurrentRotation
					CurrentRotation=NextRotation
					NextRotation=TempRotation

					PlaySound(SFX_Blocked)
				Else
					Swapped=True
					PlaySound(SFX_Rotate)
				EndIf
			EndIf
		EndIf

		If KeyDown(Key_Drop)
			If KeyPressed2=False
				Drop=True
				KeyPressed2=True
			EndIf
		Else
			KeyPressed2=False
		EndIf
	
		NoOfRepeats=Speed
	Else
		NoOfRepeats=32
	EndIf
	
	RepeatCount=1

	Repeat
		CurrentYPlus=CurrentYPlus+1
		If CurrentYPlus>31
			CurrentYPlus=0
			CurrentY=CurrentY+1
		EndIf
		If CurrentYPlus=1
			If Collision()
				Level(CurrentX,CurrentY)=CurrentCluster
				For BlockCount=0 To 2
					Level(CurrentX+Cluster(CurrentCluster,CurrentRotation,BlockCount)\x_Offset,CurrentY+Cluster(CurrentCluster,CurrentRotation,BlockCount)\y_Offset)=CurrentCluster
				Next
				CurrentCluster=NextCluster
				CurrentRotation=NextRotation
				CurrentX=(NoOfColumns-2)/2
				CurrentY=1
				CurrentYPlus=0
				NextCluster=Rand(0,6)
				NextRotation=Rand(0,3)
				Drop=False
				Swapped=False
				NewCluster=True
				
				PlaySound(SFX_Hit)
				
				For y_Count=NoOfRows-1 To 0 Step -1
					FullLine=True
					For x_Count=0 To NoOfColumns-1
						If Level(x_Count,y_Count)<0 Then FullLine=False
					Next
					If FullLine=True
						For x_Count=0 To NoOfColumns-1
							Level(x_Count,y_Count)=7
						Next
						RenderGame()
						WaitTimer(GameTimer)
						WaitTimer(GameTimer)
					EndIf
				Next
				For y_Count=NoOfRows-1 To 0 Step -1
					FullLine=True
					For x_Count=0 To NoOfColumns-1
						If Level(x_Count,y_Count)<0 Then FullLine=False
					Next
					If FullLine=True
						For x_Count=0 To NoOfColumns-1
							Level(x_Count,y_Count)=8
						Next
						RenderGame()
						PlaySound(SFX_Remove)
						WaitTimer(GameTimer)
						WaitTimer(GameTimer)
					EndIf
				Next
				
				NoOfFullLines=0
				
				For y_Count=NoOfRows-1 To 0 Step -1
					Repeat
						FullLine=True
						For x_Count=0 To NoOfColumns-1
							If Level(x_Count,y_Count)<0 Then FullLine=False
						Next
						If FullLine=True
							For x_Count=0 To NoOfColumns-1
								Level(x_Count,y_Count)=-1
								Count=1
								While y_Count-Count>=0
									Level(x_Count,y_Count-Count+1)=Level(x_Count,y_Count-Count)
									Count=Count+1
								Wend
							Next
							NoOfLines=NoOfLines+1
							NoOfFullLines=NoOfFullLines+1
							Speed=Ceil((NoOfLines+1)/10)+StartSpeed
							RenderGame()
							WaitTimer(GameTimer)
							WaitTimer(GameTimer)
						EndIf
					Until FullLine=False
				Next
				
				If NoOfFullLines>0
					Score=Score+((10^NoOfFullLines)*(Speed-1))
					PlaySound(SFX_Drop)
				EndIf
				
				For x_Count=0 To NoOfColumns-1
					If Level(x_Count,0)>=0 Then GameOver=True
				Next

			EndIf
		EndIf
		RepeatCount=RepeatCount+1
	Until RepeatCount>NoOfRepeats Or NewCluster=True
	NewCluster=False
	
	If KeyDown(1) Then GameOver=True
	
	If GameOver=True Then PlaySound(SFX_GameOver)
	
End Function

Function Collision%()
	If CurrentX<0 Or CurrentX>=NoOfColumns Then Return True
	For BlockCount=0 To 2
		If CurrentX+Cluster(CurrentCluster,CurrentRotation,BlockCount)\x_Offset<0 Or CurrentX+Cluster(CurrentCluster,CurrentRotation,BlockCount)\x_Offset>=NoOfColumns Then Return True
	Next
	If Level(CurrentX,CurrentY)>=0 Then Return True
	For BlockCount=0 To 2
		If Level(CurrentX+Cluster(CurrentCluster,CurrentRotation,BlockCount)\x_Offset,CurrentY+Cluster(CurrentCluster,CurrentRotation,BlockCount)\y_Offset)>=0 Then Return True
	Next
	If CurrentYPlus>0
		If CurrentY>NoOfRows-2 Then Return True
		For BlockCount=0 To 2
			If CurrentY+Cluster(CurrentCluster,CurrentRotation,BlockCount)\y_Offset>NoOfRows-2 Then Return True
		Next
		If Level(CurrentX,CurrentY+1)>=0 Then Return True
		For BlockCount=0 To 2
			If Level(CurrentX+Cluster(CurrentCluster,CurrentRotation,BlockCount)\x_Offset,CurrentY+Cluster(CurrentCluster,CurrentRotation,BlockCount)\y_Offset+1)>=0 Then Return True
		Next
	EndIf
End Function

Function RenderGame()
	DrawBlock BackGround,0,0
	For x_Count=0 To NoOfColumns-1
		For y_Count=0 To NoOfRows-1
			If Level(x_Count,y_Count)>=0 Then DrawBlock BlockGraphics,(x_Count*32)+32,(y_Count*32)-8,Level(x_Count,y_Count)
		Next
	Next
	
	DrawBlock BlockGraphics,(CurrentX*32)+32,((CurrentY*32)+CurrentYPlus)-8,CurrentCluster
	For BlockCount=0 To 2
		DrawBlock BlockGraphics,((CurrentX+Cluster(CurrentCluster,CurrentRotation,BlockCount)\x_Offset)*32)+32,(((CurrentY+Cluster(CurrentCluster,CurrentRotation,BlockCount)\y_Offset)*32)+CurrentYPlus)-8,CurrentCluster
	Next
	
	If ShowNextBlock
		DrawBlock BlockGraphics,448,96,NextCluster
		For BlockCount=0 To 2
			DrawBlock BlockGraphics,((14+Cluster(NextCluster,NextRotation,BlockCount)\x_Offset)*32),(3+Cluster(NextCluster,NextRotation,BlockCount)\y_Offset)*32,NextCluster
		Next
	EndIf
	
	WriteNumber(614,67,Score)
	WriteNumber(614,194,NoOfLines)
	
	If GameOver Then Text 192,300,"GAME OVER",True,True
	
	Flip
End Function

Function WriteNumber(x%,y%,Number#)
	If Number>=1000000 
		DrawImage Font,x,y,Int(Floor#(Number/1000000))
		Number=Number-(Floor#(Number/1000000)*1000000)
	EndIf
	If Number>=100000
		DrawImage Font,x+22,y,Int(Floor#(Number/100000))
		Number=Number-(Floor#(Number/100000)*100000)
	EndIf
	If Number>=10000
		DrawImage Font,x+44,y,Int(Floor#(Number/10000))
		Number=Number-(Floor#(Number/10000)*10000)
	EndIf
	If Number>=1000
		DrawImage Font,x+66,y,Int(Floor#(Number/1000))
		Number=Number-(Floor#(Number/1000)*1000)
	EndIf
	If Number>=100
		DrawImage Font,x+88,y,Int(Floor#(Number/100))
		Number=Number-(Floor#(Number/100)*100)
	EndIf
	If Number>=10
		DrawImage Font,x+110,y,Int(Floor#(Number/10))
		Number=Number-(Floor#(Number/10)*10)
	EndIf
	If Number>=1
		DrawImage Font,x+132,y,Int(Number)
	EndIf
End Function

Function Menu()
	MenuOption=0
	MenuTimer=MilliSecs()+200
		
	Repeat
		Repeat
		RenderMenu()
		Until Not KeyDown(28)
		Repeat
			If KeyDown(208) And MenuTimer<MilliSecs()
				MenuOption=MenuOption+1
				If MenuOption>5 Then MenuOption=0
				MenuTimer=MilliSecs()+200
				PlaySound(SFX_Rotate)
			EndIf
			If KeyDown(200) And MenuTimer<MilliSecs()
				MenuOption=MenuOption-1
				If MenuOption<0 Then MenuOption=5
				MenuTimer=MilliSecs()+200
				PlaySound(SFX_Rotate)
			EndIf
			If KeyDown(1) Then EndGame()
			
			RenderMenu()
	
		Until KeyDown(28)
		
		PlaySound(SFX_Hit)
	
		Select MenuOption
			Case 0
				Return
			Case 1
				GameMenu()
			Case 2
				SetupMenu()
			Case 3
				HiScores()
			Case 4
				Credits()
			Case 5
				EndGame()
		End Select
	Forever
	
End Function

Function RenderMenu()
	ClsColor 0,31,31
	Cls
	DoMenuClusters()
	DrawImage Title,400,100
	If MenuOption=0
		Color 255,0,0
		Text 400,200,"PLAY",True,True
		Color 255,255,255
	Else
		Text 400,200,"PLAY",True,True
	EndIf
	If MenuOption=1
		Color 255,0,0
		Text 400,250,"GAME OPTIONS",True,True
		Color 255,255,255
	Else
		Text 400,250,"GAME OPTIONS",True,True
	EndIf
	If MenuOption=2
		Color 255,0,0
		Text 400,300,"SETUP",True,True
		Color 255,255,255
	Else
		Text 400,300,"SETUP",True,True
	EndIf
	If MenuOption=3
		Color 255,0,0
		Text 400,350,"HI-SCORES",True,True
		Color 255,255,255
	Else
		Text 400,350,"HI-SCORES",True,True
	EndIf
	If MenuOption=4
		Color 255,0,0
		Text 400,400,"CREDITS",True,True
		Color 255,255,255
	Else
		Text 400,400,"CREDITS",True,True
	EndIf
	If MenuOption=5
		Color 255,0,0
		Text 400,500,"EXIT",True,True
		Color 255,255,255
	Else
		Text 400,500,"EXIT",True,True
	EndIf
	
	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	Text 400,575,"MENU CONTROLS: UP, DOWN, RETURN",True,True
	SetFont MenuFont
	
	Flip
End Function

Function GameMenu()
	GameMenuOption=0
	GameMenuTimer=MilliSecs()+200
		
	Repeat
		Repeat
		RenderGameMenu()
		Until Not KeyDown(28)
		Repeat
			If KeyDown(208) And GameMenuTimer<MilliSecs()
				GameMenuOption=GameMenuOption+1
				If GameMenuOption>5 Then GameMenuOption=0
				If GameMenuOption=2 And StartLines=0 Then GameMenuOption=3
				GameMenuTimer=MilliSecs()+200
				PlaySound(SFX_Rotate)
			EndIf
			If KeyDown(200) And GameMenuTimer<MilliSecs()
				GameMenuOption=GameMenuOption-1
				If GameMenuOption<0 Then GameMenuOption=5
				If GameMenuOption=2 And StartLines=0 Then GameMenuOption=1
				GameMenuTimer=MilliSecs()+200
				PlaySound(SFX_Rotate)
			EndIf
			If KeyDown(1) Then EndGame()
			
			RenderGameMenu()
	
		Until KeyDown(28)
		
		PlaySound(SFX_Hit)
	
		Select GameMenuOption
			Case 0
				StartSpeed=StartSpeed+1
				If StartSpeed>9 Then StartSpeed=1
			Case 1
				StartLines=StartLines+1
				If StartLines>5 Then StartLines=0
			Case 2
				StartLineDensity=StartLineDensity+1
				If StartLineDensity>9 Then StartLineDensity=1
			Case 3
				If ShowNextBlock=True
					ShowNextBlock=False
				Else
					ShowNextBlock=True
				EndIf
			Case 4
				If Swapping=True
					Swapping=False
				Else
					Swapping=True
				EndIf
			
			Case 5
				Return
		End Select
	Forever
	
End Function

Function RenderGameMenu()
	ClsColor 0,31,31
	Cls
	DoMenuClusters()
	DrawImage Title,400,100
	If GameMenuOption=0
		Color 255,0,0
		Text 400,200,"SPEED "+StartSpeed,True,True
		Color 255,255,255
	Else
		Text 400,200,"SPEED "+StartSpeed,True,True
	EndIf
	If GameMenuOption=1
		Color 255,0,0
		Text 400,250,"HANDICAP LINES "+StartLines,True,True
		Color 255,255,255
	Else
		Text 400,250,"HANDICAP LINES "+StartLines,True,True
	EndIf
	If GameMenuOption=2
		Color 255,0,0
		Text 400,300,"HANDICAP DENSITY "+StartLineDensity,True,True
		Color 255,255,255
	Else
		If StartLines=0 
			Color 0,127,127
			Text 400,300,"HANDICAP DENSITY "+StartLineDensity,True,True
			Color 255,255,255
		Else
			Text 400,300,"HANDICAP DENSITY "+StartLineDensity,True,True
		EndIf
	EndIf
	If GameMenuOption=3
		If ShowNextBlock=True
			Color 255,0,0
			Text 400,350,"SHOW NEXT BLOCK IS ON",True,True
			Color 255,255,255
		Else
			Color 255,0,0
			Text 400,350,"SHOW NEXT BLOCK IS OFF",True,True
			Color 255,255,255
		EndIf
	Else
		If ShowNextBlock=True
			Text 400,350,"SHOW NEXT BLOCK IS ON",True,True
		Else
			Text 400,350,"SHOW NEXT BLOCK IS OFF",True,True
		EndIf
	EndIf
	If GameMenuOption=4
		If Swapping=True
			Color 255,0,0
			Text 400,400,"BLOCK SWAPPING IS ON",True,True
			Color 255,255,255
		Else
			Color 255,0,0
			Text 400,400,"BLOCK SWAPPING IS OFF",True,True
			Color 255,255,255
		EndIf
	Else
		If Swapping=True
			Text 400,400,"BLOCK SWAPPING IS ON",True,True
		Else
			Text 400,400,"BLOCK SWAPPING IS OFF",True,True
		EndIf
	EndIf
	If GameMenuOption=5
		Color 255,0,0
		Text 400,500,"RETURN",True,True
		Color 255,255,255
	Else
		Text 400,500,"RETURN",True,True
	EndIf
	
	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	Text 400,575,"MENU CONTROLS: UP, DOWN, RETURN",True,True
	SetFont MenuFont
	
	Flip
End Function

Function SetupMenu()
	SetupMenuOption=0
	SetupMenuTimer=MilliSecs()+200
		
	Repeat
		Repeat
		RenderSetupMenu()
		Until Not KeyDown(28)
		Repeat
			If KeyDown(208) And SetupMenuTimer<MilliSecs()
				SetupMenuOption=SetupMenuOption+1
				If SetupMenuOption>4 Then SetupMenuOption=0
				SetupMenuTimer=MilliSecs()+200
				PlaySound(SFX_Rotate)
			EndIf
			If KeyDown(200) And SetupMenuTimer<MilliSecs()
				SetupMenuOption=SetupMenuOption-1
				If SetupMenuOption<0 Then SetupMenuOption=4
				SetupMenuTimer=MilliSecs()+200
				PlaySound(SFX_Rotate)
			EndIf
			If KeyDown(1) Then EndGame()
			
			RenderSetupMenu()
	
		Until KeyDown(28)
		
		PlaySound(SFX_Hit)
	
		Select SetupMenuOption
			Case 0
				If MusicPlaying
					PauseChannel MusicChannel
					MusicPlaying=False
				Else
					ResumeChannel MusicChannel
					MusicPlaying=True
				EndIf
			Case 1
				MusicVolume=MusicVolume+1
				If MusicVolume>9 Then MusicVolume=1
				ChannelVolume MusicChannel,MusicVolume/20
			Case 2
				RedefineKeys()
			Case 3
				DefaultKeys()
			Case 4
				Return
		End Select
	Forever
	
End Function

Function RenderSetupMenu()
	ClsColor 0,31,31
	Cls
	DoMenuClusters()
	DrawImage Title,400,100
	If SetupMenuOption=0
		Color 255,0,0
		Text 400,200,"MUSIC ON/OFF",True,True
		Color 255,255,255
	Else
		Text 400,200,"MUSIC ON/OFF",True,True
	EndIf
	If SetupMenuOption=1
		Color 255,0,0
		Text 400,250,"VOLUME "+Int(MusicVolume),True,True
		Color 255,255,255
	Else
		Text 400,250,"VOLUME "+Int(MusicVolume),True,True
	EndIf
	If SetupMenuOption=2
		Color 255,0,0
		Text 400,325,"REDEFINE KEYS",True,True
		Color 255,255,255
	Else
		Text 400,325,"REDEFINE KEYS",True,True
	EndIf
	If SetupMenuOption=3
		Color 255,0,0
		Text 400,375,"USE DEFAULT KEYS",True,True
		Color 255,255,255
	Else
		Text 400,375,"USE DEFAULT KEYS",True,True
	EndIf
	If SetupMenuOption=4
		Color 255,0,0
		Text 400,475,"RETURN",True,True
		Color 255,255,255
	Else
		Text 400,475,"RETURN",True,True
	EndIf
	
	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	Text 400,575,"MENU CONTROLS: UP, DOWN, RETURN",True,True
	SetFont MenuFont
	
	Flip
End Function

Function RedefineKeys()
	Repeat
		RenderKeys(0)
	Until Not KeyDown(28)
	For Count=0 To 5
		Key=0
		Repeat
			For Count2=1 To 237
				If KeyDown(Count2) Then Key=Count2
			Next
			RenderKeys(Count)
		Until key>1
		Select count
			Case 0
				Key_Left=Key
			Case 1
				Key_Right=Key
			Case 2
				Key_AntiSpin=Key
			Case 3
				Key_Spin=Key
			Case 4
				Key_Swap=Key
			Case 5
				Key_Drop=Key
		End Select
		
		PlaySound(SFX_Hit)
		
		Repeat
			RenderKeys(Count)
		Until Not KeyDown(Key)
	Next
End Function

Function RenderKeys(Display)
	ClsColor 0,31,31
	Cls
	DoMenuClusters()
	DrawImage Title,400,100

	Select Display
		Case 0
			Text 400,300,"SELECT 'LEFT' KEY",True,True
		Case 1
			Text 400,300,"SELECT 'RIGHT' KEY",True,True
		Case 2
			Text 400,300,"SELECT 'ANTI-CLOCKWISE SPIN' KEY",True,True
		Case 3
			Text 400,300,"SELECT 'CLOCKWISE SPIN' KEY",True,True
		Case 4
			Text 400,300,"SELECT 'SWAP' KEY",True,True
		Case 5
			Text 400,300,"SELECT 'DROP' KEY",True,True
	End Select

	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	SetFont MenuFont
	
	Flip
End Function

Function DefaultKeys()
	Key_Left=203
	Key_Right=205
	Key_AntiSpin=30
	Key_Spin=31
	Key_Swap=57
	Key_Drop=208
End Function


Function HiScores()
	Repeat
		RenderHiScores()
	Until Not KeyDown(28)
	Repeat
		RenderHiScores()
		If KeyDown(1) Then EndGame()
	Until KeyDown(28)
	PlaySound(SFX_Hit)
End Function

Function RenderHiScores()
	ClsColor 0,31,31
	Cls
	DoMenuClusters()
	DrawImage Title,400,100
	For Count=0 To 4
		Text 325-StringWidth(HiScore(Count)),200+(50*Count),HiScore(Count),False,True
		Text 475,200+(50*Count),HiName(Count),False,True
	Next
	
	Color 255,0,0
	Text 400,500,"RETURN",True,True
	Color 255,255,255
	
	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	Text 400,575,"MENU CONTROLS: UP, DOWN, RETURN",True,True
	SetFont MenuFont
	
	Flip
End Function

Function Credits()
	Repeat
		RenderCredits()
	Until Not KeyDown(28)
	Repeat
		RenderCredits()
		If KeyDown(1) Then EndGame()
	Until KeyDown(28)
	PlaySound(SFX_Hit)
End Function

Function RenderCredits()
	ClsColor 0,31,31
	Cls
	DoMenuClusters()
	DrawImage Title,400,100
	Text 400,200,"CODE BY DAVID WILLIAMSON",True,True
	Text 400,275,"GRAPHICS BY DAVID WILLIAMSON",True,True
	Text 400,350,"MUSIC BY TOMMI ARRELA",True,True
	Color 255,0,0
	Text 400,500,"RETURN",True,True
	Color 255,255,255
	
	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	Text 400,575,"MENU CONTROLS: UP, DOWN, RETURN",True,True
	SetFont MenuFont
	
	Flip
End Function

Function EnterHiScore()
If Score>HiScore(4)
	ClsColor 0,31,31
	Cls
	DrawImage Title,400,100
	Text 400,200,"NEW HI-SCORE",True,True
	Text 400,250,"ENTER YOUR NAME",True,True
	Text 325-StringWidth(Score),350,Score,False,True
	Text 400,450,"(8 CHARACTERS MAX.)",True,True
	SetFont CopyrightFont
	Text 400,550,"COPYRIGHT 2001 W.I.P. GAMES    HTTP://MEMBERS.AOL.COM/WIPGAMES",True,True
	SetFont MenuFont
	
	Flip
	
	SetBuffer FrontBuffer()
	Locate 475,350-(FontHeight()/2)
	Name$=Input()
	SetBuffer BackBuffer()
	
	Name=Upper(Name)
	Name=LSet(Name,8)
	
	HiName(4)=Name
	HiScore(4)=Score
	For Count=3 To 0 Step -1
		If Score>HiScore(Count)
			HiName(Count+1)=HiName(Count)
			HiScore(Count+1)=HiScore(Count)
			HiName(Count)=Name
			HiScore(Count)=Score
		EndIf
	Next
	
	PlaySound(SFX_Hit)
	
	HiScores()
EndIf
	
End Function

Function DoMenuClusters()
	For MC.MenuCluster=Each MenuCluster
		MC\y=MC\y+StartSpeed
		If MC\y>632
			MC\y=MC\y-768
			MC\x=Int(Rand(0,24))*32
			MC\ClusterType=Rand(0,6)
			MC\ClusterRotation=Rand(0,3)
		EndIf
		DrawBlock BlockGraphics,MC\x,MC\y,MC\ClusterType
		For BlockCount=0 To 2
			DrawBlock BlockGraphics,(Cluster(MC\ClusterType,MC\ClusterRotation,BlockCount)\x_Offset*32)+MC\x,(Cluster(MC\ClusterType,MC\ClusterRotation,BlockCount)\y_Offset*32)+MC\y,MC\ClusterType
		Next
		
	Next
End Function

Function LoadHiScores()
	File=ReadFile("Dat\HiScores.dat")
	For Count=0 To 4
		HiName(Count)=ReadLine(File)
	Next
	For Count=0 To 4
		HiScore(Count)=ReadInt(File)
	Next
	CloseFile File
End Function

Function SaveHiScores()
	File=WriteFile("Dat\HiScores.dat")
	For Count=0 To 4
		WriteLine File,HiName(Count)
	Next
	For Count=0 To 4
		WriteInt File,HiScore(Count)
	Next
	CloseFile File
End Function

Function SaveKeys()
	File=WriteFile("Dat\Keys.dat")
	WriteInt File,Key_Left
	WriteInt File,Key_Right
	WriteInt File,Key_AntiSpin
	WriteInt File,Key_Spin
	WriteInt File,Key_Swap
	WriteInt File,Key_Drop
	CloseFile File
End Function

Function EndGame()
	SaveKeys()
	SaveHiScores()
	End
End Function

Function WIPIntro()
	IntroFont1=LoadFont("arial",100,True)
	IntroFont2=LoadFont("arial",20,True)
	SFX_Intro=LoadSound("Wav\Intro.wav")
	
	For Count=0 To 255
		Color Count,Count,Count
		SetFont IntroFont1
		Text 400,250,"W.I.P. Games",True,True
		Flip
		If GetKey()
			FreeFont IntroFont1
			FreeFont IntroFont2
			FreeSound SFX_Intro
			Return
		EndIf
	Next
	
	IntroChannel=PlaySound(SFX_Intro)
	
	For Count=0 To 255
		Color 255,255,255
		SetFont IntroFont1
		Text 400,250,"W.I.P. Games",True,True
		Color Count,Count,Count
		SetFont IntroFont2
		Text 400,310,"http://members.aol.com/WIPgames",True,True
		Flip
		If GetKey()
			FreeFont IntroFont1
			FreeFont IntroFont2
			If ChannelPlaying(IntroChannel) Then StopChannel IntroChannel
			FreeSound SFX_Intro
			Return
		EndIf
	Next

	For Count=255 To 0 Step -1
		Color Count,Count,Count
		SetFont IntroFont1
		Text 400,250,"W.I.P. Games",True,True
		Color 255,255,255
		SetFont IntroFont2
		Text 400,310,"http://members.aol.com/WIPgames",True,True
		Flip
		If GetKey()
			FreeFont IntroFont1
			FreeFont IntroFont2
			If ChannelPlaying(IntroChannel) Then StopChannel IntroChannel
			FreeSound SFX_Intro
			Return
		EndIf
	Next
	
	For Count=255 To 0 Step -1
		Cls
		Color Count,Count,Count
		SetFont IntroFont2
		Text 400,310,"http://members.aol.com/WIPgames",True,True
		Flip
		If GetKey()
			FreeFont IntroFont1
			FreeFont IntroFont2
			If ChannelPlaying(IntroChannel) Then StopChannel IntroChannel
			FreeSound SFX_Intro
			Return
		EndIf
	Next
	
	FreeFont IntroFont1
	FreeFont IntroFont2
End Function


					;C;R
Data 0,-1,0,1,0,2	;0;0
Data -1,0,1,0,2,0	;0;1
Data 0,-1,0,1,0,2	;0;2
Data -1,0,1,0,2,0	;0;3

Data 1,0,0,1,1,1	;1;0
Data 1,0,0,1,1,1	;1;1
Data 1,0,0,1,1,1	;1;2
Data 1,0,0,1,1,1	;1;3

Data 0,-1,1,0,1,1	;2;0
Data 1,0,-1,1,0,1	;2;1
Data 0,-1,1,0,1,1	;2;2
Data 1,0,-1,1,0,1	;2;3

Data 1,-1,1,0,0,1	;3;0
Data -1,0,0,1,1,1	;3;1
Data 1,-1,1,0,0,1	;3;2
Data -1,0,0,1,1,1	;3;3

Data 0,-1,1,-1,0,1	;4;0
Data -1,0,1,0,1,1	;4;1
Data 0,-1,-1,1,0,1	;4;2
Data -1,-1,-1,0,1,0	;4;3

Data -1,-1,0,-1,0,1	;5;0
Data 1,-1,-1,0,1,0	;5;1
Data 0,-1,0,1,1,1	;5;2
Data -1,0,1,0,-1,1	;5;3

Data -1,0,1,0,0,1	;6;0
Data 0,-1,-1,0,0,1	;6;1
Data 0,-1,-1,0,1,0	;6;2
Data 0,-1,1,0,0,1	;6;3