HidePointer

Graphics3D 640, 480, 0, 2					;3D graphics at a resolution of 800x600
SetBuffer BackBuffer()						;do all drawing to the back drawing buffer

Const PLAYER_COL= 1
Const LEVEL_COL = 2
Const ENEMY_COL = 3
Const BULLET_COL= 4

Type bullettype							;set up the bullet type
  Field entityhandle						;create a field to contain the handle of the bullets mesh
End Type

Type badguytype							;set up the badguy type
  Field entityhandle						;will contain the handle of the badguys mesh
  Field state							;will contain the state that the badguy is currently in
End Type

light = CreateLight()						;Create a light to see
RotateEntity light, 30, 30, 0					;angle the light

player = CreatePivot()						;A simple pivot is all we need to represent the player

camera = CreateCamera(player)					;create the camera and attach it to the player

CameraRange camera, .01, 250					;set the camera range to something reasonable

levelfloor=LoadMesh("lebel1.b3d")	
EntityType levelfloor,level_col

weapon1 = LoadMesh("ak.b3d", camera)			;load in the weapon mesh and attach it to the camera
ScaleEntity weapon1, .0025, .0025, .0025

bulletmesh = LoadMesh("bala.b3d")				;load in a bullet mesh (this will be a template mesh)
ScaleEntity bulletmesh, .0075, .0075, .0075
EntityType bulletmesh, BULLET_COL				;set up collision type for the bullet
EntityRadius bulletmesh, .01					;set up collision radius for the bullet

badguymesh = LoadMesh("malo.b3d")				;load in badguy mesh (this will also be a template mesh)
EntityType badguymesh, ENEMY_COL				;set up collision type for the badguy
EntityRadius badguymesh, .3, .95	 			;set up collision radius for the badguy (1.9 meters tall, .6 meters wide)

HideEntity bulletmesh						;hide the template meshes since they are not actual objects
HideEntity badguymesh						;this will also exclude them from collisions

For iter = 1 To 20						;create some badguys from the template badguy mesh
  badguy.badguytype = New badguytype				;create a new badguy
  badguy\entityhandle = CopyEntity(badguymesh)			;give him a mesh
  badguy\state = Rnd(1, 2) 					;1=Guard 2=Search 3=Evade 4=Attack 5=Dead
Next

MoveEntity camera, 0, .9, 0					;move camera up to height of players head (also moves weapon)
MoveEntity weapon1, .1, -.15, .1				;move weapon to bottom right of camera
MoveEntity player, 20, 1, -20					;move the player to the starting position

For badguy = Each badguytype					;iterate through all of the badguys
  PositionEntity badguy\entityhandle, Rnd(100)-50, 0, Rnd(100)-50	;move the badguy to a random starting position
Next

EntityType player, PLAYER_COL					;set up collision type for the player
EntityRadius player, .95, .95					;set up the players collision radius (1.9 meters tall, .6 meters wide)
												;set up collision type for the level
Collisions PLAYER_COL, LEVEL_COL, 2, 2				;player to level
Collisions PLAYER_COL, ENEMY_COL, 1, 2				;player to badguy
Collisions ENEMY_COL, LEVEL_COL, 2, 2				;badguy to level
Collisions BULLET_COL, LEVEL_COL, 2, 1				;bullet to level
Collisions BULLET_COL, ENEMY_COL, 2, 1				;bullet to badguy


While Not KeyHit(1) 						;ESC key

  wkey = KeyDown(17)						;collect user input
  skey = KeyDown(31)						;It's a good practice to collect these inputs only once
  akey = KeyDown(30)						;per loop.  This will prevent odd behaviors from happening,
  dkey = KeyDown(32)						;for instance if the state of a key changes between multiple
  mouse1 = MouseHit(1)						;checks of that key while still in the same loop.

  If wkey Then MoveEntity player, 0, 0, .1			;Forward - w key
  If skey Then MoveEntity player, 0, 0, -.1			;Back    - s key
  If akey Then MoveEntity player, -.1, 0, 0			;Left    - a key
  If dkey Then MoveEntity player, .1, 0, 0			;Right   - d key

  TurnEntity player, 0, -MouseXSpeed()/5.0, 0			;rotate player Pivot according to mouse X movement
  TurnEntity camera, MouseYSpeed()/5.0, 0, 0			;rotate camera up/down according to mouse Y movement
  If EntityPitch(camera) < -45					;don't allow camera to look below -45 degrees
    RotateEntity camera, -45, EntityYaw(camera), EntityRoll(camera)
  EndIf 
  If EntityPitch(camera) > 45					;don't allow camera to look above 45 degrees
    RotateEntity camera, 45, EntityYaw(camera), EntityRoll(camera)
  EndIf
  MoveMouse GraphicsWidth()/2, GraphicsHeight()/2		;reset mouse position to middle of screen

  TranslateEntity player, 0, -.1, 0				;simple gravity

  If mouse1							;check if left mouse button was pressed
    bullet.bullettype = New bullettype				;create a bullet
    bullet\entityhandle = CopyEntity(bulletmesh)		;create the bullet mesh
    PositionEntity bullet\entityhandle, EntityX(weapon1, 1), EntityY(weapon1, 1), EntityZ(weapon1, 1)	;place the bullet at the guns position
    RotateEntity bullet\entityhandle, EntityPitch(weapon1, 1), EntityYaw(weapon1, 1), EntityRoll(weapon1, 1);orientate the bullet with the gun
    ResetEntity bullet\entityhandle				;otherwise bullet could hit enemy while moving from 0,0,0 to current position
  EndIf

  For thisbullet.bullettype = Each bullettype			;iterate through all of the bullets
    MoveEntity thisbullet\entityhandle, 0, 0, 0.5			;move the bullet forward along the bullets Z axis
    If Abs(EntityX(thisbullet\entityhandle, 1)) > 10000		;check if the bullet is way out of bounds
      FreeEntity thisbullet\entityhandle			;delete the bullet mesh
      Delete thisbullet						;delete the bullet
    ElseIf Abs(EntityY(thisbullet\entityhandle, 1)) > 10000	;check if the bullet is way out of bounds
      FreeEntity thisbullet\entityhandle			;delete the bullet mesh
      Delete thisbullet						;delete the bullet
    ElseIf Abs(EntityZ(thisbullet\entityhandle, 1)) > 10000	;check if the bullet is way out of bounds
      FreeEntity thisbullet\entityhandle			;delete the bullet mesh
      Delete thisbullet						;delete the bullet
    EndIf
  Next

  UpdateWorld							;figures out collisions

  For thisbullet = Each bullettype				;iterate through all of the bullets
    If CountCollisions(thisbullet\entityhandle) > 0		;check if bullet collided with something
      enemyhit = EntityCollided(thisbullet\entityhandle, 3)	;note which enemy bullet collided with (if any)
      If enemyhit > 0 Then KillBadGuy(enemyhit)			;enemyhit contains entity handle of enemy that was hit
      FreeEntity thisbullet\entityhandle			;delete the bullet mesh
      Delete thisbullet						;delete the bullet
    EndIf
  Next

  RenderWorld							;draws the 3d scene
  Flip								;displays the scene to the screen
Wend								;loop until the ESC key is pressed
End

Function KillBadGuy(enemyhit)
  For thisbadguy.badguytype = Each badguytype			;iterate through all of the badguys
    If enemyhit = thisbadguy\entityhandle			;check if the enemy hit = this badguy
      If thisbadguy\state <> 5					;check if badguy is alive
        thisbadguy\state = 5 ;dead				;make him dead
        EntityType thisbadguy\entityhandle, 0			;turn off collisions for this badguy
        RotateEntity thisbadguy\entityhandle, 90, 0, 0		;make him horizontal
        TranslateEntity thisbadguy\entityhandle, 0, -.7, 0	;set him on the ground
        Exit							;exits the badguy For-Next loop (no need to check rest of badguys)
      EndIf
    EndIf
  Next
End Function