Graphics3D 800,600,0,2
SetBuffer BackBuffer()
AppTitle "Wheel Example"

Global speed# = 0
Const accel# = 0.2
Const decel# = 0.01
Const break# = 0.3
Const topspeed# = 35

;LOAD WHEEL
Global wheel=LoadMesh("wheel.3ds")
PositionEntity(wheel,0,0,0)
wheel_tex=LoadTexture("tire_texb.jpg")
EntityTexture(wheel,wheel_tex)	

camera_piv=CreatePivot()
camera = CreateCamera(camera_piv)
PositionEntity(camera_piv,-20,0,20)
PointEntity(camera,wheel)
CameraClsColor(camera,100,99,139)

;------------------------------------------------------------------------------------
;MAIN LOOP
;------------------------------------------------------------------------------------
While Not KeyHit(1)
	
	SpinWheel()
	
	
	
	UpdateWorld
	RenderWorld
	
	Text 10,10,"Speed = "+speed
	
	Flip
	
Wend

End

Function SpinWheel()
	
	speed = speed - decel
	If speed<0 Then speed = 0
	
	If KeyDown(200)
		
		speed = speed + accel
		If speed> topspeed Then speed = topspeed 
		
	EndIf
	
	If KeyDown(208)
		
		speed = speed - break
		
	End If
	
	If speed< 0 Then speed = 0
	
	TurnEntity(wheel,speed,0,0)
	
End Function	
;~IDEal Editor Parameters:
;~C#Blitz3D