;--------------------------------------------------------------------
; This is a simple test app using the B3d Extensions library.
; Export an animated scene from Max that includes a camera.
; Load the b3d at the prompt and watch the scene animate.
; All B3d Extensions in the file will be supported.
;--------------------------------------------------------------------

Include "B3dExtensions.bb"

Graphics3D(640,480,32,2)

model = LoadAnimMesh("test.b3d")
If (Not model) RuntimeError("Invalid File")

extModel.EXT_Entity = EXT_InitEntity(model)

; This simple test app needs a camera
If (EXT_NumCameras(extModel)=0) Then RuntimeError("No Cameras in b3d File!")


camera = extModel\camera\camera
CameraProjMode(camera,1)

EXT_SetRenderCam(camera)

EXT_ActivateEnvironment(extModel)

frameTimer = CreateTimer(60)
Animate(model)

While Not KeyHit(1)

If KeyDown(200)
   MoveEntity camera,0,0,1	
EndIf
If KeyDown(208)
   MoveEntity camera,0,0,-1	
EndIf

If KeyDown(203)
   TurnEntity camera,0,1,0	
EndIf
If KeyDown(205)
   TurnEntity camera,0,-1,0	
EndIf

	EXT_UpdateEntity(extModel)
	EXT_UpdateEnvironment()
	EXT_UpdateCamera(extModel\camera)
	
	UpdateWorld()
	RenderWorld()
	
	WaitTimer(frameTimer)

	Flip

Wend
End