-- Fracture version 0.4.  This is a work in progress.  Please feel free to modify this code, but let me know so that I
-- can benefit from the changes as well :)

-- David Gohara david_gohara@hms.harvard.edu
-- Special thanks to Swami Lama for providing the Explode Elements function.  
-- Also thanks to Bobo and Swami for answering my inane questions. 
-- Thanks to Maneswar Cheemalapati for pointing out problems in the original script.

-- NOTES:  The farther the object is from the origin the more random the orientation of the slice planes.

rollout utilFracture "Fracture"

(

group "Settings:"
	(
		spinner slice_num "Min. # Slice Planes:" range:[0,15,6] fieldWidth:35 type:#integer
		spinner plane_lsegs "Length Segments:" range:[5,100,20] fieldWidth:35 type:#integer
		spinner plane_wsegs "Width Segments:" range:[5,100,20] fieldWidth:35 type:#integer
		spinner slice_height "Slice Height Mult." range:[0.001, 0.100, 0.001] fieldWidth:40 type:#float
	)

group "Mat. Type Selection:"
	(
		-- Define 3 Radiobuttons for the Application of a 2-sided material (ideal for times when cap holes doesn't work).
		radiobuttons radButtons2 labels:#("2-Sided Mat.","1-Sided Mat.","No Mat.") default:2 columns:1 align:#left
	)

group "Bend Settings:"
	(
		spinner angs "Max. Angle:" range:[0,359,230] fieldWidth:35 type:#integer
		spinner dirs "Max. Direction:" range:[0.0,45.0,0.0] fieldWidth:35 type:#float
	)

group "Reactor Compatible"
	(
		radioButtons radButtons3 labels:#("On","Off") default:2 columns:2 align:#left
	)
	
pickbutton chooseit "Select Fracture Object"
on chooseit picked frac do
			
			(
				frac.name = "myFracObj"
				chooseit.text = frac.name			
			)

button btnFracture "Fracture"
on btnFracture pressed do

(

 with redraw off	
 max create mode
 
 undo on
	
	(	
			obj = getNodeByName chooseit.text
					
			xdim = abs(obj.min.x - obj.max.x)
			ydim = abs(obj.min.y - obj.max.y)
			zdim = abs(obj.min.z - obj.max.z)

			maxdim = amax #(xdim, ydim, zdim)
			
--Create slice planes
--Slice Planes are actually very thin boxes designed to be larger than the maximum dimension of the fracture object.
		
		for i = 1 to slice_num.value do
		(
			new_box = box length:(maxdim*1.5) width:(maxdim*1.5) height:(maxdim*(slice_height.value)) lengthsegs:plane_lsegs.value widthsegs:plane_wsegs.value
			
			new_box.name = uniquename "sliceBox"
			
			new_box.pos.x = obj.pos.x
			new_box.pos.y = obj.pos.y
			new_box.pos.z = random ((obj.min.z)*0.9) ((obj.max.z)*0.9)

--Assign rotation in space.  
--This procedure will assign a psuedo-random orientation of the various planes relative to one another.		

			(
				if obj.pos.x==0 then
					(
						opx = random obj.min.x obj.max.x 
						new_box.rotation.x_rotation = random -opx opx
					)
				else new_box.rotation.x_rotation = random -obj.pos.x obj.pos.x
			)
			
			(
				if obj.pos.y==0 then
					(
						opy = random obj.min.y obj.max.y 
						new_box.rotation.y_rotation = random -opy opy
					)
				else new_box.rotation.y_rotation = random -obj.pos.y obj.pos.y
			)
			
			(
				if obj.pos.z==0 then
					(
						opz = random obj.min.z obj.max.z 
						new_box.rotation.z_rotation = random -opz opz
					)
				else new_box.rotation.z_rotation = random -obj.pos.z obj.pos.z
			)
			
	
--Bend the Slice Planes
--This option works the best of all the methods.

			(
				local ang = random -angs.value angs.value
				local dir = random -dirs.value dirs.value
				addmodifier new_box (bend angle:ang direction:dir axis:0)
			)
			
			convertToPoly new_box
			
		) -- END for i LOOP
	

--Assign a material to the object
	
	(
		(
			if radButtons2.state == 1 then
				(
					mat = standardMaterial()  
					mat.ShaderType = 1
					mat.twoSided = true
					obj.material = mat
				)
	
			if radButtons2.state == 2 then
				(
					mat = standardMaterial()  
					mat.ShaderType = 1
					mat.twosided = false
					obj.material = mat
				)
		
			if radButtons2.state == 3 then
				(
		 			obj.material = undefined
				)
		)
	)
	
--Cut the object (Standard Max Booleans)
	slice_plane = $sliceBox*
		
		for j = 1 to slice_plane.count do
			(
				select obj
				
				obj - slice_plane[j]
				
				convertToPoly obj
				
			) -- END for j LOOP
	
	delete slice_plane
	select obj

-- EXPLODE THE OBJECTS!

-- This code was originally generated by Swami Lama.  See the MaxScript explodeElements v 0.22(1).
-- Thanks to Swami for generously providing this invaluable function.  The code below is a stripped down verion
-- of Swami's original function.

fn explodeElements obj =
(
	local objArr
	if (classOf obj==Editable_Mesh) OR (classOf obj==Editable_Poly) then
	(
		objArr=#(obj)
		local objName=obj.name
		local geuf
		local cnt=0
		if classOf obj==Editable_Mesh then convertTo obj Editable_Poly
		while (geuf=polyop.getElementsUsingFace obj 1 as array).count < (polyop.getNumFaces obj) do
		(
			polyop.detachFaces obj (polyop.getElementsUsingFace obj 1) asNode: true	name: "" delete: true
			polyop.collapseDeadStructs obj
			append objArr objects[objects.count]
		)
		
-- Rename exploded objects.

		local cnt=0
		local charMax=(objArr.count as string).count
		for obj in objArr do
		(
			cnt+=1
			local cntStr=cnt as string
			local cntStrLen=cntStr.count
			local leadingZeros=""
			if cntStrLen<charMax then	-- Optimized for an object w/ a large # of elements.
			(
				for i=1 to (charMax-cntStrLen) do leadingZeros+="0"
				cntStr=leadingZeros+cntStr
			)
			suffixTMP=if suffix==undefined then "" else (suffix+"_")
			obj.name=objName+"_"+suffixTMP+cntStr
		)
		
		select objArr
	)	
)--end function explodeElements

objArr = explodeElements obj

--Cap holes and refine the final poly's

	expFragments = $myFracObj*

		for i = 1 to expFragments.count do
		
			(
				addmodifier expFragments[i] (cap_holes smooth_new_faces:1 smooth_with_old_face:1)
				convertToPoly expFragments[i]
				polyOp.autoSmooth expFragments[i]
				expVertCount = polyOp.getNumVerts expFragments[i]
				
--Check for fragments that have fewer than 4 vertices
				
				if radButtons3.state == 1 AND (expVertCount < 4) then
					(
						delete expFragments[i]
					)
			)

max modify mode

)--end undo
)--END button fracture	
)--end rollout

if FractureFloater != undefined do
	(
		closeRolloutFloater FractureFloater
	)
	
FractureFloater = newRolloutFloater "Fracture v0.4" 200 390
addRollout utilFracture FractureFloater