#include "ventana.hpp"
#include "common.cpp"

#include <gtkmm/stock.h>

#include <fstream>
#include <cstring>
#include <iostream>

MWin::MWin () :
	m_Solapa1(4, 2, true),
	m_Label_Red("Red"),
	m_Label_Green("Green"),
	m_Label_Blue("Blue"),
	m_Label_Ratio("Ratio"),

	m_Red_adjustement(0.0, 0.0, 101.0, 0.1, 1.0, 1.0),
	m_Green_adjustement(0.0, 0.0, 101.0, 0.1, 1.0, 1.0),
	m_Blue_adjustement(0.0, 0.0, 101.0, 0.1, 1.0, 1.0),
	m_Ratio_adjustement(0.0, 0.0, 101.0, 0.1, 1.0, 1.0),

	m_Range_Red (m_Red_adjustement),
	m_Range_Green (m_Green_adjustement),
	m_Range_Blue (m_Blue_adjustement),
	m_Range_Ratio (m_Ratio_adjustement),

	imagen_f ( "green.png" )

{
	set_title("Monster3");
	set_default_size(400, 400);
	maximize ();

	add(m_Caja_Top);

	//Crear acciones para los menús:
	v_GrupodeAccion = Gtk::ActionGroup::create();

	//Archivo|Nuevo
	v_GrupodeAccion->add(Gtk::Action::create("FileNewStandard",
		Gtk::Stock::NEW, "_New", "Create a new file"),
		sigc::mem_fun(*this, &MWin::en_click));

	//File menu:
	v_GrupodeAccion->add(Gtk::Action::create("FileMenu", "File"));
	//Sub-menu.
	v_GrupodeAccion->add(Gtk::Action::create("FileNew", Gtk::Stock::NEW));

	v_refUIManager = Gtk::UIManager::create();
	v_refUIManager->insert_action_group(v_GrupodeAccion);


	Glib::ustring ui_info = 
        "<ui>"
        "  <menubar name='MenuBar'>"
        "    <menu action='FileMenu'>"
        "      <menuitem action='FileNew'/>"
        "    </menu>"
	"  </menubar>"
        //"  <toolbar  name='ToolBar'>"
        //"    <toolitem action='FileNewStandard'/>"
        //"    <toolitem action='FileQuit'/>"
        //"  </toolbar>"
        "</ui>";

	#ifdef GLIBMM_EXCEPTIONS_ENABLED
	try
	{
		v_refUIManager->add_ui_from_string(ui_info);
	}
	catch(const Glib::Error& ex)
	{
		std::cerr << "building menus failed: " <<  ex.what();
	}
	#else
	std::auto_ptr<Glib::Error> ex;
	m_refUIManager->add_ui_from_string(ui_info, ex);
	if(ex.get())
	{
		std::cerr << "building menus failed: " <<  ex->what();
	}
	#endif //GLIBMM_EXCEPTIONS_ENABLED

	//Get the menubar and toolbar widgets, and add them to a container widget:
	Gtk::Widget* pMenubar = v_refUIManager->get_widget("/MenuBar");
	if(pMenubar)
		m_Caja_Top.pack_start(*pMenubar, Gtk::PACK_SHRINK);






	m_Caja_Top.pack_start(division);

	division.pack1 (myArea, true, true);
	division.pack2 (v_Controles, true, true);

	division.set_position (200);




	//Dibujo
	//m_Caja_Top.pack_start(myArea);
	myArea.signal_expose_event().connect(sigc::mem_fun(*this,
		&MWin::exposicion));

	myArea.signal_button_press_event().connect(sigc::mem_fun(*this,
		&MWin::toma_color));
	myArea.add_events ( Gdk::BUTTON_PRESS_MASK );
	




	//Croma
	m_Solapa1.attach(m_Label_Red, 0, 1, 0, 1);
	m_Solapa1.attach(m_Label_Green, 0, 1, 1, 2);
	m_Solapa1.attach(m_Label_Blue, 0, 1, 2, 3);
	m_Solapa1.attach(m_Label_Ratio, 0, 1, 3, 4);

	m_Red_adjustement.signal_value_changed().connect(sigc::mem_fun(*this,
		&MWin::key_recalcular));
	m_Green_adjustement.signal_value_changed().connect(sigc::mem_fun(*this,
		&MWin::key_recalcular));
	m_Blue_adjustement.signal_value_changed().connect(sigc::mem_fun(*this,
		&MWin::key_recalcular));
	m_Ratio_adjustement.signal_value_changed().connect(sigc::mem_fun(*this,
		&MWin::key_recalcular));

	m_Range_Red.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  	m_Range_Red.set_digits(3);
	m_Range_Red.set_value_pos(Gtk::POS_TOP);
	m_Range_Red.set_draw_value();
	m_Range_Red.set_size_request(20, 30);

	m_Range_Green.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  	m_Range_Green.set_digits(3);
	m_Range_Green.set_value_pos(Gtk::POS_TOP);
	m_Range_Green.set_draw_value();
	m_Range_Green.set_size_request(20, 30);

	m_Range_Blue.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  	m_Range_Blue.set_digits(3);
	m_Range_Blue.set_value_pos(Gtk::POS_TOP);
	m_Range_Blue.set_draw_value();
	m_Range_Blue.set_size_request(20, 30);

	m_Range_Ratio.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  	m_Range_Ratio.set_digits(3);
	m_Range_Ratio.set_value_pos(Gtk::POS_TOP);
	m_Range_Ratio.set_draw_value();
	m_Range_Ratio.set_size_request(20, 30);

	m_Solapa1.attach(m_Range_Red, 1, 2, 0, 1);
	m_Solapa1.attach(m_Range_Green, 1, 2, 1, 2);
	m_Solapa1.attach(m_Range_Blue, 1, 2, 2, 3);
	m_Solapa1.attach(m_Range_Ratio, 1, 2, 3, 4);


	//Notebook (Solapas)
	v_Controles.set_border_width(5);
	//m_Caja_Top.pack_start(v_Controles);

	//Add the Notebook pages: (Solapas)
	v_Controles.append_page(m_Solapa1, "Croma");
	//v_Controles.append_page(m_Label2, "Niveles");

	//v_Controles.signal_switch_page().connect(sigc::mem_fun(*this,
	//	&ExampleWindow::on_notebook_switch_page) );


	show_all_children();


}

MWin::~MWin()
{
}

void MWin::en_click()
{
	hide(); //to close the application.
}

void MWin::gen_click()
{

}

bool MWin::toma_color(GdkEventButton* event)
{
	/*
	struct GdkEventButton
	{
	  GdkEventType type;
	  GdkWindow *window;
	  gint8 send_event;
	  guint32 time;
	  gdouble x;
	  gdouble y;
	  gdouble pressure;
	  gdouble xtilt;
	  gdouble ytilt;
	  guint state;
	  guint button;
	  GdkInputSource source;
	  guint32 deviceid;
	  gdouble x_root, y_root;
	};
	*/

	//std::cout << event->x << std::endl;
	if( (event->type == GDK_BUTTON_PRESS) && (event->button == 3) )
	{
		//std::cout << "1" << std::endl;
		int c_y = event->y;
		int c_x = event->x;
		
		if ( (c_y < imagen_f.height) & (c_x < imagen_f.width) )
		{
			m_Range_Red.set_value( imagen_f.map[c_y][c_x][0] );
			m_Range_Green.set_value( imagen_f.map[c_y][c_x][1] );
			m_Range_Blue.set_value( imagen_f.map[c_y][c_x][2] );		
			//std::cout << imagen_f.map[c_y][c_x][1]  << std::endl;
		}
	}

	return true;
}

void MWin::key_recalcular()
{
	double val_Red = m_Red_adjustement.get_value();
	double val_Green = m_Green_adjustement.get_value();
	double val_Blue = m_Blue_adjustement.get_value();
	double val_Ratio = m_Ratio_adjustement.get_value();
	
	keying key (imagen_f, val_Red, val_Green, val_Blue, val_Ratio);

	myArea.queue_draw();

}

bool MWin::exposicion(GdkEventExpose* event)
{

	Gtk::Allocation allocation = get_allocation();
	const int width = allocation.get_width();
	const int height = allocation.get_height();

	// coordinates for the center of the window
	int image_width, image_height;


	Cairo::RefPtr<Cairo::Context> cr = myArea.get_window()->create_cairo_context( );

	//cr->scale( 100,100 );

	// clip to the area indicated by the expose event so that we only redraw
	// the portion of the window that needs to be redrawn
	



	Cairo::RefPtr< Cairo::ImageSurface > image_s;

	unsigned char temp[ (imagen_f.width+1) * (imagen_f.height+1) *4 ];

	levels lev (imagen_f, 0, 100, 40, 100, 3);

	read_imagen_flotante(temp, imagen_f);

	image_s = Cairo::ImageSurface::create ( temp, Cairo::FORMAT_ARGB32, imagen_f.width, imagen_f.height, (imagen_f.width)*4);

	//std::cout << "Leer" << std::endl;

	//std::cout << temp[1578236] << std::endl;

	//std::cout << "Leido" << std::endl;

	//image_s = Cairo::ImageSurface::create ( temp, Cairo::FORMAT_ARGB32, 719, 547, 720*4);

	//image_s = Cairo::ImageSurface::create_from_png ("green.png");

	image_width = image_s->get_width();
	image_height = image_s->get_height();

	cr->save();

	cr->set_source (image_s, 0.0, 0.0);

	//cr->rectangle (0.0, 0.0, image_width, image_height);

	cr->rectangle(event->area.x, event->area.y, event->area.width, event->area.height);

	cr->clip();

	cr->paint();

	cr->restore();

	return true;
}

unsigned char MWin::read_imagen_flotante(unsigned char *temp, imagen_flotante &imagen )
{
	
	int n, x, y, c, r_height, r_width;
	float ***r_map;
	

	r_map = imagen.map;
	r_height = imagen.height;
	r_width = imagen.width;
	
	//unsigned char temp [(r_height+1)*(r_width+1)*4];

	n = 0;
	for (y=0; y<r_height; y++) {
		for (x=0; x<r_width; x++) {
				//std::cout << x << ":" << y << std::endl;
				
				if (1) //RGBA
				{
					temp[n+3] = float_to_uchar (r_map[y][x][3]); //Alpha premultiplicada
					temp[n] = float_to_uchar (r_map[y][x][2] * (r_map[y][x][3] / 100) ); //Azul
					temp[n+1] = float_to_uchar (r_map[y][x][1] * (r_map[y][x][3] / 100) ); //Verde
					temp[n+2] = float_to_uchar (r_map[y][x][0] * (r_map[y][x][3] / 100) ); //Rojo
					//std::cout << n << std::endl;
				}
				else if (0) //R
				{
					temp[n+3] = float_to_uchar (r_map[y][x][3]); //Alpha premultiplicada
					temp[n] = float_to_uchar (r_map[y][x][2] * (r_map[y][x][3] / 100) ); //Azul
					temp[n+1] = float_to_uchar (r_map[y][x][1] * (r_map[y][x][3] / 100) ); //Verde
					temp[n+2] = float_to_uchar (r_map[y][x][0] * (r_map[y][x][3] / 100) ); //Rojo
					//std::cout << n << std::endl;
				}
				else if (0) //G
				{
					temp[n+3] = float_to_uchar (r_map[y][x][3]); //Alpha premultiplicada
					temp[n] = float_to_uchar (r_map[y][x][2] * (r_map[y][x][3] / 100) ); //Azul
					temp[n+1] = float_to_uchar (r_map[y][x][1] * (r_map[y][x][3] / 100) ); //Verde
					temp[n+2] = float_to_uchar (r_map[y][x][0] * (r_map[y][x][3] / 100) ); //Rojo
					//std::cout << n << std::endl;
				}
				else if (0) //B
				{
					temp[n+3] = float_to_uchar (r_map[y][x][3]); //Alpha premultiplicada
					temp[n] = float_to_uchar (r_map[y][x][2] * (r_map[y][x][3] / 100) ); //Azul
					temp[n+1] = float_to_uchar (r_map[y][x][1] * (r_map[y][x][3] / 100) ); //Verde
					temp[n+2] = float_to_uchar (r_map[y][x][0] * (r_map[y][x][3] / 100) ); //Rojo
					//std::cout << n << std::endl;
				}
				else if (0) //Alpha
				{
					temp[n+3] = 255; //Alpha premultiplicada
					temp[n] = float_to_uchar (r_map[y][x][3] ); //Azul
					temp[n+1] = float_to_uchar (r_map[y][x][3] ); //Verde
					temp[n+2] = float_to_uchar (r_map[y][x][3] ); //Rojo
					//std::cout << n << std::endl;
				}
					n+=4;

		}
	}
	//std::cout << "ok!" << temp[1578236] << std::endl;
	return 1;
}




