
#include "imagen_flotante.hpp"
#include "common.cpp"
#include <iostream>
#define PNG_DEBUG 3
#include <png.h>


imagen_flotante::imagen_flotante (unsigned int height_, unsigned int width_, unsigned int channels_) {

	//
	//if (height_ < 1 || whidth_ <1) return 1;
	//if (channels_ <1) return 1;
	//

	int x, y, c;

	height = height_;
	width = width_;
	channels = channels_;

	map = new float**[height]; //Alloca las Rows

	for (y=0; y<height; y++) {
		map[y] = new float*[width];
		for (x=0; x<width; x++) {
			map[y][x] = new float [channels];
			for (c=0; c<channels; c++) {
				map[y][x][c]=100;
			}//End Channels
		}//End Columns
	}//End Rows

};

imagen_flotante::imagen_flotante ( char *name ) { //Carga archivo

	unsigned char header[8];	// 8 is the maximum size that can be checked
	png_bytep * png_map;
	png_structp png_ptr;
	png_infop info_ptr;
	png_byte color_type;
	png_byte bit_depth;
	int number_of_passes;
	png_bytep * row_pointers;
	int png_width, png_height, png_channels;
	int x, y, c;

	/* open file and test for it being a png */
	FILE *fp = fopen(name, "rb");

	if (!fp)
		std::cout << "[read_png_file] File could not be opened for reading" << std::endl << std::endl;

	fread(header, 1, 8, fp);

	if (png_sig_cmp(header, 0, 8))
		std::cout << "[read_png_file] File is not recognized as a PNG file" << std::endl << std::endl;


	/* initialize stuff */
	png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	
	if (!png_ptr)
		std::cout << "[read_png_file] png_create_read_struct failed" << std::endl << std::endl;

	info_ptr = png_create_info_struct(png_ptr);
	if (!info_ptr)
		std::cout << "[read_png_file] png_create_info_struct failed" << std::endl << std::endl;

	if (setjmp(png_jmpbuf(png_ptr)))
		std::cout << "[read_png_file] Error during init_io" << std::endl << std::endl;

	png_init_io(png_ptr, fp);
	png_set_sig_bytes(png_ptr, 8);

	png_read_info(png_ptr, info_ptr);

	png_width = info_ptr->width;
	png_height = info_ptr->height;
	color_type = info_ptr->color_type;
	bit_depth = info_ptr->bit_depth;

	number_of_passes = png_set_interlace_handling(png_ptr);
	png_read_update_info(png_ptr, info_ptr);


	/* read file */
	if (setjmp(png_jmpbuf(png_ptr)))
		std::cout << "[read_png_file] Error during read_image" << std::endl << std::endl;

	//std::cout << "Alloco.." << std::endl << std::endl;

	row_pointers = (png_bytep*) malloc(sizeof(png_bytep) * png_height);
	for (y=0; y<png_height; y++)
		row_pointers[y] = (png_byte*) malloc(info_ptr->rowbytes);

	png_read_image(png_ptr, row_pointers);

        fclose(fp);

	///

	height = png_height;
	width = png_width;
	//channels = png_channels;
	channels = 4;

	//if (color_type == PNG_COLOR_TYPE_RGB_ALPHA)
        //	png_set_swap_alpha(png_ptr);

	map = new float**[height]; //Alloca las Rows

	for (y=0; y<height; y++) {
		map[y] = new float*[width];
		for (x=0; x<width; x++) {
			map[y][x] = new float [channels];
			for (c=0; c<channels; c++) {
				map[y][x][c]=0;
			}//End Channels
		}//End Columns
	}//End Rows

	for (y=0; y<height; y++) {
		png_byte* row = row_pointers[y];
		for (x=0; x<width; x++) {
			png_byte* ptr = &(row[x*4]);

			map[y][x][0] = uchar_to_float ( ptr[0] );
			map[y][x][1] = uchar_to_float ( ptr[1] );
			map[y][x][2] = uchar_to_float ( ptr[2] );
			map[y][x][3] = uchar_to_float ( ptr[3] );
			//std::cout << "Leyendo " << (int)ptr[0] << ":" << (int)ptr[1] << ":" << (int)ptr[2] << ":"  << (int)ptr[3] << std::endl;
			//

		}
	}
/*
	for (y=0; y<height; y++) {
		delete[] row_pointers[y];
	}
	delete[] row_pointers;
*/

};

void imagen_flotante::write_png ( char *name ) {

	png_bytep * png_map;
	png_structp png_ptr;
	png_infop info_ptr;
	int x, y, c;

	FILE *fp = fopen( name, "wb");
	if (!fp)
		std::cout << "[write_png_file] File %s could not be opened for writing" << std::endl << std::endl;

	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);

	if (!png_ptr)
		std::cout << "[write_png_file] png_create_write_struct failed" << std::endl << std::endl;

	info_ptr = png_create_info_struct(png_ptr);

	if ( setjmp(png_jmpbuf(png_ptr)) )
		std::cout << "[write_png_file] Error during init_io" << std::endl << std::endl;

	png_init_io(png_ptr, fp);

	if ( setjmp(png_jmpbuf(png_ptr)) )
		std::cout << "[write_png_file] Error during writing header" << std::endl << std::endl;

	png_set_IHDR (png_ptr, info_ptr, width, height, 8, PNG_COLOR_TYPE_RGB_ALPHA, PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

	

	png_map = (png_bytep*) malloc(sizeof(png_bytep) * height);
	for (y=0; y<height; y++)
		png_map[y] = (png_byte*) malloc(info_ptr->rowbytes);

	//Write Data
	for (y=0; y<height; y++) {
		png_byte* row = png_map[y];
		for (x=0; x<width; x++) {
			png_byte* ptr = &(row[x*4]);
			ptr[0] = float_to_uchar ( map[y][x][0] );
			ptr[1] = float_to_uchar ( map[y][x][1] );
			ptr[2] = float_to_uchar ( map[y][x][2] );
			ptr[3] = float_to_uchar ( map[y][x][3] );
			//std::cout << "Escribiendo " << map[y][x][0] << ":" << map[y][x][1] << ":" << map[y][x][2] << ":"  << map[y][x][3] << std::endl;
			//std::cout << "            " << (int)ptr[0] << ":" << (int)ptr[1] << ":" << (int)ptr[2] << ":"  << (int)ptr[3] << std::endl;
			//std::cout << x << ":" << y << std::endl;
		}
	}

	//OJO CON ESTO
	png_set_packing(png_ptr);

	png_write_info(png_ptr, info_ptr);

	if ( setjmp(png_jmpbuf(png_ptr)) )
		std::cout << "[write_png_file] Error during writing bytes" << std::endl << std::endl;

	png_write_image(png_ptr, png_map);

	if ( setjmp(png_jmpbuf(png_ptr)) )
		std::cout << "[write_png_file] Error during end of write" << std::endl << std::endl;

	png_write_end(png_ptr, NULL);


	for (y=0; y<height; y++) {
		delete[] png_map[y];
	}
	delete[] png_map;

	png_destroy_write_struct(&png_ptr, &info_ptr);

        fclose(fp);


};

imagen_flotante::~imagen_flotante () {

	int x, y;

	for (y=0; y<height; y++) {
		//delete[] map[y];
		for (x=0; x<width; x++) {
			delete[] map[y][x];
		}//End Columns
	}//End Rows

	for (y=0; y<height; y++) {
		delete[] map[y];
	}//End Rows

	delete[] map; //Desalloca las Rows
};
