
#include "fractal_a.hpp"

fractal_a::fractal_a ( imagen_flotante &imagen, float ratio ) {

	int x, y, f_y_p, f_x_p, y_b, x_b;
	float ***f_map;
	float f_red_p, f_green_p, f_blue_p;

	f_map = imagen.map;
	f_height = imagen.height;
	f_width = imagen.width;

	f_y_p = f_height * ratio;
	f_x_p = f_width * ratio;

	std::cout << f_y_p << std::endl;
	std::cout << f_x_p << std::endl;

	if ((f_y_p < 1) & (f_x_p <1)) return;
	if (f_y_p < 1) f_y_p = 1;
	if (f_x_p < 1) f_x_p = 1;

	//Bloques
	for (y_b=0; y_b < f_height; y_b += f_y_p) {

		//std::cout << "Y: " << y_b << std::endl;
		//if (y_b > f_height) y_b = f_height;

		for (x_b=0; x_b < f_width; x_b += f_x_p) {

			//std::cout << "X: " << x_b << std::endl;
			//if (x_b > f_width) x_b = f_width;

			f_red_p = 0;
			f_green_p = 0;
			f_blue_p = 0;

			//Promedia los píxeles
			for (y = y_b; (y < y_b + f_y_p) & (y < f_height); y++) {
				for (x = x_b; (x < x_b + f_x_p) & (x < f_width); x++) {

					//std::cout << "X, Y: " << x << " : " << y << std::endl;

					f_red_p += f_map[y][x][0] ;
					f_green_p += f_map[y][x][1] ;
					f_blue_p += f_map[y][x][2] ;


					//std::cout << "Alpha: " << c_map[y][x][3] << std::endl;


					//std::cout << "RGB: " << f_blue_p << "    :    " << f_green_p << "     :     " << f_blue_p << std::endl;

				}//End Columns
			}//End Rows

			f_red_p = f_red_p / ((x-x_b) * (y-y_b));
			f_green_p = f_green_p / ((x-x_b) * (y-y_b));
			f_blue_p = f_blue_p / ((x-x_b) * (y-y_b));


			//Vuelca los píxeles
			for (y = y_b; (y < y_b + f_y_p) & (y < f_height) ; y++) {
				for (x = x_b; (x < x_b + f_x_p) & (x < f_width); x++) {

					f_map[y][x][0] = f_red_p;
					f_map[y][x][1] = f_green_p;
					f_map[y][x][2] = f_blue_p;

					//std::cout << "Alpha: " << f_map[y][x][3] << std::endl;

					//std::cout << "Rojo: " << f_red << std::endl;


				}//End Columns
			}//End Rows
		}
	}

};
