-- Desarrollado por Jonathan Garca a.k.a HalfVector --

-- Funcin que distribuye los objetos en <trees> aleatoriamente en el plano XY
-- teniendo en cuenta los lmites XY del objeto <terrain>.
-- Los objetos se posicionarn a una altura <height> y respetarn
-- los bordes especificados por <border>
fn distributeTrees terrain trees border height = (
	-- Recorremos la lista de rboles
	for tree in trees do (
		-- Generamos una posicin aleatoria que se encuentre dentro de los lmites del terreno
		local pos = random (terrain.min + border) (terrain.max - border)
		-- Actualizamos la componente X...
		tree.pos.x = pos.x
		-- ...e Y con la posicin aleatoria
		tree.pos.y = pos.y
		-- Calculamos la posicin vertical del arbol
		tree.pos.z = terrain.max.z + height
	)
)

-- Destrumos el cuadro de dilogo
try ( destroyDialog roLayDownTrees ) catch ()

rollout roLayDownTrees "Lay Down Trees" width:232 height:280
(
	-- Controles de la GUI --

	listbox lbxTerrain ".::Terrain Objects::." pos:[8,8] width:104 height:9
	listbox lbxTrees ".::Trees::." pos:[120,8] width:104 height:9
	button btnTerrainAdd "Add selection" pos:[8,160] width:104 height:16
	button btnTerrainClear "Clear all" pos:[8,178] width:104 height:16
	button btnTreesAdd "Add selection" pos:[120,160] width:104 height:16
	button btnTreesClear "Clear all" pos:[120,178] width:104 height:16
	button btnDoIt "Lay down trees!" pos:[16,232] width:200 height:16
	button btnExit "Exit" pos:[60,256] width:112 height:16
	progressBar pbTrees "ProgressBar" pos:[8,208] width:216 height:16 color:(color 255 127.5 0)

	-- Funcin que detecta si el rayo <theRay> intersecta con alguno de
	-- los nodos contenidos en el array <nodeNames>. Hay que tener en
	-- cuenta que este array contiene los nombres de los nodos, no los nodos
	fn closestRayIntersection nodeNames theRay = (

		-- Inicializamos variables
		local closestDist = 999999999
		local closestInfo = undefined
		
		-- Recorremos todos los nodos especificados
		for nodeName in nodeNames do (
		
			-- Recogemos el nodo cuyo nombre es <nodeName>
			local node = getNodeByName nodeName
	
			-- Con la funcin <intersectRay> averiguamos si un rayo <theRay>
			-- intersecta con un objeto <node>
			local i = intersectRay node theRay
			
			-- Si hubo interseccin...
			if i != undefined do (
				-- Distancia entre el origen del rayo <theRay> y el punto
				-- de interseccin <i.pos>
				local dist = distance theRay.pos i.pos
				
				-- Si la distancia recin calculada, <dist>, es menor que la
				-- menor distancia anterior, <closestDist>...
				if dist < closestDist do (
					-- Actualizamos la distancia ms cercana al origen del rayo
					closestDist = dist
					-- Actualizamos la informacin de interseccin
					closestInfo = i
				)
			)
		)
		
		-- Si hubo interseccin, <closestNode> ser distinto de undefined
		if closestInfo != undefined do
			-- Retornamos la informacin de interseccin
			return closestInfo

		-- No hubo interseccin
		return undefined
	)

	-- Event handler que se llama cuando se abre el rollout
	on roLayDownTrees open do (
		-- Nada que hacer aqu
	)

	-- Event handler que se llama cuando se cierra el rollout
	on roLayDownTrees close do (
		-- Nada que hacer aqu
	)

	-- Event handler que se lanza cuando se pulsa el botn <btnTerrainAdd>
	-- Aqu rellenamos la lista de objetos que forman el terreno con los
	-- objetos seleccionados actualmente
	on btnTerrainAdd pressed do (
		-- Referenciamos la lista de objetos que componen nuestro terreno
		local items = lbxTerrain.items
		-- Nos aseguramos que haya algn objeto seleccionado
		if selection.count > 0 do (
			-- Recorremos los objetos seleccionados
			for node in selection do (
				-- Nos aseguramos que el objeto no est ya en la lista del terreno
				-- ni de los rboles
				if (findItem items node.name) == 0 and \
				   (findItem lbxTrees.items node.name)== 0 do (
				   	-- Aadimos el objeto a la lista de objetos que conforman el terreno
					append items node.name
				)
			)
			-- Actualizamos la lista de objetos que componen nuestro terreno
			lbxTerrain.items = items
		)
	)

	-- Event handler que se lanza cuando se pulsa el botn <btnTerrainClear>
	-- Aqu vaciamos por completo la lista de objetos que forman el terreno
	on btnTerrainClear pressed do (
		-- Referenciamos la lista de objetos que componen nuestro terreno
		local items = lbxTerrain.items
		-- Asignamos un array vaco (vaciamos la lista)
		items = #()
		-- Actualizamos la lista de objetos que componen nuestro terreno
		lbxTerrain.items = items
	)

	-- Event handler que se lanza cuando se pulsa el botn <btnTreesAdd>
	-- Aqu rellenamos la lista de arboles con los objetos seleccionados actualmente
	on btnTreesAdd pressed do (
		-- Referenciamos la lista de rboles
		local items = lbxTrees.items
		-- Nos aseguramos que haya algn objeto seleccionado
		if selection.count > 0 do (
			-- Recorremos los objetos seleccionados
			for node in selection do (
				-- Nos aseguramos que el objeto no est ya en la lista del terreno
				-- ni de los rboles
				if (findItem items node.name) == 0 and \
				   (findItem lbxTerrain.items node.name)== 0 do (
					-- Aadimos el objeto a la lista de objetos que conforman el terreno
					append items node.name
				)
			)
			-- Actualizamos la lista de rboles
			lbxTrees.items = items
		)
	)

	-- Event handler que se lanza cuando se pulsa el botn <btnTreesClear>
	-- Aqu vaciamos por completo la lista de rboles
	on btnTreesClear pressed do (
		-- Referenciamos la lista de rboles
		local items = lbxTrees.items
		-- Asignamos un array vaco (vaciamos la lista)
		items = #()
		-- Actualizamos la lista de rboles
		lbxTrees.items = items
	)

	-- Event handler que se lanza cuando se pulsa el botn <btnDoIt>
	-- Aqu posicionamos los rboles a la altura correcta, en base a los objetos
	-- que conforman el terreno
	on btnDoIt pressed do (
		-- Referenciamos la lista de rboles
		local trees = lbxTrees.items
		-- Referenciamos la lista de objetos que forman el terreno
		local terrain = lbxTerrain.items
		-- Recogemos el nmero de rboles
		local numTrees = trees.count
		
		-- Contador que nos servir para actualizar la barra de progreso
		local curTree = 1
		-- Reseteamos la barra de progreso
		pbTrees.value = 0
		-- Recorremos la lista de rboles
		for treeName in trees do (
			-- La lista de rboles contiene en realidad los nombres de los rboles
			-- por lo que necesitamos recoger el nodo cuyo nombre es <treeName>
			local tree = getNodeByName treeName
			-- Llamamos a la funcin <closestRayIntersection>.
			-- Con ella veremos si el rayo que va desde la posicin del arbol
			-- y en sentido vertical negativo, colisiona con algn objeto
			-- de los que forman el terreno
			local intInfo = closestRayIntersection terrain (Ray tree.pos [0,0,-1])
			-- Si <intInfo> es distinto de undefined significa que hubo colisin
			if intInfo != undefined do (
				-- La nueva posicin del arbol ser la posicin donde se produjo
				-- la interseccin del rayo
				tree.pos = intInfo.pos
			)
			-- Actualizamos la barra de progreso (pbTrees.value va de 0% a 100%)
			pbTrees.value = ((curTree as Float) * 100.0) / (numTrees as Float)
			-- Incrementamos el contador
			curTree += 1
		)
	)

	-- Event handler que se lanza cuando se pulsa el botn <btnExit>
	-- Aqu destrumos el cuadro de dilogo, saliendo as de la aplicacin
	on btnExit pressed do (
		-- Destrumos el cuadro de dilogo
		destroyDialog roLayDownTrees
	)
)

-- Creamos el cuadro de dilogo
createDialog roLayDownTrees