/******************************************************************************************
Skin Weight Importer/Exporter by Anthony Delen
Beta 1.2

Please refer to attached readme file for instructions on use.
******************************************************************************************/


if SkinToolSet != undefined then
	closerolloutfloater SkinToolSet

SkinToolSet = newrolloutfloater "Skin Toolset" 200 400

/*** Export Skin Weights *********************************/
rollout skin_esw "Export Skin Weights" width:200 height:351
(
	GroupBox grp1 "Info" pos:[10,94] width:173 height:56
	label lblCR "Skin Import/Export Beta 1.2" pos:[36,109] width:140 height:13
	button btn1 "Export" pos:[42,241] width:112 height:34
	checkbox chk1 "Export Weights" pos:[52,172] width:91 height:21 enabled:false checked:true
	checkbox chk2 "Export Vertex Positions" pos:[52,195] width:100 height:26 enabled:false checked:true
	progressBar doit_prog "ProgressBar" pos:[34,285] width:128 height:26
	label lbl9 "Anthony Delen  2003" pos:[44,127] width:121 height:20
	label lblProgress "" pos:[32,316] width:131 height:18
	bitmap bmp1 "Bitmap" pos:[8,6] width:174 height:82 enabled:true fileName:"shurpa.bmp" 
	on btn1 pressed do
	(
		local skinobj = modpanel.getcurrentobject()
		local obj = $
	
		if skinobj != undefined and obj != undefined and classof(skinobj) == skin then
		(
			local ts = skinops.getNumberVertices skinobj	
			output_name = getSaveFileName caption:"Skin Weight File" types:"Skin Weights (*.swf)|*.swf|All Files (*.*)|*.*|" 
	
			if output_name != undefined then 
			( 
				lblProgress.caption = "Exporting Weight Info..."
				
				output_file = createfile output_name 
				format "%\n" obj.numverts to:output_file
				
				-- First, export the vertex pos
				for v=1 to obj.numverts do
				(
					local vert = getVert obj v
					format "%,%,%,%\n" v vert.x vert.y vert.z to:output_file
					format "%,%,%,%\n" v vert.x vert.y vert.z
				)
	
				doit_prog.value = 40
			
				format "%\n" (skinops.GetNumberBones skinobj) to:output_file
				
				for v=1 to (skinops.GetNumberBones skinobj) do
				(
					local bonen = skinops.GetBoneName skinobj v 1
					format "%,%\n" v bonen to:output_file
				)						
	
				local vertcount = skinops.getNumberVertices skinobj
				local update = 40
				
				-- Next, export skin
				for v=1 to vertcount do 
				( 
					for b=1 to skinops.GetVertexWeightCount skinobj v do
					(
						local id = skinops.GetVertexWeightBoneID skinobj v b
						local bone = skinops.getBoneName skinobj id 1
						local weight = skinops.getVertexWeight skinobj v b
						
	        					if (weight < 0.00001) or ((weight as string)== "-1.#IND") then
							weight = 0
						
						format "%,%\n% (%,%)\n" v weight bone skinobj b
						format "%,%\n%\n" v weight bone to:output_file
					)
					
					update = 40+((v/(vertcount))*100)
	
					doit_prog.value = update
				) 
				
				doit_prog.value = 100
				doit_prog.value = 0
				
				close output_file
				
				lblProgress.caption = "Completed!"
			)
		)
		else
			MessageBox "Please select a valid mesh with the skin modifier to export\nand have the modifier panel open"
	)
)
addrollout skin_esw SkinToolSet rolledUp:false

/*** Export Selected Skin Weights *********************************/
rollout skin_essw "Export Selected Skin Weights" width:200 height:129
(
	button btn1 "Export Selected" pos:[37,19] width:112 height:34 toolTip:""
	progressBar doit_prog "ProgressBar" pos:[28,66] width:128 height:26
	label lblProgress "" pos:[28,97] width:128 height:20
	on btn1 pressed do
	(
		local skinobj = modpanel.getcurrentobject()
		local obj = $
	
		/* Check that skin is assigned to this object */
		if skinobj != undefined and obj != undefined and classof(skinobj) == skin and obj.selectedVerts.count != 0 then
		(
			local ts = skinops.getNumberVertices skinobj	
			output_name = getSaveFileName caption:"Skin Weight File" types:"Skin Weights (*.swf)|*.swf|All Files (*.*)|*.*|" 
	
			/* Make sure a file is created */
			if output_name != undefined then 
			( 
				lblProgress.caption = "Exporting Weights..."
			
				output_file = createfile output_name 
				format "%\n" obj.selectedVerts.count to:output_file
				
				-- First, export the vertex pos
	   			for v=1 to obj.selectedVerts.count do
				(
					local vert = obj.selectedVerts[v].pos
	
					format "%,%,%,%\n" obj.selectedVerts[v].index vert.x vert.y vert.z to:output_file
					format "%,%,%,%\n" obj.selectedVerts[v].index vert.x vert.y vert.z
				)
	
	
				doit_prog.value = 40
				
				format "%\n" (skinops.GetNumberBones skinobj) to:output_file
				
				for v=1 to (skinops.GetNumberBones skinobj) do
				(
					local bonen = skinops.GetBoneName skinobj v 1
					format "%,%\n" v bonen to:output_file
				)						
	
				local vertcount = skinops.getNumberVertices skinobj
				local update = 40
				
				-- Next, export skin
				for v=1 to vertcount do 
				(
					local cnt = 0
	     	 		for j=1 to obj.selectedVerts.count do
					(
						if obj.selectedVerts[j].index == v then
						(
							cnt = 1
							exit
						)
					)		
					
					if cnt == 0 then
						continue
					
					for b=1 to skinops.GetVertexWeightCount skinobj v do
					(
						local id = skinops.GetVertexWeightBoneID skinobj v b
						local bone = skinops.getBoneName skinobj id 1
						local weight = skinops.getVertexWeight skinobj v b
						
	        					if (weight < 0.00001) or ((weight as string)== "-1.#IND") then
							weight = 0
	
						format "%,%\n%\n" v weight bone to:output_file
					)
					
					update = 40+((v/(vertcount))*100)
	
					doit_prog.value = update
				) 
				
				doit_prog.value = 100
				doit_prog.value = 0
				
				close output_file
	
				lblProgress.caption = "Completed!"
			)
		)
		else
			MessageBox "Please select a valid mesh with the skin modifier to export with vertices selected\nand have the modifier panel open"
	)
)


addrollout skin_essw SkinToolSet rolledUp:true

/** UD Functions *****************/
	fn GetVertexID xp yp zp np =
	(
		local obj = $
		local totaldist=65535

		local tdvert=undefined
		local src=point3 xp yp zp
		local final=point3 0 0 0
		
		src.x = xp
		src.y = yp
		src.z = zp
		
		if obj != undefined then
		(
			for i=1 to obj.numverts do
			(
				local dest = point3 0 0 0
				local dist
				
				dest = getVert obj i
				
				dist = abs(distance src dest)
				
				if dist < totaldist then
				(
					totaldist = dist
					tdvert = i
					final = dest
				)
			)
		)
		
		format "LOOKED FOR: % % %\nGOT:% % % (%)" xp yp zp final.x final.y final.z tdvert
		
		return tdvert
	)
	
	fn GetVertexIDThreshold xp yp zp threshold =
	(
		local obj = $
		
		if obj != undefined then
		(
			local numverts = obj.numverts
		
		--	format "CHECKING Vertex %,%,%....\n" xp yp zp
			for i=1 to numverts do
			(
				local vert = getVert obj i
				
				local cmpx = if vert.x-xp < 0 then xp-vert.x else vert.x-xp
				local cmpy = if vert.y-yp < 0 then yp-vert.y else vert.y-yp
				local cmpz = if vert.z-zp < 0 then zp-vert.z else vert.z-zp
				
				if (cmpx <= threshold) AND (cmpy <= threshold) AND (cmpz <= threshold) then
				(
					return i
				)
			)
		)
	
		return undefined
	)	
	
	fn CheckMirroredVertex vpa vpb threshold =
	(
		local cmp = if vpa-vpb < 0 then vpb-vpa else vpa-vpb
--		local threshold = 0.5
	
		if cmp <= threshold then
			return true
		else
			return false
	)

	fn FindMirroredBone Name = 
	(
		local Original = Name
		local Prev = "_"
		local Next
		
		for i=1 to Name.count do
		(
			if i < Name.count-1 then
				Next = Name[i+1]
			else
				Next = " "
			
			-- Check for Right hand values
			if (Name[i] == "R") AND (Prev == " ") AND (Next == " ") then
			(
				-- Can replace with new string
				Original[i] = "L"
				return Original
			)	
			else if (Name[i] == "H") AND (Prev == "R") AND (Next == "T") then
			(
				Original[i] = "F"
				Original[i-1] = "L"
				return Original
			) -- Check for Left hand values
			else if (Name[i] == "L") AND (Prev == " " ) AND (Next == " ")  then
			(
				-- Can replace with new string
				Original[i] = "R"
				return Original
			)
			else if (Name[i] == "F") AND (Prev == "L") AND (Next == "T") then
			(
				Original[i] = "H"
				Original[i-1] = "R"
				return Original
			)
			
			Prev = Name[i]
		)
		
		format "COULD NOT FIND ALTERNATE BONE %,%\n" i Name.count
		return Original
	)


/*** Import and Mirror Weights *********************************/
rollout skin_miw "Import and Mirror Weights" width:200 height:369
(
	spinner spn1 "Threshold" pos:[30,66] width:129 height:16 enabled:false range:[0.001,2,0.5] scale:0.1 
	button btn1 "Import" pos:[36,266] width:116 height:31
	GroupBox grp1 "Mirror Axis" pos:[51,112] width:86 height:113
	checkbox cbX "X" pos:[61,140] width:43 height:18 checked:true
	checkbox cbY "Y" pos:[61,168] width:40 height:16 enabled:false
	checkbox cbZ "Z" pos:[61,195] width:32 height:15 enabled:false
	label lbl1 "(Default: 0.5)" pos:[73,85] width:88 height:21 enabled:false
	progressBar doit_prog "ProgressBar" pos:[40,303] width:114 height:26
	radiobuttons rdo1 "Import Type" pos:[46,8] width:104 height:46 enabled:true labels:#("Distance Check", "Threshold Check") default:1 columns:1
	checkbox chkmirror "Create Mirrored Bones" pos:[35,238] width:128 height:19 checked:true
	label lblProgress "" pos:[40,332] width:122 height:21 bold:true
	
	on btn1 pressed do
	(
	

		local obj = $
		local skinobj = modpanel.getcurrentobject()
		
		if obj == undefined or classof(skinobj) != skin then
			MessageBox "Please select a valid mesh with skin modifier"
		else
		(	
			format "\nSkin Import Interface\n"
		
			input_name = getOpenFileName caption:"\nSkin Weight File" types:"Skin Weights (*.swf)|*.swf|All Files (*.*)|*.*|" 
		
			if input_name != undefined then
			(
				local progup
				
				input_file = openFile input_name
	
				lblProgress.caption = "Mirroring Weights..."
	
				struct SVertex (x,y,z)
	
				local varray = #()
	
				doit_prog.value = 0
	
				--ClearWeights()
	
				-- Store all vertex position in lookup table	
				local vertcount = readvalue input_file
				for i=1 to vertcount do
				(
					local vp = readvalue input_file
					local vx = -(readvalue input_file) -- Mirrored in X Axis
					local vy = readvalue input_file
					local vz = readvalue input_file
				
					ver = SVertex x:vx y:vy z:vz
					append varray ver
				
					format "STORED:%,%,%,%\n" vp vx vy vz
					
					progup = ((i as float)/(vertcount as float))*100.0
					progressupdate progup
				)
			
				local bonecount = readvalue input_file
				format "\n%\n\n" bonecount
				for i=1 to bonecount do
				(
					local st = readvalue input_file
					local bone = readline input_file
					local newbone
					local bonename = "$'"+bone+"'"
					local boneobj = execute bonename
					--skinOps.addbone skinobj boneobj 1 
					
					newbone = copy bone
					newbone = FindMirroredBone(newbone)
					boneobj = execute ("$'"+newbone+"'")
	
					if (boneobj != undefined) and (newbone != bone) then
					(
						if chkmirror.checked == true then
						(
							skinOps.addbone skinobj boneobj 1 
						)
						format "Mirrored Bone Found\n"
					)
					else
					(
						format "Mirrored Bone NOT Found! %, %\n" bone newbone
					)
				)
				skinOps.Invalidate skinobj 0 					
			
	--						physiqueOps.setInitialPose obj true
			
				for i=1 to obj.numverts do
				(
					local vert = getVert obj i
					format "VISIBLE:%,%,%,%\n" v vert.x vert.y vert.z
	
					progup = ((i as float)/(obj.numverts as float))*100.0
					doit_prog.value = progup
				)		
	
				local barray = #()
				local warray = #()
				local oldvertex = -1
		
				with redraw off 					
				while not eof input_file do
				(
					local vertex = readvalue input_file
					local w = readvalue input_file
					local bonename = readline input_file
					local bone = "$'"+bonename+"'"
					local id = undefined
					
					local berror = 0
					local verror = 0
				
					bonename = FindMirroredBone(bonename)
					bone = FindMirroredBone(bone)
				
					local boneobj = execute bone
					if boneobj != undefined then
					(
						local newvertex 
						
						if rdo1.state == 1 then
							newvertex = GetVertexID varray[vertex].x varray[vertex].y varray[vertex].z spn1.value			
						else
							newvertex = GetVertexIDThreshold varray[vertex].x varray[vertex].y varray[vertex].z spn1.value			
					
						if (oldvertex != newvertex) and (oldvertex != -1) then
						(
							if (barray.count != 0) and (warray.count != 0) then
								skinops.ReplaceVertexWeights skinobj oldvertex barray warray
							else
								berror = berror + 1
							
							barray = #()
							warray = #()									
						)
					
						if NOT CheckMirroredVertex (-varray[vertex].x) (varray[vertex].x) (spn1.value) then
						(
							for i=1 to (skinops.getnumberbones skinobj) do
							(
								if (skinops.getbonename skinobj i 1) == bonename do
								(
									id = i
									exit
								)
							)										
	
							if newvertex != undefined and id != undefined then
							(
							--	skinops.SetVertexWeights skinobj newvertex id w
								append barray id
								append warray w									
							)
							else
							(
								format "VERTEX NOT FOUND or BONE NOT FOUND\n"
								verror = verror + 1
							)
						)
						else
							format "\n\n\nID VERTEX FOUND\n\n\n"
	

						if newvertex != undefined then
							oldvertex = newvertex
					)
					else
					(
						MessageBox "Bone NOT Found!\n"
		--				return 0
					)
				
					
					format "V: %, %, %\n" vertex w bone 
	
					progup = ((vertex as float)/(vertcount  as float))*100.0
					doit_prog.value = progup
				)		
				with redraw on 					
	
				close input_file
				lblProgress.caption = "Completed!"
				
				local str
				str = stringStream ""
				format "Vertex Error Count: %\nMatching Error Count %" verror berror to:str
				messagebox str
			)
		)
	
	)
	on rdo1 changed stat do
	(
		if rdo1.state == 1 then
		(
			spn1.enabled = false
			lbl1.enabled = false
		)
		else
		(
			spn1.enabled = true
			lbl1.enabled = true
		)
	)
)

addRollout skin_miw SkinToolSet	rolledUp:true	 


/*** Import Weights via Position *********************************/
rollout skin_iswvp "Import Weights via Position" width:200 height:271
(
	label lbl1 "Threshold:" pos:[31,64] width:57 height:23 enabled:false
	button btn5 "Import" pos:[39,178] width:121 height:29
	label lbl2 "This is the max offset used to compare the vert positions. (Default:0.5)" pos:[42,90] width:126 height:49 enabled:false
	spinner spn1 "" pos:[90,64] width:69 height:16 enabled:false range:[0.001,2,0.5] scale:0.1 
	progressBar doit_prog "ProgressBar" pos:[39,213] width:121 height:24
	checkbox chkUseBones "Import Bones" pos:[41,144] width:121 height:21 checked:true
	radiobuttons rdo1 "Import Type" pos:[54,6] width:104 height:46 enabled:true labels:#("Distance Check", "Threshold Check") default:1 columns:1
	label lblProgress "" pos:[39,240] width:130 height:20
	
	on btn5 pressed do
	(
		local obj = $
		local skinobj = modpanel.getcurrentobject()
		
		if obj == undefined or classof(skinobj) != skin then
			MessageBox "Please select a valid mesh with skin modifier\nand open modifier panel"
		else
		(
			format "\nSkin Import Interface\n"
		
			input_name = getOpenFileName caption:"Skin Weight File" types:"Skin Weights (*.swf)|*.swf|All Files (*.*)|*.*|" 
		
			if input_name != undefined then
			(
				input_file = openFile input_name
		
				lblProgress.caption = "Importing Weights..."
		
				struct SVertex (x,y,z)
		
				local varray = #()
	
				--progressstart "Importing Weight Info via Vertex ID..."
				--ClearWeights()
	
				-- Store all vertex position in lookup table	
				local vertcount = readvalue input_file
				for i=1 to vertcount do
				(
					local vp = readvalue input_file
					local vx = readvalue input_file
					local vy = readvalue input_file
					local vz = readvalue input_file
				
					ver = SVertex x:vx y:vy z:vz
					append varray ver
				
					format "STORED:%,%,%,%\n" vp vx vy vz
				)
				
				doit_prog.value = 30
			
				local bonecount = readvalue input_file
				format "\n%\n\n" bonecount
				for i=1 to bonecount do
				(
					local st = readvalue input_file
					local bonename = "$'"+readline input_file+"'"
					local boneobj = execute bonename
					if chkUseBones.checked == true then
						skinOps.addbone skinobj boneobj 1 
				)
				skinOps.Invalidate skinobj 0 					
			
				for i=1 to obj.numverts do
				(
					local vert = getVert obj i
					format "VISIBLE:%,%,%,%\n" v vert.x vert.y vert.z
				)		
			
				doit_prog.value = 50
	
				local proup
				local boneerror = 0
				local vertexerror = 0
				local vertexcomp = 0
	
				local barray = #()
				local warray = #()
				--local varray = #()
				local oldvertex = -1
	
				with redraw off
				while not eof input_file do
				(
					local vertex = readvalue input_file
					local w = readvalue input_file
					local bone = readline input_file --++"'"
					local id = undefined
					local newvertex
	
					if rdo1.state == 1 then
						newvertex = GetVertexID varray[vertex].x varray[vertex].y varray[vertex].z spn1.value			
					else
						newvertex = GetVertexIDThreshold varray[vertex].x varray[vertex].y varray[vertex].z spn1.value			
	
					if (oldvertex != newvertex) and (oldvertex != -1) then
					(
						skinops.ReplaceVertexWeights skinobj oldvertex barray warray
						
						barray = #()
						warray = #()
					--	varray = #()								
					)
						
					format "\nNEW VERTEX:%, OLD V: %\n" newvertex vertex
					if newvertex != vertex then
						vertexcomp = vertexcomp + 1
						
					for i=1 to (skinops.getnumberbones skinobj) do
					(
						if (skinops.getbonename skinobj i 1) == bone do
						(
							id = i
							exit
						)
					)								
						
					if newvertex != undefined and id != undefined then
					(
						append barray id
						append warray w
					--	append varray newvertex								
					)
					else
					(
						format "VERTEX NOT FOUND or BONE NOT FOUND\n"
						if newvertex == undefined then
							vertexerror = vertexerror + 1
						else
							boneerror = boneerror + 1
					)
	
	--							format "V: %, %, %\n" vertex w bone 
					
					proup = 50.0+((((vertex as float)/(vertcount as float))*100.0)/2.0)
					doit_prog.value = proup
					
					if newvertex != undefined then
						oldvertex = newvertex
				)		
				with redraw on
			
				local str
				str = stringStream ""
				format "Vertex Error Count: %\nBone Error Count %\nVertex Comp Error: %\n" vertexerror boneerror vertexcomp to:str
				messagebox str
	
				close input_file

				lblProgress.caption = "Completed"
			)
		)
	)
	on rdo1 changed stat do
	(
		if rdo1.state == 1 then
		(
			spn1.enabled = false
			lbl1.enabled = false
			lbl2.enabled = false
		)
		else
		(
			spn1.enabled = true
			lbl1.enabled = true
			lbl2.enabled = true
		)
	)
)
addRollout skin_iswvp SkinToolSet rolledUp:true		

/*** Import Weights via Index **********************************/
rollout Skin_isw "Import Weights via Index" width:200 height:120
(
	checkbox chk1 "Import Bones?" pos:[50,33] width:129 height:20 enabled:true checked:true
	button btnImport "Import" pos:[38,64] width:116 height:24
	label lblProgress "" pos:[38,90] width:115 height:19
	
	local res
	
	on btnImport pressed do
	(
		local obj = $
	
		if obj == undefined or classof(modpanel.getcurrentobject()) != skin then
			MessageBox "Please select a valid mesh with the skin modifier\nand have the modifier panel open"
		else
		(	
			local skinobj = modpanel.getcurrentobject()
			
			format "\nSkin Import Interface\n"
		
			input_name = getOpenFileName caption:"Skin Weight File" types:"Skin Weights (*.swf)|*.swf|All Files (*.*)|*.*|" 
		
			if input_name != undefined then
			(
				input_file = openFile input_name
	
				lblProgress.caption = "Importing Weights..."
	
			--	ClearWeights()
				
				-- Get past all the vert pos		
				local vertcount = readvalue input_file
				for i=1 to vertcount do
				(
					local st = readline input_file
				)
				
				local updateval = 0
				
				local bonecount = readvalue input_file
				format "\n%\n\n" bonecount
				for i=1 to bonecount do
				(
					local st = readvalue input_file
					local bonename = "$'"+readline input_file+"'"
					local boneobj = execute bonename
	
					if chk1.checked == true then
						skinOps.addbone skinobj boneobj 1 
				)
	
				skinOps.Invalidate skinobj 0 
	
				for i=1 to obj.numverts do
				(
					local vert = getVert obj i
					format "VISIBLE:%,%,%,%\n" v vert.x vert.y vert.z
				)		
	
				local barray = #()
				local warray = #()
				local varray = #()
				local oldvertex = -1
	
			with redraw off 
				while not eof input_file do
				(
					local vertex = readvalue input_file
					local w = readvalue input_file
					local bone = readline input_file
					local id = undefined
	
					if oldvertex != vertex and oldvertex != -1 then
					(
						skinops.ReplaceVertexWeights skinobj oldvertex barray warray
	
						barray = #()
						warray = #()
						varray = #()
					)
	
					for i=1 to (skinops.getnumberbones skinobj) do
					(
						if (skinops.getbonename skinobj i 1) == bone do
						(
							id = i
							exit
						)
					)
	
					if id != undefined then
					(
						append barray id
						append warray w
						append varray vertex
					)
					
					oldvertex = vertex
				)
		
			with redraw on 
	
				format "\nSkin Import Completed!\n"
	
				close input_file
	
				lblProgress.caption = "Completed"
			)
		)
	)
)
addRollout skin_isw SkinToolSet rolledUp:true	



