class VerificadorEntregas:
    def __init__(self):
        self.checksum_anterior = None
        
    def verificar_integridad_lote(self, lote_notificaciones):
        """Verifica que todas las notificaciones se procesaron"""
        # Generar checksum del lote
        datos_concat = ''.join(sorted([str(n['paciente_id']) for n in lote_notificaciones]))
        checksum_actual = hashlib.md5(datos_concat.encode()).hexdigest()
        
        # Comparar con lote anterior
        if self.checksum_anterior == checksum_actual:
            self.logger.warning("Posible duplicación o pérdida de registros")
            return False
        
        self.checksum_anterior = checksum_actual
        
        # Verificar cada notificación individualmente
        for notificacion in lote_notificaciones:
            if not self.verificar_notificacion_individual(notificacion):
                return False
        
        return True
    
    def verificar_notificacion_individual(self, notificacion):
        """Verifica el estado de una notificación específica"""
        # Implementar verificación con APIs de proveedores
        # (Twilio para SMS, SendGrid para email, etc.)
        pass