class SistemaNotificacionesRedundante:
    def __init__(self):
        self.canales = ['email', 'sms', 'app', 'llamada_automatica']
        self.intentos_maximos = 3
        
    def enviar_notificacion_multicanal(self, paciente, cita):
        """Envía notificación por múltiples canales simultáneamente"""
        resultados = {}
        
        # 1. Email (canal principal)
        resultados['email'] = self.enviar_email(paciente, cita)
        
        # 2. SMS (canal secundario, si email falla)
        if not resultados['email']['exito']:
            resultados['sms'] = self.enviar_sms(paciente, cita)
        
        # 3. Notificación en app móvil
        resultados['app'] = self.enviar_push_notification(paciente, cita)
        
        # 4. Verificar confirmación
        confirmado = self.verificar_confirmacion(paciente['id'], cita['id'])
        
        if not confirmado:
            # Escalar a llamada automática
            resultados['llamada'] = self.realizar_llamada_automatica(paciente)
        
        return resultados
    
    def enviar_sms(self, paciente, cita):
        """Envía SMS con confirmación de lectura"""
        try:
            client = Client(twilio_account_sid, twilio_auth_token)
            
            message = client.messages.create(
                body=f"Recordatorio: Cita mamografía {cita['fecha']}. "
                     f"Confirmar asistencia: SI/NO",
                from_='+1234567890',
                to=paciente['telefono']
            )
            
            # Monitorear estado del SMS
            status = self.verificar_entrega_sms(message.sid)
            
            return {
                'exito': status == 'delivered',
                'message_id': message.sid,
                'estado': status
            }
        except Exception as e:
            self.logger.error(f"Error SMS: {str(e)}")
            return {'exito': False, 'error': str(e)}