class SistemaAlertas:
    def __init__(self):
        self.umbrales = {
            'error_rate': 0.05,  # 5% máximo de errores
            'latencia_maxima': 24,  # horas
            'cobertura_minima': 0.98  # 98% mínimo de cobertura
        }
    
    def monitorear_metricas_tiempo_real(self):
        """Monitorea métricas del sistema en tiempo real"""
        metricas = {
            'tasa_exito': self.calcular_tasa_exito(),
            'latencia_promedio': self.calcular_latencia(),
            'cobertura': self.calcular_cobertura()
        }
        
        # Verificar umbrales
        alertas = []
        if metricas['tasa_exito'] < (1 - self.umbrales['error_rate']):
            alertas.append(f"Tasa de error elevada: {1 - metricas['tasa_exito']:.2%}")
        
        if metricas['latencia_promedio'] > self.umbrales['latencia_maxima']:
            alertas.append(f"Latencia elevada: {metricas['latencia_promedio']} horas")
        
        if metricas['cobertura'] < self.umbrales['cobertura_minima']:
            alertas.append(f"Cobertura baja: {metricas['cobertura']:.2%}")
        
        if alertas:
            self.activar_protocolo_emergencia(alertas)