# edge loop length

import bpy

obj = bpy.context.active_object
mode = obj.mode

looplength = 0

if obj.type == 'MESH':
    bpy.ops.object.mode_set(mode="OBJECT")

    edges = [e for e in obj.data.edges if e.select == True]

    if edges:
        verts = obj.data.vertices
        for edge in edges: 
            looplength += (verts[edge.vertices[0]].co - verts[edge.vertices[1]].co).length
        print(looplength)
    else:
        print("no edges selected") 

bpy.ops.object.mode_set(mode=mode)