macroScript charRigger
	category:"Comet Cartoons"
	toolTip:"charRigger: Given named pointHelpers, this creates an IK character rig."
	Icon:#("CometCartoons",14)
(
/*
 * charRigger.mcr -  Copyright 2001 Michael B. Comet  All Rights Reserved.
 *
 *  Version 1.00 - Michael B. Comet - comet@comet-cartoons.com - http://www.comet-cartoons.com/
 *					10/07/01 - Initial Release Rev.
 *
 *	Version 1.01 - comet@comet-cartoons.com 10/08/01
 *			Added bone color mixing
 *
 *  Version 1.02 -comet@comet-cartoons.com 10/09/01
 *			Fixed "connect Required SubAnim" bug fix...Thanks to "Lil Dragon" for helping!
 *
 *  Version 1.03 -comet@comet-cartoons.com 10/10/01
 *			Fixed error where Right Hand Bone is aligned wrong, Thanks to 3dmastering for the help.
 *			Added WristTwist bones and attribute.
 *			Fixed up other controls and bones not being Euler by default.
 *			Made characters with spaces in prefix convert to _ for naming.
 *			Feet and Hands now have 3Dish controls for easier grabbing.
 *			Finger curves a bit smaller
 *
 *  Version 1.04 -comet@comet-cartoons.com 10/10/01
 *			Made undo stuff have a nice label for the undo menu.
 *			Set up global Version and Build strings for about box and title.
 *
 *	Version 1.05 -comet@comet-cartoons.com 10/11/01
 *			Bones and Points handle small scale character now.
 *			Fixed feet to read angle from ptAnkle so the don't have to be straight.
 *			Fixed spine creation so things aren't rotated wrong due to parenting
 *				technique.  It now parents controls to controls...so axis match.
 *			Placement size calculation improved.
 *			Fixed Head and Neck creation so things aren't rotated wrong due to
 *				parenting technique.  Control axis will now match, like spine.
 *				Neck also properly resets controls in case you run it a 2nd time
 *				on a rig without neck1 or neck2
 *			Fixed arm and Finger bone creation so sizes are right.
 *			Fixed clav so shrug is always up.
 *
 *	Version 1.06 - comet@comet-cartoons.com 10/12/01
 *			Changed selection Set names.
 *
 *  Version 1.07 - comet@comet-cartoons.com 11/10/01
 *			Made sure hip is parented to placement on hip and place create
 *			Added new stuff to Mirror ptHelpers left or right with proper names
 *			Made arm "World" helpers now a ctrl that is visible and with a
 *				LinkController on it, so that it can easily be linked to
 *				different objects at different times during animation for
 *				external hand locking.
 *
 * Version 1.08 - comet@comet-cartoons.com 11/26/01
 *			Fixed some bugs in finger creation that occured if you tried to create
 *			only 1 or 0 fingers.
 *
 * Version 1.09 - comet@comet-cartoons.com 01/27/02
 *			Made the toe tip bone at proper angle for feet now.
 *			Also made end effectors at proper rotation too so it looks
 *			prettier.
 *
 * Version 1.10 - comet@comet-cartoons.com 01/27/02
 *			Fixed bug of creating foot after ground and placement existed would give error.
 *			Fixed footCTRL and roll rotation issues, where in some cases footRoll and
 *				the footCTRL would be at a skewed angle to what it should have been.
 *				Feet will now properly be in alignment the the ptAnkle helpers.
 *
 * Version 1.11 - comet@comet-cartoons.com 01/27/02
 *			Started to add Toe creation support in.  Currently will properly create toe
 *				attributess on the objects as needed.  From the addToeAttrs() proc.
 * 			Also rearranged UI slightly.  Eventually I will hopefully add true toe
 *			creation in.
 *
 * Version 1.20 - comet@comet-cartoons.com 03/03/02
 *			Added toe support.  You can add up 5 toes with 1-3 digits each like fingers.
 *			The first toe is optional, and can be rotated as desired, like a thumb, (good
 *			for monkey characters).   The other toes can be rotated in top view.
 *			Note: these are smaller "toes" vs. the master toe bone that gets create regardless
 *			when you create a foot.  It's only needed if your character really has separate
 *			toe finger-like detail.
 *
 * Version 1.21 - comet@comet-cartoons.com 03/03/02
 *			Also added new Digit multipliers to the finger and toes.  This allows digits farther
 *			down the chain to rotate more or less.  This gives a more natural curl.  By default
 *			the last finger digit will rotate more than the others, giving a more natural look,
 *			will not cause the fingers to dig into the hand at 100% rotation now.
 *
 * Version 1.22 - comet@comet-cartoons.com 03/04/02
 *			Added zeroOut function in based on my zeroOut script.  This now lets all
 *			basic controls get "zero" for PRS data, so that the rig can be reset in the
 *			motion panel, or via parent space viewing, or via the new attrKey, to 0,0,0
 *			which will put everything back to its default pose.
 *
 *			Also fixed up heelINT dummy position for when foot is raised
 *			so that footRoll still goes backwards properly.
 *
 * Version 1.23 - comet@comet-cartoons.com 03/04/02
 *			Fixed bug in createToes and createFingers where if no finger/toe helpers
 *			existed, it would throw an error since it was trying to create attributes
 *			for nothing...
 *			Also made UI a little more compacted/smaller
 *
 * Version 1.24 - comet@comet-cartoons.com 03/04/02
 *			Made toe end effector in Start Parent Space so it doesn't wiggle at an angles.
 *
 * Version 1.25 - comet@comet-cartoons.com 03/09/02
 *			Fixed buttons in UI for L/R being reversed for legs and arms.
 *
 * Version 1.30 - comet@comet-cartoons.com 03/09/02
 *			Added support for quadrapeds by allowing a second pair of Legs.  These are named
 *			with ptHelpers the same, except L and R becomes L2 and R2.  ie: ptL2Leg and ptR2Leg etc...
 *			By default, the front legs start dummy is parented to the last spine control created, or
 *			else the hips.  Note you can still have arms and hands too.  ie: like a centaur with
 *			4 legs and 2 arms...see the sample files.
 *			If you want more than 4 legs, you can probably hack this code by changing the calls for
 *				the ui buttons to do "L3" etc...and then changing the createLeg script to handle
 *				those prefixes wherever you see a LR if statement.
 *			You can now have up to 6 spine bones.
 *
 * Version 1.31 - comet@comet-cartoons.com 03/10/02
 *			Added support for up to 8 neck ctrls/bones and helpers.
 *			Neck, Head and Spine Controls are now created at the proper orientation,
 *				instead of just flat.  This is mostly a cosmetic thing...but makes it
 *				nicer.  They are still "zeroed" out properly for use with attrKey etc...
 *
 * Version 2.00a1 - comet@comet-cartoons.com 06/05/02
 *			Fixed bug where feet were created at ankle height, not ball height if ankle was raised.
 *				This also caused the placement and ground to be too high as well.
 *			Added new splineIK and stretchySplineIK features in for new spine type creation.
 *				NOTE: splineIK will not currently work with QUADrupeds that are hunched over...
 *			Changed clavicle to have new shoulderCTRLs that move, (removed old "reach" and "shrug" attributes.)
 *			Added feature to do automatic shoulder rotation, with attribute to set how much is automated.
 *			Fixed bug where fingers were not created right in r5 on right side
 *			Fixed bug where toes and finger spread were opposite on the right side.
 *			Fixed bug where arms/fingers could not be in a rotated down halfway pose, and had to flat.
 *				This version now allows posing/rigging even if the arms and hands are angled downwards a bit.
 *			Changed independent head to truly make the HEAD independent, and not the neck.
 *				Necks are now always inheriting the rotations...tho it's easy enough to turn off
 *				rotation inheritance in the hierarchy panel of MAX if the old behavior is still desired.
 *			Converted all controls to use shapes now.  This means even the upVector like elbow/knees
 *				now use line shapes thanks to me SplineToMXS script I have done.  Some of the other
 *				controls are also nicer now because of this as well.
 *
 * Version 2.00a2 - comet@comet-cartoons.com 07/14/02
 *			Fixed up all print to begin with -- comment line in case someone copies
 *				and pastes it back in
 *			Totally redid SplineIK to now be pseudo splineIK via lookAt's, since it works
 *				nearly the same and is much more stable.
 *
 * Version 2.00 - comet@comet-cartoons.com 07/31/02
 *			Added extra FK spine controls in even with the Look-At-IK version so that
 *			it still uses lookAt-IK, but is easier to animate without stretching all
 *			the time and having to both move and rotate.  FK control count is based
 *			on number of bones in spine chain.
 *
 * Version 2.01 - comet@comet-cartoons.com 08/21/02
 *			Since lookAt IK is slow it is almost unusable...created a new older style
 *			"Independent Hip" setup with 1 or 2 lookAts downward for the bottom bones Only.
 *			This "Indi" Hip setup is much faster, almost as fast as FK.
 *
 * Version 2.02 - comet@comet-cartoons.com 08/30/02
 *			Oops.  Since Max r5 uses a new default Parent Space setting for IK,
 *			I had changed the foot End Effector to fix this.  Unfortunately I had changed
 *			the toeEf and not the footEf.  This is now fixed.  Previous versions would
 *			cause the foot to rotate all wacky when using roll and such.
 *
 * Version 2.03 - comet@comet-cartoons.com 8/31/02
 *			Fixed mirror code to truly do a proper mirror now...so mirroed pt helpers
 *			will be good.  Also fixed up all the files yet again so that point helpers
 *			are definitely correct so feet that are mirroed etc will work and thumbs
 *			won't be wrong etc...
 *
 * Version 2.04 - comet@comet-cartoons.com 8/31/02
 *			Fixed leg creation for feet that are NOT aligned straight so that the bones
 *			are created much nicer in the actual plane of the leg.  This way things bend
 *			properly even when the legs/feet are not aligned on Y.
 *			Made knee swivel control now oriented and positioned truly nice and forward
 *			based on orientation of foot.  This causes the knee swivel to be at a more
 *			sensible place when the foot is not aligned straight forward during rigging.
 *			Also set the autoShoulder aim internal helper to have the viewLineLengthAbs
 *			turned off so that if unhidden it doesn't have a super long line sticking out.
 *
 * Version 2.10 - comet@comet-cartoons.com 10/27/02 - 10/31/02
 *			Made new Pseudo-FK arm controls which work as long as the shoulder
 *			isn't rotated too far (If the clav rotates too far, the upperArm FK control
 *			gets off alignment).  Note too you can MOVE the upperFKArm to get FK shoulder
 *			animation in as well.
 *
 *			hipIndi control now has proper CTRL suffix and is added to CTRL selection set.
 *
 *			Shoulder control is now rotation not position based.  It's also zero'd out now.
 *
 *			All controls are not only zero'd but also set as Max 5 "skin pose".
 *
 *			AUTOMATIC WRIST TWIST!  Yay...I figured out the vector/matrix math
 *				needed to do automatic wrist twist.  So that works now.
 *				It still has a manual override for additional twisting if desired.
 *				The auto should work fine and only breaks if the hand goes past
 *				90 degrees in it's flat L-R motion which is a broken pose anyhow.
 *				Other than that you can rotate -up to 180- degrees in the other axis.
 *				If you don't like it, set the autoTwistPct percentage to 0 and then
 *				just manually animate the extra wrist twist attribute on the hand control.
 *
 *			SCRIPTS delay evaluation!  Yay...this means that if you try to MERGE a rig
 *				in or load it and max has not yet loaded the CA defs onto the object,
 *				you WON'T get any script errors.  Instead thing will just work.  You
 *				-may- have to scrub the timeline a frame forward or back right after
 *				loading or merging tho to get max to refresh.
 *
 *			Finger attributes are now on a separate fingerCTRL object and not the hand.
 *				This way it is easier to key the arm/hand separately from fingers when
 *				animating, and makes it cleaner when you only want to work on one.
 *
 *			The Right thumb bones should no longer be flipped wrong after creation.  I have
 *				I have fixed the code that made that so it should be ok now.
 *
 *
 *
 * List of Required Locators.
 *		ptHips		- Hip
 *
 *			(Legs are optional in that you can just have one, or none at all)
 *			(!!!Local Z angle of ptAnkle (L&R) in top view controls angle of
 *				foot bone creation from top view, so the feet don't have to
 *				point straight forward.!!!
 *				Also X Axis for thumb should point down the thumb!)
 *		ptLLeg		- L Upper Leg Start
 *		ptLKnee		- Knee pos, where lower leg starts
 *		ptLAnkle	- Ankle of foot
 *		ptLBall		- Ball position on foot, where toes start
 *		ptLToe		- Toe TIP on foot.
 *
 *		ptRLeg		- L Upper Leg Start
 *		ptRKnee		- Knee pos, where lower leg starts
 *		ptRAnkle	- Ankle of foot
 *		ptRBall		- Ball position on foot, where toes start
 *		ptRToe		- Toe TIP on foot.
 *
 *		ptL2Leg		- L Upper Leg Start			-- for FRONT Legs stuff for quadraped!  change L to L2 basically.
 *		ptL2Knee		- Knee pos, where lower leg starts
 *		ptL2Ankle	- Ankle of foot
 *		ptL2Ball		- Ball position on foot, where toes start
 *		ptL2Toe		- Toe TIP on foot.
 *
 *		ptR2Leg		- L Upper Leg Start			-- for FRONT Legs stuff for quadraped!  change R to R2 basically.
 *		ptR2Knee		- Knee pos, where lower leg starts
 *		ptR2Ankle	- Ankle of foot
 *		ptR2Ball		- Ball position on foot, where toes start
 *		ptR2Toe		- Toe TIP on foot.
 *
 *		ptS1		- Spine 1 Start		-- optional
 *		ptS2		- Spine 2 Start		-- optional
 *		ptS3		- Spine 3 Start		-- optional
 *		ptS4		- Spine End Top		-- optional
 *		ptS5		- Spine End Top		-- optional
 *		ptS6		- Spine End Top		-- optional
 *		ptS7		- Spine End Top		-- optional
 *
 *		ptNeck1		- Neck ctrl 1		-- optional
 *		ptNeck2		- Neck ctrl 2		-- optional
 *		ptNeck1		- Neck ctrl 3		-- optional
 *		ptNeck2		- Neck ctrl 4		-- optional
 *		ptNeck1		- Neck ctrl 5		-- optional
 *		ptNeck2		- Neck ctrl 6		-- optional
 *		ptNeck1		- Neck ctrl 7		-- optional
 *		ptNeck2		- Neck ctrl 8		-- optional
 *		ptHead		- Head start
 *		ptHeadTop	- Head end
 *
 *		ptLClav		- Clavicle
 *		ptLUpArm	- Upper Arm
 *		ptLLoArm	- Lower Arm
 *		ptLHand		- Hand Start
 *		ptLHandTip	- End of Hand
 *
 *		ptRClav		- Clavicle
 *		ptRUpArm	- Upper Arm
 *		ptRLoArm	- Lower Arm
 *		ptRHand		- Hand Start
 *		ptRHandTip	- End of Hand
 *
 *		ptThumbL1	- Thumb digits, 1st 2 must exist for thumb to be created
 *		ptThumbL2
 *		ptThumbL3
 *		ptThumbL4
 *		ptThumbLUp	- Must exist for thumb.  Represents "up" direction for thumb
 *		ptFinger1L1	- Finger 1 digits
 *		ptFinger1L2
 *		ptFinger1L3
 *		ptFinger1L4
 *		ptFinger2L1	- Finger 2 digits
 *		ptFinger2L2
 *		ptFinger2L3
 *		ptFinger2L4
 *		ptFinger3L1	- Finger 3 digits
 *		ptFinger3L2
 *		ptFinger3L3
 *		ptFinger3L4
 *		ptFinger4L1	- Finger 4 digits
 *		ptFinger4L2
 *		ptFinger4L3
 *		ptFinger4L4
 *
 *		ptThumbR1	- Thumb digits, 1st 2 must exist for thumb to be created
 *		ptThumbR2
 *		ptThumbR3
 *		ptThumbR4
 *		ptThumbRUp	- Must exist for thumb.  Represents "up" direction for thumb
 *		ptFinger1R1	- Finger 1 digits
 *		ptFinger1R2
 *		ptFinger1R3
 *		ptFinger1R4
 *		ptFinger2R1	- Finger 2 digits
 *		ptFinger2R2
 *		ptFinger2R3
 *		ptFinger2R4
 *		ptFinger3R1	- Finger 3 digits
 *		ptFinger3R2
 *		ptFinger3R3
 *		ptFinger3R4
 *		ptFinger4R1	- Finger 4 digits
 *		ptFinger4R2
 *		ptFinger4R3
 *		ptFinger4R4
 *
 *		ptToe1L1, ptToe1L2, ptToe1L3, ptToe1L4;		-- replace L with R for R toes.
 *		ptToe2L1, ptToe2L2, ptToe2L3, ptToe2L4;
 *		ptToe3L1, ptToe3L2, ptToe3L3, ptToe3L4;
 *		ptToe4L1, ptToe4L2, ptToe4L3, ptToe4L4;
 *		ptToe5L1, ptToe5L2, ptToe5L3, ptToe5L4;
 *		ptToeLUp;									-- up vector for first toe.
 *
 *				-- and then also for FRONT toes... L or R becomes L2 and R2
 *		ptToe1L21, ptToe1L22, ptToe1L23, ptToe1L24;		-- replace L with R for R toes.
 *		ptToe2L21, ptToe2L22, ptToe2L23, ptToe2L24;
 *		ptToe3L21, ptToe3L22, ptToe3L23, ptToe3L24;
 *		ptToe4L21, ptToe4L22, ptToe4L23, ptToe4L24;
 *		ptToe5L21, ptToe5L22, ptToe5L23, ptToe5L24;
 *		ptToeL2Up;									-- up vector for first toe.
 *
 *
 * Wishlist/TODO Items:
 *
 * Bugs/Known Issues:
 *		- When reloading a rigged character, IK end effectors may "appear"
 *			to shoot off screen.  Just refresh the viewport by either
 *			scrubbing back and forth a frame, or by selecting and moving
 *			a related CTRL object.
 *
 *		- When MERGING a charRigger character in, you should no longer get
 *			script issues, HOWEVER, you may need to scrub the timeline once
 *			a frame back or forth to get Max to refresh things properly right
 *			after merging.
 *
 *		- FK-Arm controls and Shoulders/Clav do not work together well.  This is because
 *			the fk controls can get offset if you use the shoulder.  Generally
 *			speaking the autoShoulder is rigged so it won't have any effect
 *			when using FK arms, unless you move the hand around as well.  If
 *			you do use the shoulder controls during FK, you may have to pull the
 *			hand out or in to make the arm the proper length and have the lower arm
 *			line up with the lowerArmFK control..
 *
 *		- I probably should go thru and "lock" Rot/Trans for different objects
 *			based on how they are supposed to work...maybe one day...
 *
 */


/*
 * Global Vars
 */
global string cRversion="2.10";
global string cRdate = "Oct 31, 2002";

global string prefix="char";
global bodyColor = color 160 240 60;
global bodyColor2 = color 255 220 0;
global headColor = color 230 100 0;
global baseColor = color 50  220 190;
global leftColor = color 40 80 200;
global rightColor = color 80 200 40;
global internalColor = color 140 20 0;
global boneColor = color 174 186 203;

-- Global CTRL objects that get created
global hipCTRL = undefined;
global boolean stretchyLegs = true;
global boolean headIndep = true;
global boolean spineIndi = true;
global boolean spineSplineIK = false;
global boolean spineSplineStretch = true;
global boolean stretchyArms = true;
global boolean autoShoulders = true;
global fDig1Mult = 0.7;
global fDig2Mult = 0.8;
global fDig3Mult = 1.2;
global tDig1Mult = 0.7;
global tDig2Mult = 0.8;
global tDig3Mult = 1.2;



-- This is the range we'll set the timeline too when rigging so that
--	our expressions and wiring won't die later when animating...
global rStart = -1000;
global rEnd = 10000;

-- Functions -------------------------------------------------------------------------------------

/*
 * objExists() - Given an object name, with or w/o $, this tells if it exists or not.
 *		Returns true on exists, false otherwise.
 */
fn objExists objname =
(
    name="";

	if (objname[1] == "$") then		-- already have $ in it?
		name = objname;
	else
		name = ("$"+objname);

	ret = execute(name+" != undefined");

	return (ret);
)

-- -----------------------------------------------------------------------------------------------

/*
 * zeroOut - Zero's out an objects PRS data by parenting another object with the suffix ZEROINT
 *		at the end.  This is a straight grab from my zeroOut macro script...except this takes
 *		ONE object to zero.
 */
fn zeroOut obj =
(
	pt = Point pos:[0,0,0] isSelected:on centermarker:on axistripod:off cross:off Box:off constantscreensize:off drawontop:off size:20;
		-- Insert into hierarchy
	pt.parent = obj.parent;
		-- Now snap it to same values
	coordsys world
		(
		pt.scale = obj.scale;
		pt.rotation = obj.rotation;
		pt.position = obj.position;
		pt.wirecolor = (color 80 10 0);
		pt.name = (obj.name+"ZEROINT");
		)
		-- reparent object
	obj.parent = pt;

		-- Now also store this zero'd position as a Max 5 Skin Pose
	obj.skinPose.setSkinPose();

)

-- -----------------------------------------------------------------------------------------------

/*
 * setTimeline() - This will set the timeline to the given start and end times
 */
fn setTimeline start end =
(
	animationRange = (interval start end);
)


-- -----------------------------------------------------------------------------------------------

/*
 * replaceChar() - Given a string replaces all occurences of character f (from) with
 *					character t (to)
 */
fn replaceChar str f t =
(
    if (str == "" or str == undefined) then
		return "";

	len = str.count;

	for i in 1 to len do
		(
		if (str[i] == f) then	-- replace it needed
			str[i] = t;
		)

    return str;
)

-- -----------------------------------------------------------------------------------------------



/*
 * boneSetup() - Given a bone, set it up to be right size and color
 *		doFins will set fins on or off
 *		mixColor if provided will cause the regular bone color to mix in with it
 */
fn boneSetup boneObj doFins mixColor:boneColor =
(
    if (boneObj == undefined) then
		return 0;

	-- what is length of bone?
	len = boneObj.length;

	-- how big overall width height?
	wh = len*0.17;
--	if (wh < 5) then
--		wh = 5;

	finSz = len*0.26;

	-- make settings happen!
	boneObj.wirecolor = (0.15*mixColor)+(0.85*boneColor);
	boneObj.width = wh;
	boneObj.height = wh;
	boneObj.sidefins = doFins;
	boneObj.frontfin = doFins;
	boneObj.backfin = doFins;
	boneObj.sidefinssize = finSz;
	boneObj.frontfinsize = finSz;
	boneObj.backfinsize = finSz;

	return 1;
)
-- -----------------------------------------------------------------------------------------------

/*
 *  makeNiceSets() - This will make nice selection sets for all created rig stuff.
 */
fn makeNiceSets =
(
	selectionSets[(prefix+"_CTRLs")] = $*CTRL;
	selectionSets[(prefix+"_BONEs")] = $*BONE;
	selectionSets[(prefix+"_HIDEinternal")] = $*INT;
	selectionSets[(prefix+"_HIDEendEffectors")] = $*EndEffector;
	selectionSets[(prefix+"_DELETEptHelpers")] = $pt*;

	clearSelection();	-- not sets, but actual objects currently selected

		-- And HIDE stuff
	hide selectionSets[(prefix+"_HIDEendEffectors")];
	hide selectionSets[(prefix+"_HIDEinternal")];
	hide selectionSets[(prefix+"_DELETEptHelpers")];	-- for now don't delete, just hide

    return 1;
)


-- -----------------------------------------------------------------------------------------------

/*
 * createcubeShape() - Makes a Cube Wireframe control
 */
fn createcubeShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [20.0325,20,20.1614];
		addKnot ln splIdx #corner #curve [-19.9675,20,20.1614];
		addKnot ln splIdx #corner #curve [-19.9675,-20,20.1614];
		addKnot ln splIdx #corner #curve [20.0325,-20,20.1614];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [20.0325,20,-20.1614];
		addKnot ln splIdx #corner #curve [-19.9675,20,-20.1614];
		addKnot ln splIdx #corner #curve [-19.9675,-20,-20.1614];
		addKnot ln splIdx #corner #curve [20.0325,-20,-20.1614];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [20.0325,-20,20.1614];
		addKnot ln splIdx #corner #curve [20.0325,-20,-20.1614];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-19.9675,-20,20.1614];
		addKnot ln splIdx #corner #curve [-19.9675,-20,-20.1614];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-19.9675,20,20.1614];
		addKnot ln splIdx #corner #curve [-19.9675,20,-20.1614];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [20.0325,20,20.1614];
		addKnot ln splIdx #corner #curve [20.0325,20,-20.1614];
	open ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "cube";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createcubeAxisShape() - Creates a cube with an XYZ axis
 */
fn createcubeAxisShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [0,-6.61623e-006,90];
		addKnot ln splIdx #corner #curve [0,6.61623e-006,-90];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006];
		addKnot ln splIdx #corner #curve [6.79481e-006,90,2.68221e-006];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-90,1.07288e-005,0];
		addKnot ln splIdx #corner #curve [90,-1.07288e-005,0];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-4.0146,-7.07151e-006,102.703];
		addKnot ln splIdx #corner #curve [3.49679,-7.96694e-006,102.703];
		addKnot ln splIdx #corner #curve [-4.0146,-6.40507e-006,93.6376];
		addKnot ln splIdx #corner #curve [4.01481,-7.36225e-006,93.6376];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [96.1965,-1.17546e-005,3.90536];
		addKnot ln splIdx #corner #curve [103.708,-1.20217e-005,-4.64208];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [103.814,-1.26651e-005,3.939];
		addKnot ln splIdx #corner #curve [96.2287,-1.11076e-005,-4.9488];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.14498e-006,91.9388,5.3873];
		addKnot ln splIdx #corner #curve [7.27259e-006,95.9535,1.37259];
		addKnot ln splIdx #corner #curve [7.01219e-006,95.9535,-4.58472];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.16915e-006,96.083,1.37259];
		addKnot ln splIdx #corner #curve [7.63997e-006,100.07,5.51906];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [43.6887,43.6178,43.9698];
		addKnot ln splIdx #corner #curve [-43.5469,43.6178,43.9698];
		addKnot ln splIdx #corner #curve [-43.5469,-43.6178,43.9698];
		addKnot ln splIdx #corner #curve [43.6887,-43.6178,43.9698];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [43.6887,43.6178,-43.9698];
		addKnot ln splIdx #corner #curve [-43.5469,43.6178,-43.9698];
		addKnot ln splIdx #corner #curve [-43.5469,-43.6178,-43.9698];
		addKnot ln splIdx #corner #curve [43.6887,-43.6178,-43.9698];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [43.6887,-43.6178,43.9698];
		addKnot ln splIdx #corner #curve [43.6887,-43.6178,-43.9698];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-43.5469,-43.6178,43.9698];
		addKnot ln splIdx #corner #curve [-43.5469,-43.6178,-43.9698];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-43.5469,43.6178,43.9698];
		addKnot ln splIdx #corner #curve [-43.5469,43.6178,-43.9698];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [43.6887,43.6178,43.9698];
		addKnot ln splIdx #corner #curve [43.6887,43.6178,-43.9698];
	open ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "cubeAxis";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createtaperedRectangleShape() - Makes a nice FK arm type control of a rectangle, tapered
 *								to the right
 */
fn createtaperedRectangleShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [110.752,21.0724,21.2425];
		addKnot ln splIdx #corner #curve [-19.9675,29.2275,29.4633];
		addKnot ln splIdx #corner #curve [-19.9675,-29.2275,29.4633];
		addKnot ln splIdx #corner #curve [110.752,-21.0724,21.2425];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [110.752,21.0724,-21.2425];
		addKnot ln splIdx #corner #curve [-19.9675,29.2275,-29.4633];
		addKnot ln splIdx #corner #curve [-19.9675,-29.2275,-29.4633];
		addKnot ln splIdx #corner #curve [110.752,-21.0724,-21.2425];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [110.752,-21.0724,21.2425];
		addKnot ln splIdx #corner #curve [110.752,-21.0724,-21.2425];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-19.9675,-29.2275,29.4633];
		addKnot ln splIdx #corner #curve [-19.9675,-29.2275,-29.4633];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-19.9675,29.2275,29.4633];
		addKnot ln splIdx #corner #curve [-19.9675,29.2275,-29.4633];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [110.752,21.0724,21.2425];
		addKnot ln splIdx #corner #curve [110.752,21.0724,-21.2425];
	open ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "taperedRectangle";
	select ln;
	return ln;

)


-- -----------------------------------------------------------------------------------------------

/*
 * createsimpleRotatorShape() - Makes a simple 3 sphere and cross hair shape
 */
fn createsimpleRotatorShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [0,-6.61623e-006,90];
		addKnot ln splIdx #corner #curve [0,6.61623e-006,-90];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006];
		addKnot ln splIdx #corner #curve [6.79481e-006,90,2.68221e-006];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-90,1.07288e-005,0];
		addKnot ln splIdx #corner #curve [90,-1.07288e-005,0];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [60.4873,0,0] [60.4873,-33.376,0] [60.4873,33.376,0];
		addKnot ln splIdx #bezier #curve [-2.64398e-006,60.4873,0] [33.376,60.4873,0] [-33.376,60.4873,0];
		addKnot ln splIdx #bezier #curve [-60.4873,-5.28796e-006,0] [-60.4873,33.376,0] [-60.4873,-33.376,0];
		addKnot ln splIdx #bezier #curve [7.93195e-006,-60.4873,0] [-33.376,-60.4873,0] [33.376,-60.4873,0];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [60.4873,0,0] [60.4873,1.45891e-006,-33.376] [60.4873,-1.45891e-006,33.376];
		addKnot ln splIdx #bezier #curve [-2.64398e-006,-2.64398e-006,60.4873] [33.376,-2.64398e-006,60.4873] [-33.376,-2.64398e-006,60.4873];
		addKnot ln splIdx #bezier #curve [-60.4873,0,-5.28796e-006] [-60.4873,-1.45891e-006,33.376] [-60.4873,1.45891e-006,-33.376];
		addKnot ln splIdx #bezier #curve [7.93195e-006,2.64398e-006,-60.4873] [-33.376,2.64398e-006,-60.4873] [33.376,2.64398e-006,-60.4873];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-2.64398e-006,60.4873,0] [-4.1029e-006,60.4873,-33.376] [-1.18506e-006,60.4873,33.376];
		addKnot ln splIdx #bezier #curve [2.64398e-006,-2.64398e-006,60.4873] [1.18506e-006,33.376,60.4873] [4.10289e-006,-33.376,60.4873];
		addKnot ln splIdx #bezier #curve [2.64398e-006,-60.4873,-5.28796e-006] [4.1029e-006,-60.4873,33.376] [1.18507e-006,-60.4873,-33.376];
		addKnot ln splIdx #bezier #curve [-2.64398e-006,7.93195e-006,-60.4873] [-1.18506e-006,-33.376,-60.4873] [-4.10289e-006,33.376,-60.4873];
	close ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "simpleRotator";
	select ln;
	return ln;

)


-- -----------------------------------------------------------------------------------------------

/*
 * createsimpleRotatorXYZShape() - Make a simple rotator of an axis and 3 spheres.
 */
fn createsimpleRotatorXYZShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [0,-6.61623e-006,90];
		addKnot ln splIdx #corner #curve [0,6.61623e-006,-90];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006];
		addKnot ln splIdx #corner #curve [6.79481e-006,90,2.68221e-006];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-90,1.07288e-005,0];
		addKnot ln splIdx #corner #curve [90,-1.07288e-005,0];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-4.0146,-7.07151e-006,102.703];
		addKnot ln splIdx #corner #curve [3.49679,-7.96694e-006,102.703];
		addKnot ln splIdx #corner #curve [-4.0146,-6.40507e-006,93.6376];
		addKnot ln splIdx #corner #curve [4.01481,-7.36225e-006,93.6376];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [96.1965,-1.17546e-005,3.90536];
		addKnot ln splIdx #corner #curve [103.708,-1.20217e-005,-4.64208];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [103.814,-1.26651e-005,3.939];
		addKnot ln splIdx #corner #curve [96.2287,-1.11076e-005,-4.9488];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.14498e-006,91.9388,5.3873];
		addKnot ln splIdx #corner #curve [7.27259e-006,95.9535,1.37259];
		addKnot ln splIdx #corner #curve [7.01219e-006,95.9535,-4.58472];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.16915e-006,96.083,1.37259];
		addKnot ln splIdx #corner #curve [7.63997e-006,100.07,5.51906];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [60.4873,0,0] [60.4873,-33.376,0] [60.4873,33.376,0];
		addKnot ln splIdx #bezier #curve [-2.64398e-006,60.4873,0] [33.376,60.4873,0] [-33.376,60.4873,0];
		addKnot ln splIdx #bezier #curve [-60.4873,-5.28796e-006,0] [-60.4873,33.376,0] [-60.4873,-33.376,0];
		addKnot ln splIdx #bezier #curve [7.93195e-006,-60.4873,0] [-33.376,-60.4873,0] [33.376,-60.4873,0];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [60.4873,0,0] [60.4873,1.45891e-006,-33.376] [60.4873,-1.45891e-006,33.376];
		addKnot ln splIdx #bezier #curve [-2.64398e-006,-2.64398e-006,60.4873] [33.376,-2.64398e-006,60.4873] [-33.376,-2.64398e-006,60.4873];
		addKnot ln splIdx #bezier #curve [-60.4873,0,-5.28796e-006] [-60.4873,-1.45891e-006,33.376] [-60.4873,1.45891e-006,-33.376];
		addKnot ln splIdx #bezier #curve [7.93195e-006,2.64398e-006,-60.4873] [-33.376,2.64398e-006,-60.4873] [33.376,2.64398e-006,-60.4873];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-2.64398e-006,60.4873,0] [-4.1029e-006,60.4873,-33.376] [-1.18507e-006,60.4873,33.376];
		addKnot ln splIdx #bezier #curve [2.64398e-006,-2.64398e-006,60.4873] [1.18507e-006,33.376,60.4873] [4.1029e-006,-33.376,60.4873];
		addKnot ln splIdx #bezier #curve [2.64398e-006,-60.4873,-5.28796e-006] [4.1029e-006,-60.4873,33.376] [1.18507e-006,-60.4873,-33.376];
		addKnot ln splIdx #bezier #curve [-2.64398e-006,7.93195e-006,-60.4873] [-1.18507e-006,-33.376,-60.4873] [-4.1029e-006,33.376,-60.4873];
	close ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "simpleRotator";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createRotatorShape() - Makes a complex rotator with an axis and 3 double arrows
 */
fn createRotatorShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #smooth #curve [-7.9111,3.07955e-006,-60.0848];
		addKnot ln splIdx #smooth #curve [-7.91111,-24.4238,-54.5915];
		addKnot ln splIdx #corner #curve [-7.91111,-50.3966,-33.3038];
		addKnot ln splIdx #corner #curve [-20,-50.3966,-33.3038];
		addKnot ln splIdx #corner #curve [-1.1058e-005,-63.0936,-0.141809];
		addKnot ln splIdx #corner #curve [20,-50.3966,-33.3038];
		addKnot ln splIdx #corner #curve [7.9111,-50.3966,-33.3038];
		addKnot ln splIdx #smooth #curve [7.9111,-24.4238,-54.5915];
		addKnot ln splIdx #smooth #curve [7.91111,5.01784e-007,-60.0848];
		addKnot ln splIdx #smooth #curve [7.91111,24.4238,-54.5915];
		addKnot ln splIdx #corner #curve [7.91112,50.3966,-33.3038];
		addKnot ln splIdx #corner #curve [20,50.3966,-33.3038];
		addKnot ln splIdx #corner #curve [1.10704e-005,63.0936,-0.141806];
		addKnot ln splIdx #corner #curve [-20,50.3966,-33.3038];
		addKnot ln splIdx #corner #curve [-7.9111,50.3966,-33.3038];
		addKnot ln splIdx #smooth #curve [-7.9111,24.4238,-54.5915];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #smooth #curve [7.91109,-3.07955e-006,60.0848];
		addKnot ln splIdx #smooth #curve [7.91109,-24.4238,54.5915];
		addKnot ln splIdx #corner #curve [7.91109,-50.3966,33.3038];
		addKnot ln splIdx #corner #curve [20,-50.3966,33.3038];
		addKnot ln splIdx #corner #curve [-1.10918e-005,-63.0936,0.141806];
		addKnot ln splIdx #corner #curve [-20,-50.3966,33.3038];
		addKnot ln splIdx #corner #curve [-7.91112,-50.3966,33.3038];
		addKnot ln splIdx #smooth #curve [-7.91112,-24.4238,54.5915];
		addKnot ln splIdx #smooth #curve [-7.91112,-5.01782e-007,60.0848];
		addKnot ln splIdx #smooth #curve [-7.91111,24.4238,54.5915];
		addKnot ln splIdx #corner #curve [-7.9111,50.3966,33.3038];
		addKnot ln splIdx #corner #curve [-20,50.3966,33.3038];
		addKnot ln splIdx #corner #curve [1.10366e-005,63.0936,0.141809];
		addKnot ln splIdx #corner #curve [20,50.3966,33.3038];
		addKnot ln splIdx #corner #curve [7.91111,50.3966,33.3038];
		addKnot ln splIdx #smooth #curve [7.9111,24.4238,54.5915];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [0,-6.61623e-006,90];
		addKnot ln splIdx #corner #curve [0,6.61623e-006,-90];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006];
		addKnot ln splIdx #corner #curve [6.79481e-006,90,2.68221e-006];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-90,1.07288e-005,0];
		addKnot ln splIdx #corner #curve [90,-1.07288e-005,0];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #smooth #curve [-7.16267e-006,-60.0848,7.9111];
		addKnot ln splIdx #smooth #curve [24.4238,-54.5915,7.9111];
		addKnot ln splIdx #corner #curve [50.3966,-33.3038,7.9111];
		addKnot ln splIdx #corner #curve [50.3966,-33.3038,20];
		addKnot ln splIdx #corner #curve [61.3076,-0.141816,0];
		addKnot ln splIdx #corner #curve [50.3966,-33.3038,-20];
		addKnot ln splIdx #corner #curve [50.3966,-33.3038,-7.91111];
		addKnot ln splIdx #smooth #curve [24.4238,-54.5915,-7.91111];
		addKnot ln splIdx #smooth #curve [-7.16267e-006,-60.0848,-7.91111];
		addKnot ln splIdx #smooth #curve [-24.4238,-54.5915,-7.91111];
		addKnot ln splIdx #corner #curve [-50.3966,-33.3038,-7.91111];
		addKnot ln splIdx #corner #curve [-50.3966,-33.3038,-20];
		addKnot ln splIdx #corner #curve [-61.3076,-0.1418,0];
		addKnot ln splIdx #corner #curve [-50.3966,-33.3038,20];
		addKnot ln splIdx #corner #curve [-50.3966,-33.3038,7.9111];
		addKnot ln splIdx #smooth #curve [-24.4238,-54.5915,7.9111];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #smooth #curve [7.16267e-006,60.0848,-7.91109];
		addKnot ln splIdx #smooth #curve [24.4238,54.5915,-7.9111];
		addKnot ln splIdx #corner #curve [50.3966,33.3038,-7.9111];
		addKnot ln splIdx #corner #curve [50.3966,33.3038,-20];
		addKnot ln splIdx #corner #curve [61.3076,0.1418,0];
		addKnot ln splIdx #corner #curve [50.3966,33.3038,20];
		addKnot ln splIdx #corner #curve [50.3966,33.3038,7.91111];
		addKnot ln splIdx #smooth #curve [24.4238,54.5915,7.91112];
		addKnot ln splIdx #smooth #curve [7.16267e-006,60.0848,7.91112];
		addKnot ln splIdx #smooth #curve [-24.4238,54.5915,7.91112];
		addKnot ln splIdx #corner #curve [-50.3966,33.3038,7.91111];
		addKnot ln splIdx #corner #curve [-50.3966,33.3038,20];
		addKnot ln splIdx #corner #curve [-61.3076,0.141816,0];
		addKnot ln splIdx #corner #curve [-50.3966,33.3038,-20];
		addKnot ln splIdx #corner #curve [-50.3966,33.3038,-7.9111];
		addKnot ln splIdx #smooth #curve [-24.4238,54.5915,-7.9111];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-4.0146,-7.07151e-006,102.703];
		addKnot ln splIdx #corner #curve [3.49679,-7.96694e-006,102.703];
		addKnot ln splIdx #corner #curve [-4.0146,-6.40507e-006,93.6376];
		addKnot ln splIdx #corner #curve [4.01481,-7.36225e-006,93.6376];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [96.1965,-1.17546e-005,3.90536];
		addKnot ln splIdx #corner #curve [103.708,-1.20217e-005,-4.64208];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [103.814,-1.26651e-005,3.939];
		addKnot ln splIdx #corner #curve [96.2287,-1.11076e-005,-4.9488];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.14498e-006,91.9388,5.3873];
		addKnot ln splIdx #corner #curve [7.27259e-006,95.9535,1.37259];
		addKnot ln splIdx #corner #curve [7.01219e-006,95.9535,-4.58472];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.16915e-006,96.083,1.37259];
		addKnot ln splIdx #corner #curve [7.63997e-006,100.07,5.51906];
	open ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "rotator";
	select ln;
	return ln;

)


-- -----------------------------------------------------------------------------------------------

/*
 * createfootRotatorShape() - Creates a simple rotator shape that is squashed and adjusted to look
 *		more like a foot.
 */
fn createfootRotatorShape =
(
	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [9.82788e-007,0.0293154,42.9451];
		addKnot ln splIdx #corner #curve [9.82788e-007,0.029314,-31.7021];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-3.96021e-006,-89.233,-3.28299e-006] [-3.96021e-006,-89.233,-3.28299e-006] [-3.96021e-006,-89.233,-3.28299e-006];
		addKnot ln splIdx #corner #curve [5.04664e-006,72.3707,1.68625e-007];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-46.7199,0.029314,-2.87218e-006];
		addKnot ln splIdx #corner #curve [46.7199,0.029314,-2.87218e-006];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [31.3996,0.029314,-2.87218e-006] [31.3996,-33.3467,-3.58743e-006] [31.3996,33.4053,-2.15692e-006];
		addKnot ln splIdx #bezier #curve [-2.7893e-007,34.3545,-3.29603e-006] [20.1458,34.3545,-3.29603e-006] [-20.1458,34.3545,-3.29603e-006];
		addKnot ln splIdx #bezier #curve [-31.3996,0.029314,-2.87218e-006] [-31.3996,33.4053,-2.15692e-006] [-31.3996,-33.3467,-3.58743e-006];
		addKnot ln splIdx #bezier #curve [4.92889e-006,-59.7203,-1.20372e-006] [-20.1458,-59.7203,-1.20372e-006] [20.1458,-59.7203,-1.20372e-006];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [31.3996,0.029314,-2.87218e-006] [31.3996,0.029314,-18.9208] [31.3996,0.029314,18.9208];
		addKnot ln splIdx #bezier #curve [-3.8973e-007,0.0293154,26.2144] [17.3258,0.0293154,26.2144] [-17.3258,0.0293154,26.2144];
		addKnot ln splIdx #bezier #curve [-31.3996,0.029314,-6.21004e-006] [-31.3996,0.029314,18.9208] [-31.3996,0.029314,-18.9208];
		addKnot ln splIdx #bezier #curve [5.10035e-006,0.0293141,-15.575] [-17.3258,0.0293141,-15.575] [17.3258,0.0293141,-15.575];
	close ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-2.7893e-007,34.3545,-3.29603e-006] [-1.15954e-006,34.3545,-18.9208] [6.01677e-007,34.3545,18.9208];
		addKnot ln splIdx #bezier #curve [2.35531e-006,0.0293154,26.2144] [1.59811e-006,33.4018,35.8934] [3.11252e-006,-33.3432,16.5354];
		addKnot ln splIdx #bezier #curve [1.73706e-006,-59.7203,-4.20145e-006] [2.61766e-006,-59.7203,18.9208] [8.5646e-007,-59.7203,-18.9208];
		addKnot ln splIdx #bezier #curve [-3.8973e-007,0.0293141,-15.575] [3.6761e-007,-33.3467,-15.575] [-1.14707e-006,33.4053,-15.575];
	close ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "footRotator";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createhorizArrowShape() - Makes a 2 sided arrow L-R
 */
fn createhorizArrowShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #smooth #curve [0,-60.0848,7.91111];
		addKnot ln splIdx #smooth #curve [24.4238,-54.5915,7.91111];
		addKnot ln splIdx #corner #curve [55.2027,-33.3038,7.91111];
		addKnot ln splIdx #corner #curve [55.2027,-33.3038,20];
		addKnot ln splIdx #corner #curve [73.2715,-0.141808,0];
		addKnot ln splIdx #corner #curve [55.2027,-33.3038,-20];
		addKnot ln splIdx #corner #curve [55.2027,-33.3038,-7.91111];
		addKnot ln splIdx #smooth #curve [24.4238,-54.5915,-7.91111];
		addKnot ln splIdx #smooth #curve [0,-60.0848,-7.91111];
		addKnot ln splIdx #smooth #curve [-24.4238,-54.5915,-7.91111];
		addKnot ln splIdx #corner #curve [-55.2027,-33.3038,-7.91111];
		addKnot ln splIdx #corner #curve [-55.2027,-33.3038,-20];
		addKnot ln splIdx #corner #curve [-73.2715,-0.141808,0];
		addKnot ln splIdx #corner #curve [-55.2027,-33.3038,20];
		addKnot ln splIdx #corner #curve [-55.2027,-33.3038,7.91111];
		addKnot ln splIdx #smooth #curve [-24.4238,-54.5915,7.91111];
	close ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "horizArrow";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createaxisShape() - Makes a nice XYZ 3d cross hair shape
 */
fn createaxisShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [0,-6.61623e-006,90];
		addKnot ln splIdx #corner #curve [0,6.61623e-006,-90];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006] [-6.79481e-006,-90,-2.68221e-006];
		addKnot ln splIdx #corner #curve [6.79481e-006,90,2.68221e-006];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-90,1.07288e-005,0];
		addKnot ln splIdx #corner #curve [90,-1.07288e-005,0];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-4.0146,-7.07151e-006,102.703];
		addKnot ln splIdx #corner #curve [3.49679,-7.96694e-006,102.703];
		addKnot ln splIdx #corner #curve [-4.0146,-6.40507e-006,93.6376];
		addKnot ln splIdx #corner #curve [4.01481,-7.36225e-006,93.6376];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [96.1965,-1.17546e-005,3.90536];
		addKnot ln splIdx #corner #curve [103.708,-1.20217e-005,-4.64208];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [103.814,-1.26651e-005,3.939];
		addKnot ln splIdx #corner #curve [96.2287,-1.11076e-005,-4.9488];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.14498e-006,91.9388,5.3873];
		addKnot ln splIdx #corner #curve [7.27259e-006,95.9535,1.37259];
		addKnot ln splIdx #corner #curve [7.01219e-006,95.9535,-4.58472];
	open ln splIdx;
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [7.16915e-006,96.083,1.37259];
		addKnot ln splIdx #corner #curve [7.63997e-006,100.07,5.51906];
	open ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "axis";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createhalfCircleShape() - Makes a nice half circle shape object.
 */
fn createhalfCircleShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #bezier #curve [43.7836,0,0] [43.7836,1.05603e-006,-24.1592] [43.7836,-1.05603e-006,24.1592];
		addKnot ln splIdx #bezierCorner #curve [-1.90735e-006,-1.91384e-006,43.7836] [24.1592,-1.91384e-006,43.7836] [-0.199136,-9.89884e-007,22.6459];
		addKnot ln splIdx #corner #curve [-0.000743866,0,-3.82587e-006];
		addKnot ln splIdx #bezierCorner #curve [5.75185e-006,1.91384e-006,-43.7836] [-0.000473022,1.11209e-006,-25.4416] [24.1592,1.91384e-006,-43.7836];
	close ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "halfCircle";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * createarrowShape() - Makes a simple down arrow.
 */
fn createarrowShape =
(

	ln = line();
	splIdx = addNewSpline ln;
		addKnot ln splIdx #corner #curve [-10,-1.12401e-006,25.7143];
		addKnot ln splIdx #corner #curve [-10,1.87335e-007,-4.28571];
		addKnot ln splIdx #corner #curve [-20,1.87335e-007,-4.28571];
		addKnot ln splIdx #corner #curve [0,1.49868e-006,-34.2857];
		addKnot ln splIdx #corner #curve [20,1.87335e-007,-4.28571];
		addKnot ln splIdx #bezier #curve [10,1.87335e-007,-4.28571] [10,1.87335e-007,-4.28571] [10,1.87335e-007,-4.28571];
		addKnot ln splIdx #corner #curve [10,-1.12401e-006,25.7143];
	close ln splIdx;
	updateShape ln;
	convertToSplineShape ln;
	ln.wireColor = (color 8 61 138);
	ln.name = uniqueName "arrow";
	select ln;
	return ln;

)

-- -----------------------------------------------------------------------------------------------

/*
 * makeStretchyBones() - This will make a standard 2 joint stretchy system.
 *	upper, lower, tip are the joints in the stretchy chain in order from parent to child.
 *		tip is required since lower and tip actually have the script on them.
 *  ik   is the ik end effector for the chain
 *	ctrl is the CTRL object that has the maxStretch and extraStretch attributes on it.
 *	dep  is a string of what objects this will depend on for moving
 */
fn makeStretchyBones upper lower tip ik ctrl dep =
(
    if (upper == undefined) then
		(
		format ("-- charRigger: makeStretchyBones(), upper is undefined!\n");
		return 0;
		)
    if (lower == undefined) then
		(
		format ("-- charRigger: makeStretchyBones(), lower is undefined!\n");
		return 0;
		)
    if (tip == undefined) then
		(
		format ("-- charRigger: makeStretchyBones(), tip is undefined!\n");
		return 0;
		)

	format "-- Making Stretchy bone chain\n";

		-- First make sure controllers are proper type
    lower.position.controller = Position_XYZ();
    tip.position.controller = Position_XYZ();

		-- store lengths of bones
	upLen = upper.length;
	loLen = lower.length;
	totalLen = upLen + loLen;
    format "-- Stretchy Bone Lengths: % + % = %.\n" upLen loLen totalLen;

    cntLO = lower.position.controller.x_position.controller = float_script();
    cntTP = tip.position.x_position.controller = float_script();

	if (EmptyModifier != undefined) then
		ah = "Attribute_Holder.";
	else
		ah = "";

    str = "";
	str += ("-- Wrap this in a cA.get to make sure we have CA's now. \n");
	str += ("--    Otherwise on a load or merge, 3dsMAX might try to execute \n");
	str += ("--    this before the CA's get loaded in!  This way it waits until \n");
	str += ("--    everything is fully loaded before -really- calculating. \n");
	if (ah == "") then
	    str += ("myD = custAttributes.get $'"+ctrl.name+"' 1; \n");
    else
	    str += ("myD = custAttributes.get $'"+ctrl.name+"'.Attribute_Holder 1; \n");
	str += ("if (myD != undefined) then \n");
	str += ("( \n");
	str += ("dependsOn " +dep+";\n");
	str += ("d = distance $'"+ik.name+"'.pos $"+upper.name+".pos;\n");
	str += ("st = (d - "+(totalLen as string)+");	-- Length of Upper and Lower joints extended\n");
	str += ("orig = "+(upLen as string)+";		-- original bone.length of parent\n");
	str += ("if (st < 0) then	-- cap at 0 since if we \"squashed\" the leg\n");
	str += ("	st = 0;	-- it would never actually bend\n");
	str += ("m = $"+ctrl.name+"."+ah+"maxstretch;\n");
	str += ("if (st > m) then 	-- cap stretch at max val as set by slider\n");
	str += ("	st = m;\n");
	str += ("st = st + $"+ctrl.name+"."+ah+"extrastretch;\n");
	str += ("p = orig + (st/2);	-- divide by 2 since 2 joints in stretch chain\n");
	str += (") \n");
	str += ("else \n");
	str += ("    "+(upLen as string)+"; \n");
	str += ("-- End of script\n");

	cntLO.script = str;

    str = "";
	str += ("-- Wrap this in a cA.get to make sure we have CA's now. \n");
	str += ("--    Otherwise on a load or merge, 3dsMAX might try to execute \n");
	str += ("--    this before the CA's get loaded in!  This way it waits until \n");
	str += ("--    everything is fully loaded before -really- calculating. \n");
	if (ah == "") then
	    str += ("myD = custAttributes.get $'"+ctrl.name+"' 1; \n");
    else
	    str += ("myD = custAttributes.get $'"+ctrl.name+"'.Attribute_Holder 1; \n");
	str += ("if (myD != undefined) then \n");
	str += ("( \n");
	str += ("dependsOn " +dep+";\n");
	str += ("d = distance $'"+ik.name+"'.pos $"+upper.name+".pos;\n");
	str += ("st = (d - "+(totalLen as string)+");	-- Length of Upper and Lower joints extended\n");
	str += ("orig = "+(loLen as string)+";		-- original bone.length of parent\n");
	str += ("if (st < 0) then	-- cap at 0 since if we \"squashed\" the leg\n");
	str += ("	st = 0;	-- it would never actually bend\n");
	str += ("m = $"+ctrl.name+"."+ah+"maxstretch;\n");
	str += ("if (st > m) then 	-- cap stretch at max val as set by slider\n");
	str += ("	st = m;\n");
	str += ("st = st + $"+ctrl.name+"."+ah+"extrastretch;\n");
	str += ("p = orig + (st/2);	-- divide by 2 since 2 joints in stretch chain\n");
	str += (") \n");
	str += ("else \n");
	str += ("    "+(loLen as string)+"; \n");
	str += ("-- End of script\n");

	cntTP.script = str;

    return 1;
)
		-- wrist twist bones stay in the right place when stretchy stuff happens.
-- -----------------------------------------------------------------------------------------------

/*
 * makeStretchyTwist() -  Sets up a special script for twist bones that are
 *		parented to a regular stretchy bone...
 */
fn makeStretchyTwist num neg twB pB upB ik ctrl dep =
(
    if (twB == undefined) then
		(
		format ("-- charRigger: makeStretchyTwist(), twistBone is undefined!\n");
		return 0;
		)
    if (pB == undefined) then
		(
		format ("-- charRigger: makeStretchyTwist(), parentBone is undefined!\n");
		return 0;
		)

	format "-- Making Stretchy Twist for %\n" twB.name;

		-- First make sure controllers are proper type
    twB.position.controller = Position_XYZ();

		-- store data for bones
    origPos = (twB.pos.x - pB.pos.x)*neg;
    totalLen = distance ik upB;

    cntTW = twB.position.controller.x_position.controller = float_script();

	if (EmptyModifier != undefined) then
		ah = "Attribute_Holder.";
	else
		ah = "";

    str = "";
	str += ("-- Wrap this in a cA.get to make sure we have CA's now. \n");
	str += ("--    Otherwise on a load or merge, 3dsMAX might try to execute \n");
	str += ("--    this before the CA's get loaded in!  This way it waits until \n");
	str += ("--    everything is fully loaded before -really- calculating. \n");
	if (ah == "") then
	    str += ("myD = custAttributes.get $'"+ctrl.name+"' 1; \n");
    else
	    str += ("myD = custAttributes.get $'"+ctrl.name+"'.Attribute_Holder 1; \n");
	str += ("if (myD != undefined) then \n");
	str += ("( \n");
	str += ("dependsOn " +dep+";\n");
	str += ("d = distance $'"+ik.name+"'.pos $"+upB.name+".pos;\n");
	str += ("st = (d - "+(totalLen as string)+");	-- Length of joints extended\n");
	str += ("orig = "+(origPos as string)+";		-- original bone pos\n");
	str += ("if (st < 0) then	-- cap at 0 since if we \"squashed\" the leg\n");
	str += ("	st = 0;	-- it would never actually bend\n");
	str += ("m = $"+ctrl.name+"."+ah+"maxstretch;\n");
	str += ("if (st > m) then 	-- cap stretch at max val as set by slider\n");
	str += ("	st = m;\n");
	str += ("st = st + $"+ctrl.name+"."+ah+"extrastretch;\n");
	str += ("p = orig + (st/2*"+(num as string)+"/4);\n");
	str += (") \n");
	str += ("else \n");
	str += ("    "+(origPos as string)+"; \n");
	str += ("-- End of script\n");

	cntTW.script = str;
)


-- -----------------------------------------------------------------------------------------------

/*
 * makeAutoTwist() -  Sets up a special script for twist bones that are
 *		parented to do auto twisting based on hidden locators to read "local" hand
 *		rotation ABOUT the lower arm.  This way it uses the proper axis even the
 *		hand is up or down or at other angles, and even though it is not part of the
 *		hierarchy so we can't really read local rotation.
 */
fn makeAutoTwist attr reader base baseY handCTRL pSWV =
(
    if (reader == undefined) then
		(
		format ("-- charRigger: makeAutoTwist(), reader is undefined!\n");
		return 0;
		)

    if (base == undefined) then
		(
		format ("-- charRigger: makeAutoTwist(), base is undefined!\n");
		return 0;
		)
    if (base == undefined) then
		(
		format ("-- charRigger: makeAutoTwist(), baseY is undefined!\n");
		return 0;
		)
    if (handCTRL == undefined) then
		(
		format ("-- charRigger: makeAutoTwist(), handCTRL is undefined!\n");
		return 0;
		)

	format "-- Making autoTwist Expression.\n";


		-- Setup controller as a float script...
	cntTW = undefined;

	if (EmptyModifier != undefined) then
		(
		ah = "Attribute_Holder.";
	    cntTW = attr.Attribute_Holder.autoTwist.controller = float_script();
		)
	else
		(
		ah = "";
	    cntTW = attr.autoTwist.controller = float_script();
		)

		-- Make the expression

	str = "";

	str += ("dependsOn $'"+handCTRL.name+"' $'"+pSWV.name+"'; \n");
	str += ("--\n");
	str += ("-- Wrap this in a cA.get to make sure we have CA's now. \n");
	str += ("--    Otherwise on a load or merge, 3dsMAX might try to execute \n");
	str += ("--    this before the CA's get loaded in!  This way it waits until \n");
	str += ("--    everything is fully loaded before -really- calculating. \n");
	if (ah == "") then
	    str += ("myD = custAttributes.get $'"+handCTRL.name+"' 1; \n");
    else
	    str += ("myD = custAttributes.get $'"+handCTRL.name+"'.Attribute_Holder 1; \n");
	str += ("if (myD != undefined) then \n");
	str += ("( \n");
	str += ("--\n");
	str += ("-- This script takes two helpers on the wrist to get a\n");
	str += ("--	    local hand \"Y\" vector, and then unrotates it\n");
	str += ("--	    by the rotation on the lower arm.\n");
	str += ("-- This way the hand vector is now aligned to the\n");
	str += ("--	    coordinate space of the lower arm.\n");
	str += ("-- At that point I can get what would be the rotation around\n");
	str += ("--	    the lowerArms X axis using the Y axis as reference\n");
	str += ("--	    (using Y means Y is still correct even if it rotates\n");
	str += ("--	    up/down on the Y axis causing the Z to move)\n");
	str += ("-- Because we've rotated the hand's world space rotation\n");
	str += ("--     back by the lower arm readers rotation, this all\n");
	str += ("--     works in the coordinates of the lower arm, thereby\n");
	str += ("--	    giving us proper values, even though the hand\n");
	str += ("--	    is not in the hierarchy.\n");
	str += ("-- Using simple trig (SOH CAH TOA) we can get the angle\n");
	str += ("--	    of the twist.\n");
	str += ("--\n");
	str += ("coordsys world\n");
    str += ("    (\n");
    str += ("	-- Get rotation in world of lower arm\n");
    str += ("    rotStart = $'"+reader.name+"'.rotation as eulerangles;\n");
    str += ("	-- where is our wrist axis at?\n");
    str += ("    posEnd = $'"+base.name+"'.position;\n");
    str += ("	-- Get our Y axis for the wrist in world\n");
    str += ("    endY = $'"+baseY.name+"'.position - posEnd;\n");
    str += ("	-- Normalize our wrist axis\n");
	str += ("    endY = normalize endY;\n");
	str += ("    )\n");
	str += ("-- Everything is now normalized for the wrist, so\n");
	str += ("-- all we have to do now is unrotate by the upperArm angles\n");
	str += ("-- Make rotation matrices\n");
	str += ("rotMatX = rotateXmatrix rotStart.x;\n");
	str += ("rotMatY = rotateYmatrix rotStart.y;\n");
	str += ("rotMatZ = rotateZmatrix rotStart.z;\n");
	str += ("rotMat = rotMatX * rotMatY * rotMatZ;\n");
	str += ("-- Now rotate our Y axis Vector by each x y z of the lowerArm we got\n");
	str += ("endY = endY * rotMat;\n");
	str += ("--format \"--DEBUG: x=% y=% z=%\\n\" endX endY endZ;\n");
	str += ("-- Max atan always in degrees...yay\n");
	str += ("-- X is axis down bone, Z is up, but will probably move a lot, so look at one back/sideways = Y\n");
	str += ("autoTwistX = 0.0;\n");
	str += ("-- First make sure we don't have a divide by 0 error...\n");
	str += ("if (endY.z != 0) then\n");
	str += ("    autoTwistX = atan (endY.y / endY.z) +90;\n");
	str += ("-- Then if we have crossed above the Y=0 line, we will have a 180 flip, so handle that...\n");
	str += ("if (endY.z > 0) then\n");
	str += ("    (\n");
	str += ("    autoTwistX -= 180;\n");
	str += ("    )\n");
	str += ("autoTwistX = -1*autoTwistX;  -- Do this just so things rotate the right way\n");
	str += ("-- Now add in any manual override the user did using the handCTRL attribute.\n");
	str += ("autoTwistX *= $'"+handCTRL.name+"'."+ah+"autoTwistPct / 100.0;\n");
	str += ("autoTwistX += $'"+handCTRL.name+"'."+ah+"extraTwist;\n");
	str += ("--\n");
	str += (") \n");
	str += ("else \n");
	str += ("    0.0; \n");
	str += ("-- End of autoTwist script\n");

	cntTW.script = str;
)



-- -----------------------------------------------------------------------------------------------

/*
 * addFootAttrs() - Adds foot attributes onto the object.
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addFootAttrs obj =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addFootAttrs(), obj is undefined!\n");
		return();
		)

		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)

		--
		-- main attr def stuff
		--
    str = "footAttrs = attributes Custom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:footAttrsRO\n"+
		"	(\n"+
		"	roll type:#float default:0.0 ui:rollSpin\n"+
		"	toeRotate type:#float default:0.0 ui:toeRotateSpin;\n";
		if (stretchyLegs) then
			(
			str += "	maxstretch type:#float default:0.0 ui:maxstretchSpin\n"+
			"	extrastretch type:#float default:0.0 ui:extrastretchSpin;\n";
			)
		str += "	)\n"+
		"   \n"+
		"rollout footAttrsRO \"Foot Anim Parameters\"\n"+
		"   (\n"+
		"   spinner 'rollSpin' \"roll\" fieldWidth:60 type:#float range:[-100,100,0];\n"+
		"   spinner 'toeRotateSpin' \"toeRotate\" fieldWidth:60 type:#float range:[-180,180,0];\n";
		if (stretchyLegs) then
			(
			str += "   spinner 'maxstretchSpin' \"maxStretch\" fieldWidth:60 type:#float range:[0,9000,0];\n"+
			"   spinner 'extrastretchSpin' \"extraStretch\" fieldWidth:60 type:#float range:[-9000,9000,0];\n";
			)
	    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;

		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n"+
		"pb1 = CAT_ParamBlock name:\"'roll'\" type:\"Float\" ui:\"rollSpin\" default:\"0.0\";\n"+
		"pb2 = CAT_ParamBlock name:\"'toeRotate'\" type:\"Float\" ui:\"toeRotateSpin\" default:\"0.0\";\n";
		if (stretchyLegs) then
			(
			str += "pb3 = CAT_ParamBlock name:\"'maxstretch'\" type:\"Float\" ui:\"maxstretchSpin\" default:\"0.0\";\n"+
			"pb4 = CAT_ParamBlock name:\"'extrastretch'\" type:\"Float\" ui:\"extrastretchSpin\" default:\"0.0\";\n";
			)
		str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'roll'\" type:\"Float\" range:\"[-100,100,0]\";\n"+
		"ui2 = CAT_UIItem ui:\"Spinner\" name:\"'toeRotate'\" type:\"Float\" range:\"[-180,180,0]\";\n";
		if (stretchyLegs) then
			(
			str += "ui3 = CAT_UIItem ui:\"Spinner\" name:\"'maxstretch'\" type:\"Float\" range:\"[0,9000,0]\";\n"+
			"ui4 = CAT_UIItem ui:\"Spinner\" name:\"'extrastretch'\" type:\"Float\" range:\"[-9000,9000,0]\";\n";
			)
		if (stretchyLegs) then
			(
			str += "arr1 = #(pb1, pb2, pb3, pb4);\n"+
			"arr2 = #(ui1, ui2, ui3, ui4);\n";
			)
		else (
			str += "arr1 = #(pb1, pb2);\n"+
			"arr2 = #(ui1, ui2);\n";
			)
		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData footAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder footAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" footAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		str += "$"+(obj.name)+".Attribute_Holder.roll.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".Attribute_Holder.toeRotate.controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		str += "$"+(obj.name)+".roll.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".toeRotate.controller = Bezier_Float();\n";
		)
	execute str;

)


-- -----------------------------------------------------------------------------------------------

/*
 * addArmAttrs() - Adds arm attributes onto the object.
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addArmAttrs obj =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addArmAttrs(), obj is undefined!\n");
		return();
		)

		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)

		--
		-- main attr def stuff
		--
    str = "armAttrs = attributes ArmCustom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:armAttrsRO\n"+
		"	(\n"+
		"	localworld type:#float default:0.0 ui:localworldSpin\n"+
		"	autoTwistPct type:#float default:100.0 ui:autoTwistPctSpin\n"+
		"	extraTwist type:#float default:0.0 ui:extraTwistSpin\n";
		if (stretchyArms) then
			(
			str += "	maxstretch type:#float default:0.0 ui:maxstretchSpin\n"+
			"	extrastretch type:#float default:0.0 ui:extrastretchSpin;\n";
			)
		str += "	)\n"+
		"   \n"+
		"rollout armAttrsRO \"Arm Anim Parameters\"\n"+
		"   (\n"+
		"   spinner 'localworldSpin' \"localWorld\" fieldWidth:60 type:#float range:[0,100,0];\n"+
		"   spinner 'autoTwistPctSpin' \"autoTwistPct\" fieldWidth:60 type:#float range:[0,100,100];\n"+
		"   spinner 'extraTwistSpin' \"extraTwist\" fieldWidth:60 type:#float range:[-720,720,0];\n";
		if (stretchyArms) then
			(
			str += "   spinner 'maxstretchSpin' \"maxStretch\" fieldWidth:60 type:#float range:[0,9000,0];\n"+
			"   spinner 'extrastretchSpin' \"extraStretch\" fieldWidth:60 type:#float range:[-9000,9000,0];\n";
			)
	    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;

		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n"+
		"pb1 = CAT_ParamBlock name:\"'localworld'\" type:\"Float\" ui:\"localworldSpin\" default:\"0.0\";\n"+
		"pb1a = CAT_ParamBlock name:\"'autoTwistPct'\" type:\"Float\" ui:\"autoTwistPctSpin\" default:\"0.0\";\n"+
		"pb1b = CAT_ParamBlock name:\"'extraTwist'\" type:\"Float\" ui:\"extraTwistSpin\" default:\"0.0\";\n";
		if (stretchyArms) then
			(
			str += "pb4 = CAT_ParamBlock name:\"'maxstretch'\" type:\"Float\" ui:\"maxstretchSpin\" default:\"0.0\";\n"+
			"pb5 = CAT_ParamBlock name:\"'extrastretch'\" type:\"Float\" ui:\"extrastretchSpin\" default:\"0.0\";\n";
			)
		str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'localworld'\" type:\"Float\" range:\"[0,100,0]\";\n"+
		"ui1a = CAT_UIItem ui:\"Spinner\" name:\"'autoTwistPct'\" type:\"Float\" range:\"[0,100,100]\";\n"+
		"ui1b = CAT_UIItem ui:\"Spinner\" name:\"'extraTwist'\" type:\"Float\" range:\"[-720,720,0]\";\n";
		if (stretchyArms) then
			(
			str += "ui4 = CAT_UIItem ui:\"Spinner\" name:\"'maxstretch'\" type:\"Float\" range:\"[0,9000,0]\";\n"+
			"ui5 = CAT_UIItem ui:\"Spinner\" name:\"'extrastretch'\" type:\"Float\" range:\"[-9000,9000,0]\";\n";
			)
		if (stretchyArms) then
			(
			str += "arr1 = #(pb1, pb1a, pb1b, pb4, pb5);\n"+
			"arr2 = #(ui1, ui1a, ui1b, ui4, ui5);\n";
			)
		else (
			str += "arr1 = #(pb1, pb1a, pb1b, pb2, pb3);\n"+
			"arr2 = #(ui1, ui1a, ui1b, ui2, ui3);\n";
			)
		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData armAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder armAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" armAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		str += "$"+(obj.name)+".Attribute_Holder.localworld.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".Attribute_Holder.autoTwistPct.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".Attribute_Holder.extraTwist.controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		str += "$"+(obj.name)+".localworld.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".autoTwistPct.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".extraTwist.controller = Bezier_Float();\n";
		)
	execute str;

)


-- -----------------------------------------------------------------------------------------------

/*
 * addFingerAttrs() - Adds finger attributes onto the object.
 *		doThumb is true if there are supposed to be thumb CA's
 *		numF	is the number of finger CA's to add
 *
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addFingerAttrs obj doThumb numF =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addFingerAttrs(), obj is undefined!\n");
		return();
		)

		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)

		--
		-- main attr def stuff
		--
    str = "fingerAttrs = attributes Custom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:fingerAttrsRO\n"+
		"	(\n";
		if (doThumb) then
			(
			str += "	thumb type:#float default:0.0 ui:thumbSpin\n"+
				   "	thumbtwist type:#float default:0.0 ui:thumbtwistSpin\n"+
				   "	thumbadj type:#float default:0.0 ui:thumbadjSpin\n";
			)
		if (numF > 1) then
			(
			str += "	spread type:#float default:0.0 ui:spreadSpin\n";
			)
		for i in 1 to numF do
			(
			str += "	finger"+(i as string)+" type:#float default:0.0 ui:finger"+(i as string)+"Spin\n";
			)
		str += "	)\n"+
		"   \n"+
		"rollout fingerAttrsRO \"Finger Anim Parameters\"\n"+
		"   (\n";
		if (doThumb) then
			(
			str +=	"   spinner 'thumbSpin' \"thumb\" fieldWidth:60 type:#float range:[-100,100,0];\n"+
				    "   spinner 'thumbtwistSpin' \"thumbTwist\" fieldWidth:60 type:#float range:[-100,100,0];\n"+
				    "   spinner 'thumbadjSpin' \"thumbAdj\" fieldWidth:60 type:#float range:[-100,100,0];\n";
			)
		if (numF > 1) then
			(
			str +=	"   spinner 'spreadSpin' \"spread\" fieldWidth:60 type:#float range:[-100,100,0];\n";
			)
		for i in 1 to numF do
			(
			str +=	"   spinner 'finger"+(i as string)+"Spin' \"finger"+(i as string)+"\" fieldWidth:60 type:#float range:[-100,100,0];\n";
			)
	    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;

		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n";
		if (doThumb) then
			(
			str += "pb1 = CAT_ParamBlock name:\"'thumb'\" type:\"Float\" ui:\"thumbSpin\" default:\"0.0\";\n"+
				   "pb2 = CAT_ParamBlock name:\"'thumbadj'\" type:\"Float\" ui:\"thumbadjSpin\" default:\"0.0\";\n"+
				   "pb2a = CAT_ParamBlock name:\"'thumbtwist'\" type:\"Float\" ui:\"thumbtwistSpin\" default:\"0.0\";\n";
			)
		if (numF > 1) then
			(
			str += "pb3 = CAT_ParamBlock name:\"'spread'\" type:\"Float\" ui:\"spreadSpin\" default:\"0.0\";\n";
			)
		for i in 1 to numF do
			(
			str += "pb"+((i+3) as string)+" = CAT_ParamBlock name:\"'finger"+(i as string)+"'\" type:\"Float\" ui:\"finger"+(i as string)+"Spin\" default:\"0.0\";\n";
			)
		if (doThumb) then
			(
			str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'thumb'\" type:\"Float\" range:\"[-100,100,0]\";\n"+
				   "ui2 = CAT_UIItem ui:\"Spinner\" name:\"'thumbadj'\" type:\"Float\" range:\"[-100,100,0]\";\n"+
				   "ui2a = CAT_UIItem ui:\"Spinner\" name:\"'thumbtwist'\" type:\"Float\" range:\"[-100,100,0]\";\n";
			)
		if (numF > 1) then
			(
			str += "ui3 = CAT_UIItem ui:\"Spinner\" name:\"'spread'\" type:\"Float\" range:\"[-100,100,0]\";\n";
			)
		for i in 1 to numF do
			(
			str += "ui"+((i+3) as string)+" = CAT_UIItem ui:\"Spinner\" name:\"'finger"+(i as string)+"'\" type:\"Float\" range:\"[-100,100,0]\";\n";
			)

		if (doThumb) then
			(
			str += "arr1 = #(pb1, pb2, pb2a";
--			if (numF <= 0) then
--				str += ");\n";
			)
		if (numF > 1) then
			(
			if (doThumb == false) then
				str += "arr1 = #(";
			else
				str += ",";
			str += "pb3";
			)
		if (numF == 1) then
			(
			if (doThumb == false) then
				str += "arr1 = #(";
			else
				str += ",";
			str += "pb4);\n";
			)
		else (
			for i in 1 to numF do
				(
				str += (", pb"+((i+3) as string));
				)
			str += ");\n";
			)

		if (doThumb) then
			(
			str += "arr2 = #(ui1, ui2, ui2a";
--			if (numF <= 0) then
--				str += ");\n";
			)
		if (numF > 1) then
			(
			if (doThumb == false) then
				str += "arr2 = #(";
			else
				str += ",";
			str += "ui3";
			)
		if (numF == 1) then
			(
			if (doThumb == false) then
				str += "arr1 = #(";
			else
				str += ",";
			str += "ui4);\n";
			)
		else (
			for i in 1 to numF do
				(
				str += (", ui"+((i+3) as string));
				)
			str += ");\n";
			)

		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData fingerAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder fingerAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" fingerAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		if (doThumb) then
			(
			str += "$"+(obj.name)+".Attribute_Holder.thumb.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".Attribute_Holder.thumbadj.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".Attribute_Holder.thumbtwist.controller = Bezier_Float();\n";
			)
		if (numF > 1) then
			str += "$"+(obj.name)+".Attribute_Holder.spread.controller = Bezier_Float();\n";
		for i in 1 to numF do
			str += "$"+(obj.name)+".Attribute_Holder.finger"+(i as string)+".controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		if (doThumb) then
			(
			str += "$"+(obj.name)+".thumb.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".thumbadj.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".thumbtwist.controller = Bezier_Float();\n";
			)
		if (numF > 1) then
			str += "$"+(obj.name)+".spread.controller = Bezier_Float();\n";
		for i in 1 to numF do
			str += "$"+(obj.name)+".finger"+(i as string)+".controller = Bezier_Float();\n";
		)
	execute str;

)



-- -----------------------------------------------------------------------------------------------

/*
 * addToeAttrs() - Adds toe attributes onto the object.
 *      doToe1  true if we have a toe 1 with special control
 *		numT	is the number of toe CA's to add
 *
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addToeAttrs obj doToe1 numT =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addToeAttrs(), obj is undefined!\n");
		return();
		)

/*
--DON'T DO THIS SINCE WE'VE ALREADY DONE IT WHEN WE ADDED THE ARM ATTRS ON
		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)
*/
		--
		-- main attr def stuff
		--
    str = "toeAttrs = attributes ToeCustom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:toeAttrsRO\n"+
		"	(\n";
		if (doToe1) then
			(
			str += "	toe1 type:#float default:0.0 ui:toe1Spin\n"+
				   "	toe1twist type:#float default:0.0 ui:toe1twistSpin\n"+
				   "	toe1adj type:#float default:0.0 ui:toe1adjSpin\n";
			)
		if (numT > 1) then
			(
			str += "	toespread type:#float default:0.0 ui:toespreadSpin\n";
			)
		for i in 2 to (numT+1) do
			(
			str += "	toe"+(i as string)+" type:#float default:0.0 ui:toe"+(i as string)+"Spin\n";
			)
		str += "	)\n"+
		"   \n"+
		"rollout toeAttrsRO \"Toe Anim Parameters\"\n"+
		"   (\n";
		if (doToe1) then
			(
			str +=	"   spinner 'toe1Spin' \"toe1\" fieldWidth:60 type:#float range:[-100,100,0];\n"+
				    "   spinner 'toe1twistSpin' \"toe1Twist\" fieldWidth:60 type:#float range:[-100,100,0];\n"+
				    "   spinner 'toe1adjSpin' \"toe1Adj\" fieldWidth:60 type:#float range:[-100,100,0];\n";
			)
		if (numT > 1) then
			(
			str +=	"   spinner 'toespreadSpin' \"spread\" fieldWidth:60 type:#float range:[-100,100,0];\n";
			)
		for i in 2 to (numT+1) do
			(
			str +=	"   spinner 'toe"+(i as string)+"Spin' \"toe"+(i as string)+"\" fieldWidth:60 type:#float range:[-100,100,0];\n";
			)
	    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;


		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n";
		if (doToe1) then
			(
			str += "pb1 = CAT_ParamBlock name:\"'toe1'\" type:\"Float\" ui:\"toe1Spin\" default:\"0.0\";\n"+
				   "pb2 = CAT_ParamBlock name:\"'toe1adj'\" type:\"Float\" ui:\"toe1adjSpin\" default:\"0.0\";\n"+
				   "pb2a = CAT_ParamBlock name:\"'toe1twist'\" type:\"Float\" ui:\"toe1twistSpin\" default:\"0.0\";\n";
			)
		if (numT > 1) then
			(
			str += "pb3 = CAT_ParamBlock name:\"'toespread'\" type:\"Float\" ui:\"toespreadSpin\" default:\"0.0\";\n";
			)
		for i in 2 to (numT+1) do
			(
			str += "pb"+((i+3) as string)+" = CAT_ParamBlock name:\"'toe"+(i as string)+"'\" type:\"Float\" ui:\"toe"+(i as string)+"Spin\" default:\"0.0\";\n";
			)
		if (doToe1) then
			(
			str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'toe1'\" type:\"Float\" range:\"[-100,100,0]\";\n"+
				   "ui2 = CAT_UIItem ui:\"Spinner\" name:\"'toe1adj'\" type:\"Float\" range:\"[-100,100,0]\";\n"+
				   "ui2a = CAT_UIItem ui:\"Spinner\" name:\"'toe1twist'\" type:\"Float\" range:\"[-100,100,0]\";\n";
			)
		if (numT > 1) then
			(
			str += "ui3 = CAT_UIItem ui:\"Spinner\" name:\"'toespread'\" type:\"Float\" range:\"[-100,100,0]\";\n";
			)
		for i in 2 to (numT+1) do
			(
			str += "ui"+((i+3) as string)+" = CAT_UIItem ui:\"Spinner\" name:\"'toe"+(i as string)+"'\" type:\"Float\" range:\"[-100,100,0]\";\n";
			)

		if (doToe1) then
			(
			str += "arr1 = #(pb1, pb2, pb2a";
			)
		if (numT > 1) then
			(
			if (doToe1 == false) then
				str += "arr1 = #(";
			else
				str += ",";
			str += "pb3";
			)
		if (numT == 1) then
			(
			if (doToe1 == false) then
				str += "arr1 = #(";
			else
				str += ",";
			str += "pb4);\n";
			)
		else (
			for i in 2 to (numT+1) do
				(
				str += (", pb"+((i+3) as string));
				)
			str += ");\n";
			)

		if (doToe1) then
			(
			str += "arr2 = #(ui1, ui2, ui2a";
			)
		if (numT > 1) then
			(
			if (doToe1 == false) then
				str += "arr2 = #(";
			else
				str += ",";
			str += "ui3";
			)
		if (numT == 1) then
			(
			if (doToe1 == false) then
				str += "arr1 = #(";
			else
				str += ",";
			str += "ui4);\n";
			)
		else (
			for i in 2 to (numT+1) do
				(
				str += (", ui"+((i+3) as string));
				)
			str += ");\n";
			)

		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData toeAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder toeAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" toeAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		if (doToe1) then
			(
			str += "$"+(obj.name)+".Attribute_Holder.toe1.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".Attribute_Holder.toe1adj.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".Attribute_Holder.toe1twist.controller = Bezier_Float();\n";
			)
		if (numT > 1) then
			str += "$"+(obj.name)+".Attribute_Holder.toespread.controller = Bezier_Float();\n";
		for i in 2 to (numT+1) do
			str += "$"+(obj.name)+".Attribute_Holder.toe"+(i as string)+".controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		if (doToe1) then
			(
			str += "$"+(obj.name)+".toe1.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".toe1adj.controller = Bezier_Float();\n";
			str += "$"+(obj.name)+".toe1twist.controller = Bezier_Float();\n";
			)
		if (numT > 1) then
			str += "$"+(obj.name)+".toespread.controller = Bezier_Float();\n";
		for i in 2 to (numT+1) do
			str += "$"+(obj.name)+".toe"+(i as string)+".controller = Bezier_Float();\n";
		)
	execute str;

)



-- -----------------------------------------------------------------------------------------------



/*
 * addSpineAttrs() - Adds spine attributes onto the object.
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addSpineAttrs obj =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addSpineAttrs(), obj is undefined!\n");
		return();
		)

		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)

		--
		-- main attr def stuff
		--
    str = "spineAttrs = attributes Custom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:spineAttrsRO\n"+
		"	(\n"+
		"	stretchable type:#float default:100.0 ui:stretchableSpin\n"+
		"	squashable type:#float default:100.0 ui:squashableSpin;\n";
	str += "	)\n"+
		"   \n"+
		"rollout spineAttrsRO \"Spine Anim Parameters\"\n"+
		"   (\n"+
		"   spinner 'stretchableSpin' \"stretchable\" fieldWidth:60 type:#float range:[0,100,100];\n"+
		"   spinner 'squashableSpin' \"squashable\" fieldWidth:60 type:#float range:[0,100,100];\n";
    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;

		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n"+
		"pb1 = CAT_ParamBlock name:\"'stretchable'\" type:\"Float\" ui:\"stretchableSpin\" default:\"100.0\";\n"+
		"pb2 = CAT_ParamBlock name:\"'squashable'\" type:\"Float\" ui:\"squashableSpin\" default:\"100.0\";\n";
		str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'stretchable'\" type:\"Float\" range:\"[0,100,100]\";\n"+
			   "ui2 = CAT_UIItem ui:\"Spinner\" name:\"'squashable'\" type:\"Float\" range:\"[0,100,100]\";\n";
		str += "arr1 = #(pb1, pb2);\n"+
			   "arr2 = #(ui1, ui2);\n";
		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData spineAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder spineAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" spineAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		str += "$"+(obj.name)+".Attribute_Holder.stretchable.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".Attribute_Holder.squashable.controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		str += "$"+(obj.name)+".stretchable.controller = Bezier_Float();\n";
		str += "$"+(obj.name)+".squashable.controller = Bezier_Float();\n";
		)
	execute str;

)


-- -----------------------------------------------------------------------------------------------




/*
 * addShoulderAttrs() - Adds Shoulder attributes onto the object.
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addShoulderAttrs obj =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addShoulderAttrs(), obj is undefined!\n");
		return();
		)

		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)

		--
		-- main attr def stuff
		--
    str = "shoulderAttrs = attributes Custom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:shoulderAttrsRO\n"+
		"	(\n"+
		"	autoAim type:#float default:60.0 ui:autoAimSpin\n";
	str += "	)\n"+
		"   \n"+
		"rollout shoulderAttrsRO \"Shoulder Anim Parameters\"\n"+
		"   (\n"+
		"   spinner 'autoAimSpin' \"autoAim\" fieldWidth:60 type:#float range:[0,100,60];\n";
    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;

		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n"+
		"pb1 = CAT_ParamBlock name:\"'autoAim'\" type:\"Float\" ui:\"autoAimSpin\" default:\"60.0\";\n";
	str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'autoAim'\" type:\"Float\" range:\"[0,100,60]\";\n";
	str += "arr1 = #(pb1);\n"+
		   "arr2 = #(ui1);\n";
		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData shoulderAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder shoulderAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" shoulderAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		str += "$"+(obj.name)+".Attribute_Holder.autoAim.controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		str += "$"+(obj.name)+".autoAim.controller = Bezier_Float();\n";
		)
	execute str;

)




-- -----------------------------------------------------------------------------------------------




/*
 * addInternalTwistAttrs() - Adds internal twist attribute onto the object.
 *    This defines a CA definiton.
 *	  Then it adds some custom data as an array of two sub arrays
 *			the first being an array of MAX's CAT_ParamBlock structs
 *			the second is an array of MAX's CAT_UIItem structs,
 *				with one item per attribute.  This custom data stores info
 *				about the range, so other stuff, like my attrKey script can use
 *				and get the range data back out.
 *	  Finally the data is then actually added onto the object.  If the user has
 *		the EmptyModifer() aka Attribute Holder modifier installed, then it
 *		will tack that onto the object.  Otherwise it adds it to the base object.
 */
fn addInternalTwistAttrs obj =
(
    if (obj == undefined) then
		(
		format ("-- charRigger INTERNAL ERROR: addInternalTwistAttrs(), obj is undefined!\n");
		return();
		)

		-- Make sure user installed the AttributeHolder modifier.
    if (EmptyModifier != undefined) then
		(
			-- Add Attr Holder modifier
		addModifier obj (EmptyModifier());
		)

		--
		-- main attr def stuff
		--
    str = "internalTwistAttrs = attributes TwistCustom_Attributes\n"+
		"(\n"+
	    "parameters main rollout:internalTwistAttrsRO\n"+
		"	(\n"+
		"	autoTwist type:#float default:0.0 ui:autoTwistSpin\n";
	str += "	)\n"+
		"   \n"+
		"rollout internalTwistAttrsRO \"Internal Twist Calculation Parameters\"\n"+
		"   (\n"+
		"   spinner 'autoTwistSpin' \"autoTwist\" fieldWidth:60 type:#float range:[-720,720,0];\n";
    str += "   )\n"+
		");\n"+
		"\n" ;
	execute str;

		--
		-- Add some custom def data like MAX does, so we can retrieve RANGE info later for things like my attrKey script.
		--
	str = "\n"+
		"pb1 = CAT_ParamBlock name:\"'autoTwist'\" type:\"Float\" ui:\"autoTwistSpin\" default:\"0.0\";\n";
	str += "ui1 = CAT_UIItem ui:\"Spinner\" name:\"'autoTwist'\" type:\"Float\" range:\"[-720,720,0]\";\n";
	str += "arr1 = #(pb1);\n"+
		   "arr2 = #(ui1);\n";
		str += "theArr = #(arr1, arr2)\n"+
		"\n"+
		"custAttributes.setDefData internalTwistAttrs theArr;\n";
	execute str;

    if (EmptyModifier != undefined) then
		str = "custAttributes.add $"+(obj.name)+".Attribute_Holder internalTwistAttrs;";
	else
		str = "custAttributes.add $"+(obj.name)+" internalTwistAttrs;";
	execute str;
		--
		-- Now add a default controller too
		--
    if (EmptyModifier != undefined) then
		(
		str = "";
		str += "$"+(obj.name)+".Attribute_Holder.autoTwist.controller = Bezier_Float();\n";
		)
	else
		(
		str = "";
		str += "$"+(obj.name)+".autoTwist.controller = Bezier_Float();\n";
		)
	execute str;

)



-- -----------------------------------------------------------------------------------------------

/*
 * createHips() - Makes the hips object
 */
fn createHips =
(

    if (objExists(prefix+"_"+"hipCTRL")) then
		(
		format "-- Hips already created.\n";
		execute("hipCTRL = $"+prefix+"_hipCTRL;");
		return 0;
		)
    if (objExists("$ptHips") != true) then
		(
		format "-- WARNING: Can't create hips.  \"ptHips\" does not exist.\n";
		return 0;
		)

	-- Figure out Radius
	r = 0;
    if (objExists("$ptLLeg")) then
		(
		r = $ptLLeg.pos.x - $ptHips.pos.x;
		r = r + (0.55*r);
		r = abs(r);
		)
	else if (objExists("$ptRLeg")) then
		(
		r = $ptRLeg.pos.x - $ptHips.pos.x;
		r = r + (0.55*r);
		r = abs(r);
		)
	if (r <= 0) then
		(
		r = $ptHips.size*1.33;
		)

    hipCTRL = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptHips.pos isSelected:on;
	hipCTRL.name = (prefix+"_hipCTRL");
	hipCTRL.wirecolor = bodyColor;
	hipCTRL.position.controller = Position_XYZ();
	hipCTRL.rotation.controller = Euler_XYZ();
	convertToSplineShape hipCTRL;

    if (objExists(prefix+"_"+"placementCTRL")) then
		(
		execute("hipCTRL.parent = $"+prefix+"_placementCTRL;");
		zeroOut hipCTRL;
		)

    format "-- Hips created.\n";
    return 1;
)

-- -----------------------------------------------------------------------------------------------

/*
 * createPlacement() - Makes the Ground and Placement objects
 */
fn createPlacement =
(
    FL = undefined;
	FR = undefined;

    if (objExists(prefix+"_"+"placementCTRL")) then
		(
		format "-- Placement already exists.\n";
		return 0;
		)
    if (objExists(prefix+"_"+"groundCTRL")) then
		(
		format "-- Placement already exists.\n";
		return 0;
		)

    if (objExists(prefix+"_"+"hipCTRL")) then
		(
		execute("hipCTRL = $"+prefix+"_hipCTRL;");
		)

		-- Grab actual foot ctrls if they exist, pt locators otherwise.
	FL = execute("$"+prefix+"_footLCTRL");
	FR = execute("$"+prefix+"_footRCTRL");
	FL2 = execute("$"+prefix+"_footL2CTRL");
	FR2 = execute("$"+prefix+"_footR2CTRL");

	if ( hipCTRL == undefined or (FL == undefined and FR == undefined)) then
		(
		format "-- WARNING: Can't create Placement.  Hips and Legs don't exist.\n";
		return 0;
		)

		-- Calculate center position of body at foot height, and radius.
	ctr = hipCTRL.pos;
	if (FL2 != undefined) then
		(
		ctr.z = FL2.pos.z;
		r = FL2.pos.y - hipCTRL.pos.y;	-- for front legs use forward/back dist not left/right for radius
		)
	else if (FR2 != undefined) then
		(
		ctr.z = FR2.pos.z;
		r = FR2.pos.y - hipCTRL.pos.y;
		)
	else if (FL != undefined) then
		(
		ctr.z = FL.pos.z;
		r = FL.pos.x - hipCTRL.pos.x;
		)
	else
		(
		ctr.z = FR.pos.z;
		r = FR.pos.x - hipCTRL.pos.x;
		)
	-- The above figures center and a good approx of radius r for only 1 foot.
	-- but if we have 2 feet then we can figure r even better.
    if (FL != undefined and FR != undefined) then
		(
		r = length(FL.pos - FR.pos);
		r *= 1.5;
		)

    r = abs(r);
	r = r * 3.2;	-- make even bigger for placement

    placeCTRL = Ngon radius:r cornerRadius:0 nsides:12 circular:off scribe:1 pos:ctr isSelected:on;
	placeCTRL.name = (prefix+"_placementCTRL");
	placeCTRL.wirecolor = (bodyColor*0.2)+(baseColor*0.8);
	placeCTRL.position.controller = Position_XYZ();
	placeCTRL.rotation.controller = Euler_XYZ();
	convertToSplineShape placeCTRL;

    grndCTRL = Ngon radius:(r*0.65) cornerRadius:0 nsides:10 circular:off scribe:1 pos:ctr isSelected:on;
	grndCTRL.name = (prefix+"_groundCTRL");
	grndCTRL.wirecolor = (bodyColor*0.6)+(baseColor*0.4);
	grndCTRL.position.controller = Position_XYZ();
	grndCTRL.rotation.controller = Euler_XYZ();
	convertToSplineShape grndCTRL;

	-- Now parent things...

	zeroOut placeCTRL;
	hipCTRL.parent = placeCTRL;
	zeroOut hipCTRL;
	grndCTRL.parent = placeCTRL;
	zeroOut grndCTRL;
	if (FL != undefined) then
		(
		FL.parent = grndCTRL;
		zeroOut FL;
		)
	if (FR != undefined) then
		(
		FR.parent = grndCTRL;
		zeroOut FR;
		)
	if (FL2 != undefined) then
		(
		FL2.parent = grndCTRL;
		zeroOut FL2;
		)
	if (FR2 != undefined) then
		(
		FR2.parent = grndCTRL;
		zeroOut FR2;
		)


	format "-- Placement and ground created.\n";
	return 1;
)


-- -----------------------------------------------------------------------------------------------

/*
 * createLeg() - This creates the leg....
 */
fn createLeg LR =
(


    if (objExists("$pt"+LR+"Leg") != true) then
		(
		format "-- WARNING: Can't create % Leg.  \"pt%Leg\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"Knee") != true) then
		(
		format "-- WARNING: Can't create % Leg.  \"pt%Knee\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"Ankle") != true) then
		(
		format "-- WARNING: Can't create % Leg.  \"pt%Ankle\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"Ball") != true) then
		(
		format "-- WARNING: Can't create % Leg.  \"pt%Ball\" does not exist.\n" LR LR;
		return 0;
		)

    if (objExists("$pt"+LR+"Toe") != true) then
		(
		format "-- WARNING: Can't create % Leg.  \"pt%Toe\" does not exist.\n" LR LR;
		return 0;
		)

   if (objExists(prefix+"_foot"+LR+"CTRL")) then
		(
		format "-- Leg % already created.\n" LR;
		return 0;
		)


--
	if (LR == "L") then
		(
		ptLeg = $ptLLeg;
		ptKnee = $ptLKnee;
		ptAnkle = $ptLAnkle;
		ptBall = $ptLBall;
		ptToe = $ptLToe;
		)
	else if (LR == "R") then
		(
		ptLeg = $ptRLeg;
		ptKnee = $ptRKnee;
		ptAnkle = $ptRAnkle;
		ptBall = $ptRBall;
		ptToe = $ptRToe;
		)
	else if (LR == "L2") then
		(
		ptLeg = $ptL2Leg;
		ptKnee = $ptL2Knee;
		ptAnkle = $ptL2Ankle;
		ptBall = $ptL2Ball;
		ptToe = $ptL2Toe;
		)
	else (
		ptLeg = $ptR2Leg;
		ptKnee = $ptR2Knee;
		ptAnkle = $ptR2Ankle;
		ptBall = $ptR2Ball;
		ptToe = $ptR2Toe;
		)


		-- Create the bones and internal stuff
	swvDist = 10.0 * length(ptAnkle.pos - ptToe.pos);
	ctrlRad = 0.8 * length(ptAnkle.pos - ptToe.pos) / 40.0;

	if (LR == "L" or LR == "L2") then
		sideColor = leftColor;
	else
		sideColor = rightColor;

		-- Now we get a nice vector that would be to the "right" in world X to determine
		--		a nice proper "up" or side vector to make each leg bone. That helps
		--		legs that are not world aligned to be drawn nicely and thus aligned better
		--		for bending and such.  We get a fwd/back type vector then do a cross
		--		product to get a sideways one so that it works for the feet as well as the
		--		legs themselves.
		--
	vec = ptToe.pos - ptAnkle.pos;	-- get nice vector to determine Z up
	vec = cross [0,0,1] vec;	-- now make vec more on side not front/back

    bUL = BoneSys.createBone ptLeg.pos ptKnee.pos vec; 			-- upper leg
	bUL.name = (prefix+"_upperLeg"+LR+"BONE");
	boneSetup bUL true mixColor:sideColor;
    bLL = BoneSys.createBone ptKnee.pos ptAnkle.pos vec; 			-- lower leg
	bLL.name = (prefix+"_lowerLeg"+LR+"BONE");
	boneSetup bLL true mixColor:sideColor;
    bFT = BoneSys.createBone ptAnkle.pos ptBall.pos vec; 			-- foot
	bFT.name = (prefix+"_foot"+LR+"BONE");
	boneSetup bFT true mixColor:sideColor;
    bTO = BoneSys.createBone ptBall.pos ptToe.pos vec; 				-- toe
	bTO.name = (prefix+"_toe"+LR+"BONE");
	boneSetup bTO true mixColor:sideColor;

	tipSize = bFT.width;
	pointSize = tipSize*4;
																		-- leg start zeroer
	pST = Point pos:ptLeg.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pST.name = (prefix+"_legStart"+LR+"INT");

    p2 = ptToe.pos;		-- Get a vector from ball to toe
	p1 = ptBall.pos;
    pn = p2 - p1;
	pn = normalize pn;  -- Normalize it

    bTP = BoneSys.createBone ptToe.pos (ptToe.pos + (pn*tipSize)) [1,0,0]; 	-- tip
	bTP.name = (prefix+"_toeTip"+LR+"BONE");
	boneSetup bTP false mixColor:sideColor;
	bTP.width = bTP.height = tipSize;	-- override


																			-- swivel ctrl
	pSWV = createcubeAxisShape();
	pSWV.scale = [pointSize/130.0, pointSize/130.0, pointSize/130.0]
	pSWV.name = (prefix+"_knee"+LR+"CTRL");

		-- Now link them
	bTP.parent = bTO;
	bTO.parent = bFT;
	bFT.parent = bLL;
	bLL.parent = bUL;
	bUL.parent = pST;
	if (objExists(prefix+"_hipIndiCTRL")) then
		(
		hipIndi = execute("$"+prefix+"_hipIndiCTRL");
		pST.parent = hipIndi;
		)
	else if (hipCTRL != undefined) then
		pST.parent = hipCTRL;

		-- set some colors
	pST.wirecolor = internalColor;
	pSWV.wirecolor = sideColor;

		-- Create the IK chain solver/effector's.
	endEf1 = IKSys.ikChain bUL bFT "IKHiSolver";
	endEf1.name = (prefix+"_leg"+LR+"IKEndEffector");
	endEf1.transform.controller.SAParent = 1;   -- set to start not IK goal Parent Space.
    endEf1.rotation = ptAnkle.rotation;
    endEf1.pos = ptAnkle.pos;

	endEf2 = IKSys.ikChain bFT bTO "IKHiSolver";
	endEf2.name = (prefix+"_foot"+LR+"IKEndEffector");
	endEf2.transform.controller.SAParent = 0;
    endEf2.rotation = ptAnkle.rotation;
    endEf2.pos = ptBall.pos;

	endEf3 = IKSys.ikChain bTO bTP "IKHiSolver";
	endEf3.name = (prefix+"_toe"+LR+"IKEndEffector");
	endEf3.transform.controller.SAParent = 0;
    endEf3.rotation = ptAnkle.rotation;
    endEf3.pos = ptToe.pos;

		-- Setup swivel control for knee
	endEf1.transform.controller.VHTarget = pSWV;




		-- Make the foot CTRL curve
	footCTRL = createfootRotatorShape();
	footCTRL.name = (prefix+"_foot"+LR+"CTRL");
	footCTRL.wirecolor = sideColor;
	footCTRL.position.controller = Position_XYZ();
	footCTRL.rotation.controller = Euler_XYZ();
	footCTRL.scale = [ctrlRad, ctrlRad, ctrlRad];


		-- Now set Rotation in case foot is at an angle in TOP view! !!!
    coordsys world footCTRL.rotation = ptAnkle.rotation

    if (LR == "L" or LR == "L2") then
        coordsys local ( rotate footCTRL (eulerangles 0 0 0) );
	else
        coordsys local ( rotate footCTRL (eulerangles 180 0 0) );


	coordsys world (
		footCTRL.position = ptAnkle.pos;
		footCTRL.position.z = ptBall.pos.z;	-- this should be on "ground" level even if foot pivot is raised etc..
		)


    pSWV.position.controller = Position_XYZ();
    pSWV.rotation.controller = Euler_XYZ();
    pSWV.rotation = footCTRL.rotation;
	vec = ptToe.pos - ptAnkle.pos;	-- get nice vector...
	coordsys world ( pSWV.position = ptKnee.pos + [2*vec.x, 2*vec.y , 0] );
	pSWV.parent = footCTRL;
	zeroOut pSWV;



		-- Add CA's to foot
	addFootAttrs(footCTRL);

		-- now make our nice dummies for internal control
	pBL = Point pos:ptBall.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(pointSize*1.5);
	pBL.name = (prefix+"_ballRot"+LR+"INT");
	pBL.wirecolor = internalColor;		-- ball rotator
	pBL.rotation.controller = Euler_XYZ();
    pBL.rotation = footCTRL.rotation;
	pBL.position = ptBall.pos;

	pTO = Point pos:ptBall.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pTO.name = (prefix+"_toeRot"+LR+"INT");
	pTO.wirecolor = internalColor;		-- toe rotator
	pTO.rotation.controller = Euler_XYZ();
    pTO.rotation = footCTRL.rotation;
	pTO.position = ptBall.pos;


	pHE = Point pos:ptAnkle.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pHE.name = (prefix+"_heelRot"+LR+"INT");
	pHE.wirecolor = internalColor;		-- heel master rotator
	pHE.rotation.controller = Euler_XYZ();
    pHE.rotation = footCTRL.rotation;
	pHE.position = ptAnkle.pos;
	pHE.position.z = ptBall.pos.z;	-- this should be on "ground" level even if foot pivot is raised etc..


	pTP = Point pos:ptToe.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pTP.name = (prefix+"_tipRot"+LR+"INT");
	pTP.wirecolor = internalColor;		-- toe tip rotator
	pTP.rotation.controller = Euler_XYZ();
    pTP.rotation = footCTRL.rotation;
	pTP.position = ptToe.pos;


		-- link the dummies and the endEffectors
	endEf1.parent = pBL;
	endEf2.parent = pBL;
	endEf3.parent = pTO;
	pBL.parent = pTP;
	pTO.parent = pTP;
	pTP.parent = pHE;
	pHE.parent = footCTRL;
		-- If the ground ctrl exists, parent foot to it...
	if (objExists(prefix+"_groundCTRL")) then
		(
		execute("$"+prefix+"_foot"+LR+"CTRL.parent = $"+prefix+"_groundCTRL;");
		zeroOut footCTRL;
		)

		-- woohoo!  All we have to do at this point is do a nice reactor stuff on the dummies
    if (EmptyModifier != undefined) then
		(
		rollCnt = footCTRL.Attribute_Holder.roll.controller;
		toeRotateCnt = footCTRL.Attribute_Holder.toeRotate.controller;
		)
	else
		(
		rollCnt = footCTRL.roll.controller;
		toeRotateCnt = footCTRL.toeRotate.controller;
		)

		--
		-- Toe rotator reaction
		--
	cnt = pTO.rotation.X_Rotation.controller = Float_Reactor();
	reactTo cnt toeRotateCnt;
	cnt.reactions.setName 0 "zero";
	cnt.reactions.setValueAsFloat 0 0;	-- when toeRotate is 0...
	cnt.reactions.setFloatState 0 0;	--    xrot is 0.

	toeRotateCnt.value = 180;
	cnt.reactions.create name:"up";
	cnt.reactions.setFloatState 0 (-1.5);	--    xrot is pi/2.

	toeRotateCnt.value = -180;
	cnt.reactions.create name:"down";
	cnt.reactions.setFloatState 0 (1.5);	--    xrot is pi/2.

	toeRotateCnt.value = 0;

		--
		-- Heel rotator reaction
		--
	cnt = pHE.rotation.X_Rotation.controller = Float_Reactor();
	reactTo cnt rollCnt;
	cnt.reactions.setName 0 "zero";
	cnt.reactions.setValueAsFloat 0 0;	-- when roll is 0...
	cnt.reactions.setFloatState 0 0;	--    xrot is 0.

	rollCnt.value = -100;
	cnt.reactions.create name:"up";
	cnt.reactions.setFloatState 0 (-1.15);	--    xrot is about -65 deg

	rollCnt.value = 0;

		--
		-- Ball rotator reaction
		--
	cnt = pBL.rotation.X_Rotation.controller = Float_Reactor();
	reactTo cnt rollCnt;
	cnt.reactions.setName 0 "zero";
	cnt.reactions.setValueAsFloat 0 0;	-- when roll is 0...
	cnt.reactions.setFloatState 0 0;	--    xrot is 0.

	rollCnt.value = 50;
	cnt.reactions.create name:"up";
	cnt.reactions.setFloatState 0 (1.12);	--    xrot is about 65 deg

	rollCnt.value = 0;

		--
		-- ToeTip rotator reaction
		--
	cnt = pTP.rotation.X_Rotation.controller = Float_Reactor();
	reactTo cnt rollCnt;
	cnt.reactions.setName 0 "zero";
	cnt.reactions.setValueAsFloat 0 0;	-- when roll is 0...
	cnt.reactions.setFloatState 0 0;	--    xrot is 0.

	rollCnt.value = 50;
	cnt.reactions.create name:"hold";
	cnt.reactions.setFloatState 0 (0.0);	--    xrot is still 0

	rollCnt.value = 100;
	cnt.reactions.create name:"up";
	cnt.reactions.setFloatState 0 (1.25);	--    xrot is about 70 deg

	rollCnt.value = 0;

		-- Finally if the stretchyLegs options is on do them!
	if (objExists(prefix+"_hipIndiCTRL")) then
		master = (prefix+"_"+"hipIndiCTRL");
	else if (objExists(prefix+"_"+"hipCTRL")) then
		master = (prefix+"_"+"hipCTRL");
	else
		master = pST.name;

	if (stretchyLegs == true) then
		makeStretchyBones bUL bLL bFT endEf1 footCTRL ("$"+footCTRL.name+" $"+master+" ");

    format "-- % Leg created.\n" LR;
    return 1;
)


-- -----------------------------------------------------------------------------------------------


/*
 * createSpineSIK() - Makes spine CTRLS via a lookAt setup that simulates splineIK. It
 *			gives pos/rot control for the bottom and top half independently.
 */
fn createSpineSIK =
(
    if (objExists(prefix+"_"+"hipCTRL") != true) then
		(
		format "-- WARNING: Can't create Spine Controls, Hips don't exist.\n";
		return 0;
		)

		-- make sure global variable is up to date
    hipCTRL = execute("$"+prefix+"_"+"hipCTRL");
	lastSpine = undefined;
	if (objExists(prefix+"_"+"placementCTRL")) then
		placeCTRL = execute("$"+prefix+"_"+"placementCTRL");
	else
	    (
		placeCTRL = undefined;
		)


	sBones = #();	-- the bone's
	sPts = #();		-- the points we used
	boneCnt = 0;	-- no bones yet punk!

		-- Start by making all the bones up.
		--

	if ($ptS1 != undefined) then
		(
	    bS0 = BoneSys.createBone hipCTRL.pos $ptS1.pos [1,0,0];
		bS0.name = (prefix+"_hipBONE");
		bS0.rotation.controller = Euler_XYZ();
		boneSetup bS0 true mixColor:bodyColor;

		-- Don't set a parent for splineIK first bone.

		boneCnt += 1;
		sBones[ boneCnt ] = bS0;
		sPts[ boneCnt ] = $ptS1;


		if ($ptS2 != undefined) then
			(

		    bS1 = BoneSys.createBone $ptS1.pos $ptS2.pos [1,0,0];
			bS1.name = (prefix+"_spine01BONE");
			bS1.rotation.controller = Euler_XYZ();
			boneSetup bS1 true mixColor:((bodyColor*0.8)+(bodyColor2*0.2));
			bS1.parent = bS0;

			boneCnt += 1;
			sBones[ boneCnt ] = bS1;
			sPts[ boneCnt ] = $ptS2;

			if ($ptS3 != undefined) then
				(
			    bS2 = BoneSys.createBone $ptS2.pos $ptS3.pos [1,0,0];
				bS2.name = (prefix+"_spine02BONE");
				bS2.rotation.controller = Euler_XYZ();
				boneSetup bS2 true mixColor:((bodyColor*0.5)+(bodyColor2*0.5));
				bS2.parent = bS1;

				boneCnt += 1;
				sBones[ boneCnt ] = bS2;
				sPts[ boneCnt ] = $ptS3;


				if ($ptS4 != undefined) then
					(
				    bS3 = BoneSys.createBone $ptS3.pos $ptS4.pos [1,0,0];
					bS3.name = (prefix+"_spine03BONE");
					bS3.rotation.controller = Euler_XYZ();
					boneSetup bS3 true mixColor:((bodyColor*0.2)+(bodyColor2*0.8));
					bS3.parent = bS2;

					boneCnt += 1;
					sBones[ boneCnt ] = bS3;
					sPts[ boneCnt ] = $ptS4;

					if ($ptS5 != undefined) then
						(
					    bS4 = BoneSys.createBone $ptS4.pos $ptS5.pos [1,0,0];
						bS4.name = (prefix+"_spine04BONE");
						bS4.rotation.controller = Euler_XYZ();
						boneSetup bS4 true mixColor:((bodyColor*0.15)+(bodyColor2*0.85));
						bS4.parent = bS3;

						boneCnt += 1;
						sBones[ boneCnt ] = bS4;
						sPts[ boneCnt ] = $ptS5;

						if ($ptS6 != undefined) then
							(
						    bS5 = BoneSys.createBone $ptS5.pos $ptS6.pos [1,0,0];
							bS5.name = (prefix+"_spine05BONE");
							bS5.rotation.controller = Euler_XYZ();
							boneSetup bS5 true mixColor:((bodyColor*0.1)+(bodyColor2*0.9));
							bS5.parent = bS4;

							boneCnt += 1;
							sBones[ boneCnt ] = bS5;
							sPts[ boneCnt ] = $ptS6;

							if ($ptS7 != undefined) then
								(
							    bS6 = BoneSys.createBone $ptS6.pos $ptS7.pos [1,0,0];
								bS6.name = (prefix+"_spine06BONE");
								bS6.rotation.controller = Euler_XYZ();
								boneSetup bS6 true mixColor:((bodyColor*0.05)+(bodyColor2*0.95));
								bS6.parent = bS5;

								boneCnt += 1;
								sBones[ boneCnt ] = bS6;
								sPts[ boneCnt ] = $ptS7;


								)

							)

						)

					)

				)

			)

		)


	-- Now make a tip bone
	vec = sPts[boneCnt].pos - sBones[boneCnt].pos;
	spineTip = BoneSys.createBone sPts[boneCnt].pos (sPts[boneCnt].pos+(vec*0.5)) [1,0,0];
	spineTip.name = (prefix+"_spineTipBONE");
	spineTip.rotation.controller = Euler_XYZ();
	boneSetup spineTip false mixColor:(bodyColor2);
	spineTip.parent = sBones[boneCnt];
		-- override boneSetup wh adjust
	spineTip.width = spineTip.height = spineTip.length;

	boneCnt += 1;		-- add spineTip to array of joints
	sBones[ boneCnt ] = spineTip;



	-- At this point we have our stuff made.  We gotta make our controls and zero them out
	--	and set them to be proper rotation order.
	--

 	-- Figure out Radius same as we used on hips.
	r = 0;
    if (objExists("$ptLLeg")) then
		(
		r = $ptLLeg.pos.x - $ptS1.pos.x;
		r = r + (0.55*r);
		r = abs(r);
		)
	else if (objExists("$ptRLeg")) then
		(
		r = $ptRLeg.pos.x - $ptS1.pos.x;
		r = r + (0.55*r);
		r = abs(r);
		)
	if (r <= 0) then
		(
		r = $ptS1.size*1.33;
		)
	r /= 60.0;		-- this is a default 1,1,1 size for rotators..about 60.
	r = r * 0.50;	--	So now we have 0-1.  Make it smaller.

	pointSize = r * 75.0;


		-- Create our pseudo FK bones as well...so that it is easier to animate
		-- the top spine
		--
	cS1 = undefined;
	cS2 = undefined;
	if (sBones.count > 3) then
	    (
		if (sBones.count > 6) then
			(
			idx13 = ((sBones.count / 3.0) as integer);
			idx23 = Idx13 * 2;

			cS1 = Ngon radius:pointSize cornerRadius:0 nsides:6 circular:off scribe:1 pos:sPts[idx13].pos isSelected:on;
			cS1.name = (prefix+"_spine01CTRL");
			cS1.wirecolor = (bodyColor*0.8)+(bodyColor2*0.2);
			cS1.position.controller = Position_XYZ();
			cS1.rotation.controller = Euler_XYZ();
			convertToSplineShape cS1;

			cS1.rotation = sBones[idx13+1].rotation;
			cS1.position = sPts[idx13].position;
			addModifier cS1 (XForm())
			cS1.modifiers[#XForm].gizmo.rotation = (eulerangles 0 90 0);
			collapseStack cS1;

			cS2 = Ngon radius:pointSize cornerRadius:0 nsides:6 circular:off scribe:1 pos:sPts[idx23].pos isSelected:on;
			cs2.name = (prefix+"_spine02CTRL");
			cS2.wirecolor = (bodyColor*0.2)+(bodyColor2*0.8);
			cS2.position.controller = Position_XYZ();
			cS2.rotation.controller = Euler_XYZ();
			convertToSplineShape cS2;

			cS2.rotation = sBones[idx23+1].rotation;
			cS2.position = sPts[idx23].position;
			addModifier cS2 (XForm())
			cS2.modifiers[#XForm].gizmo.rotation = (eulerangles 0 90 0);
			collapseStack cS2;

			cS1.parent = hipCTRL;
			zeroOut cS1;
			cS2.parent = cS1;
			zeroOut cS2;
			)
		else
			(
			midIdx = ((sBones.count / 2.0) as integer);

			cS1 = Ngon radius:pointSize cornerRadius:0 nsides:6 circular:off scribe:1 pos:sPts[midIdx].pos isSelected:on;
			cS1.name = (prefix+"_spine01CTRL");
			cS1.wirecolor = (bodyColor*0.8)+(bodyColor2*0.2);
			cS1.position.controller = Position_XYZ();
			cS1.rotation.controller = Euler_XYZ();
			convertToSplineShape cS1;

			cS1.rotation = sBones[midIdx+1].rotation;
			cS1.position = sPts[midIdx].position;
				-- Now we rotate it via an XForm so that the axis stay the same as the
				--	top/bot controls, but so that the mesh is correct looking.
			addModifier cS1 (XForm());
			cS1.modifiers[#XForm].gizmo.rotation = (eulerangles 0 90 0);
			collapseStack cS1;

			cS1.parent = hipCTRL;
			zeroOut cS1;
			)
		)


	botCTRL = createsimpleRotatorXYZShape();
	botCTRL.wireColor = (bodyColor*0.5)+(bodyColor2*0.5);
	botCTRL.name = (prefix+"_spineBotCTRL");
	botCTRL.scale = [r, r, r];	-- do it uniformly!
	addModifier botCTRL (XForm());		-- effectively do a reset xform
	collapseStack botCTRL;
	botCTRL.position.controller = Position_XYZ();
	botCTRL.rotation.controller = Euler_XYZ();
	botCTRL.rotation = sBones[1].rotation
	botCTRL.pos = sBones[1].pos;
	botCTRL.parent = hipCTRL;
	zeroOut botCTRL;

	topCTRL = createsimpleRotatorXYZShape();
	topCTRL.wireColor = (bodyColor*0.10)+(bodyColor2*0.90);
	topCTRL.name = (prefix+"_spineTopCTRL");
	topCTRL.scale = [r, r, r];	-- do it uniformly!
	addModifier topCTRL (XForm());		-- effectively do a reset xform
	collapseStack topCTRL;
	topCTRL.position.controller = Position_XYZ();
	topCTRL.rotation.controller = Euler_XYZ();
	topCTRL.rotation = sBones[boneCnt].rotation;
	topCTRL.pos = sBones[boneCnt].pos;
	if (cS2 != undefined) then
		topCTRL.parent = cS2;
	else if (cS1 != undefined) then
		topCTRL.parent = cS1;
	else
		topCTRL.parent = hipCTRL;
	zeroOut topCTRL;

	-- Now we create all main helpers we want initially
	sHlp = #();
	sUp = #();

	for i in 2 to boneCnt do
		(
	    pt = Point pos:sBones[i].pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
		pt.name = (prefix+"_spineAimTarget"+((i-1) as string)+"INT");
		pt.wirecolor = internalColor;
		pt.rotation = sBones[i].rotation;
		pt.pos = sBones[i].pos;
		sHlp[i-1] = pt;

	    pt = Point pos:sBones[i].pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
		pt.name = (prefix+"_spineAimUp"+((i-1) as string)+"INT");
		pt.wirecolor = internalColor + (color 20 0 50);
		pt.rotation = sBones[i].rotation;
		pt.pos = sBones[i].pos;
		coordsys local
			(
			move pt [0, -100 * r, 0];		-- move back behind a bit for the up vecs.
			)
		sUp[i-1] = pt;

		)

	-- Now for each bone setup the lookAt target for it
	--
	for i in 1 to (boneCnt-1) do
		(
		aCntl = sBones[i].rotation.controller = LookAt_Constraint();
		aCI = aCntl.constraints;
		aCI.appendTarget sHlp[i] 100;		-- Add target as aim target
		sBones[i].rotation.controller.upnode_world = off	-- turn off world up
		sBones[i].rotation.controller.pickUpNode = sUp[i];	-- Choose up helper
		sBones[i].rotation.controller.upnode_ctrl = 1		-- Make sure Axis Alignment is chosen up mode
		sBones[i].rotation.controller.viewline_length_abs = off	 -- turn off long blue lookAt line
		)

	-- Now we gotta constrain each up dummy that is not the last to some
	-- percentage of the top and bottom controls, so that they follow the proper amt.
	--
	for i in 1 to (boneCnt-2) do
		(
		-- Now do the same for the real helpers
		--
	    pt1 = Point pos:sHlp[i].pos isSelected:on centermarker:off axistripod:off cross:on Box:off constantscreensize:off drawontop:off size:pointSize;
		pt1.name = (prefix+"_spineAimOffsetTop"+(i as string)+"INT");
		pt1.wirecolor = internalColor
		pt1.rotation = sHlp[i].rotation;
		pt1.pos = sHlp[i].pos;

	    pt2 = Point pos:sHlp[i].pos isSelected:on centermarker:off axistripod:off cross:on Box:off constantscreensize:off drawontop:off size:pointSize;
		pt2.name = (prefix+"_spineAimOffsetBot"+(i as string)+"INT");
		pt2.wirecolor = internalColor
		pt2.rotation = sHlp[i].rotation;
		pt2.pos = sHlp[i].pos;


			-- Move each master up or a down a bit in case we want to see them.
			-- Not as much for the real ones tho.
		coordsys local
			(
			move pt1 [2 * r, 0, 0];
			move pt2 [-2 * r, 0, 0];
			)

		rpct = 100.0 * i / (boneCnt - 1);	-- what percentage to the top are we?

		ppct = rpct * 1.3;		-- Make pos constraint a bit more to the top.
		if ppct > 100.0 then
			ppct = 100.0;

	    pCntl = sHlp[i].pos.controller = position_constraint();
		pCI = pCntl.constraints;		-- Get interface to constraints
		pCI.appendTarget pt1 (ppct);
		pCI.appendTarget pt2 (100.0 - ppct);

	    rCntl = sHlp[i].rotation.controller = orientation_constraint();
		rCI = rCntl.constraints;		-- Get interface to constraints
		rCI.appendTarget pt1 (rpct);
		rCI.appendTarget pt2 (100.0 - rpct);
			-- Finally parent each tween helper to the proper commands
			--
		pt1.parent = topCTRL;
		pt2.parent = botCTRL;

		sUp[i].parent = sHlp[i];
		)

		-- Parent the last Up Vec helpers to the proper controls
	sUp[boneCnt-1].parent = sHlp[boneCnt-1];
	sHlp[boneCnt-1].parent = topCTRL;
		-- First bone must also be parented to first bot ctrl
	sBones[1].parent = botCTRL;


		-- Finally we do the stretchy stuff...adding the script expr
		--	starting with the last bone, up to the second.
		--
	if (spineSplineStretch) then
		(
			-- Add custom Attributes to top spine ctrl.
		addSpineAttrs topCTRL;
		if (EmptyModifier != undefined) then
			ah = ".Attribute_Holder";
		else
			ah = "";

		for i in 2 to boneCnt do
			(
			if (i == 2) then
			    start = botCTRL;
			else
			    start = sHlp[i-2]
			end = sHlp[i-1];

				-- Orig distance is the distance between the bone and the helper it
				-- is aiming at.
			origLen = distance start.pos end.pos;
			origPos = sBones[i].parent.length;	-- default script pos X value for bone.

				-- make sure controller type is correct.
				--
			sBones[i].position.controller = Position_XYZ();
			sBones[i].position.x_position.controller = Float_Script();

				-- Make the script
			str = "";
			str += ("-- Stretchy Spine Script for "+sBones[i].name+"\n");
			str += ("-- \n");
			str += ("dependsOn $"+start.name+" $"+end.name+" $"+topCTRL.name+";\n");
			str += ("origLen = "+(origLen as string)+"; -- orig distance\n");
			str += ("origPos = "+(origPos as string)+"; -- default bone pos\n");
			str += ("stretch = $"+(topCTRL.name)+ah+".stretchable;\n");
			str += ("squash = $"+(topCTRL.name)+ah+".squashable;\n");
			str += ("newLen = distance $"+(start.name)+".pos $"+end.name+".pos;\n");
			str += ("if (newLen >= origLen) then \n");
			str += ("    (\n");
			str += ("    newXPos = origPos + (stretch / 100.0 * (newLen - origLen));\n");
			str += ("    )\n");
			str += ("else (\n");
			str += ("    newXPos = origPos + (squash / 100.0 * (newLen - origLen));\n");
			str += ("    )\n");

			sBones[i].position.x_position.controller.script = str;	-- set it!
			)

		)	-- end of spline ik stretchy


	-- Now if we made *front* legs...parent them to the spineTopCTRL...
	--
	pSTL2 = execute("$"+prefix+"_legStartL2INT");
	pSTR2 = execute("$"+prefix+"_legStartR2INT");
	if (lastSpine != undefined and pSTL2 != undefined) then
		pSTL2.parent = lastSpine;
	if (lastSpine != undefined and pSTR2 != undefined) then
		pSTR2.parent = lastSpine;

	-- Now if we made *back* legs...parent them to the spineBotCTRL...
	--
	pSTL = execute("$"+prefix+"_legStartLINT");
	pSTR = execute("$"+prefix+"_legStartRINT");
	if (botCTRL != undefined and pSTL != undefined) then
		pSTL.parent = botCTRL;
	if (botCTRL != undefined and pSTR != undefined) then
		pSTR.parent = botCTRL;

	--	If we did arms already earlier then parent them to the last spine top bone.
	--
	pSTLarm = execute("$"+prefix+"_armStartLINT");
	pSTRarm = execute("$"+prefix+"_armStartRINT");
	if (pSTLarm != undefined) then
		pSTLarm.parent = lastSpine;
	if (pSTRarm != undefined) then
		pSTRarm.parent = lastSpine;

	return 1;
)


-- -----------------------------------------------------------------------------------------------
-- end of spineSIK



/*
 * createSpineIndi() - Makes spine ctrls
 */
fn createSpineIndi =
(
    if (objExists(prefix+"_"+"hipCTRL") != true) then
		(
		format "-- WARNING: Can't create Spine Controls, Hips don't exist.\n";
		return 0;
		)

		-- make sure global variable is up to date
    hipCTRL = execute("$"+prefix+"_"+"hipCTRL");
	lastSpine = undefined;

		-- Figure radius of controls
	if ($ptLLeg != undefined) then
		r = $ptLLeg.pos.x - hipCTRL.pos.x;
	else if ($ptRLeg != undefined) then
		r = $ptRLeg.pos.x - hipCTRL.pos.x;
	else
		r = $ptLLeg.size*2;
	r *= 1.25;

	sPts = #();
	sBones = #();
	sCTRL = #();
	maxSpine = 0;

	if ($ptS1 != undefined) then
		(
		maxSpine += 1;
		sPts[maxSpine] = $ptS1;
		if ($ptS2 != undefined) then
			(
			maxSpine += 1;
			sPts[maxSpine] = $ptS2;
			if ($ptS3 != undefined) then
				(
				maxSpine += 1;
				sPts[maxSpine] = $ptS3;
				if ($ptS4 != undefined) then
					(
					maxSpine += 1;
					sPts[maxSpine] = $ptS4;
					if ($ptS5 != undefined) then
						(
						maxSpine += 1;
						sPts[maxSpine] = $ptS5;
						if ($ptS6 != undefined) then
							(
							maxSpine += 1;
							sPts[maxSpine] = $ptS6;
							if ($ptS7 != undefined) then
								(
								maxSpine += 1;
								sPts[maxSpine] = $ptS7;
								)
							)
						)
					)
				)
			)
		)


		-- Only 1 spine bone?
	if (maxSpine == 1) then
		(
	    bS = BoneSys.createBone hipCTRL.pos sPts[1].pos [1,0,0];
		bS.name = (prefix+"_hipBONE");
		bS.rotation.controller = Euler_XYZ();
		boneSetup bS true mixColor:bodyColor;
		bS.parent = hipCTRL;

		sBones[1] = bS;
		sCTRL[1] = hipCTRL;
		)


		-- Only 2 bones?
	if (maxSpine >= 2) then
		(

			-- Create the indi control
		cIndi = Ngon radius:(r*0.75) cornerRadius:0 nsides:6 circular:off scribe:1 pos:hipCTRL.pos isSelected:on;
		cIndi.name = (prefix+"_hipIndiCTRL");
		cIndi.wirecolor = (bodyColor*0.8)+(bodyColor2*0.2);
		cIndi.position.controller = Position_XYZ();
		cIndi.rotation.controller = Euler_XYZ();
		cIndi.parent = hipCTRL;
		if (maxSpine >= 3) then
			cIndi.pivot = ((sPts[1].pos + sPts[2].pos) / 2.0);
		else
			cIndi.pivot = sPts[1].pos;	-- Move pivot up for nicer animation control
		zeroOut cIndi;



			-- First create bone BACKWARDS for down look
	    bS = BoneSys.createBone sPts[1].pos hipCTRL.pos [1,0,0];
		bS.name = (prefix+"_hipBONE");
		bS.rotation.controller = Euler_XYZ();
		boneSetup bS true mixColor:bodyColor;

		pT1 = Point pos:hipCTRL.pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(0.2*r);
		pT1.name = (prefix+"_targetHipINT");
		pT1.wirecolor = internalColor;
		pT1.parent = cIndi;

		pT1Up = Point pos:sPts[1].pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(0.2*r);
		pT1Up.name = (prefix+"_targetHipUpINT");
		pT1Up.wirecolor = internalColor;
		coordsys local (move pT1Up [0, -20, 0] );
		pT1Up.parent = cIndi;

			-- Now setup the lookAt constraint stuff.
		aCntl = bS.rotation.controller = LookAt_Constraint();
		aCI = aCntl.constraints;
		aCI.appendTarget pT1 100;
		aCntl.upnode_ctrl = 1;	-- set to LookAt or AxisAlign
		aCntl.upnode_world = off;	-- Turn off World up
		aCntl.pickUpNode = pT1Up;	-- Pick up node vector
		aCntl.viewline_length_abs = off;  -- Turn off line
		aCntl.StoUP_axis = 1;	-- Set Y Axis
		aCntl.upnode_axis = 0;	-- Set X Axis

		sBones[1] = bS;
		sCTRL[1] = hipCTRL;

		start = 2;

		if (maxSpine >= 3) then
			(
			cS = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:sPts[1].pos isSelected:on;
			cS.name = (prefix+"_spine01CTRL");
			pct = 2/7.0;
			cS.wirecolor = (bodyColor*(1-pct))+(bodyColor2*(pct));
			cS.position.controller = Position_XYZ();
			cS.rotation.controller = Euler_XYZ();
			convertToSplineShape cS;

				-- First create bone BACKWARDS for down look
			bS = BoneSys.createBone sPts[2].pos sPts[1].pos [1,0,0];
			bS.name = (prefix+"_spine01BONE");
			bS.rotation.controller = Euler_XYZ();
			boneSetup bS true mixColor:bodyColor;

			cS.rotation = bS.rotation;
			coordsys local (rotate cS (eulerangles 0 90 0) );
			cS.position = sPts[1].pos;

			cS.parent = hipCTRL;
			bS.parent = cS;

			pT2 = Point pos:sPts[1].pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(0.2*r);
			pT2.name = (prefix+"_targetSpine1INT");
			pT2.wirecolor = internalColor;
			pT2.parent = cIndi;

			pT2Up = Point pos:sPts[2].pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(0.2*r);
			pT2Up.name = (prefix+"_targetSpine1UpINT");
			pT2Up.wirecolor = internalColor;
			coordsys local (move pT2Up [0, -20, 0] );
			pT2Up.parent = cS;

			pT2UpA = Point pos:sPts[2].pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(0.2*r);
			pT2UpA.name = (prefix+"_targetSpine1UpAINT");
			pT2UpA.wirecolor = internalColor;
			pT2UpA.parent = cS;
			pT2UpA.rotation = cS.rotation;
			pT2UpA.position = sPts[2].pos;
			coordsys local (move pT2UpA [0, -20, -5] );

			pT2UpB = Point pos:sPts[2].pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(0.2*r);
			pT2UpB.name = (prefix+"_targetSpine1UpBINT");
			pT2UpB.wirecolor = internalColor;
			pT2UpB.parent = cIndi;
			pT2UpB.rotation = cS.rotation;
			pT2UpB.position = sPts[2].pos;
			coordsys local (move pT2UpB [0, -20, 5] );

				-- Constrain the Up Node between the A and B targets
			pCntl = pT2Up.rotation.controller = orientation_constraint();
			pCI = pCntl.constraints;
			pCI.appendTarget pT2UpA 60;
			pCI.appendTarget pT2UpB 40;

				-- Now setup the lookAt constraint stuff.
			aCntl = bS.rotation.controller = LookAt_Constraint();
			aCI = aCntl.constraints;
			aCI.appendTarget pT2 100;
			aCntl.upnode_ctrl = 1;	-- set to Axis Align and not LookAt
			aCntl.upnode_world = off;	-- Turn off World up
			aCntl.pickUpNode = pT2Up;	-- Pick up node vector
			aCntl.viewline_length_abs = off;  -- Turn off line
			aCntl.StoUP_axis = 1;	-- Set Y Axis
			aCntl.upnode_axis = 0;	-- Set X Axis

			sBones[2] = bS;
			sCTRL[2] = cS;

			start = 3;

			)

		for i in start to maxSpine do
			(
			cS = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:sPts[i-1].pos isSelected:on;
			cS.name = (prefix+"_spine0"+((i-1) as string)+"CTRL");
			pct = i/7.0;
			cS.wirecolor = (bodyColor*(1-pct))+(bodyColor2*(pct));
			cS.position.controller = Position_XYZ();
			cS.rotation.controller = Euler_XYZ();
			convertToSplineShape cS;

		    bS = BoneSys.createBone sPts[i-1].pos sPts[i].pos [1,0,0];
			bS.name = (prefix+"_spine0"+((i-1) as string)+"BONE");
			bS.rotation.controller = Euler_XYZ();
			boneSetup bS true mixColor:((bodyColor*(1-pct))+(bodyColor2*(pct)));


			pF = Point pos:sPts[i-1].pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
			pF.name = (prefix+"_spine"+(i as string)+"FixINT");
			pF.wirecolor = internalColor;
			cS.rotation = bS.rotation;
			coordsys local (rotate cS (eulerangles 0 90 0) );
			cS.position = sPts[i-1].pos;
			pF.parent = cS;
			bS.parent = pF;
			cS.parent = sCTRL[i-1];
			zeroOut cS;

			sBones[i] = bS;
			sCTRL[i] = cS;

			)

			-- Finally parent the lookAt bones now that controls are made
		sBones[1].parent = sBones[2];
		)


	-- Now make a tip bone just because it looks nicer
	vec = sPts[maxSpine].pos - sCTRL[maxSpine].pos;
	spineTip = BoneSys.createBone sPts[maxSpine].pos (sPts[maxSpine].pos+(vec*0.5)) [1,0,0];
	spineTip.name = (prefix+"_spineTipBONE");
	spineTip.rotation.controller = Euler_XYZ();
	boneSetup spineTip false mixColor:(bodyColor2);
	spineTip.parent = sBones[maxSpine];
		-- override boneSetup wh adjust
	spineTip.width = spineTip.height = spineTip.length;



	-- Now if we made front legs...parent them to the last spine bone control...
	--
	pSTL2 = execute("$"+prefix+"_legStartL2INT");
	pSTR2 = execute("$"+prefix+"_legStartR2INT");
	if (sBones[maxSpine] != undefined and pSTL2 != undefined) then
		pSTL2.parent = sBones[maxSpine];
	if (sBones[maxSpine] != undefined and pSTR2 != undefined) then
		pSTR2.parent = sBones[maxSpine];

	-- Now if we made basic legs...parent them to the INDI control...
	--	since they default to the hip instead...
	pSTL = execute("$"+prefix+"_legStartLINT");
	pSTR = execute("$"+prefix+"_legStartRINT");
	if (sBones[maxSpine] != undefined and pSTL != undefined) then
		pSTL.parent = cIndi;
	if (sBones[maxSpine] != undefined and pSTR != undefined) then
		pSTR.parent = cIndi;


	--	If we did arms already earlier then parent them to the last spine top bone.
	--
	pSTLarm = execute("$"+prefix+"_armStartLINT");
	pSTRarm = execute("$"+prefix+"_armStartRINT");
	if (pSTLarm != undefined) then
		pSTLarm.parent = sBones[maxSpine];
	if (pSTRarm != undefined) then
		pSTRarm.parent = sBones[maxSpine];

	return 1;
)	-- end of create spine


-- ------------------------------------------------------------------------------------------------
-- End of createSpineIndi


/*
 * createSpine() - Makes spine ctrls
 */
fn createSpine =
(
	if (spineIndi == true) then
		(
		format "-- Creating Spine with Independent Hip\n";
		createSpineIndi();		-- if we are doing indi hip, use a different proc
		return();
		)
	else if (spineSplineIK == true) then
        (
		format "-- Creating Spine with SplineIK\n";
		createSpineSIK();		-- if we are doing splineIK, use a different proc
		return();
		)

    if (objExists(prefix+"_"+"hipCTRL") != true) then
		(
		format "-- WARNING: Can't create Spine Controls, Hips don't exist.\n";
		return 0;
		)

		-- make sure global variable is up to date
    hipCTRL = execute("$"+prefix+"_"+"hipCTRL");
	lastSpine = undefined;

		-- Figure radius of controls
	if ($ptLLeg != undefined) then
		r = $ptLLeg.pos.x - hipCTRL.pos.x;
	else if ($ptRLeg != undefined) then
		r = $ptRLeg.pos.x - hipCTRL.pos.x;
	else
		r = $ptLLeg.size*2;
	r *= 1.25;

	if ($ptS1 != undefined) then
		(
	    bS0 = BoneSys.createBone hipCTRL.pos $ptS1.pos [1,0,0];
		bS0.name = (prefix+"_hipBONE");
		bS0.rotation.controller = Euler_XYZ();
		boneSetup bS0 true mixColor:bodyColor;
		bS0.parent = hipCTRL;
		lastSpine = hipCTRL;
		lastPt = $ptS1;
		lastBone = bS0;

		if ($ptS2 != undefined) then
			(
			cS1 = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:$ptS1.pos isSelected:on;
			cS1.name = (prefix+"_spine01CTRL");
			cS1.wirecolor = (bodyColor*0.8)+(bodyColor2*0.2);
			cS1.position.controller = Position_XYZ();
			cS1.rotation.controller = Euler_XYZ();
			convertToSplineShape cS1;

		    bS1 = BoneSys.createBone $ptS1.pos $ptS2.pos [1,0,0];
			bS1.name = (prefix+"_spine01BONE");
			bS1.rotation.controller = Euler_XYZ();
			boneSetup bS1 true mixColor:((bodyColor*0.8)+(bodyColor2*0.2));


			pF = Point pos:$ptS1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
			pF.name = (prefix+"_spine1FixINT");
			pF.wirecolor = internalColor;
			cS1.rotation = bS1.rotation;
			coordsys local (rotate cS1 (eulerangles 0 90 0) );
			cS1.position = $ptS1.pos;
			pF.parent = cS1;
			bS1.parent = pF;
			cS1.parent = hipCTRL;

			zeroOut cS1;
			lastSpine = cS1;
			lastPt = $ptS2;
			lastBone = bS1;


			if ($ptS3 != undefined) then
				(
				cS2 = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:$ptS2.pos isSelected:on;
				cS2.name = (prefix+"_spine02CTRL");
				cS2.wirecolor = (bodyColor*0.5)+(bodyColor2*0.5);
				cS2.position.controller = Position_XYZ();
				cS2.rotation.controller = Euler_XYZ();
				convertToSplineShape cS2;

			    bS2 = BoneSys.createBone $ptS2.pos $ptS3.pos [1,0,0];
				bS2.name = (prefix+"_spine02BONE");
				bS2.rotation.controller = Euler_XYZ();
				boneSetup bS2 true mixColor:((bodyColor*0.5)+(bodyColor2*0.5));

				pF = Point pos:$ptS2.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
				pF.name = (prefix+"_spine2FixINT");
				pF.wirecolor = internalColor;
				cS2.rotation = bS2.rotation;
				coordsys local (rotate cS2 (eulerangles 0 90 0) );
				cS2.position = $ptS2.pos;
				pF.parent = cS2;
				bS2.parent = pF;
				cS2.parent = cS1;

				zeroOut cS2;
				lastSpine = cS2;
				lastPt = $ptS3;
				lastBone = bS2;


				if ($ptS4 != undefined) then
					(
					cS3 = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:$ptS3.pos isSelected:on;
					cS3.name = (prefix+"_spine03CTRL");
					cS3.wirecolor = (bodyColor*0.2)+(bodyColor2*0.8);
					cS3.position.controller = Position_XYZ();
					cS3.rotation.controller = Euler_XYZ();
					convertToSplineShape cS3;

				    bS3 = BoneSys.createBone $ptS3.pos $ptS4.pos [1,0,0];
					bS3.name = (prefix+"_spine03BONE");
					bS3.rotation.controller = Euler_XYZ();
					boneSetup bS3 true mixColor:((bodyColor*0.2)+(bodyColor2*0.8));

					pF = Point pos:$ptS3.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
					pF.name = (prefix+"_spine3FixINT");
					pF.wirecolor = internalColor;
					cS3.rotation = bS3.rotation;
					coordsys local (rotate cS3 (eulerangles 0 90 0) );
					cS3.position = $ptS3.pos;
					pF.parent = cS3;
					bS3.parent = pF;
					cS3.parent = cS2;

					zeroOut cS3;
					lastSpine = cS3;
					lastPt = $ptS4;
					lastBone = bS3;

					if ($ptS5 != undefined) then
						(
						cS4 = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:$ptS4.pos isSelected:on;
						cS4.name = (prefix+"_spine04CTRL");
						cS4.wirecolor = (bodyColor*0.15)+(bodyColor2*0.85);
						cS4.position.controller = Position_XYZ();
						cS4.rotation.controller = Euler_XYZ();
						convertToSplineShape cS4;

					    bS4 = BoneSys.createBone $ptS4.pos $ptS5.pos [1,0,0];
						bS4.name = (prefix+"_spine04BONE");
						bS4.rotation.controller = Euler_XYZ();
						boneSetup bS4 true mixColor:((bodyColor*0.15)+(bodyColor2*0.85));

						pF = Point pos:$ptS4.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
						pF.name = (prefix+"_spine4FixINT");
						pF.wirecolor = internalColor;
						cS4.rotation = bS4.rotation;
						coordsys local (rotate cS4 (eulerangles 0 90 0) );
						cS4.position = $ptS4.pos;
						pF.parent = cS4;
						bS4.parent = pF;
						cS4.parent = cS3;

						zeroOut cS4;
						lastSpine = cS4;
						lastPt = $ptS5;
						lastBone = bS4;

						if ($ptS6 != undefined) then
							(
							cS5 = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:$ptS5.pos isSelected:on;
							cS5.name = (prefix+"_spine05CTRL");
							cS5.wirecolor = (bodyColor*0.1)+(bodyColor2*0.9);
							cS5.position.controller = Position_XYZ();
							cS5.rotation.controller = Euler_XYZ();
							convertToSplineShape cS5;

						    bS5 = BoneSys.createBone $ptS5.pos $ptS6.pos [1,0,0];
							bS5.name = (prefix+"_spine05BONE");
							bS5.rotation.controller = Euler_XYZ();
							boneSetup bS5 true mixColor:((bodyColor*0.1)+(bodyColor2*0.9));

							pF = Point pos:$ptS5.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
							pF.name = (prefix+"_spine5FixINT");
							pF.wirecolor = internalColor;
							cS5.rotation = bS5.rotation;
							coordsys local (rotate cS5 (eulerangles 0 90 0) );
							cS5.position = $ptS5.pos;
							pF.parent = cS5;
							bS5.parent = pF;
							cS5.parent = cS4;

							zeroOut cS5;
							lastSpine = cS5;
							lastPt = $ptS6;
							lastBone = bS5;

							if ($ptS7 != undefined) then
								(
								cS6 = Ngon radius:r cornerRadius:0 nsides:6 circular:off scribe:1 pos:$ptS6.pos isSelected:on;
								cS6.name = (prefix+"_spine05CTRL");
								cS6.wirecolor = (bodyColor*0.05)+(bodyColor2*0.95);
								cS6.position.controller = Position_XYZ();
								cS6.rotation.controller = Euler_XYZ();
								convertToSplineShape cS6;

							    bS6 = BoneSys.createBone $ptS6.pos $ptS7.pos [1,0,0];
								bS6.name = (prefix+"_spine06BONE");
								bS6.rotation.controller = Euler_XYZ();
								boneSetup bS6 true mixColor:((bodyColor*0.05)+(bodyColor2*0.95));

								pF = Point pos:$ptS6.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*r);
								pF.name = (prefix+"_spine6FixINT");
								pF.wirecolor = internalColor;
								cS6.rotation = bS6.rotation;
								coordsys local (rotate cS6 (eulerangles 0 90 0) );
								cS6.position = $ptS6.pos;
								pF.parent = cS6;
								bS6.parent = pF;
								cS6.parent = cS5;

								zeroOut cS6;
								lastSpine = cS6;
								lastPt = $ptS7;
								lastBone = bS6;
								)

							)

						)

					)

				)

			)

		)


	-- Now make a tip bone just because it looks nice
	vec = lastPt.pos - lastSpine.pos;
	spineTip = BoneSys.createBone lastPt.pos (lastPt.pos+(vec*0.5)) [1,0,0];
	spineTip.name = (prefix+"_spineTipBONE");
	spineTip.rotation.controller = Euler_XYZ();
	boneSetup spineTip false mixColor:(bodyColor2);
	spineTip.parent = lastBone;
		-- override boneSetup wh adjust
	spineTip.width = spineTip.height = spineTip.length;



	-- Now if we made front legs...parent them to the last spine bone control...
	--
	pSTL2 = execute("$"+prefix+"_legStartL2INT");
	pSTR2 = execute("$"+prefix+"_legStartR2INT");
	if (lastSpine != undefined and pSTL2 != undefined) then
		pSTL2.parent = lastSpine;
	if (lastSpine != undefined and pSTR2 != undefined) then
		pSTR2.parent = lastSpine;


	--	If we did arms already earlier then parent them to the last spine top bone.
	--
	pSTLarm = execute("$"+prefix+"_armStartLINT");
	pSTRarm = execute("$"+prefix+"_armStartRINT");
	if (pSTLarm != undefined) then
		pSTLarm.parent = lastBone;
	if (pSTRarm != undefined) then
		pSTRarm.parent = lastBone;

	return 1;
)	-- end of create spine


-- -----------------------------------------------------------------------------------------------


/*
 * createHead() - Makes the neck and head ctrls
 */
fn createHead =
(
    if (objExists(prefix+"_headCTRL")) then
		(
		format "-- WARNING: Head and Neck already created.\n";
		return 0;
		)

    if (objExists("$ptHead") != true) then
		(
		format "-- WARNING: Can't create Head and Neck Controls, ptHead doesn't exist.\n";
		return 0;
		)
    if (objExists("$ptHeadTop") != true) then
		(
		format "-- WARNING: Can't create Head and Neck Controls, ptHeadTop doesn't exist.\n";
		return 0;
		)

		-- figure out where the internal dummy starts at
	if ($ptNeck1 != undefined) then   -- either there is a 1st neck or no necks
		posST = $ptNeck1.pos;
	else
		posST = $ptHead.pos;

	cNeck1 = cNeck2 = undefined;

	tipSize = 0.17 * (length($ptHeadTop.pos - $ptHead.pos));
	pointSize = tipSize*4;

		-- Make the starting internal neck/head dummys
	pST = Point pos:posST isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pST.name = (prefix+"_headStartINT");
	pST.wirecolor = internalColor;

		-- figure out what will be parent
	if (objExists("$"+prefix+"_spine07BONE")) then
		parST = execute("$"+prefix+"_spine07BONE");
	else if (objExists("$"+prefix+"_spine06BONE")) then
		parST = execute("$"+prefix+"_spine06BONE");
	else if (objExists("$"+prefix+"_spine05BONE")) then
		parST = execute("$"+prefix+"_spine05BONE");
	else if (objExists("$"+prefix+"_spine04BONE")) then
		parST = execute("$"+prefix+"_spine04BONE");
	else if (objExists("$"+prefix+"_spine03BONE")) then
		parST = execute("$"+prefix+"_spine03BONE");
	else if (objExists("$"+prefix+"_spine02BONE")) then
		parST = execute("$"+prefix+"_spine02BONE");
	else if (objExists("$"+prefix+"_spine01BONE")) then
		parST = execute("$"+prefix+"_spine01BONE");
	else if (objExists("$"+prefix+"_hipBONE")) then
		parST = execute("$"+prefix+"_hipBONE");
	else if (objExists("$"+prefix+"_hipCTRL")) then
		parST = execute("$"+prefix+"_hipCTRL");
	else
		parST = undefined;

		-- set parent
	if (parST != undefined) then
		pST.parent = parST;


		-- Figure radius for controls
	r = $ptHeadTop.pos.z - $ptHead.pos.z;


		-- At this point everything gets built onto the pPC node...
		-- So we just make our neck and head bones and ctrls now...
	cHead = Ngon radius:(r*1.2) cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptHead.pos isSelected:on;
	cHead.name = (prefix+"_headCTRL");
	cHead.wirecolor = headColor;
	cHead.position.controller = Position_XYZ();
	cHead.rotation.controller = Euler_XYZ();
	convertToSplineShape cHead;

    bHead = BoneSys.createBone $ptHead.pos $ptHeadTop.pos [1,0,0];
	bHead.name = (prefix+"_headBONE");
	bHead.rotation.controller = Euler_XYZ();
	boneSetup bHead true mixColor:headColor;
		-- Override head fin size for a little bit larger for head...
	bHead.sidefinssize = r*0.6;
	bHead.frontfinsize = r*0.6;
	bHead.backfinsize = r*0.6;

    bHeadTip = BoneSys.createBone $ptHeadTop.pos ($ptHeadTop.pos+[0,0,tipSize]) [1,0,0];
	bHeadTip.name = (prefix+"_headTipBONE");
	boneSetup bHeadTip false mixColor:headColor;
		-- override stuff for tip bone...
	bHeadTip.width = bHeadTip.height = tipSize;	-- override

	cHead.rotation = bHead.rotation;
	coordsys local (rotate cHead (eulerangles 0 90 0) );
	cHead.position = $ptHead.pos;
	bHead.parent = cHead;
	bHeadTip.parent = bHead;

    lastNeck = pST;
	lastBone = pST;

	if ($ptNeck1 != undefined) then
		(
		cNeck1 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck1.pos isSelected:on;
		cNeck1.name = (prefix+"_neck1CTRL");
		cNeck1.wirecolor = (headColor*0.2)+(bodyColor2*0.8);
		cNeck1.position.controller = Position_XYZ();
		cNeck1.rotation.controller = Euler_XYZ();
		convertToSplineShape cNeck1;

		if ($ptNeck2 != undefined) then
			p2 = $ptNeck2.pos;
		else
			p2 = $ptHead.pos;


		pF = Point pos:$ptNeck1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
		pF.name = (prefix+"_neck1FixINT");
		pF.wirecolor = internalColor;

	    bNeck1 = BoneSys.createBone $ptNeck1.pos p2 [1,0,0];
		bNeck1.name = (prefix+"_neck1BONE");
		bNeck1.rotation.controller = Euler_XYZ();
		boneSetup bNeck1 true mixColor:((headColor*0.2)+(bodyColor2*0.8));

		cNeck1.rotation = bNeck1.rotation;
		coordsys local (rotate cNeck1 (eulerangles 0 90 0) );
		cNeck1.position = $ptNeck1.pos;
		pF.parent = cNeck1;
		bNeck1.parent = pF;
		cNeck1.parent = pST;
		zeroOut cNeck1;
	    lastNeck = cNeck1;
		lastBone = bNeck1;


		if ($ptNeck2 != undefined) then
			(
			cNeck2 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck2.pos isSelected:on;
			cNeck2.name = (prefix+"_neck2CTRL");
			cNeck2.wirecolor = (headColor*0.3)+(bodyColor2*0.7);
			cNeck2.position.controller = Position_XYZ();
			cNeck2.rotation.controller = Euler_XYZ();
			convertToSplineShape cNeck2;

			if ($ptNeck3 != undefined) then
				p2 = $ptNeck3.pos;
			else
				p2 = $ptHead.pos;

			pF = Point pos:$ptNeck2.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
			pF.name = (prefix+"_neck2FixINT");
			pF.wirecolor = internalColor;

		    bNeck2 = BoneSys.createBone $ptNeck2.pos p2 [1,0,0];
			bNeck2.name = (prefix+"_neck2BONE");
			bNeck2.rotation.controller = Euler_XYZ();
			boneSetup bNeck2 true mixColor:((headColor*0.3)+(bodyColor2*0.7));

			cNeck2.rotation = bNeck2.rotation;
			coordsys local (rotate cNeck2 (eulerangles 0 90 0) );
			cNeck2.position = $ptNeck2.pos;
			pF.parent = cNeck2;
			bNeck2.parent = pF;
			cNeck2.parent = cNeck1;
			zeroOut cNeck2;
		    lastNeck = cNeck2;
			lastBone = bNeck2;

			if ($ptNeck3 != undefined) then
				(
				cNeck3 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck3.pos isSelected:on;
				cNeck3.name = (prefix+"_neck3CTRL");
				cNeck3.wirecolor = (headColor*0.4)+(bodyColor2*0.6);
				cNeck3.position.controller = Position_XYZ();
				cNeck3.rotation.controller = Euler_XYZ();
				convertToSplineShape cNeck3;

				if ($ptNeck4 != undefined) then
					p2 = $ptNeck4.pos;
				else
					p2 = $ptHead.pos;

				pF = Point pos:$ptNeck3.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
				pF.name = (prefix+"_neck3FixINT");
				pF.wirecolor = internalColor;

			    bNeck3 = BoneSys.createBone $ptNeck3.pos p2 [1,0,0];
				bNeck3.name = (prefix+"_neck3BONE");
				bNeck3.rotation.controller = Euler_XYZ();
				boneSetup bNeck3 true mixColor:((headColor*0.4)+(bodyColor2*0.6));

				cNeck3.rotation = bNeck3.rotation;
				coordsys local (rotate cNeck3 (eulerangles 0 90 0) );
				cNeck3.position = $ptNeck3.pos;
				pF.parent = cNeck3;
				bNeck3.parent = pF;
				cNeck3.parent = cNeck2;
				zeroOut cNeck3;
			    lastNeck = cNeck3;
				lastBone = bNeck3;

				if ($ptNeck4 != undefined) then
					(
					cNeck4 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck4.pos isSelected:on;
					cNeck4.name = (prefix+"_neck4CTRL");
					cNeck4.wirecolor = (headColor*0.5)+(bodyColor2*0.5);
					cNeck4.position.controller = Position_XYZ();
					cNeck4.rotation.controller = Euler_XYZ();
					convertToSplineShape cNeck4;

					if ($ptNeck5 != undefined) then
						p2 = $ptNeck5.pos;
					else
						p2 = $ptHead.pos;

					pF = Point pos:$ptNeck4.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
					pF.name = (prefix+"_neck4FixINT");
					pF.wirecolor = internalColor;

				    bNeck4 = BoneSys.createBone $ptNeck4.pos p2 [1,0,0];
					bNeck4.name = (prefix+"_neck4BONE");
					bNeck4.rotation.controller = Euler_XYZ();
					boneSetup bNeck4 true mixColor:((headColor*0.5)+(bodyColor2*0.5));

					cNeck4.rotation = bNeck4.rotation;
					coordsys local (rotate cNeck4 (eulerangles 0 90 0) );
					cNeck4.position = $ptNeck4.pos;
					pF.parent = cNeck4;
					bNeck4.parent = pF;
					cNeck4.parent = cNeck3;
					zeroOut cNeck4;
				    lastNeck = cNeck4;
					lastBone = bNeck4;

					if ($ptNeck5 != undefined) then
						(
						cNeck5 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck5.pos isSelected:on;
						cNeck5.name = (prefix+"_neck5CTRL");
						cNeck5.wirecolor = (headColor*0.6)+(bodyColor2*0.4);
						cNeck5.position.controller = Position_XYZ();
						cNeck5.rotation.controller = Euler_XYZ();
						convertToSplineShape cNeck5;

						if ($ptNeck6 != undefined) then
							p2 = $ptNeck6.pos;
						else
							p2 = $ptHead.pos;

						pF = Point pos:$ptNeck5.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
						pF.name = (prefix+"_neck5FixINT");
						pF.wirecolor = internalColor;

					    bNeck5 = BoneSys.createBone $ptNeck5.pos p2 [1,0,0];
						bNeck5.name = (prefix+"_neck5BONE");
						bNeck5.rotation.controller = Euler_XYZ();
						boneSetup bNeck5 true mixColor:((headColor*0.6)+(bodyColor2*0.5));

						cNeck5.rotation = bNeck5.rotation;
						coordsys local (rotate cNeck5 (eulerangles 0 90 0) );
						cNeck5.position = $ptNeck5.pos;
						pF.parent = cNeck5;
						bNeck5.parent = pF;
						cNeck5.parent = cNeck4;
						zeroOut cNeck5;
					    lastNeck = cNeck5;
					    lastBone = bNeck5;

						if ($ptNeck6 != undefined) then
							(
							cNeck6 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck6.pos isSelected:on;
							cNeck6.name = (prefix+"_neck6CTRL");
							cNeck6.wirecolor = (headColor*0.7)+(bodyColor2*0.3);
							cNeck6.position.controller = Position_XYZ();
							cNeck6.rotation.controller = Euler_XYZ();
							convertToSplineShape cNeck6;

							if ($ptNeck7 != undefined) then
								p2 = $ptNeck7.pos;
							else
								p2 = $ptHead.pos;

							pF = Point pos:$ptNeck6.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
							pF.name = (prefix+"_neck6FixINT");
							pF.wirecolor = internalColor;

						    bNeck6 = BoneSys.createBone $ptNeck6.pos p2 [1,0,0];
							bNeck6.name = (prefix+"_neck6BONE");
							bNeck6.rotation.controller = Euler_XYZ();
							boneSetup bNeck6 true mixColor:((headColor*0.7)+(bodyColor2*0.3));

							cNeck6.rotation = bNeck6.rotation;
							coordsys local (rotate cNeck6 (eulerangles 0 90 0) );
							cNeck6.position = $ptNeck6.pos;
							pF.parent = cNeck6;
							bNeck6.parent = pF;
							cNeck6.parent = cNeck5;
							zeroOut cNeck6;
						    lastNeck = cNeck6;
						    lastBone = bNeck6;

							if ($ptNeck7 != undefined) then
								(
								cNeck7 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck7.pos isSelected:on;
								cNeck7.name = (prefix+"_neck7CTRL");
								cNeck7.wirecolor = (headColor*0.8)+(bodyColor2*0.2);
								cNeck7.position.controller = Position_XYZ();
								cNeck7.rotation.controller = Euler_XYZ();
								convertToSplineShape cNeck7;

								if ($ptNeck8 != undefined) then
									p2 = $ptNeck8.pos;
								else
									p2 = $ptHead.pos;

								pF = Point pos:$ptNeck7.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
								pF.name = (prefix+"_neck7FixINT");
								pF.wirecolor = internalColor;

							    bNeck7 = BoneSys.createBone $ptNeck7.pos p2 [1,0,0];
								bNeck7.name = (prefix+"_neck7BONE");
								bNeck7.rotation.controller = Euler_XYZ();
								boneSetup bNeck7 true mixColor:((headColor*0.8)+(bodyColor2*0.2));

								cNeck7.rotation = bNeck7.rotation;
								coordsys local (rotate cNeck7 (eulerangles 0 90 0) );
								cNeck7.position = $ptNeck7.pos;
								pF.parent = cNeck7;
								bNeck7.parent = pF;
								cNeck7.parent = cNeck6;
								zeroOut cNeck7;
							    lastNeck = cNeck7;
							    lastBone = bNeck7;

								if ($ptNeck8 != undefined) then
									(
									cNeck8 = Ngon radius:r cornerRadius:0 nsides:8 circular:off scribe:1 pos:$ptNeck8.pos isSelected:on;
									cNeck8.name = (prefix+"_neck8CTRL");
									cNeck8.wirecolor = (headColor*0.9)+(bodyColor2*0.1);
									cNeck8.position.controller = Position_XYZ();
									cNeck8.rotation.controller = Euler_XYZ();
									convertToSplineShape cNeck8;

									p2 = $ptHead.pos;

									pF = Point pos:$ptNeck8.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
									pF.name = (prefix+"_neck8FixINT");
									pF.wirecolor = internalColor;

								    bNeck8 = BoneSys.createBone $ptNeck8.pos p2 [1,0,0];
									bNeck8.name = (prefix+"_neck7BONE");
									bNeck8.rotation.controller = Euler_XYZ();
									boneSetup bNeck8 true mixColor:((headColor*0.9)+(bodyColor2*0.1));

									cNeck8.rotation = bNeck8.rotation;
									coordsys local (rotate cNeck8 (eulerangles 0 90 0) );
									cNeck8.position = $ptNeck8.pos;
									pF.parent = cNeck8;
									bNeck8.parent = pF;
									cNeck8.parent = cNeck7;
									zeroOut cNeck8;
								    lastNeck = cNeck8;
								    lastBone = bNeck8;

									)

								)

							)

						)

					)

				)

			)

		)

	if (p2 != undefined) then	-- assuming we made neck bones...
		(
		-- make a tip bone
		vec = (p2 - lastBone.pos);
		normalize vec;
		bNTip = BoneSys.createBone p2 (p2+(vec*tipSize*0.05)) [1,0,0];
		bNTip.name = (prefix+"_neckTipBONE");
		bNTip.rotation.controller = Euler_XYZ();
		boneSetup bNTip true mixColor:(headColor);
		bNTip.parent = lastBone;
		)
	else			-- if just head, fake tip as the start point we did.
		bNTip = pST;

	pPC = Point pos:(bNTip.pos) isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
	pPC.name = (prefix+"_headConstraintINT");
	pPC.wirecolor = internalColor;

		-- Now constrain the pPC head node to the pST node which is parented.
		-- For independent heads, we truly do a POS constraint
		--	otherwise, we'll just parent it...
	if (headIndep) then
		(
		pCntl = pPC.pos.controller = position_constraint();
		pCI = pCntl.constraints;
		pCI.appendTarget bNTip 50;
		)
	else (
		pPC.parent = bNTip;
		)

    cHead.parent = pPC;
	zeroOut cHead;

	format "-- Head and Neck created.\n";
    return 1;
)


-- -----------------------------------------------------------------------------------------------


/*
 * createArm() - Makes a R or L arm setup
 */
fn createArm LR =
(
    if (objExists("$pt"+LR+"Clav") != true) then
		(
		format "-- WARNING: Can't create % Arm.  \"pt%Clav\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"UpArm") != true) then
		(
		format "-- WARNING: Can't create % Arm.  \"pt%UpArm\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"LoArm") != true) then
		(
		format "-- WARNING: Can't create % Arm.  \"pt%LoArm\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"Hand") != true) then
		(
		format "-- WARNING: Can't create % Arm.  \"pt%Hand\" does not exist.\n" LR LR;
		return 0;
		)
    if (objExists("$pt"+LR+"HandTip") != true) then
		(
		format "-- WARNING: Can't create % Arm.  \"pt%HandTip\" does not exist.\n" LR LR;
		return 0;
		)

   if (objExists(prefix+"_hand"+LR+"CTRL")) then
		(
		format "-- % Arm already created.\n" LR;
		return 0;
		)

		-- Setup variables for the proper side
	if (LR == "L") then
		(
		ptClav = $ptLClav;
		ptUpArm = $ptLUpArm;
		ptLoArm = $ptLLoArm;
		ptHand = $ptLHand;
		ptHandTip = $ptLHandTip;
		neg = 1;
		sideColor = leftColor;
		)
	else (
		ptClav = $ptRClav;
		ptUpArm = $ptRUpArm;
		ptLoArm = $ptRLoArm;
		ptHand = $ptRHand;
		ptHandTip = $ptRHandTip;
		neg = -1;
		sideColor = rightColor;
		)

		-- Figure out sizes and pos for stuff
	swvDist = 2.0 * length(ptUpArm.pos - ptLoArm.pos);
	ctrlRad = 0.8 * length(ptHand.pos - ptHandTip.pos) / 35.0;

	tipSize = 0.17 * (length(ptHand.pos - ptLoArm.pos));
	pointSize = tipSize*4;

		-- get placement if it exists
	place = execute("$"+prefix+"_"+"placementCTRL");
	hipCTRL = execute("$"+prefix+"_hipCTRL;");

		-- Make the starting internal neck/head dummys
	pST = Point pos:ptClav.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pST.name = (prefix+"_armStart"+LR+"INT");
	pST.wirecolor = internalColor;

		-- Make a child start, for "tweening" so that the axis of the clav are right.
	pTW = Point pos:ptClav.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(pointSize*0.5);
	pTW.name = (prefix+"_armStartTween"+LR+"INT");
	pTW.wirecolor = internalColor;

	-- Make my bones baby!
    bCL = BoneSys.createBone ptClav.pos ptUpArm.pos [0,0,1]; 			-- clav shoulder bone
	bCL.name = (prefix+"_clav"+LR+"BONE");
	boneSetup bCL true mixColor:sideColor;
    bUA = BoneSys.createBone ptUpArm.pos ptLoArm.pos [0,0,1]; 			-- upper arm bone
	bUA.name = (prefix+"_upArm"+LR+"BONE");
	boneSetup bUA true mixColor:sideColor;
    bLA = BoneSys.createBone ptLoArm.pos ptHand.pos [0,0,1]; 			-- lower arm bone
	bLA.name = (prefix+"_loArm"+LR+"BONE");
	boneSetup bLA true mixColor:sideColor;
		-- override
	bLA.sidefins = bLA.frontfin = bLA.backfin = false;	-- override
	bLA.width = bLA.height = (tipSize/3);	-- make real lo bone small here since only used for IK
	bLA.wirecolor = internalColor;

	-- Make wrist twist bones
	laDir = (ptHand.pos - ptLoArm.pos) / 4.0;
	laStart = ptLoArm.pos;
	laEnd = laStart + laDir;
	bLA1 = BoneSys.createBone laStart laEnd [0,0,1];
	bLA1.name = (prefix+"_loArmTwist1"+LR+"BONE");
	boneSetup bLA1 true mixColor:sideColor;
	laStart = laEnd;
	laEnd = laStart + laDir;
	bLA2 = BoneSys.createBone laStart laEnd [0,0,1];
	bLA2.name = (prefix+"_loArmTwist2"+LR+"BONE");
	boneSetup bLA2 true mixColor:sideColor;
	laStart = laEnd;
	laEnd = laStart + laDir;
	bLA3 = BoneSys.createBone laStart laEnd [0,0,1];
	bLA3.name = (prefix+"_loArmTwist3"+LR+"BONE");
	boneSetup bLA3 true mixColor:sideColor;
	laStart = laEnd;
	laEnd = ptHand.pos;
	bLA4 = BoneSys.createBone laStart laEnd [0,0,1];
	bLA4.name = (prefix+"_loArmTwist4"+LR+"BONE");
	boneSetup bLA4 true mixColor:sideColor;
	-- Set finsize back to proper since they're shorter...
	bLA1.sidefinssize = bLA2.sidefinssize = bLA3.sidefinssize = bLA4.sidefinssize*= 3;
	bLA1.frontfinsize = bLA2.frontfinsize = bLA3.frontfinsize = bLA4.frontfinsize*= 3;
	bLA1.backfinsize = bLA2.backfinsize = bLA3.backfinsize = bLA4.backfinsize *= 3;
/*
	bLA1.wirecolor = (bUA.wirecolor*0.8)+(sideColor*0.2);
	bLA2.wirecolor = (bUA.wirecolor*0.7)+(sideColor*0.3);
	bLA3.wirecolor = (bUA.wirecolor*0.6)+(sideColor*0.4);
	bLA4.wirecolor = (bUA.wirecolor*0.5)+(sideColor*0.5);
*/

    bTP = BoneSys.createBone ptHand.pos (ptHand.pos+[neg*(tipSize/4),0,0]) [0,0,1];	-- lower arm tip bone
	bTP.name = (prefix+"_loArmTip"+LR+"BONE");
	boneSetup bTP false mixColor:sideColor;
		-- Override for tip
	bTP.width = bTP.height = tipSize/4;

    bHD = BoneSys.createBone ptHand.pos ptHandTip.pos [0,0,1]; 			-- hand bone
	bHD.name = (prefix+"_hand"+LR+"BONE");
	boneSetup bHD true mixColor:sideColor;
    bHT = BoneSys.createBone ptHandTip.pos (ptHandTip.pos+[neg*(tipSize/4),0,0]) [0,0,1]; 	-- hand tip bone
	bHT.name = (prefix+"_handTip"+LR+"BONE");
	boneSetup bHT false mixColor:sideColor;
		-- Override for Hand tip
	bHT.width = bHT.height = tipSize/4;	 -- special make a bit smaller
																			-- swivel ctrl
	pSWV = createcubeAxisShape();
	pSWV.scale = [pointSize/180.0, pointSize/180.0, pointSize/180.0]
	pSWV.pos = (ptLoArm.pos+[0,swvDist,0]);
	pSWV.name = (prefix+"_elbow"+LR+"CTRL");

		-- Make the hand Ctrl
	cHand = createsimpleRotatorShape();
	cHand.name = (prefix+"_hand"+LR+"CTRL");
	cHand.rotation = bHD.rotation;
	cHand.position = ptHand.pos;
	cHand.scale = [ctrlRad, ctrlRad, ctrlRad]

		-- Make Clav Ctrl
	cClav = Rectangle length:pointSize width:pointSize cornerRadius:0 pos:ptClav.pos transform:(matrix3 [0,1,0] [0,0,1] [1,0,0] [0,0,0]) isSelected:on;
	cClav.name = (prefix+"_shoulder"+LR+"CTRL");

		-- Make Pseudo-FK controls
	cUpArm = createtaperedRectangleShape();
	cUpArm.name = (prefix+"_upArm"+LR+"CTRL");
	cUpArm.rotation = bUA.rotation;
	cUpArm.position = bUA.position;
	cUpArm.scale = [ctrlRad, ctrlRad, ctrlRad]

	cLoArm = createtaperedRectangleShape();
	cLoArm.name = (prefix+"_loArm"+LR+"CTRL");
	cLoArm.rotation = bLA.rotation;
	cLoArm.position = bLA.position;
	cLoArm.scale = [ctrlRad, ctrlRad, ctrlRad]


		-- Setup Tween rotation to match first real child...so we zero stuff.
	pST.rotation = bUA.rotation;
	pST.position = ptClav.pos;
	pTW.rotation = bUA.rotation;
	pTW.position = ptClav.pos;

		-- Now link them
	pTW.parent = pST;
	bCL.parent = pTW;
	bUA.parent = bCL;
	bLA.parent = bUA;
	bTP.parent = bLA;
	bHD.parent = place;
	bHT.parent = bHD;

	if (objExists("$"+prefix+"_spine07BONE")) then
		parST = execute("$"+prefix+"_spine07BONE");
	else if (objExists("$"+prefix+"_spine06BONE")) then
		parST = execute("$"+prefix+"_spine06BONE");
	else if (objExists("$"+prefix+"_spine05BONE")) then
		parST = execute("$"+prefix+"_spine05BONE");
	else if (objExists("$"+prefix+"_spine04BONE")) then
		parST = execute("$"+prefix+"_spine04BONE");
	else if (objExists("$"+prefix+"_spine03BONE")) then
		parST = execute("$"+prefix+"_spine03BONE");
	else if (objExists("$"+prefix+"_spine02BONE")) then
		parST = execute("$"+prefix+"_spine02BONE");
	else if (objExists("$"+prefix+"_spine01BONE")) then
		parST = execute("$"+prefix+"_spine01BONE");
	else if (objExists("$"+prefix+"_hipBONE")) then
		parST = execute("$"+prefix+"_hipBONE");
	else
		parST = undefined;
	pST.parent = parST;

		-- set some colors
	pSWV.wirecolor = sideColor;
	cHand.wirecolor = sideColor;
	cClav.wirecolor = sideColor;
	cUpArm.wirecolor = sideColor;
	cLoArm.wirecolor = sideColor;

		-- Nice controller types...
    cHand.position.controller = Position_XYZ();
    cHand.rotation.controller = Euler_XYZ();
	cUpArm.rotation.controller.axisOrder = 6;	-- ZYX order
    cClav.position.controller = Position_XYZ();
    cClav.rotation.controller = Euler_XYZ();
    pSWV.position.controller = Position_XYZ();
    bCL.position.controller = Position_XYZ();
    bLA1.rotation.controller = Euler_XYZ();
    bLA2.rotation.controller = Euler_XYZ();
    bLA3.rotation.controller = Euler_XYZ();
    bLA4.rotation.controller = Euler_XYZ();
    cUpArm.rotation.controller = Euler_XYZ();
	cLoArm.rotation.controller = Euler_XYZ();
	cUpArm.rotation.controller.axisOrder = 6;	-- ZYX order
	cLoArm.rotation.controller.axisOrder = 6;	-- ZYX order

		-- Create the IK chain solver/effector's. for CLAV
	endEfCL = IKSys.ikChain bCL bUA "IKHiSolver";
	endEfCL.name = (prefix+"_shoulder"+LR+"IKEndEffector");
	endEfCL.transform.controller.SAParent = 1;	-- we want this in parent space!

		-- Create the IK chain solver/effector's.
	endEf1 = IKSys.ikChain bUA bTP "IKHiSolver";
	endEf1.name = (prefix+"_arm"+LR+"IKEndEffector");
	endEf1.transform.controller.SAParent = 0;
		-- Setup swivel control for knee
	endEf1.transform.controller.VHTarget = pSWV;
		-- Setup parent for IKeffector
	endEf1.parent = cHand;
		-- For some reason it gets off sometimes, so fix
	endEf1.position = bHD.pos;

		-- Now make our loc/World locators and the one that is constrained between.
	pLC = Point pos:ptHand.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.25*pointSize);
	pLC.name = (prefix+"_local"+LR+"INT");
	pLC.wirecolor = internalColor;
	pWD = Point pos:ptHand.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.50*pointSize);
	pWD.name = (prefix+"_world"+LR+"CTRL");
	pWD.wirecolor = sideColor;
	pLW = Point pos:ptHand.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pLW.name = (prefix+"_localWorld"+LR+"INT");
	pLW.wirecolor = internalColor;

	pLC.rotation.controller = Euler_XYZ();
		-- for world locator...make it a LinkConstraint for easier animation locking later
	pWD.transform.controller = Link_Constraint();
	pWD.rotation.controller = Euler_XYZ();

		-- Make rotation of anim ctrls mirrored nicely
	if (LR == "R") then
		(
		pLC.rotation.y = 180;
		pWD.rotation.y = 180;
		pLC.rotation.x = 180;
		pWD.rotation.x = 180;
		pWD.pos = pLC.pos = ptHand.pos;

		pFX = Point pos:ptHand.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.75*pointSize);
		pFX.name = (prefix+"_parentFixer"+LR+"INT");
		pFX.wirecolor = internalColor;
		pFX.rotation = bHD.rotation;
		pFX.pos = ptHand.pos;

		coordsys local (rotate cHand (eulerangles 0 0 180) );
		coordsys local (rotate cHand (eulerangles 180 0 0) );
		cHand.pos = ptHand.pos;


			-- Don't do this till now....
		coordsys world
			(
			rotate cUpArm (eulerangles 180 0 0) ;
			rot = cUpArm.rotation as eulerangles;
			rot.z *= -1
			cUpArm.rotation = rot;
			cUpArm.position = bUA.position;


			rotate cLoArm (eulerangles 180 0 0) ;
			rot = cLoArm.rotation as eulerangles;
			rot.z *= -1
			cLoArm.rotation = rot;
			cLoArm.position = bLA.position;
			)

		)


	pLC.parent = cLoArm;
    if (place != undefined) then
		pWD.transform.controller.AddTarget place 0;	  -- for world, add link, not a parent
	pLW.parent = place;
	if (pFX != undefined) then
		pFX.parent = cHand;

		-- Now make the localWorld node point constrained between the local and world points.
	pCntl = pLW.pos.controller = position_constraint();
	pCI = pCntl.constraints;
	pCI.appendTarget pLC 50;
	pCI.appendTarget pWD 50;
	pCntl = pLW.rotation.controller = orientation_constraint();
	pCI = pCntl.constraints;
	pCI.appendTarget pLC 50;
	pCI.appendTarget pWD 50;

	cHand.parent = pLW;
	zeroOut cHand;

		-- Parenting...part ii
		--
	endEfCL.parent = cUpArm;
    cClav.parent = pTW;
	cUpArm.parent = cClav;
	cLoArm.parent = cUpArm;
	pSWV.parent = cUpArm;

	zeroOut cClav;
	zeroOut cUpArm;
	zeroOut cLoArm;
	zeroOut pSWV;

		-- Lock Pos XYZ and Rot X and Y rotation on loArm
	setTransformLockFlags cLoArm #{1,2,3,4,5};
		-- Lock POS xyz on shoulder
	setTransformLockFlags cClav #{1,2,3};


		-- Add CA's to hand
	addArmAttrs(cHand);

		-- Do stretchy stuff if needed
	if (stretchyArms == true) then
		makeStretchyBones bUA bLA bTP endEf1 cHand ("$"+cHand.name+" $"+pST.name+" ");

		-- Now we gotta hook up the localWorld attrs to drive the constraint made above.
    if (EmptyModifier != undefined) then
		cntHD = cHand.Attribute_Holder.ArmCustom_Attributes;
	else
		cntHD = cHand.ArmCustom_Attributes;
	paramWire.connect cntHD[#localworld] pLW.position.controller[1] "100-localworld;";
	paramWire.connect cntHD[#localworld] pLW.position.controller[2] "localworld;";
	paramWire.connect cntHD[#localworld] pLW.rotation.controller[1] "100-localworld;";
	paramWire.connect cntHD[#localworld] pLW.rotation.controller[2] "localworld;";


		-- -----------------------------------------------------------------------
		-- Now do auto-wrist twist locators to use during the auto expression
		--

	pLA = Point pos:bLA.pos isSelected:on centermarker:off axistripod:on cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pLA.name = (prefix+"_lowArmReader"+LR+"INT");
	pLA.wirecolor = internalColor;
	pLA.rotation = bLA.rotation;
	pLA.position = bLA.position;
	pLA.parent = bLA;

	pWS = Point pos:bHD.pos isSelected:on centermarker:off axistripod:on cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pWS.name = (prefix+"_wristReader"+LR+"INT");
	pWS.wirecolor = internalColor;
	pWS.rotation = bHD.rotation;
	pWS.position = bHD.position;
	pWS.parent = cHand;

	pWSY = Point pos:bHD.pos isSelected:on centermarker:off axistripod:on cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
	pWSY.name = (prefix+"_wristReaderY"+LR+"INT");
	pWSY.wirecolor = internalColor;
	pWSY.rotation = bHD.rotation;
	pWSY.position = bHD.position;
	coordsys local ( move pWSY [0, 1*pointSize, 0] );	-- move the Y helper out on local Y
	pWSY.parent = cHand;


		-- add an attr used internally to drive twist to one of the helpers
	addInternalTwistAttrs pLA;


		-- Create the autoTwist expression to read all the stuff...
	makeAutoTwist pLA pLA pWS pWSY cHand pSWV;

		-- Parent wrist twist bones
	bLA1.parent = bLA;
	bLA2.parent = bLA;
	bLA3.parent = bLA;
	bLA4.parent = bLA;



		-- Now setup wires to do rotation of AutoTwist
    if (EmptyModifier != undefined) then
		cntAT = pLA.Attribute_Holder.TwistCustom_Attributes;
	else
		cntAT = pLA.TwistCustom_Attributes;
	paramWire.connect cntAT[#autoTwist] bLA1.rotation.controller[1] ("degToRad(autoTwist)*0.07;");
	paramWire.connect cntAT[#autoTwist] bLA2.rotation.controller[1] ("degToRad(autoTwist)*0.333;");
	paramWire.connect cntAT[#autoTwist] bLA3.rotation.controller[1] ("degToRad(autoTwist)*0.667;");
	paramWire.connect cntAT[#autoTwist] bLA4.rotation.controller[1] ("degToRad(autoTwist)*1.00;");


		-- Now we setup a script controller on the wrist twists so that the
		-- wrist twist bones stay in the right place when stretchy stuff happens
	if (stretchyArms == true) then
		(
		makeStretchyTwist 1 neg bLA1 bLA bUA endEf1 cHand ("$"+cHand.name+" $"+pST.name+" ");
		makeStretchyTwist 2 neg bLA2 bLA bUA endEf1 cHand ("$"+cHand.name+" $"+pST.name+" ");
		makeStretchyTwist 3 neg bLA3 bLA bUA endEf1 cHand ("$"+cHand.name+" $"+pST.name+" ");
		makeStretchyTwist 4 neg bLA4 bLA bUA endEf1 cHand ("$"+cHand.name+" $"+pST.name+" ");
		)


		-- Now we gotta make the hand bone stuck to the end of the arm,
		-- but rotated based on our hand control.
	pCntl = bHD.pos.controller = position_constraint();
	pCI = pCntl.constraints;
	pCI.appendTarget bTP 100;
	if (pFX == undefined) then
		(
		pCntl = bHD.rotation.controller = orientation_constraint();
		pCI = pCntl.constraints;
		pCI.appendTarget cHand 50;
		)
	else (
		pCntl = bHD.rotation.controller = orientation_constraint();
		pCI = pCntl.constraints;
		pCI.appendTarget pFX 50;
		)

/*
	    -- Now we do wiring for reach and shrug onto clavicle
	paramWire.connect cntHD[#reach] bCL.position.controller[2] ("reach / -100.0 * "+((ctrlRad) as string)+";");
	paramWire.connect cntHD[#shrug] bCL.position.controller[3] ("shrug / 100.0 * "+((ctrlRad) as string)+";");
*/

	--
	-- Now do the auto shoulder arm heirarchy and such if we want it.
	--
	--
	if (autoShoulders == true) then
		(
		format "-- Creating % autoShoulder Setup...\n" LR;

		-- Make internal duplicate arm bones.
    	bCLAUTO = BoneSys.createBone ptClav.pos ptUpArm.pos [0,0,1];	-- clav shoulder bone
		bCLAUTO.name = (prefix+"_clavAUTO"+LR+"BONEINT");
		boneSetup bCLAUTO true mixColor:sideColor;
		bCLAUTO.sidefins = bCLAUTO.frontfin = bCLAUTO.backfin = false;	-- override
		bCLAUTO.wirecolor = internalColor;	-- override

	    bUAAUTO = BoneSys.createBone ptUpArm.pos ptLoArm.pos [0,0,1]; 			-- upper arm bone
		bUAAUTO.name = (prefix+"_upArmAUTO"+LR+"BONEINT");
		boneSetup bUAAUTO true mixColor:sideColor;
		bUAAUTO.sidefins = bUAAUTO.frontfin = bUAAUTO.backfin = false;	-- override
		bUAAUTO.wirecolor = internalColor;	-- override

    	bLAAUTO = BoneSys.createBone ptLoArm.pos ptHand.pos [0,0,1]; 			-- lower arm bone
		bLAAUTO.name = (prefix+"_loArmAUTO"+LR+"BONEINT");
		boneSetup bLAAUTO true mixColor:sideColor;
		bLAAUTO.sidefins = bLAAUTO.frontfin = bLAAUTO.backfin = false;	-- override
		bLAAUTO.wirecolor = internalColor;	-- override

	    bTPAUTO = BoneSys.createBone ptHand.pos (ptHand.pos+[neg*(tipSize/4),0,0]) [0,0,1];	-- lower arm tip bone
		bTPAUTO.name = (prefix+"_loArmTipAUTO"+LR+"BONEINT");
		boneSetup bTPAUTO false mixColor:sideColor;
			-- Override for tip
		bTPAUTO.width = bTPAUTO.height = tipSize/4;
		bTPAUTO.sidefins = bTPAUTO.frontfin = bTPAUTO.backfin = false;	-- override
		bTPAUTO.wirecolor = internalColor;	-- override


			-- Now link them
		bCLAUTO.parent = pTW;
		bUAAUTO.parent = bCLAUTO;
		bLAAUTO.parent = bUAAUTO;
		bTPAUTO.parent = bLAAUTO;

		-- Create the AUTO IK chain solver/effector's.
		endEfAUTO = IKSys.ikChain bUAAUTO bTPAUTO "IKHiSolver";
		endEfAUTO.name = (prefix+"_armAUTO"+LR+"IKEndEffector");
		endEfAUTO.transform.controller.SAParent = 0;
		-- Setup swivel control for elbow
		endEfAUTO.transform.controller.VHTarget = pSWV;
		-- Setup parent for IKeffector
		endEfAUTO.parent = cHand;
		-- For some reason it gets off sometimes, so fix
		endEfAUTO.position = bHD.pos;

		-- Now we create the 3 dummys used for the lookAt stuff. The aimer, and then
		-- the two aim targets.
		pAimer = Point pos:ptClav.pos isSelected:on centermarker:off axistripod:off cross:on Box:on constantscreensize:off drawontop:off size:(pointSize*0.75);
		pAimer.name = (prefix+"_shoulderAimer"+LR+"INT");
		pAimer.wirecolor = internalColor;

		pAimT1 = Point pos:ptUpArm.pos isSelected:on centermarker:off axistripod:off cross:on Box:off constantscreensize:off drawontop:off size:pointSize;
		pAimT1.name = (prefix+"_shoulderAimTarget1"+LR+"INT");
		pAimT1.wirecolor = internalColor;

		pAimT2 = Point pos:((ptUpArm.pos+(2*ptLoArm.pos)) / 3.0) isSelected:on centermarker:off axistripod:off cross:on Box:off constantscreensize:off drawontop:off size:pointSize;
		pAimT2.name = (prefix+"_shoulderAimTarget2"+LR+"INT");
		pAimT2.wirecolor = internalColor;

		-- Now parent the aim helpers
--		pAimer.parent = pTW;
		pAimer.parent = cUpArm;
		pAimT1.parent = bCLAUTO;
		pAimT2.parent = bUAAUTO;

		-- Now setup the lookAt constraint stuff.
		aCntl = pAimer.rotation.controller = LookAt_Constraint();
		aCI = aCntl.constraints;
		aCI.appendTarget pAimT1 40;
		aCI.appendTarget pAimT2 60;
		aCntl.viewline_length_abs = off	 -- turn off long lookAt line

		addShoulderAttrs(cClav);		-- Make the extra CA we need on the shoulder.

		-- Now we gotta hook up the autoAim attr to drive the constraint made above.
    	if (EmptyModifier != undefined) then
			cntSH = cClav.Attribute_Holder.Custom_Attributes;
		else
			cntSH = cClav.Custom_Attributes;
		paramWire.connect cntSH[#autoAim] pAimer.rotation.controller[1] "100-autoAim;";
		paramWire.connect cntSH[#autoAim] pAimer.rotation.controller[2] "autoAim;";

		-- Finally now we can just change the ik clav to be parented to the aimer
		--
		endEfCL.parent = pAimer;
		)
	--
	-- end of auto shoulder stuff



	format "-- % Arm Created.\n" LR;
	return 1;
)


-- -----------------------------------------------------------------------------------------------


/*
 * createToes() - Makes a R or L toe setup
 */
fn createToes LR =
(

		-- Setup variables for the proper side
	if (LR == "L") then
		(
		ptToe11 = $ptToe1L1;
		ptToe12 = $ptToe1L2;
		ptToe13 = $ptToe1L3;
		ptToe14 = $ptToe1L4;
		ptToeUp = $ptToeLUp;
		ptToe21 = $ptToe2L1;
		ptToe22 = $ptToe2L2;
		ptToe23 = $ptToe2L3;
		ptToe24 = $ptToe2L4;
		ptToe31 = $ptToe3L1;
		ptToe32 = $ptToe3L2;
		ptToe33 = $ptToe3L3;
		ptToe34 = $ptToe3L4;
		ptToe41 = $ptToe4L1;
		ptToe42 = $ptToe4L2;
		ptToe43 = $ptToe4L3;
		ptToe44 = $ptToe4L4;
		ptToe51 = $ptToe5L1;
		ptToe52 = $ptToe5L2;
		ptToe53 = $ptToe5L3;
		ptToe54 = $ptToe5L4;
		neg = 1;
		sideColor = 0.75*leftColor;
		)
	else if (LR == "R") then
		(
		ptToe11 = $ptToe1R1;
		ptToe12 = $ptToe1R2;
		ptToe13 = $ptToe1R3;
		ptToe14 = $ptToe1R4;
		ptToeUp = $ptToeRUp;
		ptToe21 = $ptToe2R1;
		ptToe22 = $ptToe2R2;
		ptToe23 = $ptToe2R3;
		ptToe24 = $ptToe2R4;
		ptToe31 = $ptToe3R1;
		ptToe32 = $ptToe3R2;
		ptToe33 = $ptToe3R3;
		ptToe34 = $ptToe3R4;
		ptToe41 = $ptToe4R1;
		ptToe42 = $ptToe4R2;
		ptToe43 = $ptToe4R3;
		ptToe44 = $ptToe4R4;
		ptToe51 = $ptToe5R1;
		ptToe52 = $ptToe5R2;
		ptToe53 = $ptToe5R3;
		ptToe54 = $ptToe5R4;
		neg = -1;
		sideColor = 0.75*rightColor;
		)
	else if (LR == "L2") then
		(
		ptToe11 = $ptToe1L21;
		ptToe12 = $ptToe1L22;
		ptToe13 = $ptToe1L23;
		ptToe14 = $ptToe1L24;
		ptToeUp = $ptToeL2Up;
		ptToe21 = $ptToe2L21;
		ptToe22 = $ptToe2L22;
		ptToe23 = $ptToe2L23;
		ptToe24 = $ptToe2L24;
		ptToe31 = $ptToe3L21;
		ptToe32 = $ptToe3L22;
		ptToe33 = $ptToe3L23;
		ptToe34 = $ptToe3L24;
		ptToe41 = $ptToe4L21;
		ptToe42 = $ptToe4L22;
		ptToe43 = $ptToe4L23;
		ptToe44 = $ptToe4L24;
		ptToe51 = $ptToe5L21;
		ptToe52 = $ptToe5L22;
		ptToe53 = $ptToe5L23;
		ptToe54 = $ptToe5L24;
		neg = 1;
		sideColor = 0.75*leftColor;
		)
	else
		(
		ptToe11 = $ptToe1R21;
		ptToe12 = $ptToe1R22;
		ptToe13 = $ptToe1R23;
		ptToe14 = $ptToe1R24;
		ptToeUp = $ptToeR2Up;
		ptToe21 = $ptToe2R21;
		ptToe22 = $ptToe2R22;
		ptToe23 = $ptToe2R23;
		ptToe24 = $ptToe2R24;
		ptToe31 = $ptToe3R21;
		ptToe32 = $ptToe3R22;
		ptToe33 = $ptToe3R23;
		ptToe34 = $ptToe3R24;
		ptToe41 = $ptToe4R21;
		ptToe42 = $ptToe4R22;
		ptToe43 = $ptToe4R23;
		ptToe44 = $ptToe4R24;
		ptToe51 = $ptToe5R21;
		ptToe52 = $ptToe5R22;
		ptToe53 = $ptToe5R23;
		ptToe54 = $ptToe5R24;
		neg = -1;
		sideColor = 0.75*rightColor;
		)

	cFoot = execute("$"+prefix+"_foot"+LR+"CTRL;");

	if (cFoot == undefined) then
		(
		format "-- WARNING: Can't create % Toes.  Foot Control must exist first.\n" LR;
		return 0;
		)

	bFT = execute("$"+prefix+"_foot"+LR+"BONE;");
	bTO = execute("$"+prefix+"_toe"+LR+"BONE;");

	if (bFT == undefined or bTO == undefined) then
		(
		format "-- WARNING: Can't create % Toes.  Foot and Main Toe Bone must exist first.\n" LR;
		return 0;
		)

	-- pre calc # of joints and such so that we can add attrs
	doToe1 = false;
	numToes = 0;
    if (ptToeUp != undefined and ptToe11 != undefined and ptToe12 != undefined	) then
		doToe1 = true;
    if (ptToe21 != undefined and ptToe22 != undefined	) then
		(
		numToes += 1;
	    if (ptToe31 != undefined and ptToe32 != undefined	) then
			(
			numToes += 1;
		    if (ptToe41 != undefined and ptToe42 != undefined	) then
				(
				numToes += 1;
			    if (ptToe51 != undefined and ptToe52 != undefined	) then
					(
					numToes += 1;
					)
				)
			)
		)

		-- Add CA's to ctrl object!
    if (doToe1 == true or numToes > 0) then
	    addToeAttrs cFoot doToe1 numToes;
	else
		return;


	bLast = undefined;		-- last bone
	lastP = 0;				-- last end position

	toeDigits = 0;

    if ((objExists("$"+prefix+"_toe"+LR+"1CTRL") != true) and
		ptToeUp != undefined and ptToe11 != undefined and ptToe12 != undefined	) then
		(
		format "-- Building % Toe 1.\n" LR;

		tUp = ptToeUp.pos - ptToe11.pos;
		ctrlRad = length(ptToe11.pos - ptToe12.pos)*0.75;
		tipSize = 0.17 * (length(ptToe12.pos - ptToe11.pos));
		pointSize = tipSize*4;


	    bT1 = BoneSys.createBone ptToe11.pos ptToe12.pos tUp;
		bT1.name = (prefix+"_toe1"+LR+"1BONE");
		boneSetup bT1 true mixColor:sideColor;
		bT1.rotation.controller = Euler_XYZ();
		bLast = bT1;			-- keep track so we can make tip
		lastP = ptToe12.pos;
		toeDigits += 1;
		cT1 = Ngon radius:(ctrlRad*1.2) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptToe11.pos isSelected:on;
		cT1.name = (prefix+"_toe1"+LR+"1CTRL");
		cT1.wirecolor = sideColor;
		convertToSplineShape cT1;
		cT1.rotation = bT1.rotation;		-- get control to right orientation
		coordsys local (rotate cT1 (eulerangles -90 0 0));
		cT1.position = bT1.position;
		cT1.rotation.controller = Euler_XYZ();


	    if (ptToe12 != undefined and ptToe13 != undefined	) then
			(
	    	bT2 = BoneSys.createBone ptToe12.pos ptToe13.pos tUp;
			bT2.name = (prefix+"_toe1"+LR+"2BONE");
			boneSetup bT2 true mixColor:sideColor;
			bT2.rotation.controller = Euler_XYZ();
			bLast = bT2;			-- keep track so we can make tip
			lastP = ptToe13.pos;
			toeDigits += 1;
			cT2 = Ngon radius:(ctrlRad*1.1) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptToe12.pos isSelected:on;
			cT2.name = (prefix+"_toe1"+LR+"2CTRL");
			cT2.wirecolor = sideColor;
			convertToSplineShape cT2;
			cT2.rotation = bT2.rotation;		-- get control to right orientation
			coordsys local (rotate cT2 (eulerangles -90 0 0));
			cT2.position = bT2.position;
			cT2.rotation.controller = Euler_XYZ();

		    if (ptToe13 != undefined and ptToe14 != undefined	) then
				(
		    	bT3 = BoneSys.createBone ptToe13.pos ptToe14.pos tUp;
				bT3.name = (prefix+"_toe1"+LR+"3BONE");
				boneSetup bT3 true mixColor:sideColor;
				bT3.rotation.controller = Euler_XYZ();
				bLast = bT3;			-- keep track so we can make tip
				lastP = ptToe14.pos;
				toeDigits += 1;
				cT3 = Ngon radius:(ctrlRad*1.0) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptToe13.pos isSelected:on;
				cT3.name = (prefix+"_toe1"+LR+"3CTRL");
				cT3.wirecolor = sideColor;
				convertToSplineShape cT3;
				cT3.rotation = bT3.rotation;		-- get control to right orientation
				coordsys local (rotate cT3 (eulerangles -90 0 0));
				cT3.position = bT3.position;
				cT3.rotation.controller = Euler_XYZ();

				)
			)

		-- Now make tip bone
		bTP = BoneSys.createBone lastP ((0.5*(ptToe12.pos-ptToe11.pos))+lastP) tUp;
		bTP.name = (prefix+"_toe1"+LR+"TipBONE");
		boneSetup bTP false;
			-- override
		bTP.width = bTP.height = tipSize*3;

		-- Make Toe1 Adjuster Dummy and Toe1 Master
		pTM = Point pos:ptToe11.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
		pTM.name = (prefix+"_toe1"+LR+"MasterINT");
		pTM.wirecolor = internalColor;
		pTM.rotation = bT1.rotation;
		pTM.position = bT1.pos;

		pTA = Point pos:ptToe11.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
		pTA.name = (prefix+"_toe1"+LR+"AdjusterINT");
		pTA.rotation.controller = Euler_XYZ();
		pTA.wirecolor = internalColor;
		pTA.rotation = bT1.rotation;
		pTA.position = bT1.pos;

		-- Parent stuff
--		pTM.parent = bFT;		-- parent to Bone for foot for the first toe.  All others are on the toe.?
		pTM.parent = bTO;	    -- ah most people will prob want the main toe..so do that...
		pTA.parent = pTM;
		cT1.parent = pTA
		bT1.parent = cT1;
		bTP.parent = bT1;
		zeroOut cT1;
		if (cT2 != undefined) then
			(
			cT2.parent = bT1;
			bT2.parent = cT2;
			bTP.parent = bT2;
			zeroOut cT2;
			)
		if (cT3 != undefined) then
			(
			cT3.parent = bT2;
			bT3.parent = cT3;
			bTP.parent = bT3;
			zeroOut cT3;
			)

		-- At this point things are all made and linked for the Toe1...
		-- we need to set up the auto rotations by wiring from the attrs.

--	    format "-- WIRING Toe1...\n";
	    if (EmptyModifier != undefined) then
			cntFT = cFoot.Attribute_Holder.ToeCustom_Attributes;
		else
			cntFT = cFoot.ToeCustom_Attributes;
--		format "-- cntFT = %\n" cntFT;

		paramWire.connect cntFT[#toe1] bT1.rotation.controller[3] ("toe1/100.0*"+(tDig1Mult as string)+"*"+((degToRad(360)/toeDigits) as string));
		if (bT2 != undefined) then
			paramWire.connect cntFT[#toe1] bT2.rotation.controller[3] ("toe1/100.0*"+(tDig2Mult as string)+"*"+((degToRad(360)/toeDigits) as string));
		if (bT3 != undefined) then
			paramWire.connect cntFT[#toe1] bT3.rotation.controller[3] ("toe1/100.0*"+(tDig3Mult as string)+"*"+((degToRad(360)/toeDigits) as string));
		paramWire.connect cntFT[#toe1adj] pTA.rotation.controller[3] ("toe1adj/100.0*"+((neg*degToRad(90)) as string));
		paramWire.connect cntFT[#toe1twist] pTA.rotation.controller[1] ("toe1twist/100.0*"+((neg*degToRad(90)) as string));
--	    format "-- Toe1 wired.\n";


		)
	else (
		format "-- WARNING: Can't create % Toe.  pointHelpers are missing or Toe1 already Exists.\n" LR;
		)

		--
		-- Now Make Da FINGERS
		--
	for f in 2 to (numToes+1) do
		(
		toeDigits = 0;
		bF1 = bF2 = bF3 = undefined;
		cF1 = cF2 = cF3 = undefined;
		bFP = pFM = pFA = undefined;

			-- Make easy variables based on which finger we're on.
		ptToe1 = execute("$ptToe"+(f as string)+LR+"1;");
		ptToe2 = execute("$ptToe"+(f as string)+LR+"2;");
		ptToe3 = execute("$ptToe"+(f as string)+LR+"3;");
		ptToe4 = execute("$ptToe"+(f as string)+LR+"4;");

		format "-- Building toe %%.\n" f LR;

	    if (objExists("$"+prefix+"_toe"+(f as string)+LR+"1CTRL") != true and
			ptToe1 != undefined and ptToe2 != undefined	) then
			(
			fUp = [0,0,1];
			ctrlRad = length(ptToe1.pos - ptToe2.pos)*0.75;
			tipSize = 0.17 * (length(ptToe2.pos - ptToe1.pos));
			pointSize = tipSize*4;



		    bF1 = BoneSys.createBone ptToe1.pos ptToe2.pos fUp;
			bF1.name = (prefix+"_toe"+(f as string)+LR+"1BONE");
			boneSetup bF1 true mixColor:sideColor;
			bF1.rotation.controller = Euler_XYZ();
			bLast = bF1;			-- keep track so we can make tip
			lastP = ptToe2.pos;
			toeDigits += 1;
			cF1 = Ngon radius:(ctrlRad*1.2) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptToe1.pos isSelected:on;
			cF1.name = (prefix+"_toe"+(f as string)+LR+"1CTRL");
			cF1.wirecolor = sideColor;
			convertToSplineShape cF1;
			cF1.rotation = bF1.rotation;		-- get control to right orientation
			coordsys local (rotate cF1 (eulerangles -90 0 0));
			cF1.position = bF1.position;
			cF1.rotation.controller = Euler_XYZ();


		    if (ptToe2 != undefined and ptToe3 != undefined	) then
				(
		    	bF2 = BoneSys.createBone ptToe2.pos ptToe3.pos fUp;
				bF2.name = (prefix+"_toe"+(f as string)+LR+"2BONE");
				boneSetup bF2 true mixColor:sideColor;
				bF2.rotation.controller = Euler_XYZ();
				bLast = bF2;			-- keep track so we can make tip
				lastP = ptToe3.pos;
				toeDigits+= 1;
				cF2 = Ngon radius:(ctrlRad*1.1) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptToe2.pos isSelected:on;
				cF2.name = (prefix+"_toe"+(f as string)+LR+"2CTRL");
				cF2.wirecolor = sideColor;
				convertToSplineShape cF2;
				cF2.rotation = bF2.rotation;		-- get control to right orientation
				coordsys local (rotate cF2 (eulerangles -90 0 0));
				cF2.position = bF2.position;
				cF2.rotation.controller = Euler_XYZ();

			    if (ptToe3 != undefined and ptToe4 != undefined	) then
					(
			    	bF3 = BoneSys.createBone ptToe3.pos ptToe4.pos fUp;
					bF3.name = (prefix+"_toe"+(f as string)+LR+"3BONE");
					boneSetup bF3 true mixColor:sideColor;
					bF3.rotation.controller = Euler_XYZ();
					bLast = bF3;			-- keep track so we can make tip
					lastP = ptToe4.pos;
					toeDigits+= 1;
					cF3 = Ngon radius:(ctrlRad*1.0) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptToe3.pos isSelected:on;
					cF3.name = (prefix+"_toe"+(f as string)+LR+"3CTRL");
					cF3.wirecolor = sideColor;
					convertToSplineShape cF3;
					cF3.rotation = bF3.rotation;		-- get control to right orientation
					coordsys local (rotate cF3 (eulerangles -90 0 0));
					cF3.position = bF3.position;
					cF3.rotation.controller = Euler_XYZ();

					)
				)


			-- Now make tip bone
			bFP = BoneSys.createBone lastP ((0.5*(ptToe2.pos-ptToe1.pos))+lastP) fUp;
			bFP.name = (prefix+"_toe"+(f as string)+LR+"TipBONE");
			boneSetup bFP false;
				-- override
			bFP.width = bFP.height = tipSize*3;


			-- Make Finger Master dummy and Finger Adjuster dummy
			pFM = Point pos:ptToe1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
			pFM.name = (prefix+"_toe"+(f as string)+LR+"MasterINT");
			pFM.wirecolor = internalColor;
			pFM.rotation = bF1.rotation;
			pFM.position = bF1.pos;

			pFA = Point pos:ptToe1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
			pFA.name = (prefix+"_toe"+(f as string)+LR+"AdjusterINT");
			pFA.rotation.controller = Euler_XYZ();
			pFA.wirecolor = internalColor;
			pFA.rotation = bF1.rotation;
			pFA.position = bF1.pos;

			-- Parent stuff
			pFM.parent = bTO;		-- parent to Bone for master regular large toe which already does footRoll.
			pFA.parent = pFM;
			cF1.parent = pFA
			bF1.parent = cF1;
			bFP.parent = bF1;
			zeroOut cF1;
			if (cF2 != undefined) then
				(
				cF2.parent = bF1;		-- control is parented to previous bone
				bF2.parent = cF2;		-- bone is parented to this control
				bFP.parent = bF2;
				zeroOut cF2;
				)
			if (cF3 != undefined) then
				(
				cF3.parent = bF2;
				bF3.parent = cF3;
				bFP.parent = bF3;
				zeroOut cF3;
				)


			-- At this point things are all made and linked for the finger...
			-- we need to set up the auto rotations by wiring from the attrs.
		    if (EmptyModifier != undefined) then
				cntFT = "$"+cFoot.name+".Attribute_Holder.ToeCustom_Attributes";
			else
				cntFT = "$"+cFoot.name+".ToeCustom_Attributes";

			format "-- Wiring %...\n" f;
			str = "paramWire.connect "+cntFT+"[#toe"+(f as string)+"] $"+bF1.name+".rotation.controller[3] \"toe"+(f as string)+"/100.0*"+(tDig1Mult as string)+"*"+((degToRad(360)/toeDigits) as string)+"\";\n";
			if (bF2 != undefined) then
				str += "paramWire.connect "+cntFT+"[#toe"+(f as string)+"] $"+bF2.name+".rotation.controller[3] \"toe"+(f as string)+"/100.0*"+(tDig2Mult as string)+"*"+((degToRad(360)/toeDigits) as string)+"\";\n";
			if (bF3 != undefined) then
				str += "paramWire.connect "+cntFT+"[#toe"+(f as string)+"] $"+bF3.name+".rotation.controller[3] \"toe"+(f as string)+"/100.0*"+(tDig3Mult as string)+"*"+((degToRad(360)/toeDigits) as string)+"\";\n";
			execute str;
			format "-- %% wired.\n" f LR;

			-- Finally take care of spread if needed
		    if (numToes > 1) then
				(
				deg = 0;
				if (f-1 <= (numToes/2)) then
					deg = degToRad(-10);
				else
					deg = degToRad(10);
						-- outer toes do more...
				if (f == 2) then
					deg -= degToRad(20);
				if (f-1 == numToes) then
					deg += degToRad(20);
				if (LR == "R") then
					deg *= -1;
--				format "-- Doing spread %...\n" f;
				str = "paramWire.connect "+cntFT+"[#toespread] $'"+pFA.name+"'.rotation.controller[3] \"toespread/100.0*"+(deg as string)+"\";\n";
				execute str;
--				format "-- Spread %% done.\n" f LR;
				)

			)
		else (
			format "-- WARNING: Can't create Toe %%.  pointHelpers are missing or Toe already Exists.\n" f LR;
			)

		) -- end of numToe loop

	format "-- % Toes created.\n" LR;
    return 1;
)


-- -----------------------------------------------------------------------------------------------


/*
 * createFingers() - Makes a R or L finger setup
 */
fn createFingers LR =
(

		-- Setup variables for the proper side
	if (LR == "L") then
		(
		ptThumb1 = $ptThumbL1;
		ptThumb2 = $ptThumbL2;
		ptThumb3 = $ptThumbL3;
		ptThumb4 = $ptThumbL4;
		ptThumbUp = $ptThumbLUp;
		ptFinger11 = $ptFinger1L1;
		ptFinger12 = $ptFinger1L2;
		ptFinger13 = $ptFinger1L3;
		ptFinger14 = $ptFinger1L4;
		ptFinger21 = $ptFinger2L1;
		ptFinger22 = $ptFinger2L2;
		ptFinger23 = $ptFinger2L3;
		ptFinger24 = $ptFinger2L4;
		ptFinger31 = $ptFinger3L1;
		ptFinger32 = $ptFinger3L2;
		ptFinger33 = $ptFinger3L3;
		ptFinger34 = $ptFinger3L4;
		ptFinger41 = $ptFinger4L1;
		ptFinger42 = $ptFinger4L2;
		ptFinger43 = $ptFinger4L3;
		ptFinger44 = $ptFinger4L4;
		neg = 1;
		sideColor = 0.75*leftColor;
		)
	else (
		ptThumb1 = $ptThumbR1;
		ptThumb2 = $ptThumbR2;
		ptThumb3 = $ptThumbR3;
		ptThumb4 = $ptThumbR4;
		ptThumbUp = $ptThumbRUp;
		ptFinger11 = $ptFinger1R1;
		ptFinger12 = $ptFinger1R2;
		ptFinger13 = $ptFinger1R3;
		ptFinger14 = $ptFinger1R4;
		ptFinger21 = $ptFinger2R1;
		ptFinger22 = $ptFinger2R2;
		ptFinger23 = $ptFinger2R3;
		ptFinger24 = $ptFinger2R4;
		ptFinger31 = $ptFinger3R1;
		ptFinger32 = $ptFinger3R2;
		ptFinger33 = $ptFinger3R3;
		ptFinger34 = $ptFinger3R4;
		ptFinger41 = $ptFinger4R1;
		ptFinger42 = $ptFinger4R2;
		ptFinger43 = $ptFinger4R3;
		ptFinger44 = $ptFinger4R4;
		neg = -1;
		sideColor = 0.75*rightColor;
		)

--findme

	cHand = execute("$"+prefix+"_hand"+LR+"CTRL;");
	if (cHand == undefined) then
		(
		format "-- WARNING: Can't create % Fingers.  Hand Control must exist first.\n" LR;
		return 0;
		)
    bHand = execute("$"+prefix+"_hand"+LR+"BONE;");
	if (bHand == undefined) then
		(
		format "-- WARNING: Can't create % Fingers.  Hand Bone must exist first.\n" LR;
		return 0;
		)


		-- Make Finger CTRL
		--
    cFinger = createhalfCircleShape();
    cFinger.name = (prefix+"_finger"+LR+"CTRL");
    cFinger.rotation = cHand.rotation;
    cFinger.position = cHand.position;

		-- try to guess ctrlRad now...
	ctrlRad = cHand.scale.x * 15.0;
	if (ptThumb1 != undefined and ptThumb2 != undefined) then
		ctrlRad = length(ptThumb1.pos - ptThumb2.pos)*0.75;
	else if (ptFinger11 != undefined and ptFinger12 != undefined) then
		ctrlRad = length(ptFinger12.pos - ptFinger11.pos)*0.75;
    coordsys local
    	(
		if (LR == "R") then
		    rotate cFinger (eulerangles 0 0 180);
		move cFinger [1.5*ctrlRad, 0 , 0];
		)
	cFinger.scale = [ctrlRad/15.0, ctrlRad/15.0, ctrlRad/15.0];
	cFinger.wireColor = sideColor;
	cFinger.parent = cHand;
	zeroOut cFinger;
		-- Lock Pos XYZ and Rot X and Y Z and Scale on Fingers
	setTransformLockFlags cFinger #{1,2,3,4,5,6,7,8,9};



	-- pre calc # of joints and such so that we can add attrs
	doThumb = false;
	numFingers = 0;
    if (ptThumbUp != undefined and ptThumb1 != undefined and ptThumb2 != undefined	) then
		doThumb = true;
    if (ptFinger11 != undefined and ptFinger12 != undefined	) then
		(
		numFingers += 1;
	    if (ptFinger21 != undefined and ptFinger22 != undefined	) then
			(
			numFingers += 1;
		    if (ptFinger31 != undefined and ptFinger32 != undefined	) then
				(
				numFingers += 1;
			    if (ptFinger41 != undefined and ptFinger42 != undefined	) then
					(
					numFingers += 1;
					)
				)
			)
		)

		-- Add CA's to ctrl object!
    if (doThumb == true or numFingers > 0) then
	    addFingerAttrs cFinger doThumb numFingers;
	else
	    return;

	bLast = undefined;		-- last bone
	lastP = 0;				-- last end position

	thumbDigits = 0;

    if ((objExists("$"+prefix+"_thumb"+LR+"1CTRL") != true) and
		ptThumbUp != undefined and ptThumb1 != undefined and ptThumb2 != undefined	) then
		(
		format "-- Building % Thumb.\n" LR;

		tUp = ptThumbUp.pos - ptThumb1.pos;
		ctrlRad = length(ptThumb1.pos - ptThumb2.pos)*0.75;
		tipSize = 0.17 * (length(ptThumb2.pos - ptThumb1.pos));
		pointSize = tipSize*4;


	    bT1 = BoneSys.createBone ptThumb1.pos ptThumb2.pos tUp;
		bT1.name = (prefix+"_thumb"+LR+"1BONE");
		boneSetup bT1 true mixColor:sideColor;
		bT1.rotation.controller = Euler_XYZ();
		bLast = bT1;			-- keep track so we can make tip
		lastP = ptThumb2.pos;
		thumbDigits += 1;
		cT1 = Ngon radius:(ctrlRad*1.2) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptThumb1.pos isSelected:on;
		cT1.name = (prefix+"_thumb"+LR+"1CTRL");
		cT1.wirecolor = sideColor;
		convertToSplineShape cT1;
		cT1.rotation = bT1.rotation;		-- get control to right orientation
		coordsys local (rotate cT1 (eulerangles -90 0 0));
		cT1.position = bT1.position;
		cT1.rotation.controller = Euler_XYZ();

	    if (ptThumb2 != undefined and ptThumb3 != undefined	) then
			(
	    	bT2 = BoneSys.createBone ptThumb2.pos ptThumb3.pos tUp;
			bT2.name = (prefix+"_thumb"+LR+"2BONE");
			boneSetup bT2 true mixColor:sideColor;
			bT2.rotation.controller = Euler_XYZ();
			bLast = bT2;			-- keep track so we can make tip
			lastP = ptThumb3.pos;
			thumbDigits += 1;
			cT2 = Ngon radius:(ctrlRad*1.1) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptThumb2.pos isSelected:on;
			cT2.name = (prefix+"_thumb"+LR+"2CTRL");
			cT2.wirecolor = sideColor;
			convertToSplineShape cT2;
			cT2.rotation = bT2.rotation;		-- get control to right orientation
			coordsys local (rotate cT2 (eulerangles -90 0 0));
			cT2.position = bT2.position;
			cT2.rotation.controller = Euler_XYZ();

		    if (ptThumb3 != undefined and ptThumb4 != undefined	) then
				(
		    	bT3 = BoneSys.createBone ptThumb3.pos ptThumb4.pos tUp;
				bT3.name = (prefix+"_thumb"+LR+"3BONE");
				boneSetup bT3 true mixColor:sideColor;
				bT3.rotation.controller = Euler_XYZ();
				bLast = bT3;			-- keep track so we can make tip
				lastP = ptThumb4.pos;
				thumbDigits += 1;
				cT3 = Ngon radius:(ctrlRad*1.0) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptThumb3.pos isSelected:on;
				cT3.name = (prefix+"_thumb"+LR+"3CTRL");
				cT3.wirecolor = sideColor;
				convertToSplineShape cT3;
				cT3.rotation = bT3.rotation;		-- get control to right orientation
				coordsys local (rotate cT3 (eulerangles -90 0 0));
				cT3.position = bT3.position;
				cT3.rotation.controller = Euler_XYZ();

				)
			)

		-- Now make tip bone
		bTP = BoneSys.createBone lastP ((0.5*(ptThumb2.pos-ptThumb1.pos))+lastP) tUp;
		bTP.name = (prefix+"_thumb"+LR+"TipBONE");
		boneSetup bTP false;
			-- override
		bTP.width = bTP.height = tipSize*3;

		-- Make thumb Adjuster Dummy and Thumb Master
		pTM = Point pos:ptThumb1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
		pTM.name = (prefix+"_thumb"+LR+"MasterINT");
		pTM.wirecolor = internalColor;
		pTM.rotation = bT1.rotation;
		pTM.position = bT1.pos;

		pTA = Point pos:ptThumb1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
		pTA.name = (prefix+"_thumb"+LR+"AdjusterINT");
		pTA.rotation.controller = Euler_XYZ();
		pTA.wirecolor = internalColor;
		pTA.rotation = bT1.rotation;
		pTA.position = bT1.pos;

		-- Parent stuff
		pTM.parent = bHand;		-- parent to Bone which is stuck on end of arm
		pTA.parent = pTM;
		cT1.parent = pTA
		bT1.parent = cT1;
		bTP.parent = bT1;
		zeroOut cT1;
		if (cT2 != undefined) then
			(
			cT2.parent = bT1;
			bT2.parent = cT2;
			bTP.parent = bT2;
			zeroOut cT2;
			)
		if (cT3 != undefined) then
			(
			cT3.parent = bT2;
			bT3.parent = cT3;
			bTP.parent = bT3;
			zeroOut cT3;
			)

		-- At this point things are all made and linked for the thumb...
		-- we need to set up the auto rotations by wiring from the attrs.

--	    format "-- WIRING Thumb...\n";
	    if (EmptyModifier != undefined) then
			cntHD = cFinger.Attribute_Holder.Custom_Attributes;
		else
			cntHD = cFinger.Custom_Attributes;
--		format "-- cntHD = %\n" cntHD;

		paramWire.connect cntHD[#thumb] bT1.rotation.controller[3] ("thumb/100.0*"+(fDig1Mult as string)+"*"+((degToRad(360)/thumbDigits) as string));
		if (bT2 != undefined) then
		    (
	        paramWire.connect cntHD[#thumb] bT2.rotation.controller[3] ("thumb/100.0*"+(fDig2Mult as string)+"*"+((degToRad(360)/thumbDigits) as string));
			)
		if (bT3 != undefined) then
		    (
	        iRot = coordsys parent ( bT3.rotation as eulerangles );
			paramWire.connect cntHD[#thumb] bT3.rotation.controller[3] ("thumb/100.0*"+(fDig3Mult as string)+"*"+((degToRad(360)/thumbDigits) as string));
			)
		paramWire.connect cntHD[#thumbadj] pTA.rotation.controller[3] ("thumbadj/100.0*"+((neg*degToRad(90)) as string));
		paramWire.connect cntHD[#thumbtwist] pTA.rotation.controller[1] ("thumbtwist/100.0*"+((neg*degToRad(90)) as string));
--	    format "-- Thumb wired.\n";

		if (LR == "R") then
			(
					-- r5 seems to need this now...
					-- For some reason after wiring the bones may be off by 180.
					--   if so set them back.  This now works right because it checks.
					--		10/31/02 - mcomet
			if (bT1 != undefined) then
				(
	    		iRot = coordsys parent ( bT1.rotation as eulerangles );
	    		if (iRot.z == 180 or iRot.z == -180) then
	    		    (
				    coordsys local (rotate bT1 (eulerangles 0 0 180) );
				    coordsys local (rotate bT1 (eulerangles 180 0 0) );
				    )
				)
			if (bT2 != undefined) then
				(
	    		iRot = coordsys parent ( bT2.rotation as eulerangles );
	    		if (iRot.z == 180 or iRot.z == -180) then
	    		    (
					coordsys local (rotate bT2 (eulerangles 0 0 180) );
					coordsys local (rotate bT2 (eulerangles 180 0 0) );
					)
				)
			if (bT3 != undefined) then
				(
	    		iRot = coordsys parent ( bT3.rotation as eulerangles );
	    		if (iRot.z == 180 or iRot.z == -180) then
	    		    (
					coordsys local (rotate bT3 (eulerangles 0 0 180) );
					)
				)
			)

		)
	else (
		format "-- WARNING: Can't create % Thumb.  pointHelpers are missing or Thumb already Exists.\n" LR;
		)

		--
		-- Now Make Da FINGERS
		--
	for f in 1 to numFingers do
		(
		fingerDigits = 0;
		bF1 = bF2 = bF3 = undefined;
		cF1 = cF2 = cF3 = undefined;
		bFP = pFM = pFA = undefined;

			-- Make easy variables based on which finger we're on.
		ptFinger1 = execute("$ptFinger"+(f as string)+LR+"1;");
		ptFinger2 = execute("$ptFinger"+(f as string)+LR+"2;");
		ptFinger3 = execute("$ptFinger"+(f as string)+LR+"3;");
		ptFinger4 = execute("$ptFinger"+(f as string)+LR+"4;");

		format "-- Building finger %%.\n" f LR;

	    if (objExists("$"+prefix+"_finger"+(f as string)+LR+"1CTRL") != true and
			ptFinger1 != undefined and ptFinger2 != undefined	) then
			(
--			fUp = cross(ptFinger2.pos - ptFinger1.pos);
			fUp = [0,0,1];
			ctrlRad = length(ptFinger1.pos - ptFinger2.pos)*0.75;
			tipSize = 0.17 * (length(ptFinger2.pos - ptFinger1.pos));
			pointSize = tipSize*4;



		    bF1 = BoneSys.createBone ptFinger1.pos ptFinger2.pos fUp;
			bF1.name = (prefix+"_finger"+(f as string)+LR+"1BONE");
			boneSetup bF1 true mixColor:sideColor;
			bF1.rotation.controller = Euler_XYZ();
			bLast = bF1;			-- keep track so we can make tip
			lastP = ptFinger2.pos;
			fingerDigits += 1;
			cF1 = Ngon radius:(ctrlRad*1.2) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptFinger1.pos isSelected:on;
			cF1.name = (prefix+"_finger"+(f as string)+LR+"1CTRL");
			cF1.wirecolor = sideColor;
			convertToSplineShape cF1;
			cF1.rotation = bF1.rotation;		-- get control to right orientation
			coordsys local (rotate cF1 (eulerangles -90 0 0));
			cF1.position = bF1.position;
			cF1.rotation.controller = Euler_XYZ();


		    if (ptFinger2 != undefined and ptFinger3 != undefined	) then
				(
		    	bF2 = BoneSys.createBone ptFinger2.pos ptFinger3.pos fUp;
				bF2.name = (prefix+"_finger"+(f as string)+LR+"2BONE");
				boneSetup bF2 true mixColor:sideColor;
				bF2.rotation.controller = Euler_XYZ();
				bLast = bF2;			-- keep track so we can make tip
				lastP = ptFinger3.pos;
				fingerDigits += 1;
				cF2 = Ngon radius:(ctrlRad*1.1) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptFinger2.pos isSelected:on;
				cF2.name = (prefix+"_finger"+(f as string)+LR+"2CTRL");
				cF2.wirecolor = sideColor;
				convertToSplineShape cF2;
				cF2.rotation = bF2.rotation;		-- get control to right orientation
				coordsys local (rotate cF2 (eulerangles -90 0 0));
				cF2.position = bF2.position;
				cF2.rotation.controller = Euler_XYZ();

			    if (ptFinger3 != undefined and ptFinger4 != undefined	) then
					(
			    	bF3 = BoneSys.createBone ptFinger3.pos ptFinger4.pos fUp;
					bF3.name = (prefix+"_finger"+(f as string)+LR+"3BONE");
					boneSetup bF3 true mixColor:sideColor;
					bF3.rotation.controller = Euler_XYZ();
					bLast = bF3;			-- keep track so we can make tip
					lastP = ptFinger4.pos;
					fingerDigits += 1;
					cF3 = Ngon radius:(ctrlRad*1.0) cornerRadius:0 nsides:6 circular:off scribe:1 pos:ptFinger3.pos isSelected:on;
					cF3.name = (prefix+"_finger"+(f as string)+LR+"3CTRL");
					cF3.wirecolor = sideColor;
					convertToSplineShape cF3;
					cF3.rotation = bF3.rotation;		-- get control to right orientation
					coordsys local (rotate cF3 (eulerangles -90 0 0));
					cF3.position = bF3.position;
					cF3.rotation.controller = Euler_XYZ();

					)
				)


			-- Now make tip bone
			bFP = BoneSys.createBone lastP ((0.5*(ptFinger2.pos-ptFinger1.pos))+lastP) fUp;
			bFP.name = (prefix+"_finger"+(f as string)+LR+"TipBONE");
			boneSetup bFP false;
				-- override
			bFP.width = bFP.height = tipSize*3;


			-- Make Finger Master dummy and Finger Adjuster dummy
			pFM = Point pos:ptFinger1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:pointSize;
			pFM.name = (prefix+"_finger"+(f as string)+LR+"MasterINT");
			pFM.wirecolor = internalColor;
			pFM.rotation = bF1.rotation;
			pFM.position = bF1.pos;

			pFA = Point pos:ptFinger1.pos isSelected:on centermarker:off axistripod:off cross:off Box:on constantscreensize:off drawontop:off size:(0.5*pointSize);
			pFA.name = (prefix+"_finger"+(f as string)+LR+"AdjusterINT");
			pFA.rotation.controller = Euler_XYZ();
			pFA.wirecolor = internalColor;
			pFA.rotation = bF1.rotation;
			pFA.position = bF1.pos;

			-- Parent stuff
			pFM.parent = bHand;		-- parent to Bone which is stuck on end of arm
			pFA.parent = pFM;
			cF1.parent = pFA
			bF1.parent = cF1;
			bFP.parent = bF1;
			zeroOut cF1;
			if (cF2 != undefined) then
				(
				cF2.parent = bF1;		-- control is parented to previous bone
				bF2.parent = cF2;		-- bone is parented to this control
				bFP.parent = bF2;
				zeroOut cF2;
				)
			if (cF3 != undefined) then
				(
				cF3.parent = bF2;
				bF3.parent = cF3;
				bFP.parent = bF3;
				zeroOut cF3;
				)


			-- At this point things are all made and linked for the finger...
			-- we need to set up the auto rotations by wiring from the attrs.
		    if (EmptyModifier != undefined) then
				cntHD = "$"+cFinger.name+".Attribute_Holder.Custom_Attributes";
			else
				cntHD = "$"+cFinger.name+".Custom_Attributes";

--			format "-- Wiring %...\n" f;
			str = "paramWire.connect "+cntHD+"[#finger"+(f as string)+"] $"+bF1.name+".rotation.controller[3] \"finger"+(f as string)+"/100.0*"+(fDig1Mult as string)+"*"+((degToRad(360)/fingerDigits) as string)+"\";\n";
			if (bF2 != undefined) then
				str += "paramWire.connect "+cntHD+"[#finger"+(f as string)+"] $"+bF2.name+".rotation.controller[3] \"finger"+(f as string)+"/100.0*"+(fDig2Mult as string)+"*"+((degToRad(360)/fingerDigits) as string)+"\";\n";
			if (bF3 != undefined) then
				str += "paramWire.connect "+cntHD+"[#finger"+(f as string)+"] $"+bF3.name+".rotation.controller[3] \"finger"+(f as string)+"/100.0*"+(fDig3Mult as string)+"*"+((degToRad(360)/fingerDigits) as string)+"\";\n";
			execute str;
--			format "-- %% wired.\n" f LR;

			-- Finally take care of spread if needed
		    if (numFingers > 1) then
				(
				deg = 0;
				if (f <= (numFingers/2)) then
					deg = degToRad(-10);
				else
					deg = degToRad(10);
						-- outer fingers do more...
				if (f == 1) then
					deg -= degToRad(20);
				if (f == numFingers) then
					deg += degToRad(20);
				if (LR == "R") then
				    deg *= -1;
--				format "-- Doing spread %...\n" f;
				str = "paramWire.connect "+cntHD+"[#spread] $'"+pFA.name+"'.rotation.controller[3] \"spread/100.0*"+(deg as string)+"\";\n";
				execute str;
--				format "-- Spread %% done.\n" f LR;
				)

			)
		else (
			format "-- WARNING: Can't create Finger %%.  pointHelpers are missing or Finger already Exists.\n" f LR;
			)

		) -- end of numFingers loop

	format "-- % Fingers created.\n" LR;
    return 1;
)


-- -----------------------------------------------------------------------------------------------

/*
 * mirrorObjX() - Given the objname to mirror and a newname for the new object,
 *		this creates a mirrored copy on the X axis.
 */
fn mirrorObjX objname newname =
(
	if (objExists(objname) and (objExists(newname) != true)) then
		(

		pM = Point pos:[0,0,0] isSelected:off centermarker:off axistripod:on cross:off Box:off constantscreensize:off drawontop:off size:(10);
		pM.name = "tempMirrorPoint";

		newobj = execute("copy "+objname+";")
		newobj.name = newname;
		newobj.wirecolor = execute(objname+".wirecolor")

		origParent = newobj.parent;

		newobj.parent = pM;		-- temporary parent to nice helper aligned to world at 0,0,0
		coordsys world ( scale pM [-1, 1, 1] );	-- scale the main master -1 x
		newobj.parent = origParent;	-- and set parent back

		delete pM;		-- blow away temp helper.
		)

)



-- -----------------------------------------------------------------------------------------------


/*
 * mirrorPtHelpers() - Given a side to mirror, this duplicates and mirrors helpers
 *		across the other side and names them correctly.
 */
fn mirrorPtHelpers LR =
(
		-- figure which side is the opposite
    if (LR == "L") then
		LR2 = "R";
	else
		LR2 = "L";

	mirrorObjX ("$pt"+LR+"Leg") ("pt"+LR2+"Leg");
	mirrorObjX ("$pt"+LR+"Knee") ("pt"+LR2+"Knee");
	mirrorObjX ("$pt"+LR+"Ankle") ("pt"+LR2+"Ankle");

--	pt = execute("$pt"+LR2+"Ankle");
--	coordsys local (rotate pt (eulerangles 180 0 0) );

	mirrorObjX ("$pt"+LR+"Ball") ("pt"+LR2+"Ball");
	mirrorObjX ("$pt"+LR+"Toe") ("pt"+LR2+"Toe");

	mirrorObjX ("$pt"+LR+"2Leg") ("pt"+LR2+"2Leg");
	mirrorObjX ("$pt"+LR+"2Knee") ("pt"+LR2+"2Knee");
	mirrorObjX ("$pt"+LR+"2Ankle") ("pt"+LR2+"2Ankle");

--	pt = execute("$pt"+LR2+"2Ankle");
--	coordsys local (rotate pt (eulerangles 180 0 0) );

	mirrorObjX ("$pt"+LR+"2Ball") ("pt"+LR2+"2Ball");
	mirrorObjX ("$pt"+LR+"2Toe") ("pt"+LR2+"2Toe");


	mirrorObjX ("$pt"+LR+"Clav") ("pt"+LR2+"Clav");
	mirrorObjX ("$pt"+LR+"UpArm") ("pt"+LR2+"UpArm");
	mirrorObjX ("$pt"+LR+"LoArm") ("pt"+LR2+"LoArm");
	mirrorObjX ("$pt"+LR+"Hand") ("pt"+LR2+"Hand");
	mirrorObjX ("$pt"+LR+"HandTip") ("pt"+LR2+"HandTip");

	mirrorObjX ("$ptThumb"+LR+"1") ("ptThumb"+LR2+"1");
	mirrorObjX ("$ptThumb"+LR+"2") ("ptThumb"+LR2+"2");
	mirrorObjX ("$ptThumb"+LR+"3") ("ptThumb"+LR2+"3");
	mirrorObjX ("$ptThumb"+LR+"4") ("ptThumb"+LR2+"4");
	mirrorObjX ("$ptThumb"+LR+"Up") ("ptThumb"+LR2+"Up");

	mirrorObjX ("$ptFinger1"+LR+"1") ("ptFinger1"+LR2+"1");
	mirrorObjX ("$ptFinger1"+LR+"2") ("ptFinger1"+LR2+"2");
	mirrorObjX ("$ptFinger1"+LR+"3") ("ptFinger1"+LR2+"3");
	mirrorObjX ("$ptFinger1"+LR+"4") ("ptFinger1"+LR2+"4");

	mirrorObjX ("$ptFinger2"+LR+"1") ("ptFinger2"+LR2+"1");
	mirrorObjX ("$ptFinger2"+LR+"2") ("ptFinger2"+LR2+"2");
	mirrorObjX ("$ptFinger2"+LR+"3") ("ptFinger2"+LR2+"3");
	mirrorObjX ("$ptFinger2"+LR+"4") ("ptFinger2"+LR2+"4");

	mirrorObjX ("$ptFinger3"+LR+"1") ("ptFinger3"+LR2+"1");
	mirrorObjX ("$ptFinger3"+LR+"2") ("ptFinger3"+LR2+"2");
	mirrorObjX ("$ptFinger3"+LR+"3") ("ptFinger3"+LR2+"3");
	mirrorObjX ("$ptFinger3"+LR+"4") ("ptFinger3"+LR2+"4");

	mirrorObjX ("$ptFinger4"+LR+"1") ("ptFinger4"+LR2+"1");
	mirrorObjX ("$ptFinger4"+LR+"2") ("ptFinger4"+LR2+"2");
	mirrorObjX ("$ptFinger4"+LR+"3") ("ptFinger4"+LR2+"3");
	mirrorObjX ("$ptFinger4"+LR+"4") ("ptFinger4"+LR2+"4");

	mirrorObjX ("$ptToe1"+LR+"1") ("ptToe1"+LR2+"1");
	mirrorObjX ("$ptToe1"+LR+"2") ("ptToe1"+LR2+"2");
	mirrorObjX ("$ptToe1"+LR+"3") ("ptToe1"+LR2+"3");
	mirrorObjX ("$ptToe1"+LR+"4") ("ptToe1"+LR2+"4");
	mirrorObjX ("$ptToe"+LR+"Up") ("ptToe"+LR2+"Up");

	mirrorObjX ("$ptToe2"+LR+"1") ("ptToe2"+LR2+"1");
	mirrorObjX ("$ptToe2"+LR+"2") ("ptToe2"+LR2+"2");
	mirrorObjX ("$ptToe2"+LR+"3") ("ptToe2"+LR2+"3");
	mirrorObjX ("$ptToe2"+LR+"4") ("ptToe2"+LR2+"4");

	mirrorObjX ("$ptToe3"+LR+"1") ("ptToe3"+LR2+"1");
	mirrorObjX ("$ptToe3"+LR+"2") ("ptToe3"+LR2+"2");
	mirrorObjX ("$ptToe3"+LR+"3") ("ptToe3"+LR2+"3");
	mirrorObjX ("$ptToe3"+LR+"4") ("ptToe3"+LR2+"4");

	mirrorObjX ("$ptToe4"+LR+"1") ("ptToe4"+LR2+"1");
	mirrorObjX ("$ptToe4"+LR+"2") ("ptToe4"+LR2+"2");
	mirrorObjX ("$ptToe4"+LR+"3") ("ptToe4"+LR2+"3");
	mirrorObjX ("$ptToe4"+LR+"4") ("ptToe4"+LR2+"4");

	mirrorObjX ("$ptToe5"+LR+"1") ("ptToe5"+LR2+"1");
	mirrorObjX ("$ptToe5"+LR+"2") ("ptToe5"+LR2+"2");
	mirrorObjX ("$ptToe5"+LR+"3") ("ptToe5"+LR2+"3");
	mirrorObjX ("$ptToe5"+LR+"4") ("ptToe5"+LR2+"4");


	mirrorObjX ("$ptToe1"+LR+"21") ("ptToe1"+LR2+"21");
	mirrorObjX ("$ptToe1"+LR+"22") ("ptToe1"+LR2+"22");
	mirrorObjX ("$ptToe1"+LR+"23") ("ptToe1"+LR2+"23");
	mirrorObjX ("$ptToe1"+LR+"24") ("ptToe1"+LR2+"24");
	mirrorObjX ("$ptToe"+LR+"2Up") ("ptToe"+LR2+"2Up");

	mirrorObjX ("$ptToe2"+LR+"21") ("ptToe2"+LR2+"21");
	mirrorObjX ("$ptToe2"+LR+"22") ("ptToe2"+LR2+"22");
	mirrorObjX ("$ptToe2"+LR+"23") ("ptToe2"+LR2+"23");
	mirrorObjX ("$ptToe2"+LR+"24") ("ptToe2"+LR2+"24");

	mirrorObjX ("$ptToe3"+LR+"21") ("ptToe3"+LR2+"21");
	mirrorObjX ("$ptToe3"+LR+"22") ("ptToe3"+LR2+"22");
	mirrorObjX ("$ptToe3"+LR+"23") ("ptToe3"+LR2+"23");
	mirrorObjX ("$ptToe3"+LR+"24") ("ptToe3"+LR2+"24");

	mirrorObjX ("$ptToe4"+LR+"21") ("ptToe4"+LR2+"21");
	mirrorObjX ("$ptToe4"+LR+"22") ("ptToe4"+LR2+"22");
	mirrorObjX ("$ptToe4"+LR+"23") ("ptToe4"+LR2+"23");
	mirrorObjX ("$ptToe4"+LR+"24") ("ptToe4"+LR2+"24");

	mirrorObjX ("$ptToe5"+LR+"21") ("ptToe5"+LR2+"21");
	mirrorObjX ("$ptToe5"+LR+"22") ("ptToe5"+LR2+"22");
	mirrorObjX ("$ptToe5"+LR+"23") ("ptToe5"+LR2+"23");
	mirrorObjX ("$ptToe5"+LR+"24") ("ptToe5"+LR2+"24");

--  mirrorObjX ("$pt"+LR+"") ("pt"+LR2+"");

)

-- Rollouts --------------------------------------------------------------------------------------

rollout ro_CCcreate "Create"
(
    group "ptHelper Setup"
		(
	    button b_mirrorL "Mirror L to R" offset:[0,0] width:70 across:2;
	    button b_mirrorR "Mirror R to L" offset:[6,0] width:70;
		)

    group "Creation"
		(
		edittext et_prefix "Name: " fieldwidth:80 text:"char" width:148;
	    button b_createAll "Create ALL" width:150;
		)

    group "Legs"
		(
		button b_createRLeg "R Leg" width:73 across:2;
		button b_createLLeg "L Leg" width:73;
		checkbox cb_stretchyLegs "Stretchy Legs" checked:true align:#center;
        button b_createRToes "R Toes" width:73 across:2 ;
        button b_createLToes "L Toes" width:73;
		label lbl_TDig "Toe Digit Rotation %'s:" align:#left;
		spinner spn_TDig1 "" range:[-100,100,tDig1Mult] offset:[-2,0] fieldWidth:40 across:3;
		spinner spn_TDig2 "" range:[-100,100,tDig2Mult] offset:[0,0] fieldWidth:40 ;
		spinner spn_TDig3 "" range:[-100,100,tDig3Mult] offset:[2,0] fieldWidth:40 ;
		)

    group "Base and Body"
		(
		button b_createHips "Hips" width:150;
		button b_createPlace "Placement & Ground" width:150;
		button b_createSpine "Spine" width:150;
	    radiobuttons rb_spineType labels:#( "FK Spine","Indi-Hip", "lookAt-IK (slow)") default:2 columns:2 offset:[20,0];
		checkbox cb_spineSplineStretch "Stretchy lookAt-IK" checked:true align:#center enabled:false offset:[-7,0];
		button b_createHead "Neck & Head" width:150;
		checkbox cb_headIndep "Head is Independent" checked:true align:#center;
		)

	on et_prefix changed str do
		(
			-- store global as name but with spaces as underscores
		prefix = replaceChar str " " "_";
		)

    group "Arms"
		(
		button b_createRArm "R Arm" width:73 across:2;
		button b_createLArm "L Arm" width:73;
		checkbox cb_autoShoulders "Automatic Shoulders" offset:[0,0] checked:true align:#center;
		checkbox cb_stretchyArms "Stretchy Arms" offset:[-16,0] checked:true align:#center;
		button b_createRFingers "R Fingers" width:73 across:2;
		button b_createLFingers "L Fingers" width:73;
		label lbl_FDig "Finger Digit Rotation %'s" align:#left;
		spinner spn_FDig1 "" range:[-100,100,fDig1Mult] offset:[-2,0] fieldWidth:40 across:3;
		spinner spn_FDig2 "" range:[-100,100,fDig2Mult] offset:[0,0] fieldWidth:40 ;
		spinner spn_FDig3 "" range:[-100,100,fDig3Mult] offset:[2,0] fieldWidth:40 ;
		)

	group "CTRL Colors"
		(
		colorpicker cp_rightColor "Right:" color:rightColor across:2 fieldwidth:35 height:20;
		colorpicker cp_leftColor "Left:" color:leftColor offset:[13,0] fieldwidth:35 height:20;
		colorpicker cp_bodyColor "Body1:" color:bodyColor offset:[-5,0] across:2 fieldwidth:35 height:20;
		colorpicker cp_bodyColor2 "Body2:" color:bodyColor2 offset:[1,0] fieldwidth:35 height:20;
		colorpicker cp_headColor "Head:" color:headColor offset:[-1,0] across:2 fieldwidth:35 height:20;
		colorpicker cp_baseColor "Base:" color:baseColor offset:[7,0] fieldwidth:35 height:20;
		colorpicker cp_internalColor "Int.:" color:internalColor offset:[10,0] fieldwidth:35 height:20 across:2;
		colorpicker cp_boneColor "Bone:" color:boneColor offset:[6,0] fieldwidth:35 height:20;
		)

    on b_mirrorL pressed do
		(
		undo "charRigger: Mirror L ptHelpers" on
			(
			setWaitCursor();
			mirrorPtHelpers "L";
			setArrowCursor();
			)
		)

    on b_mirrorR pressed do
		(
		undo "charRigger: Mirror R ptHelpers" on
			(
			setWaitCursor();
			mirrorPtHelpers "R";
			setArrowCursor();
			)
		)

    on b_createAll pressed do
		(
		undo "charRigger: Create All" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createHips();
			createLeg("L");
			createLeg("L2");
			createLeg("R");
			createLeg("R2");
			createToes("L");
			createToes("L2");
			createToes("R");
			createToes("R2");
			createPlacement();
			createSpine();
			createHead();
			createArm("L");
			createArm("R");
			createFingers("L");
			createFingers("R");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

    on b_createLLeg pressed do
		(
		undo "charRigger: Create L Leg" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createHips();
			createLeg("L");
			createLeg("L2");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

    on b_createRLeg pressed do
		(
		undo "charRigger: Create R Leg" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createHips();
			createLeg("R");
			createLeg("R2");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

	on cb_stretchyLegs changed state do
		(
		stretchyLegs = state;	-- store in global variable
		)

	on b_createHips pressed do
		(
		undo "charRigger: Create Hips" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createHips();
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

	on b_createPlace pressed do
		(
		undo "charRigger: Create Placement" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createPlacement();
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

	on b_createSpine pressed do
		(
		undo "charRigger: Create Spine" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createHips();
			createSpine();
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

	on b_createHead pressed do
		(
		undo "charRigger: Create Head" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createHead();
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)


	on rb_spineType changed state do
		(
				-- 2 means indi mode
		spineIndi = (state == 2)
				-- 3 means lookAt IK
		spineSplineIK = (state == 3);
		cb_spineSplineStretch.enabled = (state == 3);	-- enable or disable lookAt stretch
		)


	on cb_spineSplineStretch changed state do
		(
		spineSplineStretch = state;
		)


	on cb_autoShoulders changed state do
		(
		autoShoulders = state;
		)

	on cb_headIndep changed state do
		(
		headIndep = state;	-- store in global variable
		)


    on b_createLArm pressed do
		(
		undo "charRigger: Create L Arm" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createArm("L");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

    on b_createRArm pressed do
		(
		undo "charRigger: Create R Arm" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createArm("R");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

	on cb_stretchyArms changed state do
		(
		stretchyArms = state;	-- store in global variable
		)

    on b_createLFingers pressed do
		(
		undo "charRigger: Create L Fingers" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createFingers("L");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

    on b_createRFingers pressed do
		(
		undo "charRigger: Create R Fingers" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createFingers("R");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

	on spn_FDig1 changed val do
		(
		fDig1Mult = val;
		)

	on spn_FDig2 changed val do
		(
		fDig2Mult = val;
		)

	on spn_FDig3 changed val do
		(
		fDig3Mult = val;
		)

	on spn_TDig1 changed val do
		(
		tDig1Mult = val;
		)

	on spn_TDig2 changed val do
		(
		tDig2Mult = val;
		)

	on spn_TDig3 changed val do
		(
		tDig3Mult = val;
		)

    on b_createLToes pressed do
		(
		undo "charRigger: Create L Toes" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createToes("L");
			createToes("L2");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)

    on b_createRToes pressed do
		(
		undo "charRigger: Create R Toes" on
			(
			max create mode;	-- this speeds it up for some reason!
			setTimeline rStart rEnd;
			setWaitCursor();
			createToes("R");
			createToes("R2");
			makeNiceSets();
			setArrowCursor();
			setTimeline 0 100;
			)
		)
	on cp_rightColor changed clr do
		(
			rightColor = clr;		-- store in global var
		)

	on cp_leftColor changed clr do
		(
			leftColor = clr;		-- store in global var
		)

	on cp_bodyColor changed clr do
		(
			bodyColor = clr;		-- store in global var
		)

	on cp_bodyColor2 changed clr do
		(
			bodyColor2 = clr;		-- store in global var
		)

	on cp_headColor changed clr do
		(
			headColor = clr;		-- store in global var
		)

	on cp_baseColor changed clr do
		(
			baseColor = clr;		-- store in global var
		)

	on cp_internalColor changed clr do
		(
			internalColor = clr;		-- store in global var
		)

	on cp_boneColor changed clr do
		(
			boneColor = clr;		-- store in global var
		)

  )  -- end of Create Rollout



rollout ro_CCabout "About"
(
	label abt_lbl1 "charRigger"
	label abt_lbl2 "Version"
	label abt_lbl3 "Built: "
	label abt_lbl4 ""
	label abt_lbl5 "by Michael B. Comet"
	label abt_lbl6 "comet@comet-cartoons.com"
	label abt_lbl7 "www.comet-cartoons.com"
	label abt_lbl7b ""
	label abt_lbl8 "Copyright 2001,2002"
	label abt_lbl9 "Michael B. Comet"
	label abt_lbl10 "All Rights Reserved."
	label abt_lbl12 ""
	on ro_CCabout open do
	(
		abt_lbl2.text = ("Version "+cRversion);
		abt_lbl3.text = ("Built: "+cRdate);
	)

)


-- Just make this thing a floater...no need for utility

ro_CCfloater = (newRolloutFloater ("charRigger "+cRversion) 200 805)
addRollout ro_CCcreate ro_CCfloater
addRollout ro_CCabout ro_CCfloater rolledUp:true




) -- end of Macroscript


