/*****************************************************
	FILE: utils.h
	DESCRIPTION: Include file for some common stuff
	Copyright (C) 2001-2003 by Vladimir Koylazov
	vkoylazov@hotmail.com

	OS SUPPORT: Win32, Linux
*****************************************************/

#pragma once
#ifndef __UTILS_H__
#define __UTILS_H__

// System-dependent include files
#include "systemstuff.h"

// Some common library include files
#include <stdio.h>
#include <float.h>

/*#ifdef __INTEL_COMPILER
#include <mathimf.h>
#else*/
#include <math.h>
//#endif

#include <stdlib.h>
#include <memory.h>
#include <malloc.h>
#include <string.h>

// Some common definitions
#include "defines.h"

// Base scalar type
BEGIN_VLADO
typedef float real;
END_VLADO

// Some common include files
#include "misc.h"
#include "vector.h"
#include "color.h"
#include "matrix.h"
#include "box.h"
#include "random.h"
#include "ray.h"

inline void* orig_malloc(size_t size) { return malloc(size); }
inline void orig_free(void *ptr) { free(ptr); }
inline void* orig_calloc(size_t num, size_t size) { return calloc(num, size); }

extern void* vutils_malloc(size_t size);
extern void vutils_free(void *ptr, const char *fileName, int lineNum);
extern void* vutils_calloc(size_t num, size_t size);
extern void checkHeap(void);

#ifdef _VUTILS_MALLOC

#define malloc(x) vutils_malloc(x)
#define free(x) vutils_free(x, __FILE__, __LINE__)
#define calloc(n,s) vutils_calloc(n,s)

#endif

inline void breakPoint(void) { *((int*)NULL)=0; }

#define vutils_assert(x) { if (!(x)) breakPoint(); }

#endif
