/*****************************************************
	FILE: 3dsMAX.h
	DESCRIPTION: For compatibility with 3D Studio MAX
	Copyright (C) 2001 by Vladimir Koylazov
	vkoylazov@hotmail.com
*****************************************************/

#pragma once
#ifndef __3DSMAX_H__
#define __3DSMAX_H__

__forceinline Point3 toPoint3(const Vlado::Vector &a) {
	return Point3(a.x, a.y, a.z);
}

__forceinline Color toColor(const Vlado::Color &a) {
	return Color(a.r, a.g, a.b);
}

__forceinline Vlado::Vector toVector(const Point3 &a) {
	return Vlado::Vector(a.x, a.y, a.z);
}

__forceinline Vlado::Color toColor(const Color &a) {
	return Vlado::Color(a.r, a.g, a.b);
}

__forceinline Vlado::Color toColor(const AColor &a) {
	return Vlado::Color(a.r, a.g, a.b);
}

__forceinline Vlado::Ray toRay(const Ray &ray) {
	return Vlado::Ray(toVector(ray.p), toVector(ray.dir));
}

__forceinline Ray toRay(const Vlado::Ray &ray) {
	Ray res;
	res.p=toPoint3(ray.p);
	res.dir=toPoint3(ray.dir);
	return res;
}

__forceinline Vlado::Transform toTransform(const Matrix3 &m) {
	Vlado::Transform tm;
	tm.m.f[0]=toVector(m.GetRow(0));
	tm.m.f[1]=toVector(m.GetRow(1));
	tm.m.f[2]=toVector(m.GetRow(2));
	tm.offs=toVector(m.GetRow(3));

	return tm;
}

__forceinline Matrix3 toMatrix3(const Vlado::Transform &m) {
	Matrix3 tm;
	tm.SetRow(0, toPoint3(m.m.f[0]));
	tm.SetRow(1, toPoint3(m.m.f[1]));
	tm.SetRow(2, toPoint3(m.m.f[2]));
	tm.SetRow(3, toPoint3(m.offs));

	return tm;
}

__forceinline Matrix3 toMatrix3(const Vlado::Matrix &m) {
	Matrix3 tm;
	tm.SetRow(0, toPoint3(m.f[0]));
	tm.SetRow(1, toPoint3(m.f[1]));
	tm.SetRow(2, toPoint3(m.f[2]));
	tm.SetRow(3, Point3(0,0,0));

	return tm;
}

__forceinline Point2 toPoint2(const Vlado::Vector2 &pt) {
	return Point2(pt.x, pt.y);
}

__forceinline Box3 toBox3(const Vlado::Box &b) {
	Box3 res;
	res.pmin=toPoint3(b.pmin);
	res.pmax=toPoint3(b.pmax);
	return res;
}

#endif