/**********************************************************************
	FILE: Table.h
	DESCRIPTION: A helper class for storing a small number of things
	Copyright (c) 2001 by Vladimir Koylazov
	vkoylazov@hotmail.com
***********************************************************************/

#ifndef __TABLE_H__
#define __TABLE_H__

BEGIN_VLADO

template<class T, int enlargeStep=100>
class Table {
	public:
		int numElements, incStep;
		int maxElements;
		T *elements;

		Table(int incStep=enlargeStep) {
			maxElements=numElements=0;
			this->incStep=incStep;
			elements=NULL;
		}
		~Table(void) { freeData(); }

		void freeData(void) {
			numElements=maxElements=0;
			if (elements) delete[] elements;
			elements=NULL;
		}

		void freeMem(void) { freeData(); }

		void clear(void) {
			numElements=0;
		}

		T *newElement(void) {
			setCount(numElements+1);
			return elements+numElements-1;
		}

		void setCount(int nelements) {
			if (nelements<=maxElements) { numElements=nelements; return; }
			maxElements=nelements+incStep-(nelements%incStep);

			T *newElements=new T[maxElements];
			for (int i=0; i<numElements; i++) newElements[i]=elements[i];

			if (elements) delete[] elements;
			elements=newElements;

			numElements=nelements;
		}

		int count(void) { return numElements; }

		T &operator[](int index) { return elements[index]; }
		void operator+=(const T &a) { *(newElement())=a; }

		void removeLast(void) { numElements--; }
		void removeLast(T &a) { a=elements[--numElements]; }
		void removeElement(int i) { elements[i]=elements[--numElements]; }
};

END_VLADO

#endif