/*****************************************************
	FILE: systemstuff.h
	DESCRIPTION: OS-specific include files and defines
	Copyright (C) 2001-2003 by Vladimir Koylazov
	vkoylazov@hotmail.com

	OS SUPPORT: Win32, Linux

*****************************************************/

#pragma once
#ifndef _SYSTEMSTUFF_H__
#define _SYSTEMSTUFF_H__

// Compiler type

#define CTG_MICROSOFT 1
#define CTG_INTEL 2
#define CTG_GCC 3

#ifdef __INTEL_COMPILER
	#define COMPILER_TYPE_GENERIC CTG_INTEL
	#define COMPILER_TYPE_SPECIFIC 0
	#define COMPILER_TYPE_TXT "Intel C++ compiler"
	#define COMPILER_VERSION __INTEL_COMPILER
#elif _MSC_VER
	#define COMPILER_TYPE_GENERIC CTG_MICROSOFT
	#define COMPILER_TYPE_SPECIFIC 0
	#define COMPILER_TYPE_TXT "Microsoft Visual C++ compiler"
	#define COMPILER_VERSION _MSC_VER
#elif defined __MINGW32__
	#define COMPILER_TYPE_GENERIC CTG_GCC
	#define COMPILER_TYPE_SPECIFIC 1
	#define COMPILER_TYPE_TXT "MinGW GCC compiler"
	#define COMPILER_VERSION 0
#elif defined __GNUC__
	#define COMPILER_TYPE_GENERIC CTG_GCC
	#define COMPILER_TYPE_SPECIFIC 0
	#define COMPILER_TYPE_TXT "A GCC-compatible compiler"
	#define COMPILER_VERSION 0
#else
	#define COMPILER_TYPE_GENERIC 0
	#define COMPILER_TYPE_SPECIFIC 0
	#define COMPILER_TYPE_TXT "An Unknown compiler"
	#define COMPILER_VERSION 0
#endif

// FORCEINLINE definition
#if defined __INTEL_COMPILER || defined _MSC_VER
	#define FORCEINLINE_SUPPORTED
	#define FORCEINLINE __forceinline
#else
	#undef FORCEINLINE
	#define FORCEINLINE inline
#endif

#ifdef _WIN32
	#ifndef _WINDOWS_
		#ifndef _WIN32_WINNT 
			#define _WIN32_WINNT 0x0410
		#elif _WIN32_WINNT < 0x0410
			#undef _WIN32_WINNT
			#define _WIN32_WINNT 0x0410
		#endif
	#else
		// #pragma message("[SystemStuff.h] Included after Windows.h")
	#endif

	// Windows
	#include <windows.h>
	#include <TCHAR.h>

	typedef TCHAR tchar;

	// _FASTCALL definition
	#define _FASTCALL __fastcall

	// vsnprintf
	#define vsnprintf _vsnprintf

	// getTickCount()
	FORCEINLINE unsigned int getTickCount(void) { return GetTickCount(); }

#elif defined __linux__ || defined unix
	#define _MULTI_THREADED
	// Linux with glibc:
	#include <unistd.h>
	#include <pthread.h>
	#include <time.h>
	#include <sys/types.h>

	// _FASTCALL definition
	#define _FASTCALL

	inline unsigned int getTickCount(void) {
		clock_t ticks=clock();
		return ticks*(1000/CLOCKS_PER_SEC);
	}

	#define _tcscat strcat
	#define _tcscpy strcpy
	#define _tcsncpy strncpy

	#define _T(x) (x)
	#define _vsntprintf vsnprintf
	#define OutputDebugString(x) fputs(x, stderr)
	
#else
	#error Not Win32 and not Unix!
#endif

// Some basic system types
#if defined _WIN32 || defined __INTEL_COMPILER

	typedef __int8 int8;
	typedef __int16 int16;
	typedef __int32 int32;
	typedef __int64 int64;

	typedef unsigned __int8 uint8;
	typedef unsigned __int16 uint16;
	typedef unsigned __int32 uint32;
	typedef unsigned __int64 uint64;

#else

	typedef int8_t int8;
	typedef int16_t int16;
	typedef int32_t int32;
	typedef int64_t int64;

	typedef u_int8_t uint8;
	typedef u_int16_t uint16;
	typedef u_int32_t uint32;
	typedef u_int64_t uint64;

#endif // _WIN32 || __INTEL_COMPILER

#if defined __linux__ || defined unix

	// TCHAR definition
	typedef char TCHAR;
	typedef char* LPSTR;
	typedef char* LPCTSTR;
	typedef char tchar;

	typedef uint8 BYTE;
	typedef uint8* LPBYTE;

	typedef uint16 WORD;
	typedef uint32 DWORD;

#endif // __linux

// This is a type big enough to hold an integer or a pointer
union int_ptr {
	int i;
	void *ptr;

	int_ptr(void) {}
	int_ptr(int a):i(a) {}
	int_ptr(void *a):ptr(a) {}

	operator int(void) { return i; }
	operator void*(void) { return ptr; }
};

#endif /* _SYSTEM_STUFF_H__ */
