#ifndef _RASTERIZER_3D__
#define _RASTERIZER_3D__

#include "utils.h"
#include "raycameras.h"

BEGIN_VLADO

// A generic class for drawing 3D objects, implementation-independent
class Rasterizer3D {
	public:
		virtual void setBufferSize(int bwidth, int bheight)=0; // Sets the drawing buffer
		// virtual void setBufferWindow(HWND hWnd)=0; // Sets the buffer from the given window
		// virtual void showBuffer(HDC hdc)=0; // Shows the drawn buffer

		virtual void setBackground(const Color &bgColor)=0; // Sets the current background
		void clearBackground(void);

		virtual void setCamera(Camera &camera)=0; // Sets the current view camera

		virtual void drawLine(Vector &p0, Vector &p1, const Color &color)=0; // Draws a line in 3D
		virtual void drawShadedLine(Vector &p0, Vector &p1, Vector &n0, Vector &n1, const Color &color)=0;
		virtual void drawShadedTriangle(Vector &p0, Vector &p1, Vector &p2, Vector &n0, Vector &n1, Vector &n2, const Color &color)=0;
};

END_VLADO

#endif
