/*****************************************************
	FILE: Misc.h
	DESCRIPTION: Various utility functions
	Copyright (C) 2001 by Vladimir Koylazov
	vkoylazov@hotmail.com

	OS SUPPORT: Win32, Linux
*****************************************************/
#ifndef __MISC_H__
#define __MISC_H__

BEGIN_VLADO

inline void debug(const tchar *format, ...) {
	char buf[512];

	va_list args;
	va_start(args,format);
	vsnprintf(buf, 511, (tchar*) format, args);
	va_end(args);

	OutputDebugString(buf);
}

// The pi constant; this is a function, since it conflicted with some OpenGL include file
FORCEINLINE real pi(void) { return real(3.1415926535897932384626433832795); }

#define LARGE_FLOAT (1e18f)
#define VERY_LARGE_FLOAT (1e30f)

// Returns 1 is x is negative, and 0 otherwise
/*
FORCEINLINE int is_negative(float x) {
	return *((unsigned int *) &x)>>31;
}

FORCEINLINE int is_negative(double x) {
	return ((unsigned int *) &x)[1]>>31;
}

FORCEINLINE int is_less(float a, float b) { return is_negative(a-b); }
FORCEINLINE int is_less_eq(float a, float b) { return 1-is_negative(b-a); }
FORCEINLINE int is_greater(float a, float b) { return is_negative(b-a); }
FORCEINLINE int is_greater_eq(float a, float b) { return 1-is_negative(a-b); }
FORCEINLINE int is_between(float x, float a, float b) { return is_negative((x-a)*(x-b)); }
*/
/*
extern int fast_round(float x);
extern int fast_floor(float x);
FORCEINLINE int fast_ceil(float x) { return -fast_floor(-x); }
FORCEINLINE int fast_trunc(float x) { return (x>=0.0f)? fast_floor(x) : fast_ceil(x); }
extern float fast_log2(float x);
extern float fast_pow_pos(float x, float power);

extern int fast_round(double x);
extern int fast_floor(double x);
FORCEINLINE int fast_ceil(double x) { return -fast_floor(-x); }
FORCEINLINE int fast_trunc(double x) { return (x>=0.0f)? fast_floor(x) : fast_ceil(x); }
extern double fast_log2(double x);
extern double fast_pow_pos(double x, double power);
*/

// Truncates the fractional part of the given number
FORCEINLINE int fast_trunc(float x) { return int(x); }
FORCEINLINE int fast_trunc(double x) { return int(x); }

// Returns the largest integer smaller than or equal to the given number
FORCEINLINE int fast_floor(float x) { return int(x)-(x<int(x)); }
FORCEINLINE int fast_floor(double x) { return int(x)-(x<int(x)); }

// Returns the smallest integer greater than or equal to the given number
FORCEINLINE int fast_ceil(float x) { return int(x)+(int(x)<x); }
FORCEINLINE int fast_ceil(double x) { return int(x)+(int(x)<x); }

FORCEINLINE unsigned int fast_ceil_pos(float x) { return int(x); }

FORCEINLINE float fast_pow_pos(float x, float power) { return powf(x, power); }
FORCEINLINE float fast_log2(float x) { return logf(x); }

template<class T> FORCEINLINE T Max(const T& a, const T& b) { return (a>b)? a:b; }
template<class T> FORCEINLINE T Min(const T& a, const T& b) { return (a<b)? a:b; }

template<class T> inline T Max(T a, T b, T c) {
	if (a>b) return (a>c)? a : c;
	else return (b>c)? b : c;
}

template<class T> inline T Min(T a, T b, T c) {
	if (a<b) return (a<c)? a : c;
	else return (b<c)? b : c;
}
template<class T> inline T Max(T a, T b, T c, T d) {
	if (b>a) a=b;
	if (c>a) a=c;
	if (d>a) a=d;
	return a;
}

template<class T> inline T Min(T a, T b, T c, T d) {
	if (b<a) a=b;
	if (c<a) a=c;
	if (d<a) a=d;
	return a;
}

/// Clamps a number within a range.
/// @param x The number to clamp.
/// @param a The lower bound.
/// @param b The upper bound.
/// @return If x is between a and b, the return value is x. If x is below a, the return value is a. If x is above b, the return value is b. Otherwise (f.e. NaN), the return value is a.
template<class T>
FORCEINLINE T clamp(T x, T a, T b) {
	if (x>b) return b;
	if (x>a) return x;
	return a;
}

template<class T>
FORCEINLINE T sign(T x) {
	if (x<0.0f) return T(-1);
	if (x>0.0f) return T(1);
	return T(0);
}

template<class T>
FORCEINLINE void swap(T &a, T &b) {
	T t=a;
	a=b;
	b=t;
}

template<class T>
FORCEINLINE T sqr(T a) { return a*a; }

template<class T>
FORCEINLINE T cube(T a) { return a*a*a; }

template<class T>
FORCEINLINE void nudge(T &xmin, T &xmax, float x) {
	if (x<xmin) xmin=x;
	if (x>xmax) xmax=x;
}

// This function interpolates between a and b depending on the value of x
FORCEINLINE float interpolate(float x, float a, float b) { return a*(1.0f-x)+x*b; }
FORCEINLINE double interpolate(double x, double a, double b) { return a*(1.0f-x)+x*b; }

// Some faster logical functions

// p_or returns non-zero if at least one of the arguments is non-zero
FORCEINLINE int p_or(int a, int b) { return a | b; }
FORCEINLINE int p_or(int a, int b, int c) { return a | b | c; }
FORCEINLINE int p_or(int a, int b, int c, int d) { return a | b | c | d; }
FORCEINLINE int p_or(int a, int b, int c, int d, int e) { return a | b | c | d | e; }
FORCEINLINE int p_or(int a, int b, int c, int d, int e, int f) { return a | b | c | d | e | f; }
FORCEINLINE int p_or(int a, int b, int c, int d, int e, int f, int g) { return a | b | c | d | e | f | g; }

// p_and returns non-zero if both arguments are non-zero
FORCEINLINE int p_and(int a, int b) { return ~((~a)|(~b)); }
FORCEINLINE int p_and(int a, int b, int c) { return ~((~a)|(~b)|(~c)); }
FORCEINLINE int p_and(int a, int b, int c, int d) { return ~((~a)|(~b)|(~c)|(~d)); }
FORCEINLINE int p_and(int a, int b, int c, int d, int e) { return ~((~a)|(~b)|(~c)|(~d)|(~e)); }
FORCEINLINE int p_and(int a, int b, int c, int d, int e, int f) { return ~((~a)|(~b)|(~c)|(~d)|(~e)|(~f)); }
FORCEINLINE int p_and(int a, int b, int c, int d, int e, int f, int g) { return ~((~a)|(~b)|(~c)|(~d)|(~e)|(~f)|(~g)); }

// p_not returns zero, if the argument is non-zero, and non-zero otherwise
FORCEINLINE int p_not(int a) { return a? 0 : 1; }

// p_bool returns zero if the argument is zero, and ONE otherwise
FORCEINLINE int p_bool(int a) { return a? 1 : 0; }

// This returns a if k==0 and b if k==1
// Essentially this is the same as interpolate
/*
FORCEINLINE float select(int k, float a, float b) {
	return k? a : b;
}

/*
float Min<float>(const float &a, const float &b) {
	return select(is_negative(b-a), a, b);
}

float Max<float>(const float &a, const float &b) {
	return select(is_negative(a-b), a, b);
}

float clamp<float>(float x, float a, float b) {
	return Min(Max(x, a), b);
}

int Min<int>(const int &a, const int &b) {
	int k=(b-a)>>31;
	return (a&(~k))|(b&k);
}

int Max<int>(const int &a, const int &b) {
	int k=(a-b)>>31;
	return (a&(~k))|(b&k);
}

double Min<double>(const double &a, const double &b) {
	return (a<b)? a : b;
}

double Max<double>(const double &a, const double &b) {
	return (a>b)? a : b;
}
*/

END_VLADO

#endif
