#include "Headers.h"
#include "resource.h"
#include "Utils.h"
#include "VertexGroup.h"
#include "SimClothModifier.h"
#include "SimClothToMax.h"

extern INT_PTR CALLBACK aboutDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern SimCloth3ClassDesc simCloth3ClassDesc;

//**************************************************************
// subobject methods - from BaseObject
INT_PTR CALLBACK subobjDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	static IParamMap2 *groupParams=NULL;
	static bool inEditBox=false;

	SimCloth3 *mod=(SimCloth3*) GetWindowLongPtr(hWnd, GWLP_USERDATA);
	switch (message) {
		case WM_INITDIALOG: {
			SetWindowLongPtr(hWnd, GWLP_USERDATA, lParam);

			HWND lbox=GetDlgItem(hWnd, lb_SELSETS);
			mod=(SimCloth3*) lParam;
			mod->listGroups(lbox);
			SendMessage(lbox, LB_SETCURSEL, (WPARAM) -1, 0);

			groupParams=NULL;
			inEditBox=false;
			return TRUE;
		}
		case WM_DESTROY:
			if (groupParams) DestroyCPParamMap2(groupParams);
			return TRUE;
		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDOK: {
					if (inEditBox) {
						if (!mod) break;
						HWND lbox=GetDlgItem(hWnd, lb_SELSETS);
						int idx=SendMessage(lbox, LB_GETCURSEL, 0, 0);

						TCHAR name[1024];
						SendMessage(lbox, LB_GETTEXT, idx, (LPARAM) name);
						VertexGroup *group=mod->selectGroup(name);

						TCHAR newName[1024];

						HWND editBox=GetDlgItem(hWnd, ed_CURSEL);
						GetWindowText(editBox, newName, 1024);
						if (group) group->setName(newName);

						mod->listGroups(lbox);

						idx=SendMessage(lbox, LB_FINDSTRINGEXACT, (WPARAM) -1, (LPARAM) newName);
						SendMessage(lbox, LB_SETCURSEL, idx, 0);
					}
					break;
				}
				case bn_NEWGROUP: {
					if (!mod) break;
					TCHAR name[1024];

					HWND lbox=GetDlgItem(hWnd, lb_SELSETS);
					int cnt=0;
					TCHAR str[50];
					do {
						cnt++;
						sprintf(str, "%02i", cnt);
						_tcscpy(name, "group_");
						_tcscat(name, str);
						int idx=SendMessage(lbox, LB_FINDSTRINGEXACT, (WPARAM) -1, (LPARAM) name);
						if (idx==LB_ERR) break;
					} while (1);

					int idx=SendMessage(lbox, LB_FINDSTRINGEXACT, (WPARAM) -1, (LPARAM) name);

					mod->setGroup(name);
					mod->listGroups(lbox);

					SendMessage(lbox, LB_SETCURSEL, (WPARAM) -1, 0);
					break;
				}
				case bn_SETGROUP: {
					if (!mod) break;
					TCHAR name[1024];

					HWND lbox=GetDlgItem(hWnd, lb_SELSETS);
					int idx=SendMessage(lbox, LB_GETCURSEL, 0, 0);

					if (idx!=LB_ERR) {
						SendMessage(lbox, LB_GETTEXT, idx, (LPARAM) name);
						mod->setGroup(name);
					}

					break;
				}
				case bn_DELGROUP: {
					if (!mod) break;
					HWND lbox=GetDlgItem(hWnd, lb_SELSETS);
					int idx=SendMessage(lbox, LB_GETCURSEL, 0, 0);

					TCHAR name[1024];
					SendMessage(lbox, LB_GETTEXT, idx, (LPARAM) name);
					mod->delGroup(name);
					mod->listGroups(lbox);

					if (groupParams) DestroyCPParamMap2(groupParams);
					groupParams=NULL;

					SendMessage(lbox, LB_SETCURSEL, (WPARAM) -1, 0);

					HWND ebox=GetDlgItem(hWnd, ed_CURSEL);
					SetWindowText(ebox, _T(""));

					break;
				}
				case ed_CURSEL: {
					int notifyCode = HIWORD(wParam);
					switch (notifyCode) {
						case EN_SETFOCUS:
							DisableAccelerators();
							inEditBox=true;
							break;
						case EN_KILLFOCUS:
							EnableAccelerators();
							inEditBox=false;
							break;
					}
					break;
				}
				case lb_SELSETS: {
					int notifyCode = HIWORD(wParam);
					switch (notifyCode) {
						case LBN_SETFOCUS:
							break;
						case LBN_KILLFOCUS:
							break;
						case LBN_SELCHANGE: {
							if (!mod) break;
							HWND lbox=GetDlgItem(hWnd, lb_SELSETS);
							int idx=SendMessage(lbox, LB_GETCURSEL, 0, 0);

							TCHAR name[1024];
							SendMessage(lbox, LB_GETTEXT, idx, (LPARAM) name);
							VertexGroup *group=mod->selectGroup(name);

							HWND ebox=GetDlgItem(hWnd, ed_CURSEL);
							SetWindowText(ebox, name);

							if (!group) {
								if (groupParams) DestroyCPParamMap2(groupParams);
								groupParams=NULL;
							} else {
								IParamBlock2 *pblock=group->pblock;
								if (groupParams) groupParams->SetParamBlock(pblock);
								else groupParams=CreateCPParamMap2(pblock,
									mod->ip, hInstance,
									(TCHAR*) IDD_GROUP, GetString(IDS_PARAMS_GROUP), 0, NULL);
							}

							break;
						}
					}
					break;
				}
			}
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}

void SimCloth3::ActivateSubobjSel(int level, XFormModes& modes) {
	modes=XFormModes(NULL,NULL,NULL,NULL,NULL,selectMode);

	switch (level) {
		case 0: {
			simCloth3ClassDesc.BeginEditParams(ip, this, 0, NULL);
			if (subobjWnd) ip->DeleteRollupPage(subobjWnd);
			subobjWnd=NULL;
			if (!aboutWnd) aboutWnd=ip->AddRollupPage(hInstance, MAKEINTRESOURCE(IDD_ABOUT), aboutDlgProc, GetString(IDS_PARAMS_ABOUT), 0, APPENDROLL_CLOSED);
			break;
		}
		case 1: {
			if (!subobjWnd) {
				simCloth3ClassDesc.EndEditParams(ip, this, END_EDIT_REMOVEUI, NULL);
				if (aboutWnd) ip->DeleteRollupPage(aboutWnd);
				aboutWnd=NULL;

				subobjWnd=ip->AddRollupPage(hInstance, (TCHAR*) IDD_SUBOBJ, subobjDlgProc, GetString(IDS_PARAMS_SUBOBJ), (LPARAM) this);
			}
			break;
		}
	}

	NotifyDependents(FOREVER, PART_DISPLAY, REFMSG_CHANGE);
	ip->RedrawViews(ip->GetTime());
}

void SimCloth3::GetWorldBoundBox(TimeValue t, INode* inode, ViewExp *vpt, Box3& box, ModContext *mc) {
	if (!mc || !mc->localData) return;
	if (editMod!=this || subobjWnd==NULL) return;

	SimClothLocalData *ld=(SimClothLocalData*) mc->localData;

	EnterCriticalSection(&ld->csect);

	if (!ld->cachedMesh) {
		LeaveCriticalSection(&ld->csect);
		return;
	}

	Matrix3 tm=inode->GetObjectTM(t);
	box=ld->cachedMesh->getBoundingBox(&tm);

	LeaveCriticalSection(&ld->csect);
}

int SimCloth3::Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc) {
	if (!(flagst & DISP_SHOWSUBOBJECT) || subobjWnd==NULL) return 0;
	if (!mc || !mc->localData) return 0;

	SimClothLocalData *ld=(SimClothLocalData*) mc->localData;

	EnterCriticalSection(&ld->csect);

	Mesh *mesh=ld->cachedMesh;
	if (!mesh) {
		LeaveCriticalSection(&ld->csect);
		return 0;
	}

	// Set up GW
	GraphicsWindow *gw = vpt->getGW();
	Matrix3 tm = inode->GetObjectTM(t);
	int savedLimits;
	gw->setRndLimits((savedLimits = gw->getRndLimits()) & ~GW_ILLUM);
	gw->setTransform(tm);

	// We need to draw a "gizmo" version of the mesh:
	Point3 colSel=GetSubSelColor();
	Point3 colTicks=GetUIColor (COLOR_VERT_TICKS);
	Point3 colGiz=GetUIColor(COLOR_GIZMOS);
	Point3 colGizSel=GetUIColor(COLOR_SEL_GIZMOS);
	gw->setColor (LINE_COLOR, colGiz);

	int n=min(mesh->numVerts, numPts);
	for (int i=0; i<n; i++) {
		Point3 &pt=mesh->verts[i];

		if (selPts[i]) gw->setColor (LINE_COLOR, colSel);
		else gw->setColor (LINE_COLOR, colTicks);

		if(getUseVertexDots()) gw->marker(&pt, getVertexDotType() ? DOT_MRKR : SM_DOT_MRKR);
		else gw->marker(&pt, PLUS_SIGN_MRKR);
	}

	LeaveCriticalSection(&ld->csect);

	gw->setRndLimits(savedLimits);
	return 1;
}

int SimCloth3::HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt, ModContext* mc) {
	if (!mc || !mc->localData) return 0;
	SimClothLocalData *ld=(SimClothLocalData*) mc->localData;

	EnterCriticalSection(&ld->csect);

	Mesh *mesh=ld->cachedMesh;
	if (!mesh) {
		LeaveCriticalSection(&ld->csect);
		return 0;
	}

	// the following code is taken from the MeshSelect code
	Interval valid;
	int savedLimits, res = 0;
	GraphicsWindow *gw = vpt->getGW();
	HitRegion hr;
	
	// setup GW
	MakeHitRegion(hr,type, crossing,4,p);
	gw->setHitRegion(&hr);
	Matrix3 mat = inode->GetObjectTM(t);
	gw->setTransform(mat);	
	gw->setRndLimits(((savedLimits = gw->getRndLimits()) | GW_PICK) & ~GW_ILLUM);
	/*if (ignoreBackfaces)*/ gw->setRndLimits(gw->getRndLimits() |  GW_BACKCULL);
	// else gw->setRndLimits(gw->getRndLimits() & ~GW_BACKCULL);
	gw->clearHitCode();
		
	SubObjHitList hitList;
	MeshSubHitRec *rec;	

	res=mesh->SubObjectHitTest(gw, NULL/*gw->getMaterial()*/, &hr, /*flags |*/SUBHIT_VERTS, hitList, 0);

	rec=hitList.First();
	while (rec) {
		vpt->LogHit(inode, mc, rec->dist, rec->index, NULL);
		rec=rec->Next();
	}

	LeaveCriticalSection(&ld->csect);

	gw->setRndLimits(savedLimits);	
	return res;	
}

void SimCloth3::SelectSubComponent(HitRecord *hitRec, BOOL selected, BOOL all, BOOL invert) {
	if (!selPts) return;

	HitRecord *rec=hitRec;
	do {
		ModContext *mc=rec->modContext;
		if (!mc || !mc->localData) continue;
		SimClothLocalData *ld=(SimClothLocalData*) mc->localData;

		int idx=rec->hitInfo;
		if (idx>=0 && idx<numPts) {
			if (invert || !all) selPts[idx]=selPts[idx]? 0:1;
			else selPts[idx]=selected? 1:0;
		}

		if (!all) break;
		rec=rec->Next();
	} while (rec);

	NotifyDependents(FOREVER, PART_SELECT, REFMSG_CHANGE);
}

void SimCloth3::GetSubObjectCenters(SubObjAxisCallback *cb,TimeValue t,INode *node,ModContext *mc) {
}

void SimCloth3::GetSubObjectTMs(SubObjAxisCallback *cb,TimeValue t,INode *node,ModContext *mc) {
}

void SimCloth3::ClearSelection(int selLevel) {
	if (selLevel==1) {
		for (int i=0; i<numPts; i++) selPts[i]=false;
		NotifyDependents(FOREVER, PART_SELECT, REFMSG_CHANGE);
	}
}

void SimCloth3::SelectAll(int selLevel) {
	if (selLevel==1) {
		for (int i=0; i<numPts; i++) selPts[i]=true;
		NotifyDependents(FOREVER, PART_SELECT, REFMSG_CHANGE);
	}
}

void SimCloth3::InvertSelection(int selLevel) {
	if (selLevel==1) {
		for (int i=0; i<numPts; i++) selPts[i]=!selPts[i];
		NotifyDependents(FOREVER, PART_SELECT, REFMSG_CHANGE);
	}
}

int SimCloth3::SubObjectIndex(HitRecord *hitRec) {
	return hitRec->hitInfo;
}

//**************************************************************
// Group management
void SimCloth3::listGroups(HWND lbox) {
	SendMessage(lbox, LB_RESETCONTENT, 0,0);
	SendMessage(lbox, LB_SETCURSEL, 0,0);

	for (int i=0; i<groups.Count(); i++) {
		TCHAR *name=groups[i]->getName();
		int idx=SendMessage(lbox, LB_FINDSTRINGEXACT, (WPARAM) -1, (LPARAM) name);
		if (idx==LB_ERR) SendMessage(lbox, LB_ADDSTRING,0,(LPARAM) name);
	}

	SendMessage(lbox, LB_SETCURSEL, 0, 0);
}

void SimCloth3::setGroup(TCHAR *name) {
	bool found=false;
	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		if (_tcscmp(group.getName(), name)==0) {
			found=true;
			group.setSelected(numPts, selPts);
		}
	}

	if (!found) {
		VertexGroup *group=(VertexGroup*) CreateInstance(REF_MAKER_CLASS_ID, VERTEXGROUP_CLASS_ID);
		group->setName(name);
		group->setSelected(numPts, selPts);

		int idx=groups.Count();
		groups.SetCount(idx+1);

		MakeRefByID(FOREVER, REFNO_GROUPS+idx, group);
		NotifyDependents(FOREVER, PART_ALL, REFMSG_SUBANIM_STRUCTURE_CHANGED);
	}
}

VertexGroup *SimCloth3::selectGroup(TCHAR *name) {
	VertexGroup *res=NULL;
	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		if (_tcscmp(group.getName(), name)==0) {
			setSelected(group.numPts, group.selected);
			res=&group;
		}
	}

	NotifyDependents(FOREVER, PART_DISPLAY, REFMSG_CHANGE);
	ip->RedrawViews(ip->GetTime());

	return res;
}

void SimCloth3::delGroup(TCHAR *name) {
	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		if (_tcscmp(group.getName(), name)==0) {
			group.freeData();
			ReplaceReference(REFNO_GROUPS+i, NULL);
			groups.Delete(i, 1);
			ClearSelection(1);
		}
	}
}

void SimCloth3::setSelected(int n, unsigned char *s) {
	if (n!=numPts && selPts) { delete[] selPts; selPts=NULL; }
	if (!selPts) selPts=new unsigned char[n];
	numPts=n;
	memcpy(selPts, s, sizeof(s[0])*numPts);
}

int SimCloth3::getVertexCollide(int index) {
	int res=true;
	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		if (!group.collide && group.selected[index]) {
			res=false;
			break;
		}
	}
	return res;
}

int SimCloth3::getVertexSelfCollide(int index) {
	int res=true;
	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		if (!group.selfCollide && group.selected[index]) {
			res=false;
			break;
		}
	}
	return res;
}

int SimCloth3::getVertexCheckIntersections(int index) {
	int res=true;
	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		if (!group.checkIntersections && group.selected[index]) {
			res=false;
			break;
		}
	}
	return res;
}

void SimCloth3::beginSimulation(TimeValue t, SimClothObject *scObj) {
	for (int i=0; i<groups.Count(); i++) groups[i]->beginSimulation(t, scObj);
}

void SimCloth3::endSimulation(void) {
	for (int i=0; i<groups.Count(); i++) groups[i]->endSimulation();
}

void SimCloth3::updateSimulation(TimeValue t, SimClothObject *scObj) {
	for (int i=0; i<groups.Count(); i++) groups[i]->updateSimulation(t, scObj);
}

int SimCloth3::getAttachPos(int index, Vlado::Vector &p) {
	int res=false;

	for (int i=0; i<groups.Count(); i++) {
		VertexGroup &group=(*groups[i]);
		res=group.getAttachPos(index, p);
		if (res) break;
	}

	return res;
}
