/********************************************************
	FILE: SimClothCache.h
	DESCRIPTION: Header file for the simcloth modifier animation cache
	CREATED: 1 December 2002
	AUTHOR: Vladimir Koylazov
	Copyright (C) by Vladimir Koylazov (Vlado)

	HISTORY:

*********************************************************/

#ifndef __SIMCLOTHCACHE_H__
#define __SIMCLOTHCACHE_H__

class SimClothKey {
	public:
		TimeValue time;
		int numPoints;
		Point3 *points;

		SimClothKey(void) {}
		~SimClothKey(void) {}

		void init(void) {
			numPoints=0;
			points=NULL;
		}

		void init(SimClothKey &key) {
			time=key.time;
			numPoints=key.numPoints;
			points=new Point3[numPoints];
			memcpy(points, key.points, numPoints*sizeof(Point3));
		}

		void freeData(void) {
			if (points) delete[] points;
			points=NULL;
			numPoints=0;
		}

		IOResult save(ISave *isave) {
			ULONG nwr;
			IOResult res;

			res=isave->Write(&time, sizeof(time), &nwr);
			res=isave->Write(&numPoints, sizeof(numPoints), &nwr);
			res=isave->Write(points, sizeof(Point3)*numPoints, &nwr);

			return res;
		}

		IOResult load(ILoad *iload) {
			ULONG nrd;
			IOResult res;

			res=iload->Read(&time, sizeof(time), &nrd);
			res=iload->Read(&numPoints, sizeof(numPoints), &nrd);

			points=new Point3[numPoints];
			res=iload->Read(points, sizeof(Point3)*numPoints, &nrd);

			return res;
		}
};

class SimClothCache {
	public:
		Vlado::Table<SimClothKey> keys;

		SimClothCache(void) {
		}

		~SimClothCache(void) {
			freeData();
		}

		void init(void) {
		}

		void init(SimClothCache &cache) {
			for (int i=0; i<cache.keys.count(); i++) {
				SimClothKey *key=keys.newElement();
				key->init(cache.keys[i]);
			}
		}

		void freeData(void) {
			for (int i=0; i<keys.count(); i++) {
				keys[i].freeData();
			}
			keys.freeData();
		}

		SimClothKey *getKey(TimeValue t) {
			for (int i=0; i<keys.count(); i++) {
				if (keys[i].time==t) return &(keys[i]);
			}
			return NULL;
		}

		IOResult save(ISave *isave) {
			ULONG nwr;
			int numKeys=keys.count();
			IOResult res=isave->Write(&numKeys, sizeof(numKeys), &nwr);
			for (int i=0; i<numKeys; i++) res=keys[i].save(isave);
			return res;
		}

		IOResult load(ILoad *iload) {
			freeData();

			ULONG nrd;
			int numKeys;
			IOResult res=iload->Read(&numKeys, sizeof(numKeys), &nrd);
			for (int i=0; i<numKeys; i++) {
				SimClothKey *newKey=keys.newElement();
				res=newKey->load(iload);
			}
			return res;
		}
};

#endif