#include <malloc.h>

#ifdef _USE_SSE

#ifdef __INTEL_COMPILER

void *operator new(size_t nbytes) {
	return _mm_malloc(nbytes, 16);
}

void operator delete(void *p) {
	_mm_free(p);
}

#else

void *operator new(size_t nbytes) {
	return _aligned_malloc(nbytes, 16);
}

void operator delete(void *p) {
	_aligned_free(p);
}

#endif

#endif