#ifndef __SCFORCES_H__
#define __SCFORCES_H__

#include "ClothForces.h"

BEGIN_VLADO

class SpringsArray {
	float *ks;
	float *kd;
	float *restLen;

	int useSSE;

	int numSprings;
	int idx;

	void doSprings4(int i);
	void doSprings1(int i);

public:
	float *scale;
	ClothParticle **p0, **p1;

	SpringsArray(void) {
		ks=kd=restLen=scale=NULL;
		p0=p1=NULL;
		idx=numSprings=0;
	}

	~SpringsArray(void) { freeMem(); }

	void freeMem(void);
	void setCount(int count, int useSSE);
	void addSpring(ClothParticle &p0, ClothParticle &p1, float ks, float kd);
	void applyForces(void);

	int count(void) { return idx; }
};

class BendsArray {
	ForceTriplet **tri0, **tri1;
	float *ks;
	float *kd;
	float *restLen;
	Matrix *Imat;

	int useSSE;
	int method;

	int numBends;
	int idx;

	void doBends4(int i);
	void doBends1(int i);

public:
	ClothParticle **parts;

	BendsArray(void) {
		ks=kd=NULL;
		tri0=tri1=NULL;
		parts=NULL;
		restLen=NULL;
		Imat=NULL;
		idx=numBends=0;
	}

	~BendsArray(void) { freeMem(); }

	void freeMem(void);
	void setCount(int count, int useSSE, int oldMethod);
	void addBend(ClothParticle &p0, ClothParticle &p1, ClothParticle &p2, ClothParticle &p3, ForceTriplet &t0, ForceTriplet &t1, float ks, float kd);
	void applyForces(void);

	int count(void) { return idx; }
};

END_VLADO

#endif