#ifndef _THREADS_WIN32_H_
#define _THREADS_WIN32_H_

#ifndef _WIN32
#	error This file is for Win32 platform only
#else

#define MAX_THREADS 8

BEGIN_VLADO

class CriticalSection {
public:
	CRITICAL_SECTION csect;

	CriticalSection(void) { InitializeCriticalSection(&csect); }
	~CriticalSection(void) { DeleteCriticalSection(&csect); }

	void enter(void) { EnterCriticalSection(&csect); }
	void leave(void) { LeaveCriticalSection(&csect); }
	// int tryEnter(void) { return TryEnterCriticalSection(&csect); }
};

// A simple variable with locked increment and decrement
class InterlockedCounter {
public:
	volatile long counter;

	long increment(void) { return InterlockedIncrement(&counter); }
	long decrement(void) { return InterlockedDecrement(&counter); }

	void clear(void) { counter=0; }
	void set(long i) { counter=i; }
	long get(void) { return counter; }

	long operator++(int) { return increment(); }
	long operator--(int) { return decrement(); }
};

class DoneEvent {
	friend class ThreadManager;
	CriticalSection csect;

	int count;
	HANDLE handle;
public:

	DoneEvent(void) {
		handle=NULL;
		count=0;
	}

	~DoneEvent(void) {
		if (handle) CloseHandle(handle);
	}

	// Sets the number of threads to be waited for; returns cnt if
	// the count was set, zero otherwise
	int setCount(int cnt) {
		csect.enter();
		if (count) { csect.leave(); return 0; }
		if (!handle) handle=CreateEvent(NULL, TRUE, FALSE, NULL);
		count=cnt;
		csect.leave();

		ResetEvent(handle);

		return cnt;
	}

	// Decrements the counter by one when a thread is finished
	// If the counter becomes zero, releases the waiting thread
	void decCount(void) {
		csect.enter();
		count--;
		int newCount=count;
		csect.leave();

		if (newCount==0) SetEvent(handle);
	}

	int wait(int waitInterval) { return WaitForSingleObject(handle, waitInterval); }
	int waitEvents(int waitInterval) { return MsgWaitForMultipleObjects(1, &handle, FALSE, waitInterval, QS_ALLINPUT); }
};

class ThreadLocalStorage {
public:
	DWORD index;

	ThreadLocalStorage(void) { index=TlsAlloc(); }
	~ThreadLocalStorage(void) { TlsFree(index); }

	void set(void *ptr) { TlsSetValue(index, ptr); }
	void* get(void) { return TlsGetValue(index); }
};

class SystemInfo {
public:
	int numProcessors;

	SystemInfo(void) {
		SYSTEM_INFO systemInfo;
		GetSystemInfo(&systemInfo);
		numProcessors=systemInfo.dwNumberOfProcessors;
	}
};

END_VLADO

#endif

#endif
