/*****************************************************
	FILE: systemstuff.h
	DESCRIPTION: OS-specific include files and defines
	Copyright (C) 2001-2003 by Vladimir Koylazov
	vkoylazov@hotmail.com

	OS SUPPORT: Win32, Linux

*****************************************************/
#ifndef _SYSTEMSTUFF_H__
#define _SYSTEMSTUFF_H__

#	ifdef _WIN32
		// Windows
#		include <windows.h>
#		include <TCHAR.h>

		// _FASTCALL definition
#		define _FASTCALL __fastcall

		// getTickCount()
		__forceinline unsigned int getTickCount(void) {
			return GetTickCount();
		}

		// vsnprintf
#		define vsnprintf _vsnprintf

		// INLINE definition
		// __forceinline is supported by both the Microsoft and the Intel compilers
		// it's doubtful if it has any effect with the Intel compiler though
#		define INLINE __forceinline

#	endif /* _WIN32 */

#	ifdef __linux__

		// Linux with glibc:
#		include <unistd.h>
#		include <pthread.h>
#		include <time.h>

		// TCHAR definition
		typedef char TCHAR;
		typedef char* LPCTSTR;

		// _FASTCALL definition
#		define _FASTCALL

		// _FORCEINLINE definition
#		ifdef __INTEL_COMPILER
#			define INLINE __forceinline
#		else
#			define INLINE inline
#		endif

		inline unsigned int getTickCount(void) {
			timespec ctime;
			clock_gettime(CLOCK_REALTIME, &ctime);
			return ctime.tv_sec*1000+ctime.tv_nsec/1000000;
		}

#	endif /* __linux__ */

// Some basic system types
#	if defined _WIN32 || defined __INTEL_COMPILER
		typedef __int8 int8;
		typedef __int16 int16;
		typedef __int32 int32;
		typedef __int64 int64;

		typedef unsigned __int8 uint8;
		typedef unsigned __int16 uint16;
		typedef unsigned __int32 uint32;
		typedef unsigned __int64 uint64;
#	else
#		include <sys/types.h>

		typedef int8_t int8;
		typedef int16_t int16;
		typedef int32_t int32;
		typedef int64_t int64;

		typedef u_int8_t uint8;
		typedef u_int16_t uint16;
		typedef u_int32_t uint32;
		typedef u_int64_t uint64;
#	endif

#endif /* _SYSTEM_STUFF_H__ */
