/******************************************************************************
	FILE: random.h
	DESCRIPTION: A random number generator; based on modified srand48
	STARTED: 11 July 1999
	Copyright (C) 1999-2001 by Vladimir Koyalzov
	vkoylazov@hotmail.com

	OS SUPPORT: Win32, Linux
*******************************************************************************/
#ifndef __RANDOM_H__
#define __RANDOM_H__

BEGIN_VLADO

class Random {
	public:
		uint64 randSeed;

		Random(void) {};
		Random(int seed) { setSeed(seed); }

		// generate the next seed from the current one
		void nextSeed(void) {
			randSeed=(randSeed*0x5DEECE66D+0xB);
			double sn=sin(double(randSeed>>16));
			randSeed+=*((uint32*) (((int8*) &sn)+1));
			randSeed&=0xFFFFFFFFFFFF;
			/*
			randSeed=randSeed*0x12345671+0xFCB234D1;
			double sn=sin(float(randSeed>>32));
			randSeed+=*((uint32*) (((int8*) &sn)+1));
			*/
		}

		// generate a floating-point number in the range [0,1) from the current seed
		real getFloat(void) {
			return real(randSeed>>18)/real(1<<30);
			// return real(randSeed>>34)/real(1<<30);
		}

		// generate a floating-point number in the range [0,1) and generate the next seed
		real rnd(void) {
			nextSeed();
			return getFloat();
		}

		// Set the seed of the generator
		void setSeed(int seed) {
			randSeed=seed;
			nextSeed();
		}

		// Return a random number between two values
		real getf(real minv, real maxv) { return minv+rnd()*(maxv-minv); }
};

INLINE real rndFromSeed(int seed) {
	Random rnd(seed);
	return rnd.rnd();
}

END_VLADO

#endif
