/*****************************************************
	FILE: Misc.h
	DESCRIPTION: Various utility functions
	Copyright (C) 2001 by Vladimir Koylazov
	vkoylazov@hotmail.com

	OS SUPPORT: Win32, Linux
*****************************************************/
#ifndef __MISC_H__
#define __MISC_H__

BEGIN_VLADO

inline int FLOOR(float x) { return ((int)(x)-((x)<0.0f)); }
inline int FLOOR(double x) { return ((int)(x)-((x)<0.0f)); }

template<class T> inline T Max(T a, T b) { return (a>b)? a:b; }
template<class T> inline T Min(T a, T b) { return (a<b)? a:b; }

template<class T> inline T Max(T a, T b, T c) {
	if (a>b) return (a>c)? a : c;
	else return (b>c)? b : c;
}

template<class T> inline T Min(T a, T b, T c) {
	if (a<b) return (a<c)? a : c;
	else return (b<c)? b : c;
}
template<class T> inline T Max(T a, T b, T c, T d) {
	if (b>a) a=b;
	if (c>a) a=c;
	if (d>a) a=d;
	return a;
}

template<class T> inline T Min(T a, T b, T c, T d) {
	if (b<a) a=b;
	if (c<a) a=c;
	if (d<a) a=d;
	return a;
}

inline float clamp(float x, float a, float b) {
	if (x<a) return a;
	if (x>b) return b;
	return x;
}

inline int sign(real x) {
	if (x<0.0f) return -1;
	if (x>0.0f) return 1;
	return 0;
}

template<class T>
inline void swap(T &a, T &b) {
	T t=a;
	a=b;
	b=t;
}

template<class T>
inline T sqr(T a) { return a*a; }

template<class T>
inline T cube(T a) { return a*a*a; }

template<class T>
inline void nudge(T &xmin, T &xmax, float x) {
	if (x<xmin) xmin=x;
	if (x>xmax) xmax=x;
}

END_VLADO

#endif
