#ifndef __FILEUTILS_H__
#define __FILEUTILS_H__

BEGIN_VLADO

static void skipSpaces(FILE *fp) {
	char c;
	do {
		c=fgetc(fp);
	} while (c==' ' || c=='\t' || c=='\r' || c=='\n');

	if (c!='/') { fseek(fp, -1, SEEK_CUR); return; }

	c=fgetc(fp);
	if (c=='/') {
		// Comment until the end of the line
		do {
			c=fgetc(fp);
		} while (c!='\n' && c!='\r' && c!=EOF);
		
		skipSpaces(fp);
	} else if (c=='*') {
		// Bracketed comment
		do {
			c=fgetc(fp);
			if (c=='*') {
				c=fgetc(fp);
				if (c=='/') break;
			}
		} while (c!=EOF);

		skipSpaces(fp);
	} else {
		 fseek(fp, -2, SEEK_CUR);
		 return;
	}
}

inline int letter(char c) {
	if ((c>='a' && c<='z') || (c>='A' && c<='Z') || c=='_') return true;
	return false;
}

inline int digit(char c) {
	if (c>='0' && c<='9') return true;
	return false;
}

static int readWord(FILE *fp, char *word) {
	skipSpaces(fp);
	char c=fgetc(fp);

	if (!letter(c)) {
		fseek(fp, -1, SEEK_CUR);
		return false;
	}

	int len=0;
	word[len++]=c;

	do {
		c=fgetc(fp);
		if (letter(c) || digit(c)) word[len++]=c;
		else break;
	} while (1);

	word[len]='\0';

	fseek(fp, -1, SEEK_CUR);
	return true;
}

static int blockStart(FILE *fp) {
	skipSpaces(fp);

	char c=fgetc(fp);
	if (c=='{') return true;

	fseek(fp, -1, SEEK_CUR);
	return false;
}

static int blockEnd(FILE *fp) {
	skipSpaces(fp);

	char c=fgetc(fp);
	if (c=='}') return true;

	fseek(fp, -1, SEEK_CUR);
	return false;
}

static int readString(FILE *fp, char *str) {
	skipSpaces(fp);
	
	char c=fgetc(fp);
	if (c!='"') {
		fseek(fp, -1, SEEK_CUR);
		return false;
	}

	int len=0;
	do {
		c=fgetc(fp);
		if (c=='"') break;
		str[len++]=c;
	} while (1);

	str[len]='\0';

	return true;
}

static int readFloat(FILE *fp, float &f) {
	skipSpaces(fp);

	float sign=1.0f;
	float result=0.0f;

	char c=fgetc(fp);
	if (c=='+') c=fgetc(fp);
	else if (c=='-') { sign=-1.0f; c=fgetc(fp); }

	if (digit(c)) {
		// Read the integer part
		result+=float(c-'0');
		do {
			c=fgetc(fp);
			if (digit(c)) { result*=10.0f; result+=float(c-'0'); }
			else break;
		} while (1);
	}

	if (c=='.') {
		// Read the fractional part
		float mult=0.1f;
		do {
			c=fgetc(fp);
			if (digit(c)) { result+=mult*float(c-'0'); mult*=0.1f; }
			else break;
		} while (1);
	}

	fseek(fp, -1, SEEK_CUR);

	f=result*sign;
	return true;
}

static int readInt(FILE *fp, int &i) {
	skipSpaces(fp);

	int sign=1;
	int result=0;

	char c=fgetc(fp);
	if (c=='+') c=fgetc(fp);
	else if (c=='-') { sign=-1; c=fgetc(fp); }

	if (digit(c)) {
		// Read the integer part
		result+=c-'0';
		do {
			c=fgetc(fp);
			if (digit(c)) { result*=10; result+=c-'0'; }
			else break;
		} while (1);
	}

	fseek(fp, -1, SEEK_CUR);

	i=result*sign;
	return true;
}

static int readVector(FILE *fp, Vector &v) {
	skipSpaces(fp);
	if (!readFloat(fp, v.x)) return false;
	if (!readFloat(fp, v.y)) return false;
	if (!readFloat(fp, v.z)) return false;
	return true;
}

static int readColor(FILE *fp, Color &c) {
	skipSpaces(fp);
	if (!readFloat(fp, c.r)) return false;
	if (!readFloat(fp, c.g)) return false;
	if (!readFloat(fp, c.b)) return false;
	return true;
}

END_VLADO

#endif
