#ifndef _VGL_EDGELISTER_H__
#define _VGL_EDGELISTER_H__

/*
	the parameter class T must have the following methods:
	
	int getNumVerts();
	int getNumFaces();

	int getFaceVertex(int face, int v);

	void setNumEdges(int numEdges);
	void setEdge(int idx, EdgeData &edge);
*/
BEGIN_VLADO

struct EdgeData {
	int v[2]; // The two vertices
	int f[2]; // The two faces
	int i[2]; // Indices of the edge in the faces
	int tv[2]; // The opposite vertices
	int numFaces;
};

struct FaceData {
	int v[3];
};

struct NgbList {
	int vert;
	EdgeData *edge;
	int edgeIdx;
	NgbList *next;
};

template<class T>
class EdgeLister {
	public:
		int enumEdges(T &mesh) {
			EdgeData *edges=new EdgeData[mesh.getNumFaces()*3];
			int numEdges=0;

			int *emptyEdge=new int[mesh.getNumVerts()];
			memset(emptyEdge, 0xFF, sizeof(emptyEdge[0])*mesh.getNumVerts());

			NgbList **vertexNgbs=new NgbList*[mesh.getNumVerts()];
			memset(vertexNgbs, 0, sizeof(NgbList*)*mesh.getNumVerts());

			NgbList *pool=new NgbList[mesh.getNumFaces()*3];
			NgbList *freePool=pool;

			for (int i=mesh.getNumFaces()-1; i>=0; i--) {
				for (int j=0; j<3; j++) {
					int r0, r1;
					int v0=r0=mesh.getFaceVertex(i, j);
					int v1=r1=mesh.getFaceVertex(i, (j==2)? 0 : j+1);
					if (v0>v1) swap(v0, v1);
					else if (v0==v1) {
						emptyEdge[mesh.getFaceVertex(i, (j+2)%3)]=v0;
					}

					// Try to locate the edge (v0, v1)
					NgbList *ngbList=vertexNgbs[v0];
					while (ngbList && (ngbList->vert!=v1 || ngbList->edge->numFaces>=2)) ngbList=ngbList->next;
					if (!ngbList) {
						// A new edge is found
						EdgeData &edge=edges[numEdges++];
						edge.v[0]=r0;
						edge.v[1]=r1;
						edge.f[0]=i;
						edge.numFaces=1;
						edge.i[0]=j;
						edge.i[1]=-1;
						edge.tv[0]=mesh.getFaceVertex(i, (j+2)%3);
						mesh.setFaceEdge(i, j, numEdges-1);

						ngbList=freePool++;
						ngbList->vert=v1;
						ngbList->edge=&edge;
						ngbList->edgeIdx=numEdges-1;
						ngbList->next=vertexNgbs[v0];
						vertexNgbs[v0]=ngbList;
					} else {
						// The second part of an edge is found
						EdgeData &edge=*(ngbList->edge);
						edge.f[1]=i;
						edge.i[1]=j;
						edge.tv[1]=mesh.getFaceVertex(i, (j+2)%3);
						edge.numFaces++;
						mesh.setFaceEdge(i, j, ngbList->edgeIdx);
					}
				}
			}

			// Add the "empty" vertex edges
			for (i=mesh.getNumVerts()-1; i>=0; i--) {
				if (emptyEdge[i]>=0) {
					NgbList *ngbList=vertexNgbs[i];
					while (ngbList && (ngbList->vert!=i || ngbList->edge->numFaces>=2)) ngbList=ngbList->next;
					if (ngbList) {
						// The second part of an "empty" edge is found
						EdgeData &edge=*(ngbList->edge);
						edge.f[1]=-1;
						edge.i[1]=-1;
						edge.tv[1]=emptyEdge[i];
						edge.numFaces++;
					}
				}
			}

			if (pool) delete[] pool;
			if (vertexNgbs) delete[] vertexNgbs;

			mesh.setNumEdges(numEdges);
			for (i=0; i<numEdges; i++) mesh.setEdge(i, edges[i]);

			if (edges) delete[] edges;
			return numEdges;
		}
};

END_VLADO

#endif