/********************************************************
	FILE: Plugin.cpp
	DESCRIPTION: The MAX interface of simcloth3.dlm
	CREATED: 1 December 2002
	AUTHOR: Vladimir Koylazov
	Copyright (C) by Vladimir Koylazov (Vlado)

	HISTORY:

*********************************************************/

#include "Headers.h"
#include "resource.h"
#include "SimClothModifier.h"
#include "VertexGroup.h"

HINSTANCE hInstance;
int controlsInit = FALSE;

BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved) {
	hInstance = hinstDLL;

	if (!controlsInit ) {
		controlsInit = TRUE;
		InitCustomControls(hInstance);
		InitCommonControls();
	}

	switch(fdwReason) {
		case DLL_PROCESS_ATTACH:
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
		}
	return(TRUE);
}

TCHAR *GetString(int id) {
	static TCHAR buf[256];
	if(hInstance) return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}

__declspec( dllexport ) const TCHAR *
LibDescription() { return GetString(IDS_LIBDESC); }

__declspec( dllexport ) int LibNumberClasses() 
{
	return 2;
}

__declspec( dllexport ) ClassDesc* LibClassDesc(int i) 
{
	switch(i) {
		case 0: return GetSimCloth3Desc();
		case 1: return GetVertexGroupDesc();
		default: return 0;
	}
}


__declspec( dllexport ) ULONG LibVersion() { return VERSION_3DSMAX; }
