#ifndef __PROGRESS_H__
#define __PROGRESS_H__

#include "defines.h"

#define PERR_START 0
#define PERR_END (PERR_START+9999)
#define PWRN_START (PERR_END+1)
#define PWRN_END (PWRN_START+9999)
#define PINF_START (PWRN_END+1)
#define PINF_END (PINF_START+9999)
#define PDBG_START (PINF_END+1)
#define PDBG_END (PDBG_START+9999)

BEGIN_VLADO

//******************************************************************************
//* Project:	
//*    File:	VRRendProg.h						  Module:	
//* Started:	28-Nov-2001(Wed) (17:33)		Last Changes:	
//*  Author:	POM
//******************************************************************************

//******************************************************************************
//******************************************************************************
//*      class...VRRendProg
//* Description: vray progress. should be platform independant !
//*     Started: 27-Nov-2001(Tue) (16:37)
//*      Author: POM
//******************************************************************************
//******************************************************************************
class ProgressCallback {
	public:
		virtual int Init()=0;
		virtual int Done()=0;
		//
		virtual void SetTotal(int)=0;
		virtual int GetTotal()=0;
		//
		virtual void SetProgress(int)=0;
		virtual int GetProgress()=0;
		//
		virtual void SetMainTitle(LPCTSTR)=0;
		virtual void SetProgTitle(LPCTSTR)=0;
		//abort / pause flags
		//
		//TRUE -> abort requested, FALSE - > just CONTINUE
		virtual int CheckForAbort()=0;
		virtual int GetAbort()=0;	
		virtual void SetAbort(int)=0;

		virtual int DoesMessageProcessing()=0; // This must return TRUE if the progress callback does any message processing
		virtual void ProcessMessages()=0; // If DoesMessageProcessing() returns TRUE, this function will be called to process the messages
		//
		//always returns FALSE... but we will leave it for future use by independent progress callbacks
		virtual int GetPause()=0;	
		virtual void SetPause(int)=0;
		//
		virtual void operator<<( LPCTSTR)=0;

		// Dumps a message to the progress output
		// module is an application-defined identifier of the module outputting the message
		// level is an application-defined level of importance of the message
		// use the following guidelines:
		//   PERR_START..PERR_END: critical errors (very important)
		//   PWRN_START..PWRN_END: warnings (non-critical errors)
		//   PINF_START..PINF_END: informative messages
		//   PDBG_START..PDBG_END: debug messages
		virtual void DumpMsg(int module, int level, LPCTSTR format, ...)=0;

		virtual void DisableDump(void)=0;
		virtual void EnableDump(void)=0;
		//
		virtual void IncMsgIndent(void)=0;
		virtual void DecMsgIndent(void)=0;

		virtual void SetMarker(int line, TCHAR *fname, TCHAR *description)=0;

		virtual void ClearException(void)=0;
		virtual void SetException(int module, TCHAR *description)=0;
};

class ConsoleProgressCallback: public ProgressCallback {
	public:
		virtual int CreateConsole()=0;
		virtual int DestroyConsole()=0;

		virtual void ShowConsole()=0;
		virtual void HideConsole()=0;
		virtual void ClearConsole()=0;
};

END_VLADO

#endif
