#ifndef _COLLISIONMESH_H__
#define _COLLISIONMESH_H__

#include "Utils.h"
#include "Sequence.h"
#include "BVTree.h"
#include "FDop.h"
#include "TriMesh.h"

BEGIN_VLADO

template<class Mesh>
class Collision;

template<class Mesh>
struct BVertex: public BVolume {
	Mesh *cmesh; // The mesh
	int idx;
	Vector p;
	int fixed;
	Vector normal;
	int currentCollidePriority;
	int collide, selfCollide, checkIntersections;
	Collision<Mesh> *deflectorCollision;
};

template<class Mesh>
struct BEdge: public BVolume {
	Mesh *cmesh; // The mesh
	int edgeIdx;
	int idx[2];
	int fixed;
	int invisible;
	int collide, selfCollide, checkIntersections;

	Vector p;
	Vector dir;
};

template<class Mesh>
struct BFace: public BVolume {
	Mesh *cmesh; // The mesh
	int idx[3];
	int fixed;
	int valid;
	int collide, selfCollide, checkIntersections;

	Transform tm; // transform from world space to face space
	Vector normal;
};

template<class Mesh>
struct BMesh: public BVolume {
	Mesh *cmesh;
};

END_VLADO

#endif