#ifndef _VERTEXGROUP_H_
#define _VERTEXGROUP_H_

#define VERTEXGROUP_CLASS_ID Class_ID(0x33840ecb, 0x36ed3998)

// Access to the class descriptor
extern ClassDesc* GetVertexGroupDesc();

// Parameter block IDs
enum {
	sc3_group,
}; 

// Parameters for the group pblock
enum {
	sc3_group_name,
	sc3_group_collide,
	sc3_group_selfCollide,
	sc3_group_attached,
	sc3_group_attachNode,
	sc3_group_checkIntersections,
	sc3_group_scale,
};


//******************************************************
// Class VertexGroup
// A groups of vertices (as displayed in subobject mode)
class SimClothObject;

class VertexGroup: public ReferenceTarget {
	public:
		int numPts; // Number of points
		unsigned char *selected; // Selection flags (non-zero is selected)

		IParamBlock2 *pblock;

		int collide, selfCollide, attached;
		int prevAttached;
		int checkIntersections;
		INode *attachNode;
		float scale;

		Vlado::Transform tm; // The transformation matrix of the node at the current time
		Vlado::Vector *partCoords;

		// Constructor/destructor
		VertexGroup(void);
		~VertexGroup(void);

		// From ReferenceTarget
		RefTargetHandle Clone(RemapDir& remap);

		// From ReferenceMaker
		RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message);
		int NumRefs() { return 1; }
		RefTargetHandle GetReference(int i) { return i==0? pblock : NULL; }
		void SetReference(int i, RefTargetHandle rtarg) { if (i==0) pblock=(IParamBlock2*) rtarg; }

		IOResult Load(ILoad *iload);
		IOResult Save(ISave *isave);

		// From Animatable
		Class_ID ClassID() { return VERTEXGROUP_CLASS_ID; }
		virtual ULONG SuperClassID() { return REF_MAKER_CLASS_ID; }
		void GetClassName(TSTR &s) { s=_T("SimClothVertexGroup"); }

		// Subanims
		int NumSubs();
		Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);

		// Direct paramblock access
		int	NumParamBlocks() { return 1; }
		IParamBlock2* GetParamBlock(int i) { return pblock; }
		IParamBlock2* GetParamBlockByID(BlockID id) { return (id==pblock->ID())? pblock : NULL; }
		int GetParamBlockIndex(int id) { return (id==pblock->ID())? 0 : -1; }

		void DeleteThis() { delete this; }

		// My methods
		void setName(TCHAR *name);
		TCHAR *getName(void);
		void setSelected(int numPts, unsigned char *selPts);
		void freeData(void);

		void beginSimulation(TimeValue t, SimClothObject *scObj);
		void updateSimulation(TimeValue t, SimClothObject *scObj);
		void endSimulation(void);

		int getAttachPos(int index, Vlado::Vector &p);
};

//******************************************************
// class SimCloth3ClassDesc
// The description of the plugin class, an instance is returned to Max in LibClassDesc()
class VertexGroupClassDesc:public ClassDesc2 {
	public:
		int IsPublic() { return FALSE; }
		void* Create(BOOL loading ) { return new VertexGroup; }
		const TCHAR* ClassName() { return _T("SimClothVertexGroup"); }
		SClass_ID SuperClassID() { return REF_MAKER_CLASS_ID; }
		Class_ID ClassID() { return VERTEXGROUP_CLASS_ID; }
		const TCHAR* Category() { return _T("");  }

		// Hardwired name, used by MAX Script as unique identifier
		const TCHAR* InternalName() { return _T("SimClothVertexGroup"); }
		HINSTANCE HInstance() { return hInstance; }
};

#endif