/* 
---- Frame Number Display V0.5 by Mark Tsang -- marcus_tsang@yahoo.ie
---- This Script displays the current frame number in the current viewport also recordable in previews - It is useful becasue when previewing to avi or mov in max there
---- is a long standing bug where the displayed fames is out of sync with the numbers that are displayed with the "Frame Numbers" check box in the preview dialog - this
---- script always displays the correct frame. It is based on Fred Ruffs Polygon counter script that ships with Max. Written by Mark Tsang
				
		**TO DO**
		*- I want to add options for the placement of the numbers as well as the colour
		*- Get it to work with multipass effects
*/
macroScript Frame_Num_Display
--enabledIn:#("max")
	category:"Mark Tsang"
	internalcategory:"Mark Tsang"
	buttontext:"Frame Numbers"
	toolTip:"Frame Numbers Display" 
(
	global frame_num_on = false, fn_frame_display
	local currentframe, lastframe, currentframecount, lastcurrentframecount
	local lastViewport
	local textPos
	local updateRect
	local viewportsize, lastviewportsize
	
	fn fn_cleartext =
	(
		local rect = gw.getTextExtent lastframe
		updateRect.w = rect.x+1
		updateRect.h = rect.y+1
		print updaterect
		gw.clearscreen updateRect useBkg:true
		gw.enlargeUpdateRect updateRect 
		gw.updateScreen() 
		gw.resetUpdateRect()
	)
	
	fn fn_callback = 
	(
		registerRedrawViewsCallback fn_frame_display
			local viewsize = getViewSize()
			
				currentframe = ""
				roundcurrenttime = currenttime as integer /ticksperframe
				currentframe = (roundcurrenttime as string)

			textPos = [(((viewsize[1] as integer) - (6 * currentframe.count))-10),20,0]
			updateRect = box2 (textPos.x) (textPos.y-(gw.getTextExtent "X").y) 0 0
			lastframe = ""

	)
	
	fn fn_frame_display = 
		(
			try 
			(
				currentframe = ""
				roundcurrenttime = currenttime as integer /ticksperframe
				currentframe = (roundcurrenttime as string)
				viewportsize = getViewSize() 			
				currentframecount = currentframe.count
				
				local needUpdate = currentframe != lastframe 
				
				local movenum = (currentframecount!=lastcurrentframecount) or (viewportsize != lastviewportsize)
				
				if movenum do
					(
					fn_cleartext()
					
					unregisterRedrawViewsCallback fn_frame_display
					
					fn_callback()
					
					fn_cleartext()
					)
				
				if viewport.activeViewport != lastViewport then
				(	
				completeredraw()
				lastViewport = viewport.activeViewport 
				)
				
				else if needUpdate do
				(	
				fn_cleartext()
				)
				
				if (currentframe != "") do
				(
				gw.wtext textPos currentframe color:(color 255 255 255)
				rect = gw.getTextExtent currentframe 
				
				updateRect.w = rect.x+1
				updateRect.h = rect.y+1
				gw.enlargeUpdateRect updateRect
				gw.updateScreen() 
				)
				lastframe = currentframe
				lastviewportsize = viewportsize
				lastcurrentframecount = currentframecount
			)	
			catch ()
		)
	on ischecked return frame_num_on
		
	On execute do
		(	
		if frame_num_on then 
		unregisterRedrawViewsCallback fn_frame_display
		else
			(
			fn_callback()
			)

		frame_num_on = not frame_num_on 
		completeredraw()
		updateToolbarButtons()
		) 

	) 
