#python
#Constrain to Path And Duplicate Assembly script
#Author: Erik Karlsson - www.erka.se
#ver: 1.00
#jul 23, 2009

#Description
#This script is useful when you want to path constrain multiple objects to a curve. 
#The script creates a rig with controlobjects to easily  control the spacing, movement, axis and more of multiple objects.

#Installation
#Put the script file pathDuplicate.py in users script folder
#Put the config file pathDuplicate.CFG in users config folder
#In Modo go to System> Form Editor and look for the form "Constrain to Path and Duplicate" 
#Place the form where ever you like.

#Or
#Run the script @pathDuplicate_pop.LXM and it will pop up the form in a new palette.
#You can then map this command to a key or button for easy access to the pop-up window.

#How to use Populate Path
#Select the object you want to duplicate and constrain to the cuve. Then select the curve you want to constrain to.
#Run the script from the form unsing "Populate Path" button.

#How to use Purge controlItems
#To purge all controlItems and modifiers of your path constraint, select the Group Item containing all of the constrained items or select one of the constrained items.
#And then run the script using the "Purge controlItems" button.
#If you want to keep the curve for some reason, select the Group Item or one of the constrained items followed by the curve mesh.
#And then run the script using the "Purge controlItems" button. 


#Updates 
# 0.90
# 	- Added option for the type of path constrain, align and position.
# 	- Added automatic resizing of locators
# 	- Added roll value for the controlobjects
# 0.95
#	- Added option for instances and replicators
#	- The script will now work with a object that already has a user channel named "nr". This channel will be overwritten.
#	- Added wraptoggle for the controlobject
# 0.98
#	- Added relative spacing to the control object. If you check RelativeSpacing the objects will keep their relative spacing when you modify the curve.
#	- Changed how Fill by Number works if you check Wrap in the palette. Check Wrap if you want to distribute the objects on a closed curve. Uncheck if you are using an open curve.
#	- Added a Purge controlItem script to get rid of all controlItems and modifiers if you don't want to animate it.
# 1.00
#   - Added Up vector controllers to the controlobject as well as local up vector and negative axis values.
#	- Fixed an issue with automatic resizing of locators when using instances and replicators.

#Known bugs
# - In Modo 401 x64, using replicators and then running the script and then undo will only work first time.
#   If you run the script again and then undo it, modo will crash. No problems with this in Modo 401 x32.


import lx

arg = lx.arg()

if arg == '0':
	#Assigning variables for the selected objects
	mySelection = lx.eval('query sceneservice selection ? all');
	myItem = mySelection[0]
	curve = mySelection[1]
	
	#Getting the size of the object
	lx.eval('select.drop item')
	lx.eval('select.Item %s' %(myItem))
	lx.eval('query sceneservice item.ID ? %s' %(myItem))
	if lx.eval('query sceneservice isType ? mesh'):
		lx.eval('@Absolute.pl grab')
		sizeGrab = lx.eval('user.value lux_absolute_size_Uniform ?')
	else:
		sizeGrab = lx.eval('item.channel locator$size ?')

	#Getting the user value for what type of object to duplicate, Instances or Replicators
	toggleInstances = lx.eval('user.value toggleInstances ?')
	toggleReplicators = lx.eval('user.value toggleReplicators ?')
	lx.eval('select.drop item')
	
	if toggleInstances == 1:
		lx.eval('select.Item %s' %(myItem))
		lx.eval('item.duplicate true type:locator all:true')
		myItem = lx.eval('query sceneservice selection ? all');
		lx.eval('select.drop item')
	else:
		if toggleReplicators == 1:
			lx.eval('item.create mesh')
			lx.eval('item.name pointCloud mesh')
			pointCloudItem = lx.eval('query sceneservice selection ? all')
			lx.eval('tool.set prim.makeVertex on')
			lx.eval('tool.attr prim.makeVertex cenX 0.0')
			lx.eval('tool.attr prim.makeVertex cenY 0.0')
			lx.eval('tool.attr prim.makeVertex cenZ 0.0')
			lx.eval('tool.apply')
			lx.eval('tool.set prim.makeVertex off')
			lx.eval('item.create replicator')
			lx.eval('replicator.source %s' % (myItem))
			lx.eval('replicator.particle %s' % (pointCloudItem))
			myItem = lx.eval('query sceneservice selection ? all')
			lx.eval('select.drop item')	
			
	lx.eval('select.subItem %s set' %(myItem))
	lx.eval('select.subItem %s add' %(curve))
	
	upVectorControler = lx.eval('user.value upVectorControl ?')

	#Determing what type of pathconstrain to build
	alignValue = lx.eval('user.value toggleAlign ?')
	posValue = lx.eval('user.value togglePos ?')

	if posValue == 1 and alignValue == 1:
		lx.eval('constraintCurve path both')
	else:
		if alignValue ==1:
			lx.eval('constraintCurve path norm')
		if posValue ==1:
			lx.eval('constraintCurve path pos')
		if alignValue == 0 and posValue == 0:
			lx.eval('constraintCurve path both')

	#Creating a pathconstraint with the selected curve and object
	constrain = lx.eval('query sceneservice selection ? cmPathConstraint')
	lx.eval('select.drop item')

	#creating new channel named "nr" for the object
	lx.eval('select.subItem %s set' %(constrain))
	lx.eval('item.selectLinkIO output')
	lx.eval('query sceneservice item.ID ? %s' % (myItem))
	channelLength = lx.eval('query sceneservice channel.N ?')
	lx.eval('query sceneservice item.ID ? %s' % (myItem))
	NR = "nr"
	i = 0
	while i<channelLength:
		checkNr = lx.eval('query sceneservice channel.name ? %s' % (i))
		i = i+1
		if checkNr == "nr":
			lx.eval('select.channel {%s:%s} set' % (myItem, NR))
			lx.eval('channel.delete')
	lx.eval('channel.create %s' %(NR))
	lx.eval('select.channel {%s:%s} set' % (myItem, NR))
	lx.eval('channel.value %s' %('0'))
		
	#Getting the length of the path
	lx.eval('select.drop item')
	lx.eval('query sceneservice item.ID ? %s' %(constrain))
	pathLength = float(lx.eval('query sceneservice channel.eval ? 13'))

	#Creating another locator and pathconstraint to help calculating length of the curve
	lx.eval('select.drop item')
	lx.eval('item.create locator')
	lx.eval('item.name "dummyLocator" xfrmcore')
	dummy = lx.eval('query sceneservice selection ? all')
	lx.eval('select.subItem %s set'%(curve))
	lx.eval('constraintCurve path both')
	dummyLocator = lx.eval('query sceneservice selection ? cmPathConstraint')
	lx.eval('item.channel locator$visible off')

	#creating new controlItem Locator and sets new channels, Spacing, Move, Roll, Wrap and AxisXYZ.
	lx.eval('select.drop item')
	lx.eval('item.create locator')
	lx.eval('item.name "MainController" xfrmcore')
	lx.eval('item.help add label MainController')
	lx.eval('item.channel locator$ihLabel.Y 0.0')
	controlItem = lx.eval('query sceneservice selection ? all')
	lx.eval('item.channel locator$drawShape custom')
	lx.eval('item.channel locator$isShape circle')
	lx.eval('item.channel locator$isAxis y')
	lx.eval('item.channel locator$isSolid false')
	lx.eval('item.channel locator$isRadius %s' %(sizeGrab))
	lx.eval('item.channel locator$isStyle replace')
	lx.eval('item.command add "item.channelHaul"')
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channel.create Spacing distance')
	lx.eval('channel.create Move distance')
	lx.eval('channel.create Roll angle')
	lx.eval('channel.create AxisXYZ integer scalar true 0.0 true 2.0 1.0')
	lx.eval('channel.create Wrap boolean')
	lx.eval('channel.create RelativeSpacing boolean')
	if upVectorControler == 1:
		lx.eval('channel.create upVectorX boolean')
		lx.eval('channel.create upVectorY boolean scalar false 0.0 false 0.0 1.0')
		lx.eval('channel.create upVectorZ boolean')
	elif upVectorControler == 0:
		lx.eval('channel.create upVectorX float')
		lx.eval('channel.create upVectorY float scalar false 0.0 false 0.0 1.0')
		lx.eval('channel.create upVectorZ float')
	lx.eval('channel.create localUpVector boolean')
	lx.eval('channel.create negativeAxis boolean')
	lx.eval('select.subItem %s set' %(dummy))
	lx.eval('select.subItem %s add' %(controlItem))
	lx.eval('item.parent')

	#creating new individual controlItem Locator and creating new channels, Offset and Roll. 
	lx.eval('select.drop item')
	lx.eval('item.create locator')
	lx.eval('item.name "Offset Controller" xfrmcore')
	IndividualControlItem = lx.eval('query sceneservice selection ? all')
	lx.eval('item.channel locator$drawShape custom')
	lx.eval('item.channel locator$isShape circle')
	lx.eval('item.channel locator$isAxis z')
	lx.eval('item.channel locator$isSolid false')
	lx.eval('item.channel locator$isRadius %s' %(sizeGrab*0.5))
	lx.eval('item.channel locator$isStyle replace')
	lx.eval('item.command add "item.channelHaul"')
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(IndividualControlItem))
	lx.eval('channel.create Offset distance')
	lx.eval('channel.create Roll angle')
	lx.eval('select.subItem %s add' %(myItem))
	lx.eval('item.parent')

	#Adding Modifiers:

	#Adding Divide modifier to calculate distance
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Divide"')
	DivideMod = lx.eval('query sceneservice selection ? all')

	#Adding Multiply modifier, using the unique nr channel of the object
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Multiply"')
	MultiMod = lx.eval('query sceneservice selection ? all')

	#Adding Add modifier for individual offset to add to the main offset spacing 
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Add"')
	AddIMod = lx.eval('query sceneservice selection ? all')

	#Modifers for managing relative spacing on or off:
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Multiply"')
	relativePathMod = lx.eval('query sceneservice selection ? all')

	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Multiply"')
	pathMod = lx.eval('query sceneservice selection ? all')

	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Add"')
	addPathMod = lx.eval('query sceneservice selection ? all')

	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Modulo"')
	moduloPathMod = lx.eval('query sceneservice selection ? all')

	#Linking them all together:

	lx.eval('select.channel {%s:Spacing} set' % (controlItem))
	lx.eval('select.channel {%s:input1} add' % (MultiMod))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:output} set' % (MultiMod))
	lx.eval('select.channel {%s:input2} add' % (AddIMod))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:Offset} set' % (IndividualControlItem))
	lx.eval('select.channel {%s:input1} add' % (AddIMod))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:output} set' % (AddIMod))
	lx.eval('select.channel {%s:input1} add' % (DivideMod))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:output} set' % (addPathMod))
	lx.eval('select.channel {%s:input2} add' % (DivideMod))
	lx.eval('channel.link toggle')

	lx.eval('select.channel {%s:output} set' % (pathMod))
	lx.eval('select.channel {%s:input1} add' % (addPathMod))
	lx.eval('channel.link toggle')

	lx.eval('select.channel {%s:output} set' % (relativePathMod))
	lx.eval('select.channel {%s:input2} add' % (addPathMod))
	lx.eval('channel.link toggle')

	lx.eval('select.channel {%s:output} set' % (moduloPathMod))
	lx.eval('select.channel {%s:input1} add' % (pathMod))
	lx.eval('channel.link toggle')

	lx.eval('select.channel {%s:length} set' % (dummyLocator))
	lx.eval('select.channel {%s:input2} add' % (pathMod))
	lx.eval('channel.link toggle')

	lx.eval('select.channel {%s:input1} set' % (moduloPathMod))
	lx.eval('channel.value 1')

	lx.eval('select.channel {%s:input2} set' % (relativePathMod))
	lx.eval('channel.value %s' % (pathLength))

	lx.eval('select.channel {%s:RelativeSpacing} set' % (controlItem))
	lx.eval('select.channel {%s:input2} add' % (moduloPathMod))
	lx.eval('channel.link toggle')

	lx.eval('select.channel {%s:RelativeSpacing} set' % (controlItem))
	lx.eval('select.channel {%s:input1} add' % (relativePathMod))
	lx.eval('channel.link toggle')

	#Linking The result to the path constrain
	lx.eval('select.drop item')
	lx.eval('select.channel {%s:output} set' % (DivideMod))
	lx.eval('select.channel {%s:offset} add' % (constrain))
	lx.eval('channel.link toggle')

	#Linking nr to multiply modifier
	lx.eval('select.drop item')
	lx.eval('select.channel {%s:%s} set' % (myItem, NR))
	lx.eval('select.channel {%s:input2} add' % (MultiMod))
	lx.eval('channel.link toggle')

	#Linking the percent value to Move
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Divide"')
	MoveMod = lx.eval('query sceneservice selection ? all')
	lx.eval('select.channel {%s:Move} set' % (controlItem))
	lx.eval('select.channel {%s:input1} add' % (MoveMod))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:length} set' % (dummyLocator))
	lx.eval('select.channel {%s:input2} add' % (MoveMod))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:output} set' % (MoveMod))
	lx.eval('select.channel {%s:percent} add' % (constrain))
	lx.eval('channel.link toggle')

	#Linking Pathconstrain axis to controlItem
	lx.eval('select.drop item')
	lx.eval('select.channel {%s:AxisXYZ} set' % (controlItem))
	lx.eval('select.channel {%s:axis} add' % (constrain))
	lx.eval('channel.link toggle')

	#Linking Wrap to controlItem
	lx.eval('select.drop item')
	lx.eval('select.channel {%s:Wrap} set' % (controlItem))
	lx.eval('select.channel {%s:wrap} add' % (constrain))
	lx.eval('channel.link toggle')

	#Linking Pathconstraint roll to controlItem
	lx.eval('select.drop item')
	lx.eval('select.subItem %s set' %(controlItem))
	lx.eval('channelModifier.create "Basic Math:Add"')
	addRoll = lx.eval('query sceneservice selection ? all')
	lx.eval('select.channel {%s:Roll} set' % (controlItem))
	lx.eval('select.channel {%s:input1} add' % (addRoll))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:Roll} set' % (IndividualControlItem))
	lx.eval('select.channel {%s:input2} add' % (addRoll))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:output} set' % (addRoll))
	lx.eval('select.channel {%s:roll} add' % (constrain))
	lx.eval('channel.link toggle')
	
	#Linking Pathconstraint upVectors to controlItem
	lx.eval('select.drop item')
	lx.eval('select.channel {%s:upVectorX} set' % (controlItem))
	lx.eval('select.channel {%s:up.X} add' % (constrain))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:upVectorY} set' % (controlItem))
	lx.eval('select.channel {%s:up.Y} add' % (constrain))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:upVectorZ} set' % (controlItem))
	lx.eval('select.channel {%s:up.Z} add' % (constrain))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:localUpVector} set' % (controlItem))
	lx.eval('select.channel {%s:local} add' % (constrain))
	lx.eval('channel.link toggle')
	lx.eval('select.channel {%s:negativeAxis} set' % (controlItem))
	lx.eval('select.channel {%s:axisNeg} add' % (constrain))
	lx.eval('channel.link toggle')
	
	#parent to group locator
	lx.eval('select.drop item')
	lx.eval('item.create groupLocator')
	lx.eval('item.name "Constraint Items" groupLocator')
	gLocator = lx.eval('query sceneservice selection ? all')
	lx.eval('select.subItem %s set' %(myItem))
	lx.eval('select.subItem %s add' %(gLocator))
	lx.eval('item.parent')
	
	#Getting wrap on or off
	wrapValue = lx.eval('user.value toggleWrap ?')
	lx.eval('select.channel {%s:Wrap} set' % (controlItem))
	lx.eval('channel.value %s' %(wrapValue))

	spreadEven = lx.eval('user.value toggleSpread ?')
	spreadEvenByNr = lx.eval('user.value toggleSpreadByNr ?')

	#Calculating how to spread and duplicate the items
	if spreadEven == 0 and spreadEvenByNr == 0:
		m = lx.eval('user.value offsetM ?')
		numOfItems = int(lx.eval('user.value numItems ?'))
	if spreadEven == 1 and spreadEvenByNr == 0:
		m = lx.eval('user.value offsetM ?')
		lx.eval('select.drop item')
		lx.eval('query sceneservice item.ID ? %s' %(constrain))
		lengthValue = float(lx.eval('query sceneservice channel.eval ? 13'))
		numOfItems = int(lengthValue/m)+1
	if spreadEvenByNr == 1:
		numOfItems = int(lx.eval('user.value numItems ?'))
		lx.eval('select.drop item')
		lx.eval('query sceneservice item.ID ? %s' %(constrain))
		lengthValue = float(lx.eval('query sceneservice channel.eval ? 13'))
		if wrapValue == 1:
			m = float(lengthValue/(numOfItems))
		elif wrapValue == 0:
			m = float(lengthValue/(numOfItems-1))

	mon = lx.Monitor()
	mon.init(numOfItems)

	count = 0
	
	#Creating the duplicates
	while (count < numOfItems-1):
		count = count + 1
		lx.eval('select.item %s' %(myItem))
		lx.eval('item.duplicate type:locator all:true')
		currSel = lx.eval('query sceneservice selection ? all')	
		lx.eval('select.channel {%s:%s} set' % (currSel, NR))
		lx.eval('channel.value %s' %(count))
		mon.step(1)
	lx.eval('select.drop item')	
	lx.eval('select.item %s' %(controlItem))
	lx.eval('item.channelHaul')
	lx.eval('select.channel {%s:Spacing} set' % (controlItem))
	lx.eval('channel.value %s'%(m))
	lx.eval('select.channel {%s:Move} add' % (controlItem))
	lx.eval('select.channel {%s:Roll} add' % (controlItem))
	lx.eval('select.channel {%s:AxisXYZ} add' % (controlItem))
	lx.eval('select.channel {%s:Wrap} add' % (controlItem))
	lx.eval('select.channel {%s:RelativeSpacing} add' % (controlItem))
	lx.eval('select.channel {%s:upVectorX} add' % (controlItem))
	lx.eval('select.channel {%s:upVectorY} add' % (controlItem))
	lx.eval('select.channel {%s:upVectorZ} add' % (controlItem))
	lx.eval('select.channel {%s:localUpVector} add' % (controlItem))
	lx.eval('select.channel {%s:negativeAxis} add' % (controlItem))


if arg == '1':
	mySelection = lx.eval('query sceneservice selection ? all')
	if len(mySelection)==2:
		myItem = mySelection[0]
		myCurve = mySelection[1]
		lx.eval('select.drop item')
	else:
		myItem = mySelection
	lx.eval('select.subItem %s set' %(myItem))	
	lx.eval('pickWalk up')
	myItem = lx.eval('query sceneservice selection ? all')
	
	myChildren = lx.eval('query sceneservice item.children ? %s' %(myItem))
	
	numChildren = len(myChildren)
	lx.eval('select.drop item')

	i = 0
	while i<numChildren:
		lx.eval('select.subItem %s add' %(myChildren[i]))
		lx.eval('pickWalk down')
		lx.eval('delete yes')
		lx.eval('select.subItem %s add' %(myChildren[i]))
		lx.eval('item.apply pos')
		lx.eval('item.apply rot')
		i = i+1
	
	lx.eval('select.drop item')

	i = 0
	while i<numChildren:
		lx.eval('select.subItem %s add' %(myChildren[i]))
		lx.eval('item.selectLinkIO input')
		lx.eval('select.subItem %s remove' %(myChildren[i]))
		if len(mySelection)==2:
			lx.eval('select.subItem %s remove' %(myCurve))
		lx.eval('delete yes')
		i = i+1