/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import net.sourceforge.arbaro.params.LevelParams;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.SegmentImpl;
import net.sourceforge.arbaro.tree.StemSection;

class SubsegmentImpl
implements StemSection {
    public Vector pos;
    public double dist;
    public double rad;
    SegmentImpl segment;
    public SubsegmentImpl prev = null;
    public SubsegmentImpl next = null;

    public Vector getPosition() {
        return this.pos;
    }

    public double getRadius() {
        return this.rad;
    }

    public Transformation getTransformation() {
        return this.segment.transf.translate(this.pos.sub(this.segment.getLowerPosition()));
    }

    public Vector getZ() {
        return this.segment.transf.getZ();
    }

    public double getDistance() {
        return (double)this.segment.index * this.segment.length + this.dist;
    }

    public SubsegmentImpl(Vector p, double r, double h, SegmentImpl segment) {
        this.pos = p;
        this.rad = r;
        this.dist = h;
        this.segment = segment;
    }

    public Vector[] getSectionPoints() {
        Vector[] points;
        Params par = this.segment.par;
        LevelParams lpar = this.segment.lpar;
        int pt_cnt = lpar.mesh_points;
        Transformation trf = this.getTransformation();
        if (this.rad < 1.0E-6) {
            points = new Vector[]{trf.apply(new Vector(0.0, 0.0, 0.0))};
        } else {
            points = new Vector[pt_cnt];
            int i = 0;
            while (i < pt_cnt) {
                double angle = (double)i * 360.0 / (double)pt_cnt;
                if (lpar.level == 0 && par.Lobes != 0) {
                    angle -= 10.0 / (double)par.Lobes;
                }
                Vector pt = new Vector(Math.cos(angle * Math.PI / 180.0), Math.sin(angle * Math.PI / 180.0), 0.0);
                if (lpar.level == 0 && (par.Lobes != 0 || par._0ScaleV != 0.0)) {
                    double rad1 = this.rad * (1.0 + par.random.uniform(-par._0ScaleV, par._0ScaleV) / (double)this.segment.getSubsegmentCount());
                    pt = pt.mul(rad1 * (1.0 + par.LobeDepth * Math.cos((double)par.Lobes * angle * Math.PI / 180.0)));
                } else {
                    pt = pt.mul(this.rad);
                }
                points[i] = pt = trf.apply(pt);
                ++i;
            }
        }
        return points;
    }
}

