/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import java.util.Vector;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.params.LevelParams;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.tree.StemImpl;
import net.sourceforge.arbaro.tree.StemSection;
import net.sourceforge.arbaro.tree.SubsegmentImpl;

class SegmentImpl
implements StemSection {
    Params par;
    public LevelParams lpar;
    public int index;
    Transformation transf;
    double rad1;
    public double rad2;
    double length;
    StemImpl stem;
    Vector subsegments;

    public double getLength() {
        return this.length;
    }

    public Transformation getTransformation() {
        return this.transf;
    }

    public SegmentImpl(StemImpl stm, int inx, Transformation trf, double r1, double r2) {
        this.index = inx;
        this.transf = trf;
        this.rad1 = r1;
        this.rad2 = r2;
        this.stem = stm;
        this.par = this.stem.par;
        this.lpar = this.stem.lpar;
        this.length = this.stem.segmentLength;
        this.subsegments = new Vector(10);
    }

    public void addSubsegment(SubsegmentImpl ss) {
        if (this.subsegments.size() > 0) {
            SubsegmentImpl p = (SubsegmentImpl)this.subsegments.elementAt(this.subsegments.size() - 1);
            p.next = ss;
            ss.prev = p;
        }
        this.subsegments.add(ss);
    }

    void minMaxTest() {
        this.stem.minMaxTest(this.getUpperPosition());
        this.stem.minMaxTest(this.getLowerPosition());
    }

    public void make() {
        if (this.lpar.nCurveV < 0.0) {
            this.makeHelix(10);
        } else if (this.lpar.nTaper > 1.0 && this.lpar.nTaper <= 2.0 && this.isLastStemSegment()) {
            this.makeSphericalEnd(10);
        } else if (this.lpar.nTaper > 2.0) {
            this.makeSubsegments(20);
        } else if (this.lpar.level == 0 && this.par.Flare != 0.0 && this.index == 0) {
            if (Console.debug()) {
                this.stem.DBG("Segment.make() - flare");
            }
            this.makeFlare(10);
        } else {
            this.makeSubsegments(1);
        }
        this.minMaxTest();
    }

    private void makeSubsegments(int cnt) {
        net.sourceforge.arbaro.transformation.Vector dir = this.getUpperPosition().sub(this.getLowerPosition());
        int i = 1;
        while (i < cnt + 1) {
            double pos = (double)i * this.length / (double)cnt;
            double rad = this.stem.stemRadius((double)this.index * this.length + pos);
            this.addSubsegment(new SubsegmentImpl(this.getLowerPosition().add(dir.mul(pos / this.length)), rad, pos, this));
            ++i;
        }
    }

    private void makeSphericalEnd(int cnt) {
        net.sourceforge.arbaro.transformation.Vector dir = this.getUpperPosition().sub(this.getLowerPosition());
        int i = 1;
        while (i < cnt) {
            double pos = this.length - this.length / Math.pow(2.0, i);
            double rad = this.stem.stemRadius((double)this.index * this.length + pos);
            this.addSubsegment(new SubsegmentImpl(this.getLowerPosition().add(dir.mul(pos / this.length)), rad, pos, this));
            ++i;
        }
        this.addSubsegment(new SubsegmentImpl(this.getUpperPosition(), this.rad2, this.length, this));
    }

    private void makeFlare(int cnt) {
        net.sourceforge.arbaro.transformation.Vector dir = this.getUpperPosition().sub(this.getLowerPosition());
        int i = cnt - 1;
        while (i >= 0) {
            double pos = this.length / Math.pow(2.0, i);
            double rad = this.stem.stemRadius((double)this.index * this.length + pos);
            this.addSubsegment(new SubsegmentImpl(this.getLowerPosition().add(dir.mul(pos / this.length)), rad, pos, this));
            --i;
        }
    }

    private void makeHelix(int cnt) {
        double angle = Math.abs(this.lpar.nCurveV) / 180.0 * Math.PI;
        double rad = Math.sqrt(1.0 / (Math.cos(angle) * Math.cos(angle)) - 1.0) * this.length / Math.PI / 2.0;
        if (Console.debug()) {
            this.stem.DBG("Segment.make_helix angle: " + angle + " len: " + this.length + " rad: " + rad);
        }
        int i = 1;
        while (i < cnt + 1) {
            net.sourceforge.arbaro.transformation.Vector pos = new net.sourceforge.arbaro.transformation.Vector(rad * Math.cos(Math.PI * 2 * (double)i / (double)cnt) - rad, rad * Math.sin(Math.PI * 2 * (double)i / (double)cnt), (double)i * this.length / (double)cnt);
            double srad = this.stem.stemRadius((double)this.index * this.length + (double)i * this.length / (double)cnt);
            this.addSubsegment(new SubsegmentImpl(this.transf.apply(pos), srad, (double)i * this.length / (double)cnt, this));
            ++i;
        }
    }

    public Transformation substemPosition(Transformation trf, double where) {
        if (this.lpar.nCurveV >= 0.0) {
            return trf.translate(this.transf.getZ().mul(where * this.length));
        }
        int i = (int)(where * (double)(this.subsegments.size() - 1));
        net.sourceforge.arbaro.transformation.Vector p1 = ((SubsegmentImpl)this.subsegments.elementAt((int)i)).pos;
        net.sourceforge.arbaro.transformation.Vector p2 = ((SubsegmentImpl)this.subsegments.elementAt((int)(i + 1))).pos;
        net.sourceforge.arbaro.transformation.Vector pos = p1.add(p2.sub(p1).mul(where - (double)(i / (this.subsegments.size() - 1))));
        return trf.translate(pos.sub(this.getLowerPosition()));
    }

    public net.sourceforge.arbaro.transformation.Vector getLowerPosition() {
        return this.transf.getT();
    }

    public net.sourceforge.arbaro.transformation.Vector getPosition() {
        return this.transf.getT();
    }

    public net.sourceforge.arbaro.transformation.Vector getUpperPosition() {
        return this.transf.getT().add(this.transf.getZ().mul(this.length));
    }

    public int getIndex() {
        return this.index;
    }

    public int getSubsegmentCount() {
        return this.subsegments.size();
    }

    public double getLowerRadius() {
        return this.rad1;
    }

    public double getRadius() {
        return this.rad1;
    }

    public double getDistance() {
        return (double)this.index * this.length;
    }

    public net.sourceforge.arbaro.transformation.Vector getZ() {
        return this.transf.getZ();
    }

    public double getUpperRadius() {
        return this.rad2;
    }

    public boolean isLastStemSegment() {
        return this.index == this.stem.segmentCount - 1;
    }

    public net.sourceforge.arbaro.transformation.Vector[] getSectionPoints() {
        net.sourceforge.arbaro.transformation.Vector[] points;
        int pt_cnt = this.lpar.mesh_points;
        Transformation trf = this.getTransformation();
        double rad = this.rad1;
        if (rad < 1.0E-6) {
            points = new net.sourceforge.arbaro.transformation.Vector[]{trf.apply(new net.sourceforge.arbaro.transformation.Vector(0.0, 0.0, 0.0))};
        } else {
            points = new net.sourceforge.arbaro.transformation.Vector[pt_cnt];
            int i = 0;
            while (i < pt_cnt) {
                double angle = (double)i * 360.0 / (double)pt_cnt;
                if (this.lpar.level == 0 && this.par.Lobes != 0) {
                    angle -= 10.0 / (double)this.par.Lobes;
                }
                net.sourceforge.arbaro.transformation.Vector pt = new net.sourceforge.arbaro.transformation.Vector(Math.cos(angle * Math.PI / 180.0), Math.sin(angle * Math.PI / 180.0), 0.0);
                if (this.lpar.level == 0 && (this.par.Lobes != 0 || this.par._0ScaleV != 0.0)) {
                    double rad1 = rad * (1.0 + this.par.random.uniform(-this.par._0ScaleV, this.par._0ScaleV) / (double)this.getSubsegmentCount());
                    pt = pt.mul(rad1 * (1.0 + this.par.LobeDepth * Math.cos((double)this.par.Lobes * angle * Math.PI / 180.0)));
                } else {
                    pt = pt.mul(rad);
                }
                points[i] = pt = trf.apply(pt);
                ++i;
            }
        }
        return points;
    }
}

