/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import junit.framework.TestCase;
import junit.swingui.TestRunner;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Matrix;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.LeafImpl;

public class LeafTest
extends TestCase {
    double prec = 1.0E-5;
    static /* synthetic */ Class class$0;

    private void assertMatrixEquals(Matrix m1, Matrix m2) {
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                LeafTest.assertEquals((double)m1.get(r, c), (double)m2.get(r, c), (double)this.prec);
                ++c;
            }
            ++r;
        }
    }

    private void assertVectorEquals(Vector v1, Vector v2) {
        LeafTest.assertEquals((double)v1.getX(), (double)v2.getX(), (double)this.prec);
        LeafTest.assertEquals((double)v1.getY(), (double)v2.getY(), (double)this.prec);
        LeafTest.assertEquals((double)v1.getZ(), (double)v2.getZ(), (double)this.prec);
    }

    private void assertTransformationEquals(Transformation T1, Transformation T2) {
        this.assertMatrixEquals(T1.matrix(), T2.matrix());
        this.assertVectorEquals(T1.vector(), T2.vector());
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.tree.LeafTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testLeaf() {
        Params params = new Params();
        Transformation[] T = new Transformation[]{new Transformation(), new Transformation().rotx(35.0).translate(new Vector(0.9, 1.2, 0.0)), new Transformation().rotz(120.0).translate(new Vector(0.9, 1.2, 0.0)), new Transformation().roty(156.0).translate(new Vector(0.9, 1.2, 0.0)), new Transformation().rotx(180.0).translate(new Vector(-0.9, 1.2, 0.0))};
        int i = 0;
        while (i < T.length) {
            params.LeafBend = 0.0;
            LeafImpl leaf = new LeafImpl(T[i]);
            leaf.make(params);
            this.assertTransformationEquals(T[i], leaf.transf);
            params.LeafBend = 1.0;
            leaf = new LeafImpl(T[i]);
            leaf.make(params);
            Vector t = T[i].getT();
            Vector z = leaf.transf.getZ();
            this.assertVectorEquals(t, leaf.transf.getT());
            if (t.abs() > this.prec) {
                LeafTest.assertEquals((String)("T[" + i + "]"), (double)Math.abs(z.prod(t.normalize())), (double)1.0, (double)this.prec);
            }
            LeafTest.assertEquals((String)("T[" + i + "]"), (double)z.getZ(), (double)0.0, (double)this.prec);
            ++i;
        }
    }
}

