/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.transformation;

import junit.framework.TestCase;
import junit.swingui.TestRunner;
import net.sourceforge.arbaro.transformation.Vector;

public class VectorTest
extends TestCase {
    double prec = 1.0E-5;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.transformation.VectorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testVector() {
        Vector v = new Vector();
        VectorTest.assertEquals((double)v.getX(), (double)0.0, (double)this.prec);
        VectorTest.assertEquals((double)v.getY(), (double)0.0, (double)this.prec);
        VectorTest.assertEquals((double)v.getZ(), (double)0.0, (double)this.prec);
    }

    public void testVectordoubledoubledouble() {
        Vector v = new Vector(13.1, 1700000.23, -0.002);
        VectorTest.assertEquals((double)v.getX(), (double)13.1, (double)this.prec);
        VectorTest.assertEquals((double)v.getY(), (double)1700000.23, (double)this.prec);
        VectorTest.assertEquals((double)v.getZ(), (double)-0.002, (double)this.prec);
    }

    public void testAbs() {
        Vector v1 = new Vector(1.0, 2.0, 3.0);
        Vector v2 = new Vector(-1.0, 2.0, -3.0);
        VectorTest.assertEquals((double)v1.abs(), (double)Math.sqrt(14.0), (double)this.prec);
        VectorTest.assertEquals((double)v2.abs(), (double)Math.sqrt(14.0), (double)this.prec);
    }

    public void testToString() {
        Vector v = new Vector(3.0, -4.0, 5.0);
        VectorTest.assertEquals((String)v.toString(), (String)"<3,-4,5>");
        Vector v1 = new Vector(3.0001, -4.46464646, 5.999);
        VectorTest.assertEquals((String)v1.toString(), (String)"<3.0001,-4.46465,5.999>");
    }

    public void testNormalize() {
        Vector v = new Vector(3.0, 4.0, 5.0);
        Vector n = v.normalize();
        VectorTest.assertEquals((double)n.abs(), (double)1.0, (double)this.prec);
        VectorTest.assertEquals((double)(n.getX() / n.getY()), (double)(v.getX() / v.getY()), (double)this.prec);
        VectorTest.assertEquals((double)(n.getX() / n.getZ()), (double)(v.getX() / v.getZ()), (double)this.prec);
        VectorTest.assertEquals((double)(n.getZ() / n.getY()), (double)(v.getZ() / v.getY()), (double)this.prec);
    }

    public void testGetX() {
        Vector v = new Vector(13.1, 2.0, 3.0);
        VectorTest.assertEquals((double)v.getX(), (double)13.1, (double)this.prec);
    }

    public void testGetY() {
        Vector v = new Vector(13.1, -2.444, 3.0);
        VectorTest.assertEquals((double)v.getY(), (double)-2.444, (double)this.prec);
    }

    public void testGetZ() {
        Vector v = new Vector(13.1, 2.0, 3.333);
        VectorTest.assertEquals((double)v.getZ(), (double)3.333, (double)this.prec);
    }

    public void testMul() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = u.mul(-2.0);
        VectorTest.assertEquals((double)v.getX(), (double)2.0, (double)this.prec);
        VectorTest.assertEquals((double)v.getY(), (double)-4.0, (double)this.prec);
        VectorTest.assertEquals((double)v.getZ(), (double)-6.0, (double)this.prec);
    }

    public void testProd() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = new Vector(-2.0, 2.0, 2.0);
        double p = u.prod(v);
        VectorTest.assertEquals((double)p, (double)12.0, (double)this.prec);
    }

    public void testDiv() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = u.div(-2.0);
        VectorTest.assertEquals((double)v.getX(), (double)0.5, (double)this.prec);
        VectorTest.assertEquals((double)v.getY(), (double)-1.0, (double)this.prec);
        VectorTest.assertEquals((double)v.getZ(), (double)-1.5, (double)this.prec);
    }

    public void testAdd() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = new Vector(-2.0, 2.0, 2.0);
        Vector w = u.add(v);
        VectorTest.assertEquals((double)w.getX(), (double)-3.0, (double)this.prec);
        VectorTest.assertEquals((double)w.getY(), (double)4.0, (double)this.prec);
        VectorTest.assertEquals((double)w.getZ(), (double)5.0, (double)this.prec);
    }

    public void testSub() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = new Vector(-2.0, 2.0, 2.0);
        Vector w = u.sub(v);
        VectorTest.assertEquals((double)w.getX(), (double)1.0, (double)this.prec);
        VectorTest.assertEquals((double)w.getY(), (double)0.0, (double)this.prec);
        VectorTest.assertEquals((double)w.getZ(), (double)1.0, (double)this.prec);
    }

    public void testAtan2() {
        VectorTest.assertEquals((double)Vector.atan2(0.0, 2.0), (double)0.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(2.0, 0.0), (double)90.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(0.0, -2.0), (double)180.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(1.0E-8, -2.0), (double)180.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(-1.0E-8, -2.0), (double)-180.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(-2.0, 0.0), (double)-90.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(2.0, 2.0), (double)45.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(2.0, -2.0), (double)135.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(-2.0, 2.0), (double)-45.0, (double)this.prec);
        VectorTest.assertEquals((double)Vector.atan2(-2.0, -2.0), (double)-135.0, (double)this.prec);
    }

    public void testSetMaxCoord() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = new Vector(-2.0, 2.0, 2.0);
        u.setMaxCoord(v);
        VectorTest.assertEquals((double)u.getX(), (double)-1.0, (double)this.prec);
        VectorTest.assertEquals((double)u.getY(), (double)2.0, (double)this.prec);
        VectorTest.assertEquals((double)u.getZ(), (double)3.0, (double)this.prec);
    }

    public void testSetMinCoord() {
        Vector u = new Vector(-1.0, 2.0, 3.0);
        Vector v = new Vector(-2.0, 2.0, 2.0);
        u.setMinCoord(v);
        VectorTest.assertEquals((double)u.getX(), (double)-2.0, (double)this.prec);
        VectorTest.assertEquals((double)u.getY(), (double)2.0, (double)this.prec);
        VectorTest.assertEquals((double)u.getZ(), (double)2.0, (double)this.prec);
    }
}

