/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.transformation;

import junit.framework.TestCase;
import junit.swingui.TestRunner;
import net.sourceforge.arbaro.transformation.Matrix;
import net.sourceforge.arbaro.transformation.Vector;

public class MatrixTest
extends TestCase {
    double prec = 1.0E-5;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.transformation.MatrixTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testMatrix() {
        Matrix m = new Matrix();
        MatrixTest.assertEquals((double)m.get(0, 0), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)0.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)0.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)0.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)0.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)0.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)0.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)1.0, (double)this.prec);
    }

    public void testMatrixdoubledoubledoubledoubledoubledoubledoubledoubledouble() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)3.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)5.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)7.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)9.0, (double)this.prec);
    }

    public void testRow() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Vector u = m.row(0);
        MatrixTest.assertEquals((double)u.getX(), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)u.getY(), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)u.getZ(), (double)3.0, (double)this.prec);
        Vector v = m.row(1);
        MatrixTest.assertEquals((double)v.getX(), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)v.getY(), (double)5.0, (double)this.prec);
        MatrixTest.assertEquals((double)v.getZ(), (double)6.0, (double)this.prec);
        Vector w = m.row(2);
        MatrixTest.assertEquals((double)w.getX(), (double)7.0, (double)this.prec);
        MatrixTest.assertEquals((double)w.getY(), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)w.getZ(), (double)9.0, (double)this.prec);
    }

    public void testCol() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Vector u = m.col(0);
        MatrixTest.assertEquals((double)u.getX(), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)u.getY(), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)u.getZ(), (double)7.0, (double)this.prec);
        Vector v = m.col(1);
        MatrixTest.assertEquals((double)v.getX(), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)v.getY(), (double)5.0, (double)this.prec);
        MatrixTest.assertEquals((double)v.getZ(), (double)8.0, (double)this.prec);
        Vector w = m.col(2);
        MatrixTest.assertEquals((double)w.getX(), (double)3.0, (double)this.prec);
        MatrixTest.assertEquals((double)w.getY(), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)w.getZ(), (double)9.0, (double)this.prec);
    }

    public void testGet() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)3.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)5.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)7.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)9.0, (double)this.prec);
    }

    public void testSet() {
        Matrix m = new Matrix();
        m.set(0, 0, -1.0);
        m.set(0, 1, 2.0);
        m.set(0, 2, 3.0);
        m.set(1, 0, 4.0);
        m.set(1, 1, 5.0);
        m.set(1, 2, 6.0);
        m.set(2, 0, 7.0);
        m.set(2, 1, 8.0);
        m.set(2, 2, 9.0);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)-1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)3.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)5.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)7.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)9.0, (double)this.prec);
        m.set(0, 0, 1.0);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)1.0, (double)this.prec);
    }

    public void testTranspose() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0).transpose();
        MatrixTest.assertEquals((double)m.get(0, 0), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)7.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)5.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)3.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)9.0, (double)this.prec);
    }

    public void testMul() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0).mul(2.0);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)10.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)12.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)14.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)16.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)18.0, (double)this.prec);
    }

    public void testProdMatrix() {
        Matrix n1 = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Matrix n2 = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Matrix m = n1.prod(n2);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)n1.row(0).prod(n2.col(0)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)n1.row(0).prod(n2.col(1)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)n1.row(0).prod(n2.col(2)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)n1.row(1).prod(n2.col(0)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)n1.row(1).prod(n2.col(1)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)n1.row(1).prod(n2.col(2)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)n1.row(2).prod(n2.col(0)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)n1.row(2).prod(n2.col(1)), (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)n1.row(2).prod(n2.col(2)), (double)this.prec);
    }

    public void testAdd() {
        Matrix n1 = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Matrix n2 = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Matrix m = n1.add(n2);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)10.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)12.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)14.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)16.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)18.0, (double)this.prec);
    }

    public void testProdVector() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Vector v = new Vector(-1.0, 1.0, 2.0);
        Vector p = m.prod(v);
        MatrixTest.assertEquals((double)p.getX(), (double)7.0, (double)this.prec);
        MatrixTest.assertEquals((double)p.getY(), (double)13.0, (double)this.prec);
        MatrixTest.assertEquals((double)p.getZ(), (double)19.0, (double)this.prec);
    }

    public void testDiv() {
        Matrix m = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0).div(2.0);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)0.5, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)1.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)1.5, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)2.5, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)3.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)3.5, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)4.5, (double)this.prec);
    }

    public void testSub() {
        Matrix n1 = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        Matrix n2 = new Matrix(-1.0, -2.0, -3.0, -4.0, -5.0, -6.0, -7.0, -8.0, -9.0);
        Matrix m = n1.sub(n2);
        MatrixTest.assertEquals((double)m.get(0, 0), (double)2.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 1), (double)4.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(0, 2), (double)6.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 0), (double)8.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 1), (double)10.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(1, 2), (double)12.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 0), (double)14.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 1), (double)16.0, (double)this.prec);
        MatrixTest.assertEquals((double)m.get(2, 2), (double)18.0, (double)this.prec);
    }
}

