/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.params;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.params.ParamException;

public abstract class AbstractParam {
    public static final int GENERAL = -999;
    String name;
    String group;
    int level;
    int order;
    String shortDesc;
    String longDesc;
    boolean enabled;
    protected ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    public static boolean loading = false;
    static /* synthetic */ Class class$0;

    public AbstractParam(String nam, String grp, int lev, int ord, String sh, String lng) {
        this.name = nam;
        this.group = grp;
        this.level = lev;
        this.order = ord;
        this.shortDesc = sh;
        this.longDesc = lng;
        this.enabled = true;
    }

    public abstract void setValue(String var1) throws ParamException;

    public abstract String getValue();

    public abstract String getDefaultValue();

    public abstract void clear();

    public abstract boolean empty();

    protected void warn(String warning) {
        if (!loading) {
            Console.errorOutput("WARNING: " + warning);
        }
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
        this.fireStateChanged();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public int getLevel() {
        return this.level;
    }

    public int getOrder() {
        return this.order;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    public String toString() {
        if (!this.empty()) {
            return this.getValue();
        }
        return this.getDefaultValue();
    }

    public String getLongDesc() {
        return this.longDesc;
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }
}

