/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.MeshException;
import net.sourceforge.arbaro.mesh.UVVector;
import net.sourceforge.arbaro.mesh.Vertex;
import net.sourceforge.arbaro.params.FloatFormat;

public class MeshSection
extends Vector {
    private static final long serialVersionUID = 1L;
    public MeshSection previous;
    public MeshSection next;
    public double mapV;

    public MeshSection(int ptcnt, double v) {
        super(ptcnt);
        this.mapV = v;
    }

    public void addPoint(net.sourceforge.arbaro.transformation.Vector pt, double mapU) {
        this.addElement(new Vertex(pt, null, new UVVector(mapU, this.mapV)));
    }

    public net.sourceforge.arbaro.transformation.Vector pointAt(int i) {
        return ((Vertex)this.elementAt((int)i)).point;
    }

    public Enumeration allVertices(boolean UVVertices) {
        if (UVVertices) {
            return new UVVertexEnumerator();
        }
        return this.elements();
    }

    public Enumeration allFaces(int startIndex, boolean UVFaces, boolean useQuads) {
        return new FaceEnumerator(startIndex, UVFaces, useQuads);
    }

    public UVVector uvAt(int i) {
        if (i < this.size()) {
            return ((Vertex)this.elementAt((int)i)).uv;
        }
        return new UVVector(1.0, this.mapV);
    }

    public boolean isFirst() {
        return this.previous == null;
    }

    public boolean isLast() {
        return this.next == null;
    }

    public int faceCount(boolean useQuads) {
        if (this.size() == 1) {
            return this.next.size();
        }
        if (this.next.size() == 1 || useQuads) {
            return this.size();
        }
        return this.size() * 2;
    }

    public net.sourceforge.arbaro.transformation.Vector normalAt(int i) throws Exception {
        Vertex v = (Vertex)this.elementAt(i);
        if (v.normal == null) {
            throw new MeshException("Error: Normal not set for point " + this.vectorStr(v.point));
        }
        return v.normal;
    }

    private String vectorStr(net.sourceforge.arbaro.transformation.Vector v) {
        NumberFormat fmt = FloatFormat.getInstance();
        return "<" + fmt.format(v.getX()) + "," + fmt.format(v.getZ()) + "," + fmt.format(v.getY()) + ">";
    }

    public net.sourceforge.arbaro.transformation.Vector here(int i) {
        return ((Vertex)this.elementAt((int)i)).point;
    }

    public net.sourceforge.arbaro.transformation.Vector left(int i) {
        return ((Vertex)this.elementAt((int)((i - 1 + this.size()) % this.size()))).point;
    }

    public net.sourceforge.arbaro.transformation.Vector right(int i) {
        return ((Vertex)this.elementAt((int)((i + 1) % this.size()))).point;
    }

    public net.sourceforge.arbaro.transformation.Vector up(int i) {
        return ((Vertex)this.next.elementAt((int)(i % this.next.size()))).point;
    }

    public net.sourceforge.arbaro.transformation.Vector down(int i) {
        return ((Vertex)this.previous.elementAt((int)(i % this.previous.size()))).point;
    }

    public net.sourceforge.arbaro.transformation.Vector normal(net.sourceforge.arbaro.transformation.Vector a, net.sourceforge.arbaro.transformation.Vector b, net.sourceforge.arbaro.transformation.Vector c) {
        net.sourceforge.arbaro.transformation.Vector u = a.sub(b).normalize();
        net.sourceforge.arbaro.transformation.Vector v = c.sub(b).normalize();
        net.sourceforge.arbaro.transformation.Vector norm = new net.sourceforge.arbaro.transformation.Vector(u.getY() * v.getZ() - u.getZ() * v.getY(), u.getZ() * v.getX() - u.getX() * v.getZ(), u.getX() * v.getY() - u.getY() * v.getX()).normalize();
        if (Double.isNaN(norm.getX()) && Double.isNaN(norm.getY()) && Double.isNaN(norm.getZ())) {
            System.err.println("WARNING: invalid normal vector - stem radius too small?");
            norm = new net.sourceforge.arbaro.transformation.Vector(0.0, 0.0, 1.0);
        }
        return norm;
    }

    public void setNormalsToVector(net.sourceforge.arbaro.transformation.Vector vec) {
        int i = 0;
        while (i < this.size()) {
            ((Vertex)this.elementAt((int)i)).normal = vec;
            ++i;
        }
    }

    public void setNormalsUp() {
        int i = 0;
        while (i < this.size()) {
            ((Vertex)this.elementAt((int)i)).normal = this.normal(this.up(i), this.here(i), this.left(i)).add(this.normal(this.right(i), this.here(i), this.up(i))).normalize();
            ++i;
        }
    }

    public void setNormalsDown() {
        int i = 0;
        while (i < this.size()) {
            ((Vertex)this.elementAt((int)i)).normal = this.normal(this.down(i), this.here(i), this.right(i)).add(this.normal(this.left(i), this.here(i), this.down(i))).normalize();
            ++i;
        }
    }

    public void setNormalsUpDown() {
        int i = 0;
        while (i < this.size()) {
            ((Vertex)this.elementAt((int)i)).normal = this.normal(this.up(i), this.here(i), this.left(i)).add(this.normal(this.right(i), this.here(i), this.up(i))).add(this.normal(this.down(i), this.here(i), this.right(i))).add(this.normal(this.left(i), this.here(i), this.down(i))).normalize();
            ++i;
        }
    }

    private class UVVertexEnumerator
    implements Enumeration {
        private int i = 0;

        public boolean hasMoreElements() {
            return this.i == 0 && MeshSection.this.size() == 1 || this.i <= MeshSection.this.size() && MeshSection.this.size() > 1;
        }

        public Object nextElement() {
            if (this.i < MeshSection.this.size()) {
                return ((Vertex)MeshSection.this.elementAt((int)this.i++)).uv;
            }
            if (this.i == MeshSection.this.size() && MeshSection.this.size() > 1) {
                ++this.i;
                return new UVVector(1.0, MeshSection.this.mapV);
            }
            throw new NoSuchElementException();
        }
    }

    private class FaceEnumerator
    implements Enumeration {
        private int i;
        private int ni;
        private int cnt_i;
        private int cnt_ni;
        private int inx;
        private int ninx;
        private boolean quads;
        private boolean uv;
        private Face face;

        public FaceEnumerator(int startIndex, boolean UVFaces, boolean useQuads) {
            if (MeshSection.this.next == null) {
                return;
            }
            this.i = 0;
            this.ni = 0;
            this.inx = startIndex;
            this.ninx = UVFaces ? this.inx + (MeshSection.this.size() == 1 ? 1 : MeshSection.this.size() + 1) : this.inx + MeshSection.this.size();
            this.quads = useQuads;
            this.uv = UVFaces;
            if (this.uv) {
                this.cnt_i = MeshSection.this.size() + 1;
                this.cnt_ni = MeshSection.this.next.size() + 1;
            } else {
                this.cnt_i = MeshSection.this.size();
                this.cnt_ni = MeshSection.this.next.size();
            }
            if (MeshSection.this.size() == 1 && MeshSection.this.next.size() == 1) {
                Console.errorOutput("WARNING: two adjacent mesh sections with only one point.");
            }
        }

        public boolean hasMoreElements() {
            return !(MeshSection.this.next == null || MeshSection.this.size() == 1 && this.ni >= MeshSection.this.next.size() || MeshSection.this.next.size() == 1 && this.i >= MeshSection.this.size() || this.ni >= MeshSection.this.next.size() && this.i >= MeshSection.this.size());
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.face = this.quads && MeshSection.this.size() > 1 && MeshSection.this.next.size() == MeshSection.this.size() ? new Face(this.inx + this.i, this.ninx + this.ni, this.ninx + ++this.ni % this.cnt_ni, this.inx + ++this.i % this.cnt_i) : (this.i <= this.ni || MeshSection.this.next.size() == 1 ? new Face(this.inx + this.i, this.ninx + this.ni, this.inx + ++this.i % this.cnt_i) : new Face(this.inx + this.i % this.cnt_i, this.ninx + this.ni, this.ninx + ++this.ni % this.cnt_ni));
            return this.face;
        }
    }
}

