/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import java.util.Enumeration;
import java.util.Vector;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshException;
import net.sourceforge.arbaro.mesh.MeshSection;
import net.sourceforge.arbaro.mesh.VFace;
import net.sourceforge.arbaro.mesh.Vertex;
import net.sourceforge.arbaro.tree.Stem;

public class MeshPart
extends Vector {
    private static final long serialVersionUID = 1L;
    Stem stem;
    boolean useNormals;
    boolean useQuads;

    public MeshPart(Stem stem, boolean useNormals, boolean useQuads) {
        this.useNormals = useNormals;
        this.useQuads = useQuads;
        this.stem = stem;
    }

    public Stem getStem() {
        return this.stem;
    }

    public String getTreePosition() {
        return this.stem.getTreePosition();
    }

    public int getLevel() {
        return this.stem.getLevel();
    }

    public void addSection(MeshSection section) {
        if (this.size() > 0) {
            ((MeshSection)this.lastElement()).next = section;
            section.previous = (MeshSection)this.lastElement();
        }
        this.addElement(section);
    }

    public Enumeration allVertices(boolean UVVertices) {
        return new VertexEnumerator(UVVertices);
    }

    public Enumeration allFaces(Mesh mesh, int startIndex, boolean UVFaces) {
        return new FaceEnumerator(mesh, startIndex, UVFaces, this.useQuads);
    }

    public void setNormals(boolean checkNull) {
        if (checkNull) {
            MeshSection s = (MeshSection)this.elementAt(0);
            int i = 0;
            while (i < s.size()) {
                if (((Vertex)s.elementAt((int)i)).normal == null) {
                    Console.errorOutput("No normal set for lower section of mesh part of stem " + this.stem.getTreePosition());
                }
                ++i;
            }
            s = (MeshSection)this.elementAt(this.size() - 1);
            i = 0;
            while (i < s.size()) {
                if (((Vertex)s.elementAt((int)i)).normal == null) {
                    Console.errorOutput("No normal set for upper section of mesh part of stem " + this.stem.getTreePosition());
                }
                ++i;
            }
        }
        if (this.size() > 1) {
            ((MeshSection)this.elementAt(1)).setNormalsUp();
            int i = 2;
            while (i < this.size() - 1) {
                ((MeshSection)this.elementAt(i)).setNormalsUpDown();
                ++i;
            }
        } else {
            Console.errorOutput("WARNING: degnerated MeshPart with only " + this.size() + " sections at" + " tree position " + this.stem.getTreePosition() + ".");
        }
    }

    public int vertexCount() {
        int cnt = 0;
        int i = 1;
        while (i < this.size()) {
            cnt += ((MeshSection)this.elementAt(i)).size();
            ++i;
        }
        return cnt;
    }

    public int uvCount() {
        int cnt = 0;
        int i = 1;
        while (i < this.size()) {
            cnt += ((MeshSection)this.elementAt(i)).size() == 1 ? 1 : ((MeshSection)this.elementAt(i)).size() + 1;
            ++i;
        }
        return cnt;
    }

    public int faceCount() {
        int cnt = 0;
        int i = 1;
        while (i < this.size() - 1) {
            int c_i1;
            int c_i = ((MeshSection)this.elementAt(i)).size();
            if (c_i != (c_i1 = ((MeshSection)this.elementAt(i + 1)).size())) {
                cnt += Math.max(c_i, c_i1);
            } else if (c_i > 1) {
                cnt += 2 * c_i;
            }
            ++i;
        }
        return cnt;
    }

    public Vector faces(long inx, MeshSection section) throws MeshException {
        MeshSection next = section.next;
        Vector<Face> faces = new Vector<Face>();
        if (section.size() == 1 && next.size() == 1) {
            System.err.println("WARNING: two adjacent mesh sections with only one point.");
            return faces;
        }
        if (section.isFirst()) {
            int i = 1;
            while (i < next.size() - 1) {
                faces.addElement(new Face(inx, inx + (long)i, inx + (long)i + 1L));
                ++i;
            }
        } else if (section.size() == 1) {
            int i = 0;
            while (i < next.size()) {
                faces.addElement(new Face(inx, inx + 1L + (long)i, inx + 1L + (long)((i + 1) % next.size())));
                ++i;
            }
        } else if (next.size() == 1) {
            long ninx = inx + (long)section.size();
            int i = 0;
            while (i < section.size()) {
                faces.addElement(new Face(inx + (long)i, ninx, inx + (long)((i + 1) % section.size())));
                ++i;
            }
        } else {
            long ninx = inx + (long)section.size();
            if (section.size() != next.size()) {
                throw new MeshException("Error: vertice numbers of two sections differ (" + inx + "," + ninx + ")");
            }
            int i = 0;
            while (i < section.size()) {
                if (this.useQuads) {
                    faces.addElement(new Face(inx + (long)i, ninx + (long)i, ninx + (long)((i + 1) % next.size()), inx + (long)((i + 1) % section.size())));
                } else {
                    faces.addElement(new Face(inx + (long)i, ninx + (long)i, inx + (long)((i + 1) % section.size())));
                    faces.addElement(new Face(inx + (long)((i + 1) % section.size()), ninx + (long)i, ninx + (long)((i + 1) % next.size())));
                }
                ++i;
            }
        }
        return faces;
    }

    public Vector vFaces(MeshSection section) throws MeshException {
        MeshSection next = section.next;
        Vector<VFace> faces = new Vector<VFace>();
        if (section.size() == 1 && next.size() == 1) {
            System.err.println("WARNING: two adjacent mesh sections with only one point.");
            return faces;
        }
        if (section.isFirst()) {
            int i = 1;
            while (i < next.size() - 1) {
                faces.addElement(new VFace(next.pointAt(0), next.pointAt(i), next.pointAt(i + 1)));
                ++i;
            }
        } else if (section.size() == 1) {
            int i = 0;
            while (i < next.size()) {
                faces.addElement(new VFace(section.pointAt(0), next.pointAt(i), next.pointAt((i + 1) % next.size())));
                ++i;
            }
        } else if (next.size() == 1) {
            int i = 0;
            while (i < section.size()) {
                faces.addElement(new VFace(section.pointAt(i), next.pointAt(0), section.pointAt((i + 1) % section.size())));
                ++i;
            }
        } else {
            if (section.size() != next.size()) {
                throw new MeshException("Error: vertice numbers of two sections differ (" + section.size() + "," + next.size() + ")");
            }
            int i = 0;
            while (i < section.size()) {
                faces.addElement(new VFace(section.pointAt(i), next.pointAt(i), section.pointAt((i + 1) % section.size())));
                faces.addElement(new VFace(section.pointAt((i + 1) % section.size()), next.pointAt(i), next.pointAt((i + 1) % next.size())));
                ++i;
            }
        }
        return faces;
    }

    public Vector uvFaces(long inx, MeshSection section, Mesh mesh) throws MeshException {
        int i;
        MeshSection next = section.next;
        Vector<Face> faces = new Vector<Face>();
        if (section.size() == 1 && next.size() == 1) {
            System.err.println("WARNING: two adjacent mesh sections with only one point.");
            return faces;
        }
        int uvVertexOffset = 0;
        if (this.stem.isClone()) {
            MeshPart mp = (MeshPart)mesh.elementAt(mesh.firstMeshPart[this.stem.getLevel()]);
            MeshSection ms = (MeshSection)mp.elementAt(1);
            i = 0;
            while (i < this.stem.getCloneSectionOffset()) {
                uvVertexOffset += ms.size() == 1 ? 1 : ms.size() + 1;
                ms = ms.next;
                ++i;
            }
        }
        long ninx = section.size() > 1 ? inx + (long)section.size() + 1L + (long)uvVertexOffset : (long)(1 + uvVertexOffset);
        if (section.isFirst()) {
            inx += (long)uvVertexOffset;
        }
        if (section.isFirst()) {
            i = 1;
            while (i < next.size() - 1) {
                faces.addElement(new Face(inx, inx + (long)i, inx + (long)i + 1L));
                ++i;
            }
        } else if (section.size() == 1) {
            i = 0;
            while (i < next.size()) {
                faces.addElement(new Face(inx, inx + ninx + (long)i, inx + ninx + (long)(i + 1)));
                ++i;
            }
        } else if (next.size() == 1) {
            i = 0;
            while (i < section.size()) {
                faces.addElement(new Face(inx + (long)i, ninx, inx + (long)(i + 1)));
                ++i;
            }
        } else {
            if (section.size() != next.size()) {
                throw new MeshException("Error: vertex numbers of two sections differ (" + inx + "," + ninx + ")");
            }
            i = 0;
            while (i < section.size()) {
                if (this.useQuads) {
                    faces.addElement(new Face(inx + (long)i, ninx + (long)i, ninx + (long)(i + 1), inx + (long)(i + 1)));
                } else {
                    faces.addElement(new Face(inx + (long)i, ninx + (long)i, inx + (long)(i + 1)));
                    faces.addElement(new Face(inx + (long)(i + 1), ninx + (long)i, ninx + (long)(i + 1)));
                }
                ++i;
            }
        }
        return faces;
    }

    private class VertexEnumerator
    implements Enumeration {
        private Enumeration sections;
        private Enumeration sectionVertices;
        private boolean UVVertices;

        public VertexEnumerator(boolean uv) {
            this.UVVertices = uv;
            this.sections = MeshPart.this.elements();
            this.sections.nextElement();
            this.sectionVertices = ((MeshSection)this.sections.nextElement()).allVertices(this.UVVertices);
        }

        public boolean hasMoreElements() {
            if (!this.sectionVertices.hasMoreElements() && this.sections.hasMoreElements()) {
                this.sectionVertices = ((MeshSection)this.sections.nextElement()).allVertices(this.UVVertices);
            }
            return this.sectionVertices.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.sectionVertices.hasMoreElements() && this.sections.hasMoreElements()) {
                this.sectionVertices = ((MeshSection)this.sections.nextElement()).allVertices(this.UVVertices);
            }
            return this.sectionVertices.nextElement();
        }
    }

    private class FaceEnumerator
    implements Enumeration {
        private Enumeration sections;
        private Enumeration sectionFaces;
        private MeshSection section;
        private boolean UVFaces;
        private boolean useQuads;
        private int startIndex;

        public FaceEnumerator(Mesh mesh, int startInx, boolean uv, boolean quads) {
            this.UVFaces = uv;
            this.startIndex = startInx;
            this.useQuads = quads;
            this.sections = MeshPart.this.elements();
            MeshSection sec = (MeshSection)this.sections.nextElement();
            int uvVertexOffset = 0;
            if (uv && MeshPart.this.stem.isClone()) {
                MeshPart mp = (MeshPart)mesh.elementAt(mesh.firstMeshPart[MeshPart.this.stem.getLevel()]);
                MeshSection ms = (MeshSection)mp.elementAt(1);
                int i = 0;
                while (i < MeshPart.this.stem.getCloneSectionOffset()) {
                    uvVertexOffset += ms.size() == 1 ? 1 : ms.size() + 1;
                    if (Console.debug()) {
                        Console.debugOutput("i: " + i + " vertexOff: " + uvVertexOffset);
                    }
                    ms = ms.next;
                    ++i;
                }
                this.startIndex += uvVertexOffset;
            }
            this.nextSection(true);
        }

        private void nextSection(boolean firstSection) {
            if (!firstSection) {
                this.startIndex = this.UVFaces ? (this.startIndex += this.section.size() == 1 ? 1 : this.section.size() + 1) : (this.startIndex += this.section.size());
            }
            this.section = (MeshSection)this.sections.nextElement();
            this.sectionFaces = this.section.allFaces(this.startIndex, this.UVFaces, this.useQuads);
        }

        public boolean hasMoreElements() {
            if (!this.sectionFaces.hasMoreElements() && this.sections.hasMoreElements()) {
                this.nextSection(false);
            }
            return this.sectionFaces.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.sectionFaces.hasMoreElements() && this.sections.hasMoreElements()) {
                this.nextSection(false);
            }
            return this.sectionFaces.nextElement();
        }
    }
}

