/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.Console;

public final class Progress {
    String phase;
    long maxProgress = 100L;
    long progress = 0L;

    public synchronized void beginPhase(String ph, long max) {
        this.phase = ph;
        this.maxProgress = max;
        this.progress = 0L;
        Console.verboseOutput(ph);
    }

    public synchronized void endPhase() {
        this.progress = this.maxProgress;
        Console.verboseOutput("");
    }

    public synchronized void setProgress(long prog) {
        this.progress = prog > this.maxProgress ? this.maxProgress : prog;
    }

    public synchronized void incProgress(long inc) {
        this.progress += inc;
    }

    public synchronized int getPercent() {
        if (this.maxProgress <= 0L) {
            return -1;
        }
        int percent = (int)((float)this.progress / (float)this.maxProgress * 100.0f);
        if (percent < 0) {
            return 0;
        }
        if (percent > 100) {
            return 100;
        }
        return percent;
    }

    public synchronized String getPhase() {
        return this.phase;
    }

    public synchronized long getMaxProgress() {
        return this.maxProgress;
    }
}

