/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.tree.Tree;

class POVSceneExporter
extends AbstractExporter {
    Tree tree;
    String povrayDeclarationPrefix;
    int renderW;
    int renderH;

    public POVSceneExporter(Tree tree, int renderW, int renderH) {
        this.tree = tree;
        this.renderW = renderW;
        this.renderH = renderH;
        this.povrayDeclarationPrefix = String.valueOf(tree.getSpecies()) + "_" + tree.getSeed() + "_";
    }

    public void doWrite() {
        this.w.println("// render as " + this.renderH + "x" + this.renderW);
        this.w.println("#include \"" + this.tree.getSpecies() + ".inc\"");
        this.w.println("background {rgb <0.95,0.95,0.9>}");
        this.w.println("light_source { <5000,5000,-3000>, rgb 1.2 }");
        this.w.println("light_source { <-5000,2000,3000>, rgb 0.5 shadowless }");
        this.w.println("#declare HEIGHT = " + this.povrayDeclarationPrefix + "height * 1.3;");
        this.w.println("#declare WIDTH = HEIGHT*" + this.renderW + "/" + this.renderH + ";");
        this.w.println("camera { orthographic location <0, HEIGHT*0.45, -100>");
        this.w.println("         right <WIDTH, 0, 0> up <0, HEIGHT, 0>");
        this.w.println("         look_at <0, HEIGHT*0.45, -80> }");
        this.w.println("union { ");
        this.w.println("         object { " + this.povrayDeclarationPrefix + "stems");
        this.w.println("                pigment {color rgb 0.9} }");
        this.w.println("         object { " + this.povrayDeclarationPrefix + "leaves");
        this.w.println("                texture { pigment {color rgb 1} ");
        this.w.println("                          finish { ambient 0.15 diffuse 0.8 }}}");
        this.w.println("         rotate 90*y }");
        if (this.tree.getLeafCount() > 0L) {
            this.w.println("         object { " + this.povrayDeclarationPrefix + "stems");
            this.w.println("                scale 0.7 rotate 45*y");
            this.w.println("                translate <WIDTH*0.33,HEIGHT*0.33,WIDTH>");
            this.w.println("                pigment {color rgb 0.9} }");
        }
        this.w.flush();
    }
}

