/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.POVMeshLeafWriterBase;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.tree.Leaf;

class POVMeshLeafFaceWriter
extends POVMeshLeafWriterBase {
    public POVMeshLeafFaceWriter(AbstractExporter exporter, LeafMesh leafMesh, long leafVertexOffset) {
        super(exporter, leafMesh, leafVertexOffset);
    }

    public boolean visitLeaf(Leaf leaf) {
        String indent = "    ";
        int i = 0;
        while (i < this.leafMesh.getShapeFaceCount()) {
            Face face = this.leafMesh.shapeFaceAt(i);
            this.w.print("<" + (this.leafVertexOffset + face.points[0]) + "," + (this.leafVertexOffset + face.points[1]) + "," + (this.leafVertexOffset + face.points[2]) + ">");
            if (i < this.leafMesh.getShapeFaceCount() - 1) {
                this.w.print(",");
            }
            if (i % 6 == 4) {
                this.w.println();
                this.w.print(String.valueOf(indent) + "          ");
            }
            ++i;
        }
        this.w.println();
        this.leafVertexOffset += (long)this.leafMesh.getShapeVertexCount();
        this.exporter.incProgressCount(500);
        return true;
    }
}

