/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.text.NumberFormat;
import java.util.Vector;
import net.sourceforge.arbaro.export.DXFLeafWriter;
import net.sourceforge.arbaro.export.DXFWriter;
import net.sourceforge.arbaro.export.MeshExporter;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.mesh.MeshPart;
import net.sourceforge.arbaro.mesh.MeshSection;
import net.sourceforge.arbaro.mesh.VFace;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.tree.Tree;

class DXFExporter
extends MeshExporter {
    NumberFormat frm = FloatFormat.getInstance();
    Tree tree;

    public DXFExporter(Tree tree, MeshGenerator meshFactory) {
        super(meshFactory);
        this.tree = tree;
    }

    public void doWrite() {
        DXFWriter writer = new DXFWriter(this.w);
        writer.writeHeader("DXF created with Arbaro, tree species: " + this.tree.getSpecies(), this.tree.getMinPoint(), this.tree.getMaxPoint());
        writer.writeTables();
        writer.writeBlocks();
        writer.writeEntitiesBegin();
        this.writeStems("1");
        this.writeLeafs("2");
        writer.writeEntitiesEnd();
        writer.wg(0, "EOF");
        this.w.flush();
    }

    private void writeStems(String layer) {
        Mesh mesh = this.meshGenerator.createStemMesh(this.tree, this.progress);
        this.progress.beginPhase("Writing stem mesh", mesh.size());
        DXFWriter writer = new DXFWriter(this.w);
        int i = 0;
        while (i < mesh.size()) {
            MeshPart mp = (MeshPart)mesh.elementAt(i);
            int k = 0;
            while (k < mp.size() - 1) {
                Vector faces = mp.vFaces((MeshSection)mp.elementAt(k));
                int j = 0;
                while (j < faces.size()) {
                    VFace face = (VFace)faces.elementAt(j);
                    writer.writeFace(face, layer);
                    ++j;
                }
                ++k;
            }
            this.incProgressCount(100);
            ++i;
        }
        this.progress.endPhase();
    }

    private void writeLeafs(String layer) {
        this.progress.beginPhase("Writing leaf mesh", this.tree.getLeafCount());
        DXFLeafWriter exporter = new DXFLeafWriter(this, this.meshGenerator, layer);
        this.tree.traverseTree(exporter);
        this.progress.endPhase();
    }
}

