/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

public final class Console {
    public static final int REALLY_QUIET = 0;
    public static final int QUIET = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static char progrChr = (char)32;
    public static int outputLevel;

    public static void setOutputLevel(int level) {
        outputLevel = level;
        progrChr = outputLevel >= 2 ? (char)46 : (char)32;
    }

    public static synchronized boolean debug() {
        return outputLevel >= 3;
    }

    public static synchronized void progressChar() {
        if (outputLevel >= 2) {
            System.err.print(progrChr);
        }
    }

    public static synchronized void verboseOutput(String msg) {
        if (outputLevel >= 2) {
            System.err.println(msg);
        }
    }

    public static synchronized void debugOutput(String msg) {
        if (outputLevel >= 3) {
            System.err.println(msg);
        }
    }

    public static synchronized void errorOutput(String msg) {
        if (outputLevel > 0) {
            System.err.println(msg);
        }
    }

    public static synchronized void printException(Exception e) {
        if (outputLevel > 0) {
            System.err.println(e);
            e.printStackTrace(System.err);
        }
    }

    public static synchronized void progressChar(char c) {
        if (outputLevel >= 2) {
            System.err.print(c);
        }
    }

    public static void setProgressChar(char consoleChar) {
        progrChr = consoleChar;
    }
}

